/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Utilities;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.CJKFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

class FontDetails {
    PdfIndirectReference indirectReference;
    PdfName fontName;
    BaseFont baseFont;
    TrueTypeFontUnicode ttu;
    CJKFont cjkFont;
    byte[] shortTag;
    HashMap longTag;
    IntHashtable cjkTag;
    int fontType;
    boolean symbolic;
    protected boolean subset = true;

    FontDetails(PdfName pdfName, PdfIndirectReference pdfIndirectReference, BaseFont baseFont) {
        this.fontName = pdfName;
        this.indirectReference = pdfIndirectReference;
        this.baseFont = baseFont;
        this.fontType = baseFont.getFontType();
        switch (this.fontType) {
            case 0: 
            case 1: {
                this.shortTag = new byte[256];
                break;
            }
            case 2: {
                this.cjkTag = new IntHashtable();
                this.cjkFont = (CJKFont)baseFont;
                break;
            }
            case 3: {
                this.longTag = new HashMap();
                this.ttu = (TrueTypeFontUnicode)baseFont;
                this.symbolic = baseFont.isFontSpecific();
            }
        }
    }

    PdfIndirectReference getIndirectReference() {
        return this.indirectReference;
    }

    PdfName getFontName() {
        return this.fontName;
    }

    BaseFont getBaseFont() {
        return this.baseFont;
    }

    byte[] convertToBytes(String string) {
        byte[] byArray = null;
        switch (this.fontType) {
            case 5: {
                return this.baseFont.convertToBytes(string);
            }
            case 0: 
            case 1: {
                byArray = this.baseFont.convertToBytes(string);
                int n2 = byArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.shortTag[byArray[i2] & 0xFF] = 1;
                }
                break;
            }
            case 2: {
                int n3 = string.length();
                for (int i3 = 0; i3 < n3; ++i3) {
                    this.cjkTag.put(this.cjkFont.getCidCode(string.charAt(i3)), 0);
                }
                byArray = this.baseFont.convertToBytes(string);
                break;
            }
            case 4: {
                byArray = this.baseFont.convertToBytes(string);
                break;
            }
            case 3: {
                try {
                    int n4;
                    int n5 = string.length();
                    int[] nArray = null;
                    char[] cArray = new char[n5];
                    int n6 = 0;
                    if (this.symbolic) {
                        byArray = PdfEncodings.convertToBytes(string, "symboltt");
                        n5 = byArray.length;
                        for (n4 = 0; n4 < n5; ++n4) {
                            nArray = this.ttu.getMetricsTT(byArray[n4] & 0xFF);
                            if (nArray == null) continue;
                            this.longTag.put(new Integer(nArray[0]), new int[]{nArray[0], nArray[1], this.ttu.getUnicodeDifferences(byArray[n4] & 0xFF)});
                            cArray[n6++] = (char)nArray[0];
                        }
                    } else {
                        for (n4 = 0; n4 < n5; ++n4) {
                            int n7;
                            if (Utilities.isSurrogatePair(string, n4)) {
                                n7 = Utilities.convertToUtf32(string, n4);
                                ++n4;
                            } else {
                                n7 = string.charAt(n4);
                            }
                            nArray = this.ttu.getMetricsTT(n7);
                            if (nArray == null) continue;
                            int n8 = nArray[0];
                            Integer n9 = new Integer(n8);
                            if (!this.longTag.containsKey(n9)) {
                                this.longTag.put(n9, new int[]{n8, nArray[1], n7});
                            }
                            cArray[n6++] = (char)n8;
                        }
                    }
                    String string2 = new String(cArray, 0, n6);
                    byArray = string2.getBytes("UnicodeBigUnmarked");
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new ExceptionConverter(unsupportedEncodingException);
                }
            }
        }
        return byArray;
    }

    void writeFont(PdfWriter pdfWriter) {
        try {
            switch (this.fontType) {
                case 5: {
                    this.baseFont.writeFont(pdfWriter, this.indirectReference, null);
                    break;
                }
                case 0: 
                case 1: {
                    int n2;
                    int n3;
                    for (n3 = 0; n3 < 256 && this.shortTag[n3] == 0; ++n3) {
                    }
                    for (n2 = 255; n2 >= n3 && this.shortTag[n2] == 0; --n2) {
                    }
                    if (n3 > 255) {
                        n3 = 255;
                        n2 = 255;
                    }
                    this.baseFont.writeFont(pdfWriter, this.indirectReference, new Object[]{new Integer(n3), new Integer(n2), this.shortTag, this.subset});
                    break;
                }
                case 2: {
                    this.baseFont.writeFont(pdfWriter, this.indirectReference, new Object[]{this.cjkTag});
                    break;
                }
                case 3: {
                    this.baseFont.writeFont(pdfWriter, this.indirectReference, new Object[]{this.longTag, this.subset});
                }
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean bl) {
        this.subset = bl;
    }
}

