/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.fonts.cmaps.CMap;
import com.lowagie.text.pdf.fonts.cmaps.CMapParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class CMapAwareDocumentFont
extends DocumentFont {
    private PdfDictionary fontDic;
    private int spaceWidth;
    private CMap toUnicodeCmap;
    private char[] cidbyte2uni;

    public CMapAwareDocumentFont(PRIndirectReference pRIndirectReference) {
        super(pRIndirectReference);
        this.fontDic = (PdfDictionary)PdfReader.getPdfObjectRelease(pRIndirectReference);
        this.processToUnicode();
        if (this.toUnicodeCmap == null) {
            this.processUni2Byte();
        }
        this.spaceWidth = super.getWidth(32);
        if (this.spaceWidth == 0) {
            this.spaceWidth = this.computeAverageWidth();
        }
    }

    private void processToUnicode() {
        PdfObject pdfObject = this.fontDic.get(PdfName.TOUNICODE);
        if (pdfObject != null) {
            try {
                byte[] byArray = PdfReader.getStreamBytes((PRStream)PdfReader.getPdfObjectRelease(pdfObject));
                CMapParser cMapParser = new CMapParser();
                this.toUnicodeCmap = cMapParser.parse(new ByteArrayInputStream(byArray));
            }
            catch (IOException iOException) {
                throw new Error("Unable to process ToUnicode map - " + iOException.getMessage(), iOException);
            }
        }
    }

    private void processUni2Byte() {
        IntHashtable intHashtable = this.getUni2Byte();
        int[] nArray = intHashtable.toOrderedKeys();
        this.cidbyte2uni = new char[256];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = intHashtable.get(nArray[i2]);
            if (this.cidbyte2uni[n2] != '\u0000') continue;
            this.cidbyte2uni[n2] = (char)nArray[i2];
        }
    }

    private int computeAverageWidth() {
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < this.widths.length; ++i2) {
            if (this.widths[i2] == 0) continue;
            n3 += this.widths[i2];
            ++n2;
        }
        return n2 != 0 ? n3 / n2 : 0;
    }

    public int getWidth(int n2) {
        if (n2 == 32) {
            return this.spaceWidth;
        }
        return super.getWidth(n2);
    }

    private String decodeSingleCID(byte[] byArray, int n2, int n3) {
        if (this.toUnicodeCmap != null) {
            if (n2 + n3 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException("Invalid index: " + n2 + n3);
            }
            return this.toUnicodeCmap.lookup(byArray, n2, n3);
        }
        if (n3 == 1) {
            return new String(this.cidbyte2uni, 0xFF & byArray[n2], 1);
        }
        throw new Error("Multi-byte glyphs not implemented yet");
    }

    public String decode(byte[] byArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            String string = this.decodeSingleCID(byArray, i2, 1);
            if (string == null) {
                string = this.decodeSingleCID(byArray, i2, 2);
                ++i2;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String encode(byte[] byArray, int n2, int n3) {
        return this.decode(byArray, n2, n3);
    }
}

