/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.CJKFont;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.EnumerateTTC;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFont;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import com.lowagie.text.pdf.Type1Font;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public abstract class BaseFont {
    public static final String COURIER = "Courier";
    public static final String COURIER_BOLD = "Courier-Bold";
    public static final String COURIER_OBLIQUE = "Courier-Oblique";
    public static final String COURIER_BOLDOBLIQUE = "Courier-BoldOblique";
    public static final String HELVETICA = "Helvetica";
    public static final String HELVETICA_BOLD = "Helvetica-Bold";
    public static final String HELVETICA_OBLIQUE = "Helvetica-Oblique";
    public static final String HELVETICA_BOLDOBLIQUE = "Helvetica-BoldOblique";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES_ROMAN = "Times-Roman";
    public static final String TIMES_BOLD = "Times-Bold";
    public static final String TIMES_ITALIC = "Times-Italic";
    public static final String TIMES_BOLDITALIC = "Times-BoldItalic";
    public static final String ZAPFDINGBATS = "ZapfDingbats";
    public static final int ASCENT = 1;
    public static final int CAPHEIGHT = 2;
    public static final int DESCENT = 3;
    public static final int ITALICANGLE = 4;
    public static final int BBOXLLX = 5;
    public static final int BBOXLLY = 6;
    public static final int BBOXURX = 7;
    public static final int BBOXURY = 8;
    public static final int AWT_ASCENT = 9;
    public static final int AWT_DESCENT = 10;
    public static final int AWT_LEADING = 11;
    public static final int AWT_MAXADVANCE = 12;
    public static final int UNDERLINE_POSITION = 13;
    public static final int UNDERLINE_THICKNESS = 14;
    public static final int STRIKETHROUGH_POSITION = 15;
    public static final int STRIKETHROUGH_THICKNESS = 16;
    public static final int SUBSCRIPT_SIZE = 17;
    public static final int SUBSCRIPT_OFFSET = 18;
    public static final int SUPERSCRIPT_SIZE = 19;
    public static final int SUPERSCRIPT_OFFSET = 20;
    public static final int FONT_TYPE_T1 = 0;
    public static final int FONT_TYPE_TT = 1;
    public static final int FONT_TYPE_CJK = 2;
    public static final int FONT_TYPE_TTUNI = 3;
    public static final int FONT_TYPE_DOCUMENT = 4;
    public static final int FONT_TYPE_T3 = 5;
    public static final String IDENTITY_H = "Identity-H";
    public static final String IDENTITY_V = "Identity-V";
    public static final String CP1250 = "Cp1250";
    public static final String CP1252 = "Cp1252";
    public static final String CP1257 = "Cp1257";
    public static final String WINANSI = "Cp1252";
    public static final String MACROMAN = "MacRoman";
    public static final int[] CHAR_RANGE_LATIN = new int[]{0, 383, 8192, 8303, 8352, 8399, 64256, 64262};
    public static final int[] CHAR_RANGE_ARABIC = new int[]{0, 127, 1536, 1663, 8352, 8399, 64336, 64511, 65136, 65279};
    public static final int[] CHAR_RANGE_HEBREW = new int[]{0, 127, 1424, 1535, 8352, 8399, 64285, 64335};
    public static final int[] CHAR_RANGE_CYRILLIC = new int[]{0, 127, 1024, 1327, 8192, 8303, 8352, 8399};
    public static final boolean EMBEDDED = true;
    public static final boolean NOT_EMBEDDED = false;
    public static final boolean CACHED = true;
    public static final boolean NOT_CACHED = false;
    public static final String RESOURCE_PATH = "com/lowagie/text/pdf/fonts/";
    public static final char CID_NEWLINE = Short.MAX_VALUE;
    protected ArrayList subsetRanges;
    int fontType;
    public static final String notdef = ".notdef";
    protected int[] widths = new int[256];
    protected String[] differences = new String[256];
    protected char[] unicodeDifferences = new char[256];
    protected int[][] charBBoxes = new int[256][];
    protected String encoding;
    protected boolean embedded;
    protected int compressionLevel = -1;
    protected boolean fontSpecific = true;
    protected static HashMap fontCache = new HashMap();
    protected static final HashMap BuiltinFonts14 = new HashMap();
    protected boolean forceWidthsOutput = false;
    protected boolean directTextToByte = false;
    protected boolean subset = true;
    protected boolean fastWinansi = false;
    protected IntHashtable specialMap;

    protected BaseFont() {
    }

    public static BaseFont createFont() throws DocumentException, IOException {
        return BaseFont.createFont(HELVETICA, "Cp1252", false);
    }

    public static BaseFont createFont(String string, String string2, boolean bl) throws DocumentException, IOException {
        return BaseFont.createFont(string, string2, bl, true, null, null, false);
    }

    public static BaseFont createFont(String string, String string2, boolean bl, boolean bl2) throws DocumentException, IOException {
        return BaseFont.createFont(string, string2, bl, true, null, null, bl2);
    }

    public static BaseFont createFont(String string, String string2, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) throws DocumentException, IOException {
        return BaseFont.createFont(string, string2, bl, bl2, byArray, byArray2, false);
    }

    public static BaseFont createFont(String string, String string2, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2, boolean bl3) throws DocumentException, IOException {
        return BaseFont.createFont(string, string2, bl, bl2, byArray, byArray2, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseFont createFont(String string, String string2, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2, boolean bl3, boolean bl4) throws DocumentException, IOException {
        HashMap hashMap;
        boolean bl5;
        String string3 = BaseFont.getBaseName(string);
        string2 = BaseFont.normalizeEncoding(string2);
        boolean bl6 = BuiltinFonts14.containsKey(string);
        boolean bl7 = bl5 = bl6 ? false : CJKFont.isCJKFont(string3, string2);
        if (bl6 || bl5) {
            bl = false;
        } else if (string2.equals(IDENTITY_H) || string2.equals(IDENTITY_V)) {
            bl = true;
        }
        BaseFont baseFont = null;
        BaseFont baseFont2 = null;
        String string4 = string + "\n" + string2 + "\n" + bl;
        if (bl2) {
            hashMap = fontCache;
            synchronized (hashMap) {
                baseFont = (BaseFont)fontCache.get(string4);
            }
            if (baseFont != null) {
                return baseFont;
            }
        }
        if (bl6 || string.toLowerCase().endsWith(".afm") || string.toLowerCase().endsWith(".pfm")) {
            baseFont2 = new Type1Font(string, string2, bl, byArray, byArray2, bl4);
            baseFont2.fastWinansi = string2.equals("Cp1252");
        } else if (string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0) {
            if (string2.equals(IDENTITY_H) || string2.equals(IDENTITY_V)) {
                baseFont2 = new TrueTypeFontUnicode(string, string2, bl, byArray, bl4);
            } else {
                baseFont2 = new TrueTypeFont(string, string2, bl, byArray, false, bl4);
                baseFont2.fastWinansi = string2.equals("Cp1252");
            }
        } else if (bl5) {
            baseFont2 = new CJKFont(string, string2, bl);
        } else {
            if (bl3) {
                return null;
            }
            throw new DocumentException("Font '" + string + "' with '" + string2 + "' is not recognized.");
        }
        if (bl2) {
            hashMap = fontCache;
            synchronized (hashMap) {
                baseFont = (BaseFont)fontCache.get(string4);
                if (baseFont != null) {
                    return baseFont;
                }
                fontCache.put(string4, baseFont2);
            }
        }
        return baseFont2;
    }

    public static BaseFont createFont(PRIndirectReference pRIndirectReference) {
        return new DocumentFont(pRIndirectReference);
    }

    protected static String getBaseName(String string) {
        if (string.endsWith(",Bold")) {
            return string.substring(0, string.length() - 5);
        }
        if (string.endsWith(",Italic")) {
            return string.substring(0, string.length() - 7);
        }
        if (string.endsWith(",BoldItalic")) {
            return string.substring(0, string.length() - 11);
        }
        return string;
    }

    protected static String normalizeEncoding(String string) {
        if (string.equals("winansi") || string.equals("")) {
            return "Cp1252";
        }
        if (string.equals("macroman")) {
            return MACROMAN;
        }
        return string;
    }

    protected void createEncoding() {
        if (this.encoding.startsWith("#")) {
            int n2;
            String string;
            this.specialMap = new IntHashtable();
            StringTokenizer stringTokenizer = new StringTokenizer(this.encoding.substring(1), " ,\t\n\r\f");
            if (stringTokenizer.nextToken().equals("full")) {
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    string = stringTokenizer.nextToken();
                    n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                    int n3 = string2.startsWith("'") ? (int)string2.charAt(1) : Integer.parseInt(string2);
                    this.specialMap.put(n2, n3 %= 256);
                    this.differences[n3] = string;
                    this.unicodeDifferences[n3] = n2;
                    this.widths[n3] = this.getRawWidth(n2, string);
                    this.charBBoxes[n3] = this.getRawCharBBox(n2, string);
                }
            } else {
                int n4 = 0;
                if (stringTokenizer.hasMoreTokens()) {
                    n4 = Integer.parseInt(stringTokenizer.nextToken());
                }
                while (stringTokenizer.hasMoreTokens() && n4 < 256) {
                    string = stringTokenizer.nextToken();
                    n2 = Integer.parseInt(string, 16) % 65536;
                    String string3 = GlyphList.unicodeToName(n2);
                    if (string3 == null) continue;
                    this.specialMap.put(n2, n4);
                    this.differences[n4] = string3;
                    this.unicodeDifferences[n4] = (char)n2;
                    this.widths[n4] = this.getRawWidth(n2, string3);
                    this.charBBoxes[n4] = this.getRawCharBBox(n2, string3);
                    ++n4;
                }
            }
            for (int i2 = 0; i2 < 256; ++i2) {
                if (this.differences[i2] != null) continue;
                this.differences[i2] = notdef;
            }
        } else if (this.fontSpecific) {
            for (int i3 = 0; i3 < 256; ++i3) {
                this.widths[i3] = this.getRawWidth(i3, null);
                this.charBBoxes[i3] = this.getRawCharBBox(i3, null);
            }
        } else {
            byte[] byArray = new byte[1];
            for (int i4 = 0; i4 < 256; ++i4) {
                byArray[0] = (byte)i4;
                String string = PdfEncodings.convertToString(byArray, this.encoding);
                int n5 = string.length() > 0 ? (int)string.charAt(0) : 63;
                String string4 = GlyphList.unicodeToName(n5);
                if (string4 == null) {
                    string4 = notdef;
                }
                this.differences[i4] = string4;
                this.unicodeDifferences[i4] = n5;
                this.widths[i4] = this.getRawWidth(n5, string4);
                this.charBBoxes[i4] = this.getRawCharBBox(n5, string4);
            }
        }
    }

    abstract int getRawWidth(int var1, String var2);

    public abstract int getKerning(int var1, int var2);

    public abstract boolean setKerning(int var1, int var2, int var3);

    public int getWidth(int n2) {
        if (this.fastWinansi) {
            if (n2 < 128 || n2 >= 160 && n2 <= 255) {
                return this.widths[n2];
            }
            return this.widths[PdfEncodings.winansi.get(n2)];
        }
        int n3 = 0;
        byte[] byArray = this.convertToBytes((char)n2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            n3 += this.widths[0xFF & byArray[i2]];
        }
        return n3;
    }

    public int getWidth(String string) {
        int n2 = 0;
        if (this.fastWinansi) {
            int n3 = string.length();
            for (int i2 = 0; i2 < n3; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 < '\u0080' || c2 >= '\u00a0' && c2 <= '\u00ff') {
                    n2 += this.widths[c2];
                    continue;
                }
                n2 += this.widths[PdfEncodings.winansi.get(c2)];
            }
            return n2;
        }
        byte[] byArray = this.convertToBytes(string);
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            n2 += this.widths[0xFF & byArray[i3]];
        }
        return n2;
    }

    public int getDescent(String string) {
        int n2 = 0;
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            int[] nArray = this.getCharBBox(cArray[i2]);
            if (nArray == null || nArray[1] >= n2) continue;
            n2 = nArray[1];
        }
        return n2;
    }

    public int getAscent(String string) {
        int n2 = 0;
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            int[] nArray = this.getCharBBox(cArray[i2]);
            if (nArray == null || nArray[3] <= n2) continue;
            n2 = nArray[3];
        }
        return n2;
    }

    public float getDescentPoint(String string, float f2) {
        return (float)this.getDescent(string) * 0.001f * f2;
    }

    public float getAscentPoint(String string, float f2) {
        return (float)this.getAscent(string) * 0.001f * f2;
    }

    public float getWidthPointKerned(String string, float f2) {
        float f3 = (float)this.getWidth(string) * 0.001f * f2;
        if (!this.hasKernPairs()) {
            return f3;
        }
        int n2 = string.length() - 1;
        int n3 = 0;
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += this.getKerning(cArray[i2], cArray[i2 + 1]);
        }
        return f3 + (float)n3 * 0.001f * f2;
    }

    public float getWidthPoint(String string, float f2) {
        return (float)this.getWidth(string) * 0.001f * f2;
    }

    public float getWidthPoint(int n2, float f2) {
        return (float)this.getWidth(n2) * 0.001f * f2;
    }

    byte[] convertToBytes(String string) {
        if (this.directTextToByte) {
            return PdfEncodings.convertToBytes(string, null);
        }
        if (this.specialMap != null) {
            byte[] byArray = new byte[string.length()];
            int n2 = 0;
            int n3 = string.length();
            for (int i2 = 0; i2 < n3; ++i2) {
                char c2 = string.charAt(i2);
                if (!this.specialMap.containsKey(c2)) continue;
                byArray[n2++] = (byte)this.specialMap.get(c2);
            }
            if (n2 < n3) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                return byArray2;
            }
            return byArray;
        }
        return PdfEncodings.convertToBytes(string, this.encoding);
    }

    byte[] convertToBytes(int n2) {
        if (this.directTextToByte) {
            return PdfEncodings.convertToBytes((char)n2, null);
        }
        if (this.specialMap != null) {
            if (this.specialMap.containsKey(n2)) {
                return new byte[]{(byte)this.specialMap.get(n2)};
            }
            return new byte[0];
        }
        return PdfEncodings.convertToBytes((char)n2, this.encoding);
    }

    abstract void writeFont(PdfWriter var1, PdfIndirectReference var2, Object[] var3) throws DocumentException, IOException;

    abstract PdfStream getFullFontStream() throws IOException, DocumentException;

    public String getEncoding() {
        return this.encoding;
    }

    public abstract float getFontDescriptor(int var1, float var2);

    public int getFontType() {
        return this.fontType;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isFontSpecific() {
        return this.fontSpecific;
    }

    public static String createSubsetPrefix() {
        String string = "";
        for (int i2 = 0; i2 < 6; ++i2) {
            string = string + (char)(Math.random() * 26.0 + 65.0);
        }
        return string + "+";
    }

    char getUnicodeDifferences(int n2) {
        return this.unicodeDifferences[n2];
    }

    public abstract String getPostscriptFontName();

    public abstract void setPostscriptFontName(String var1);

    public abstract String[][] getFullFontName();

    public abstract String[][] getAllNameEntries();

    public static String[][] getFullFontName(String string, String string2, byte[] byArray) throws DocumentException, IOException {
        String string3 = BaseFont.getBaseName(string);
        BaseFont baseFont = null;
        baseFont = string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont(string, "Cp1252", false, byArray, true, false) : BaseFont.createFont(string, string2, false, false, byArray, null);
        return ((BaseFont)baseFont).getFullFontName();
    }

    public static Object[] getAllFontNames(String string, String string2, byte[] byArray) throws DocumentException, IOException {
        String string3 = BaseFont.getBaseName(string);
        BaseFont baseFont = null;
        baseFont = string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont(string, "Cp1252", false, byArray, true, false) : BaseFont.createFont(string, string2, false, false, byArray, null);
        return new Object[]{baseFont.getPostscriptFontName(), baseFont.getFamilyFontName(), baseFont.getFullFontName()};
    }

    public static String[][] getAllNameEntries(String string, String string2, byte[] byArray) throws DocumentException, IOException {
        String string3 = BaseFont.getBaseName(string);
        BaseFont baseFont = null;
        baseFont = string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont(string, "Cp1252", false, byArray, true, false) : BaseFont.createFont(string, string2, false, false, byArray, null);
        return ((BaseFont)baseFont).getAllNameEntries();
    }

    public abstract String[][] getFamilyFontName();

    public String[] getCodePagesSupported() {
        return new String[0];
    }

    public static String[] enumerateTTCNames(String string) throws DocumentException, IOException {
        return new EnumerateTTC(string).getNames();
    }

    public static String[] enumerateTTCNames(byte[] byArray) throws DocumentException, IOException {
        return new EnumerateTTC(byArray).getNames();
    }

    public int[] getWidths() {
        return this.widths;
    }

    public String[] getDifferences() {
        return this.differences;
    }

    public char[] getUnicodeDifferences() {
        return this.unicodeDifferences;
    }

    public boolean isForceWidthsOutput() {
        return this.forceWidthsOutput;
    }

    public void setForceWidthsOutput(boolean bl) {
        this.forceWidthsOutput = bl;
    }

    public boolean isDirectTextToByte() {
        return this.directTextToByte;
    }

    public void setDirectTextToByte(boolean bl) {
        this.directTextToByte = bl;
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean bl) {
        this.subset = bl;
    }

    public static InputStream getResourceStream(String string) {
        return BaseFont.getResourceStream(string, null);
    }

    public static InputStream getResourceStream(String string, ClassLoader classLoader) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        InputStream inputStream = null;
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(string)) != null) {
            return inputStream;
        }
        try {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader2 != null) {
                inputStream = classLoader2.getResourceAsStream(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (inputStream == null) {
            inputStream = BaseFont.class.getResourceAsStream("/" + string);
        }
        if (inputStream == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
        }
        return inputStream;
    }

    public int getUnicodeEquivalent(int n2) {
        return n2;
    }

    public int getCidCode(int n2) {
        return n2;
    }

    public abstract boolean hasKernPairs();

    public boolean charExists(int n2) {
        byte[] byArray = this.convertToBytes(n2);
        return byArray.length > 0;
    }

    public boolean setCharAdvance(int n2, int n3) {
        byte[] byArray = this.convertToBytes(n2);
        if (byArray.length == 0) {
            return false;
        }
        this.widths[0xFF & byArray[0]] = n3;
        return true;
    }

    private static void addFont(PRIndirectReference pRIndirectReference, IntHashtable intHashtable, ArrayList arrayList) {
        PdfObject pdfObject = PdfReader.getPdfObject(pRIndirectReference);
        if (pdfObject == null || !pdfObject.isDictionary()) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
        PdfName pdfName = pdfDictionary.getAsName(PdfName.SUBTYPE);
        if (!PdfName.TYPE1.equals(pdfName) && !PdfName.TRUETYPE.equals(pdfName)) {
            return;
        }
        PdfName pdfName2 = pdfDictionary.getAsName(PdfName.BASEFONT);
        arrayList.add(new Object[]{PdfName.decodeName(pdfName2.toString()), pRIndirectReference});
        intHashtable.put(pRIndirectReference.getNumber(), 1);
    }

    private static void recourseFonts(PdfDictionary pdfDictionary, IntHashtable intHashtable, ArrayList arrayList, int n2) {
        Object object;
        Object object2;
        if (++n2 > 50) {
            return;
        }
        PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.RESOURCES);
        if (pdfDictionary2 == null) {
            return;
        }
        PdfDictionary pdfDictionary3 = pdfDictionary2.getAsDict(PdfName.FONT);
        if (pdfDictionary3 != null) {
            object2 = pdfDictionary3.getKeys().iterator();
            while (object2.hasNext()) {
                int n3;
                object = pdfDictionary3.get((PdfName)object2.next());
                if (object == null || !((PdfObject)object).isIndirect() || intHashtable.containsKey(n3 = ((PRIndirectReference)object).getNumber())) continue;
                BaseFont.addFont((PRIndirectReference)object, intHashtable, arrayList);
            }
        }
        if ((object2 = pdfDictionary2.getAsDict(PdfName.XOBJECT)) != null) {
            object = ((PdfDictionary)object2).getKeys().iterator();
            while (object.hasNext()) {
                BaseFont.recourseFonts(((PdfDictionary)object2).getAsDict((PdfName)object.next()), intHashtable, arrayList, n2);
            }
        }
    }

    public static ArrayList getDocumentFonts(PdfReader pdfReader) {
        IntHashtable intHashtable = new IntHashtable();
        ArrayList arrayList = new ArrayList();
        int n2 = pdfReader.getNumberOfPages();
        for (int i2 = 1; i2 <= n2; ++i2) {
            BaseFont.recourseFonts(pdfReader.getPageN(i2), intHashtable, arrayList, 1);
        }
        return arrayList;
    }

    public static ArrayList getDocumentFonts(PdfReader pdfReader, int n2) {
        IntHashtable intHashtable = new IntHashtable();
        ArrayList arrayList = new ArrayList();
        BaseFont.recourseFonts(pdfReader.getPageN(n2), intHashtable, arrayList, 1);
        return arrayList;
    }

    public int[] getCharBBox(int n2) {
        byte[] byArray = this.convertToBytes(n2);
        if (byArray.length == 0) {
            return null;
        }
        return this.charBBoxes[byArray[0] & 0xFF];
    }

    protected abstract int[] getRawCharBBox(int var1, String var2);

    public void correctArabicAdvance() {
        int n2;
        for (n2 = 1611; n2 <= 1624; n2 = (int)((char)(n2 + 1))) {
            this.setCharAdvance(n2, 0);
        }
        this.setCharAdvance(1648, 0);
        for (n2 = 1750; n2 <= 1756; n2 = (int)((char)(n2 + 1))) {
            this.setCharAdvance(n2, 0);
        }
        for (n2 = 1759; n2 <= 1764; n2 = (int)((char)(n2 + 1))) {
            this.setCharAdvance(n2, 0);
        }
        for (n2 = 1767; n2 <= 1768; n2 = (int)((char)(n2 + 1))) {
            this.setCharAdvance(n2, 0);
        }
        for (n2 = 1770; n2 <= 1773; n2 = (int)((char)(n2 + 1))) {
            this.setCharAdvance(n2, 0);
        }
    }

    public void addSubsetRange(int[] nArray) {
        if (this.subsetRanges == null) {
            this.subsetRanges = new ArrayList();
        }
        this.subsetRanges.add(nArray);
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int n2) {
        this.compressionLevel = n2 < 0 || n2 > 9 ? -1 : n2;
    }

    static {
        BuiltinFonts14.put(COURIER, PdfName.COURIER);
        BuiltinFonts14.put(COURIER_BOLD, PdfName.COURIER_BOLD);
        BuiltinFonts14.put(COURIER_BOLDOBLIQUE, PdfName.COURIER_BOLDOBLIQUE);
        BuiltinFonts14.put(COURIER_OBLIQUE, PdfName.COURIER_OBLIQUE);
        BuiltinFonts14.put(HELVETICA, PdfName.HELVETICA);
        BuiltinFonts14.put(HELVETICA_BOLD, PdfName.HELVETICA_BOLD);
        BuiltinFonts14.put(HELVETICA_BOLDOBLIQUE, PdfName.HELVETICA_BOLDOBLIQUE);
        BuiltinFonts14.put(HELVETICA_OBLIQUE, PdfName.HELVETICA_OBLIQUE);
        BuiltinFonts14.put(SYMBOL, PdfName.SYMBOL);
        BuiltinFonts14.put(TIMES_ROMAN, PdfName.TIMES_ROMAN);
        BuiltinFonts14.put(TIMES_BOLD, PdfName.TIMES_BOLD);
        BuiltinFonts14.put(TIMES_BOLDITALIC, PdfName.TIMES_BOLDITALIC);
        BuiltinFonts14.put(TIMES_ITALIC, PdfName.TIMES_ITALIC);
        BuiltinFonts14.put(ZAPFDINGBATS, PdfName.ZAPFDINGBATS);
    }

    static class StreamFont
    extends PdfStream {
        public StreamFont(byte[] byArray, int[] nArray, int n2) throws DocumentException {
            try {
                this.bytes = byArray;
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    this.put(new PdfName("Length" + (i2 + 1)), new PdfNumber(nArray[i2]));
                }
                this.flateCompress(n2);
            }
            catch (Exception exception) {
                throw new DocumentException(exception);
            }
        }

        public StreamFont(byte[] byArray, String string, int n2) throws DocumentException {
            try {
                this.bytes = byArray;
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                if (string != null) {
                    this.put(PdfName.SUBTYPE, new PdfName(string));
                }
                this.flateCompress(n2);
            }
            catch (Exception exception) {
                throw new DocumentException(exception);
            }
        }
    }
}

