/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodeInter25
extends Barcode {
    private static final byte[][] BARS = new byte[][]{{0, 0, 1, 1, 0}, {1, 0, 0, 0, 1}, {0, 1, 0, 0, 1}, {1, 1, 0, 0, 0}, {0, 0, 1, 0, 1}, {1, 0, 1, 0, 0}, {0, 1, 1, 0, 0}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {0, 1, 0, 1, 0}};

    public BarcodeInter25() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static String keepNumbers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '0' || c2 > '9') continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static char getChecksum(String string) {
        int n2 = 3;
        int n3 = 0;
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            int n4 = string.charAt(i2) - 48;
            n3 += n2 * n4;
            n2 ^= 2;
        }
        return (char)((10 - n3 % 10) % 10 + 48);
    }

    public static byte[] getBarsInter25(String string) {
        if (((string = BarcodeInter25.keepNumbers(string)).length() & 1) != 0) {
            throw new IllegalArgumentException("The text length must be even.");
        }
        byte[] byArray = new byte[string.length() * 5 + 7];
        int n2 = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        int n3 = string.length() / 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = string.charAt(i2 * 2) - 48;
            int n5 = string.charAt(i2 * 2 + 1) - 48;
            byte[] byArray2 = BARS[n4];
            byte[] byArray3 = BARS[n5];
            for (int i3 = 0; i3 < 5; ++i3) {
                byArray[n2++] = byArray2[i3];
                byArray[n2++] = byArray3[i3];
            }
        }
        byArray[n2++] = 1;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        String string;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            f3 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.code;
            if (this.generateChecksum && this.checksumText) {
                string = string + BarcodeInter25.getChecksum(string);
            }
            f2 = this.font.getWidthPoint(this.altText != null ? this.altText : string, this.size);
        }
        string = BarcodeInter25.keepNumbers(this.code);
        int n2 = string.length();
        if (this.generateChecksum) {
            ++n2;
        }
        float f4 = (float)n2 * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        f4 = Math.max(f4, f2);
        float f5 = this.barHeight + f3;
        return new Rectangle(f4, f5);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        String string = this.code;
        float f2 = 0.0f;
        if (this.font != null) {
            if (this.generateChecksum && this.checksumText) {
                string = string + BarcodeInter25.getChecksum(string);
            }
            string = this.altText != null ? this.altText : string;
            f2 = this.font.getWidthPoint(string, this.size);
        }
        String string2 = BarcodeInter25.keepNumbers(this.code);
        if (this.generateChecksum) {
            string2 = string2 + BarcodeInter25.getChecksum(string2);
        }
        int n2 = string2.length();
        float f3 = (float)n2 * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f2 > f3) {
                    f4 = f2 - f3;
                    break;
                }
                f5 = f3 - f2;
                break;
            }
            default: {
                if (f2 > f3) {
                    f4 = (f2 - f3) / 2.0f;
                    break;
                }
                f5 = (f3 - f2) / 2.0f;
            }
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f7 = this.barHeight - this.baseline;
            } else {
                f7 = -this.font.getFontDescriptor(3, this.size);
                f6 = f7 + this.baseline;
            }
        }
        byte[] byArray = BarcodeInter25.getBarsInter25(string2);
        boolean bl = true;
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            float f8;
            float f9 = f8 = byArray[i2] == 0 ? this.x : this.x * this.n;
            if (bl) {
                pdfContentByte.rectangle(f4, f6, f8 - this.inkSpreading, this.barHeight);
            }
            bl = !bl;
            f4 += f8;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f5, f7);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color color, Color color2) {
        int n2;
        int n3 = color.getRGB();
        int n4 = color2.getRGB();
        Canvas canvas = new Canvas();
        String string = BarcodeInter25.keepNumbers(this.code);
        if (this.generateChecksum) {
            string = string + BarcodeInter25.getChecksum(string);
        }
        int n5 = string.length();
        int n6 = (int)this.n;
        int n7 = n5 * (3 + 2 * n6) + (6 + n6);
        byte[] byArray = BarcodeInter25.getBarsInter25(string);
        boolean bl = true;
        int n8 = 0;
        int n9 = (int)this.barHeight;
        int[] nArray = new int[n7 * n9];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            int n10 = byArray[n2] == 0 ? 1 : n6;
            int n11 = n4;
            if (bl) {
                n11 = n3;
            }
            bl = !bl;
            for (int i2 = 0; i2 < n10; ++i2) {
                nArray[n8++] = n11;
            }
        }
        for (n2 = n7; n2 < nArray.length; n2 += n7) {
            System.arraycopy(nArray, 0, nArray, n2, n7);
        }
        Image image = canvas.createImage(new MemoryImageSource(n7, n9, nArray, 0, n7));
        return image;
    }
}

