/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.treetable;

import com.klg.jclass.swing.DefaultTreeTableSelectionModel;
import com.klg.jclass.swing.JCTreeTable;
import com.klg.jclass.swing.JCTreeTableSelectionModel;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.graphics.UIDComponent;
import com.klg.jclass.util.graphics.UIResourceUtil;
import com.klg.jclass.util.swing.DefaultRowSortTableModel;
import com.klg.jclass.util.swing.JCAction;
import com.klg.jclass.util.swing.JCRowSortModel;
import com.klg.jclass.util.swing.JCRowSortTableModel;
import com.klg.jclass.util.treetable.DefaultTreeIconRenderer;
import com.klg.jclass.util.treetable.EmptyTreeTableModel;
import com.klg.jclass.util.treetable.JCTreeIconRenderer;
import com.klg.jclass.util.treetable.JCTreeTableModel;
import com.klg.jclass.util.treetable.TableFromTreeTable;
import com.klg.jclass.util.treetable.TreeWithSortableChildren;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTableSupport
implements TableModel,
JCRowSortTableModel,
TableModelListener,
RowMapper,
Serializable {
    public static final int TREE = 1;
    public static final int TABLE = 2;
    public static final int NODE_LINES_SHOW = 1;
    public static final int NODE_LINES_HIDE = 2;
    public static final int NODE_LINES_USE_PLAF = 3;
    protected boolean sortable = true;
    protected int sortOrder = 1;
    protected int[][] keyColumnsArray;
    protected boolean autoSort = true;
    protected int showNodeLines = 3;
    protected JComponent visualComponent;
    protected int view = 1;
    protected JCTreeTableModel treetable = null;
    protected TableModel table;
    protected TreeModelListener treeListener = new TreeListener();
    protected JCListenerList tableListeners = null;
    protected int treeColumn = 0;
    protected JCListenerList treeExpansionListeners;
    protected JCListenerList treeSelectionListeners;
    protected JCListenerList treeWillExpandListeners;
    protected boolean rootVisible = true;
    protected boolean showsRootHandles = false;
    protected JCTreeIconRenderer iconRenderer = new DefaultTreeIconRenderer();
    protected boolean scrollsOnExpand;
    protected Icon expandedIcon;
    protected Icon collapsedIcon;
    protected int leftLevelSpacing;
    protected int rightLevelSpacing;
    protected int levelIndent;
    protected Icon openIcon;
    protected Icon closedIcon;
    protected Icon leafIcon;
    protected Color lineColor;
    protected int lineThickness;
    protected Stroke lineStroke;
    protected boolean drawLines;
    protected Color tableBackground;
    private boolean isMotif = false;
    protected int cellHeight;
    protected RemovableVector<TreePath> rowMap = null;
    protected Hashtable<TreePath, Boolean> expandedState = null;

    public TreeTableSupport(JComponent jComponent, JCTreeTableModel jCTreeTableModel) {
        this(jComponent);
        this.setTreeTableModel(jCTreeTableModel);
    }

    public TreeTableSupport(JComponent jComponent) {
        this.visualComponent = jComponent;
        this.inferLookAndFeel();
    }

    public void inferLookAndFeel() {
        Object object;
        Object object2;
        Object object3;
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        String string = lookAndFeel.getID();
        boolean bl = "Synth".equals(string);
        SynthContext synthContext = null;
        if (bl) {
            object3 = new UIDComponent("TreeUI");
            object2 = SynthLookAndFeel.getRegion((JComponent)object3);
            object = SynthLookAndFeel.getStyle((JComponent)object3, (Region)object2);
            synthContext = new SynthContext((JComponent)object3, (Region)object2, (SynthStyle)object, 1);
            ((SynthStyle)object).installDefaults(synthContext);
        }
        this.expandedIcon = new DefaultIcon(false);
        object3 = UIResourceUtil.getUIResourceObject("Tree.expandedIcon", synthContext, this.expandedIcon);
        if (object3 instanceof Icon) {
            this.expandedIcon = (Icon)object3;
        }
        this.collapsedIcon = new DefaultIcon(true);
        object3 = UIResourceUtil.getUIResourceObject("Tree.collapsedIcon", synthContext, this.collapsedIcon);
        if (object3 instanceof Icon) {
            this.collapsedIcon = (Icon)object3;
        }
        this.leftLevelSpacing = 7;
        object3 = UIResourceUtil.getUIResourceObject("Tree.leftChildIndent", synthContext, new Integer(this.leftLevelSpacing));
        if (object3 instanceof Integer) {
            this.leftLevelSpacing = (Integer)object3;
        }
        this.rightLevelSpacing = 14;
        object3 = UIResourceUtil.getUIResourceObject("Tree.rightChildIndent", synthContext, new Integer(this.rightLevelSpacing));
        if (object3 instanceof Integer) {
            this.rightLevelSpacing = (Integer)object3;
        }
        this.scrollsOnExpand = true;
        object3 = UIResourceUtil.getUIResourceObject("Tree.scrollsOnExpand", synthContext, this.scrollsOnExpand);
        if (object3 instanceof Boolean) {
            this.scrollsOnExpand = (Boolean)object3;
        }
        this.openIcon = new DefaultNodeIcon(0);
        this.openIcon = UIResourceUtil.getUIResourceIcon("Tree.openIcon", synthContext, this.openIcon);
        this.closedIcon = new DefaultNodeIcon(1);
        this.closedIcon = UIResourceUtil.getUIResourceIcon("Tree.closedIcon", synthContext, this.closedIcon);
        this.leafIcon = new DefaultNodeIcon(2, 16, 20);
        this.leafIcon = UIResourceUtil.getUIResourceIcon("Tree.leafIcon", synthContext, this.leafIcon);
        this.lineColor = UIResourceUtil.getUIResourceColor("Tree.hash", synthContext, ColorType.FOREGROUND, Color.black);
        this.levelIndent = this.leftLevelSpacing + this.rightLevelSpacing;
        if (bl) {
            object2 = (UIDComponent)synthContext.getComponent();
            ((UIDComponent)object2).setUIClassID("TableUI");
            object = SynthLookAndFeel.getRegion((JComponent)object2);
            SynthStyle synthStyle = SynthLookAndFeel.getStyle((JComponent)object2, (Region)object);
            synthContext = new SynthContext((JComponent)object2, (Region)object, synthStyle, 1);
            synthStyle.installDefaults(synthContext);
        }
        this.tableBackground = UIResourceUtil.getUIResourceColor("Table.background", synthContext, ColorType.BACKGROUND, Color.white);
        this.cellHeight = Math.max(this.openIcon.getIconHeight(), this.closedIcon.getIconHeight());
        this.cellHeight = Math.max(this.cellHeight, this.leafIcon.getIconHeight());
        if (JCEnvironment.isMetal()) {
            this.drawLines = false;
        } else if (JCEnvironment.isMotif()) {
            this.drawLines = true;
            this.lineThickness = 2;
            this.isMotif = true;
            this.lineStroke = new BasicStroke(this.lineThickness, 0, 2, 5.0f, null, 0.0f);
        } else {
            this.drawLines = true;
            this.lineThickness = 1;
            object2 = new float[]{this.lineThickness, this.lineThickness};
            this.lineStroke = new BasicStroke(this.lineThickness, 0, 2, 5.0f, (float[])object2, 0.0f);
        }
        if (this.showNodeLines != 3) {
            this.drawLines = this.showNodeLines == 1;
        }
    }

    @Override
    public int[] getRowsForPaths(TreePath[] treePathArray) {
        int n2;
        if (treePathArray == null) {
            return null;
        }
        int[] nArray = new int[treePathArray.length];
        int n3 = 0;
        for (n2 = 0; n2 < treePathArray.length; ++n2) {
            int n4 = this.getRowForPath(treePathArray[n2]);
            if (n4 < 0) continue;
            nArray[n3++] = n4;
        }
        if (n2 != n3) {
            int[] nArray2 = new int[n3];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            nArray = nArray2;
        }
        return nArray;
    }

    public void setShowNodeLines(int n2) {
        if (this.showNodeLines == n2) {
            return;
        }
        if (n2 != 1 && n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("Invalid value for showNodeLines");
        }
        this.showNodeLines = n2;
        if (this.showNodeLines == 3) {
            this.inferLookAndFeel();
        }
        this.drawLines = this.showNodeLines == 1;
    }

    public int getShowNodeLines() {
        return this.showNodeLines;
    }

    public int getMaxIconHeight() {
        return this.cellHeight;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean bl) {
        this.sortable = bl;
    }

    protected void initTableViewModels() {
        if (this.table != null) {
            this.table.removeTableModelListener(this);
        }
        this.table = new TableFromTreeTable(this.treetable);
        if (!(this.table instanceof JCRowSortTableModel)) {
            this.table = new DefaultRowSortTableModel(this.table);
        }
        this.table.addTableModelListener(this);
    }

    public void setView(int n2) {
        if (this.view == n2) {
            return;
        }
        if (n2 != 2 && n2 != 1) {
            throw new IllegalArgumentException("view must be one of TREE or TABLE");
        }
        this.view = n2;
        if (n2 == 2) {
            this.initTableViewModels();
        }
        this.postTableModelChanged(new TableModelEvent(this));
    }

    public int getView() {
        return this.view;
    }

    public void setTreeTableModel(JCTreeTableModel jCTreeTableModel) {
        if (jCTreeTableModel == null) {
            jCTreeTableModel = new EmptyTreeTableModel(EmptyTreeTableModel.makeDefaultTree());
        }
        if (this.sortable && this.view == 1 && !(jCTreeTableModel instanceof JCRowSortModel)) {
            jCTreeTableModel = new TreeWithSortableChildren(jCTreeTableModel);
        }
        if (this.treetable == jCTreeTableModel) {
            return;
        }
        this.treetable = jCTreeTableModel;
        jCTreeTableModel.addTreeModelListener(this.treeListener);
        if (this.view == 2) {
            this.initTableViewModels();
        }
        this.clearExpandedState(false);
    }

    public void clearExpandedState() {
        this.clearExpandedState(true);
    }

    protected void clearExpandedState(boolean bl) {
        this.expandedState = new Hashtable();
        this.mapTreeTable(bl);
        if (this.visualComponent instanceof JCTreeTable) {
            JCTreeTable jCTreeTable = (JCTreeTable)this.visualComponent;
            jCTreeTable.removeEditor();
            JCTreeTableSelectionModel jCTreeTableSelectionModel = jCTreeTable.getTreeSelectionModel();
            if (jCTreeTableSelectionModel != null) {
                ListSelectionListener[] listSelectionListenerArray = null;
                ListSelectionModel listSelectionModel = jCTreeTableSelectionModel.getListSelectionModel();
                if (listSelectionModel instanceof DefaultListSelectionModel) {
                    ListSelectionListener[] listSelectionListenerArray2 = (ListSelectionListener[])listSelectionModel;
                    listSelectionListenerArray = listSelectionListenerArray2.getListSelectionListeners();
                }
                jCTreeTableSelectionModel = new DefaultTreeTableSelectionModel();
                jCTreeTable.setTreeTableSelectionModel(jCTreeTableSelectionModel);
                if (listSelectionListenerArray != null) {
                    listSelectionModel = jCTreeTableSelectionModel.getListSelectionModel();
                    for (ListSelectionListener listSelectionListener : listSelectionListenerArray) {
                        listSelectionModel.addListSelectionListener(listSelectionListener);
                    }
                }
            }
        }
    }

    public void mapTreeTable(boolean bl) {
        DefaultRowSortTableModel defaultRowSortTableModel;
        TableModel tableModel;
        Object object = this.treetable.getRoot();
        this.rowMap = new RemovableVector();
        TreePath treePath = new TreePath(object);
        if (this.rootVisible) {
            this.rowMap.add(treePath);
        } else if (!this.treetable.isLeaf(object)) {
            this.expandedState.put(treePath, Boolean.TRUE);
        }
        Vector<TreePath> vector = new Vector<TreePath>();
        this.getExpandedKids(treePath, vector);
        this.rowMap.addAll(vector);
        if (this.table instanceof DefaultRowSortTableModel && (tableModel = (defaultRowSortTableModel = (DefaultRowSortTableModel)this.table).getModel()) instanceof TableFromTreeTable) {
            TableFromTreeTable tableFromTreeTable = (TableFromTreeTable)tableModel;
            tableFromTreeTable.resetMappings();
        }
        if (bl) {
            this.postTableModelChanged(new TableModelEvent(this));
        }
    }

    public JCTreeTableModel getTreeTableModel() {
        return this.treetable;
    }

    public TableModel getTableModel() {
        return this.table;
    }

    public boolean hasBeenExpanded(TreePath treePath) {
        return treePath != null && this.expandedState.get(treePath) != null;
    }

    protected void postTableModelChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null) {
            return;
        }
        Enumeration<Object> enumeration = JCListenerList.elements(this.tableListeners);
        while (enumeration.hasMoreElements()) {
            TableModelListener tableModelListener = (TableModelListener)enumeration.nextElement();
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    public void setTreeIconRenderer(JCTreeIconRenderer jCTreeIconRenderer) {
        this.iconRenderer = jCTreeIconRenderer;
    }

    public JCTreeIconRenderer getTreeIconRenderer() {
        return this.iconRenderer;
    }

    public TreePath getPathForRow(int n2) {
        return this.getPathForRow(this.view, n2);
    }

    protected TreePath getPathForRow(int n2, int n3) {
        DefaultRowSortTableModel defaultRowSortTableModel;
        TableModel tableModel;
        if (n2 == 1) {
            return (TreePath)this.rowMap.elementAt(n3);
        }
        if (this.table instanceof DefaultRowSortTableModel && (tableModel = (defaultRowSortTableModel = (DefaultRowSortTableModel)this.table).getModel()) instanceof TableFromTreeTable) {
            TableFromTreeTable tableFromTreeTable = (TableFromTreeTable)tableModel;
            int n4 = defaultRowSortTableModel.getUnsortedRow(n3);
            return tableFromTreeTable.rowToTreePath(n4);
        }
        return null;
    }

    public int getRowForPath(TreePath treePath) {
        return this.getRowForPath(this.view, treePath);
    }

    protected int getRowForPath(int n2, TreePath treePath) {
        DefaultRowSortTableModel defaultRowSortTableModel;
        TableModel tableModel;
        if (n2 == 1) {
            for (int i2 = 0; i2 < this.rowMap.size(); ++i2) {
                if (!((TreePath)this.rowMap.elementAt(i2)).equals(treePath)) continue;
                return i2;
            }
        } else if (this.table instanceof DefaultRowSortTableModel && (tableModel = (defaultRowSortTableModel = (DefaultRowSortTableModel)this.table).getModel()) instanceof TableFromTreeTable) {
            TableFromTreeTable tableFromTreeTable = (TableFromTreeTable)tableModel;
            int n3 = tableFromTreeTable.treePathToRow(treePath);
            return defaultRowSortTableModel.getSortedRow(n3);
        }
        return -1;
    }

    public boolean isExpanded(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Boolean bl = this.expandedState.get(treePath);
        if (bl == null) {
            return false;
        }
        if (!bl.booleanValue()) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        return treePath2 == null || this.isExpanded(treePath2);
    }

    @Override
    public boolean getAutoSort() {
        if (!this.sortable) {
            this.autoSort = false;
        }
        return this.autoSort;
    }

    @Override
    public void setAutoSort(boolean bl) {
        if (this.autoSort == bl) {
            return;
        }
        this.autoSort = bl;
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setAutoSort(bl);
        }
    }

    @Override
    public void setKeyColumns(int n2, int[] nArray) {
        if (this.keyColumnsArray == null) {
            this.keyColumnsArray = new int[this.treetable.getColumnCount()][];
        }
        this.keyColumnsArray[n2] = nArray;
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setKeyColumns(n2, nArray);
        }
    }

    @Override
    public int[] getKeyColumns(int n2) {
        return this.keyColumnsArray[n2];
    }

    protected JCRowSortModel getRowSortModel() {
        if (this.sortable && this.view == 1 && this.treetable instanceof JCRowSortModel) {
            return (JCRowSortModel)((Object)this.treetable);
        }
        if (this.sortable && this.view == 2 && this.table != null) {
            return (JCRowSortModel)((Object)this.table);
        }
        return null;
    }

    @Override
    public boolean isDataSorted() {
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        return jCRowSortModel != null && jCRowSortModel.isDataSorted();
    }

    @Override
    public void setDataSorted(boolean bl) {
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setDataSorted(bl);
        }
    }

    @Override
    public int getSortColumn() {
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            return jCRowSortModel.getSortColumn();
        }
        return -1;
    }

    @Override
    public void setSortColumn(int n2) {
        if (!this.sortable) {
            return;
        }
        if (this.getSortColumn() == n2) {
            return;
        }
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setSortColumn(n2);
        }
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(int n2) {
        if (this.sortOrder == n2) {
            return;
        }
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setSortOrder(n2);
        }
        this.sortOrder = n2;
    }

    @Override
    public void toggleSortOrder() {
        this.sortOrder = this.sortOrder == 1 ? -1 : 1;
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setSortOrder(this.sortOrder);
        }
    }

    @Override
    public int getUnsortedRow(int n2) {
        if (this.table == null) {
            return -1;
        }
        JCRowSortTableModel jCRowSortTableModel = (JCRowSortTableModel)((Object)this.table);
        return jCRowSortTableModel.getUnsortedRow(n2);
    }

    @Override
    public int getSortedRow(int n2) {
        if (this.table == null) {
            return -1;
        }
        JCRowSortTableModel jCRowSortTableModel = (JCRowSortTableModel)((Object)this.table);
        return jCRowSortTableModel.getSortedRow(n2);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        TableModelEvent tableModelEvent2 = new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), tableModelEvent.getType());
        Enumeration<Object> enumeration = JCListenerList.elements(this.tableListeners);
        while (enumeration.hasMoreElements()) {
            TableModelListener tableModelListener = (TableModelListener)enumeration.nextElement();
            tableModelListener.tableChanged(tableModelEvent2);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.tableListeners = JCListenerList.add(this.tableListeners, tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.tableListeners = JCListenerList.remove(this.tableListeners, tableModelListener);
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        Class<Object> clazz = this.view == 1 && n2 == this.getTreeColumn() ? TreePath.class : this.treetable.getColumnClass(n2);
        return clazz;
    }

    @Override
    public int getColumnCount() {
        return this.treetable.getColumnCount();
    }

    @Override
    public String getColumnName(int n2) {
        return this.treetable.getColumnName(n2);
    }

    @Override
    public int getRowCount() {
        if (this.view == 1) {
            return this.rowMap.size();
        }
        if (this.table != null) {
            return this.table.getRowCount();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        if (this.view == 1) {
            if (n3 == this.getTreeColumn()) {
                return this.rowMap.elementAt(n2);
            }
            return this.treetable.getValueAt(this.getNode(n2), n3);
        }
        if (this.table != null) {
            return this.table.getValueAt(n2, n3);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        if (this.view == 1) {
            return this.treetable.isCellEditable(this.getNode(n2), n3);
        }
        return this.table != null && this.table.isCellEditable(n2, n3);
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        if (this.view == 1) {
            this.treetable.setValueAt(object, this.getNode(n2), n3);
        } else if (this.table != null) {
            this.table.setValueAt(object, n2, n3);
        }
    }

    protected static Object getParent(TreePath treePath) {
        if (treePath.getPathCount() == 1) {
            return null;
        }
        return treePath.getPathComponent(treePath.getPathCount() - 2);
    }

    protected static Object getNode(TreePath treePath) {
        return treePath.getLastPathComponent();
    }

    protected Object getNode(int n2) {
        TreePath treePath = (TreePath)this.rowMap.elementAt(n2);
        if (treePath == null) {
            return null;
        }
        return treePath.getLastPathComponent();
    }

    protected int getLevel(int n2) {
        TreePath treePath = this.getPathForRow(n2);
        return treePath.getPathCount();
    }

    protected void toggleState(int n2) {
        if (this.isExpanded(this.getPathForRow(1, n2))) {
            this.collapseRow(n2);
        } else {
            this.expandRow(n2);
        }
    }

    public boolean processClickInTreeColumn(MouseEvent mouseEvent, int n2, int n3, Point point, int n4) {
        JCTreeTable jCTreeTable;
        if (n2 < 0 || n3 < 0) {
            return false;
        }
        if (this.view != 1) {
            return false;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return false;
        }
        if (this.treetable.isLeaf(this.getNode(n2))) {
            return false;
        }
        if (this.visualComponent instanceof JCTreeTable && (jCTreeTable = (JCTreeTable)this.visualComponent).isExpandInTreeColumnOnly() && jCTreeTable.getTreeColumn() != n3) {
            return false;
        }
        if (!this.isPointInControlBox(point, n2, n3, n4, this.getLevel(n2)) && mouseEvent.getClickCount() <= 1) {
            return false;
        }
        this.toggleState(n2);
        mouseEvent.consume();
        return true;
    }

    protected boolean isPointInControlBox(Point point, int n2, int n3, int n4, int n5) {
        int n6;
        --n5;
        if (!this.showsRootHandles) {
            --n5;
        }
        if (!this.rootVisible) {
            --n5;
        }
        boolean bl = true;
        int n7 = 0;
        TableColumnModel tableColumnModel = null;
        if (this.visualComponent instanceof JTable) {
            bl = this.visualComponent.getComponentOrientation().isLeftToRight();
            tableColumnModel = ((JTable)this.visualComponent).getColumnModel();
            n7 = tableColumnModel.getColumn(n3).getWidth();
        }
        int n8 = this.expandedIcon.getIconWidth();
        int n9 = this.expandedIcon.getIconHeight();
        int n10 = this.levelIndent / 2 + n5 * this.levelIndent;
        if (!bl) {
            n10 = n7 - n10;
        }
        n10 -= n8 / 2;
        int n11 = n4 / 2 - n9 / 2;
        if (this.visualComponent instanceof JCTreeTable) {
            int n12;
            JCTreeTable jCTreeTable = (JCTreeTable)this.visualComponent;
            if (n3 != jCTreeTable.getTreeColumn()) {
                return false;
            }
            n6 = bl ? 0 : tableColumnModel.getColumnCount() - 1;
            point.y -= n2 * jCTreeTable.getRowHeight();
            TableColumn tableColumn = tableColumnModel == null ? null : tableColumnModel.getColumn(n6);
            int n13 = n12 = tableColumn == null ? 0 : tableColumn.getWidth();
            if (JCEnvironment.getJavaVersion() < 130) {
                Dimension dimension = jCTreeTable.getIntercellSpacing();
                n10 += dimension.width / 2;
                while (bl ? n6 < n3 : n6 > n3) {
                    n10 += n12 + dimension.width;
                    n6 = bl ? n6 + 1 : n6 - 1;
                }
                point.y -= n2 * dimension.height;
            } else {
                while (bl ? n6 < n3 : n6 > n3) {
                    n10 += n12;
                    n6 = bl ? n6 + 1 : n6 - 1;
                }
            }
        }
        boolean bl2 = point.x >= n10 && point.x < n10 + n8;
        n6 = point.y >= n11 && point.y < n11 + n9 ? 1 : 0;
        return bl2 && n6 != 0;
    }

    protected void addKids(Object object, TreePath treePath, Vector<TreePath> vector) {
        int n2 = this.treetable.getChildCount(object);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = this.treetable.getChild(object, i2);
            TreePath treePath2 = treePath.pathByAddingChild(object2);
            vector.add(treePath2);
            if (!this.isExpanded(treePath2)) continue;
            this.addKids(object2, treePath2, vector);
        }
    }

    public void expandRow(int n2) {
        this.expandPathRow(this.getPathForRow(1, n2), n2);
    }

    protected int countKidsToRemove(Object object, TreePath treePath) {
        int n2;
        int n3 = n2 = this.treetable.getChildCount(object);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = this.treetable.getChild(object, i2);
            TreePath treePath2 = treePath.pathByAddingChild(object2);
            if (!this.isExpanded(treePath2)) continue;
            n3 += this.countKidsToRemove(object2, treePath2);
        }
        return n3;
    }

    public void collapseRow(int n2) {
        this.collapsePathRow(this.getPathForRow(1, n2), n2);
    }

    public void collapsePathRow(TreePath treePath, int n2) {
        if (!this.isExpanded(treePath)) {
            return;
        }
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this.visualComponent, treePath);
        Enumeration<Object> enumeration = JCListenerList.elements(this.treeWillExpandListeners);
        while (enumeration.hasMoreElements()) {
            TreeWillExpandListener treeWillExpandListener = (TreeWillExpandListener)enumeration.nextElement();
            try {
                treeWillExpandListener.treeWillCollapse(treeExpansionEvent);
            }
            catch (ExpandVetoException expandVetoException) {
                return;
            }
        }
        int n3 = this.countKidsToRemove(this.getNode(n2), treePath);
        this.expandedState.put(treePath, Boolean.FALSE);
        this.rowMap.remove(n2 + 1, n2 + 1 + n3);
        TableModelEvent tableModelEvent = new TableModelEvent(this, n2 + 1, n2 + n3, -1, -1);
        this.postTableModelChanged(tableModelEvent);
        enumeration = JCListenerList.elements(this.treeExpansionListeners);
        while (enumeration.hasMoreElements()) {
            TreeExpansionListener treeExpansionListener = (TreeExpansionListener)enumeration.nextElement();
            treeExpansionListener.treeCollapsed(treeExpansionEvent);
        }
    }

    protected static boolean isLastChild(JCTreeTableModel jCTreeTableModel, TreePath treePath) {
        Object object = TreeTableSupport.getParent(treePath);
        if (object == null) {
            return true;
        }
        int n2 = jCTreeTableModel.getIndexOfChild(object, TreeTableSupport.getNode(treePath));
        return n2 == jCTreeTableModel.getChildCount(object) - 1;
    }

    public void prepareCellForRender(Graphics graphics, int n2, int n3) {
        graphics.setColor(this.tableBackground);
        graphics.fillRect(0, 0, n2, n3);
    }

    protected Icon getNodeIcon(TreePath treePath, Object object, Class<?> clazz, boolean bl, boolean bl2) {
        if (this.iconRenderer == null) {
            return null;
        }
        Icon icon = bl ? this.leafIcon : (bl2 ? this.openIcon : this.closedIcon);
        return this.iconRenderer.getNodeIcon(this.treetable, TreeTableSupport.getNode(treePath), object, clazz, bl, bl2, icon);
    }

    public void renderHierarchy(Graphics graphics, Rectangle rectangle, TreePath treePath, Object object, Class<?> clazz) {
        int n2;
        int n3;
        int n4;
        graphics.setColor(this.lineColor);
        Stroke stroke = null;
        if (this.lineStroke != null && graphics instanceof Graphics2D) {
            stroke = ((Graphics2D)graphics).getStroke();
            ((Graphics2D)graphics).setStroke(this.lineStroke);
        }
        int n5 = treePath.getPathCount() - 1;
        boolean bl = this.isExpanded(treePath);
        boolean bl2 = this.treetable.isLeaf(TreeTableSupport.getNode(treePath));
        int n6 = 0;
        if (this.rootVisible) {
            n6 = 0;
        } else if (!this.showsRootHandles) {
            n6 = 1;
        }
        boolean bl3 = this.visualComponent.getComponentOrientation().isLeftToRight();
        int n7 = rectangle.y;
        int n8 = rectangle.height / 2 + n7;
        int n9 = rectangle.height + n7;
        int n10 = rectangle.width;
        int n11 = this.levelIndent / 2;
        TreePath treePath2 = treePath;
        int n12 = this.getNodeIndent(treePath);
        for (n4 = 1; n4 < n5 - n6; ++n4) {
            if (TreeTableSupport.isLastChild(this.treetable, treePath2 = treePath2.getParentPath())) continue;
            n3 = n12 - n4 * this.levelIndent - n11;
            if (!bl3) {
                n3 = n10 - n3;
            }
            if (!this.drawLines) continue;
            graphics.drawLine(n3, n7, n3, n9);
        }
        if ((n5 != 0 || this.showsRootHandles) && (n5 != 1 || this.rootVisible || this.showsRootHandles)) {
            n4 = n12 - n11;
            if (!bl3) {
                n4 = n10 - n4;
            }
            if (this.drawLines) {
                if (TreeTableSupport.isLastChild(this.treetable, treePath)) {
                    graphics.drawLine(n4, n7, n4, n8);
                } else {
                    graphics.drawLine(n4, n7, n4, n9);
                }
            }
            if (this.drawLines) {
                n3 = bl3 ? n11 : -n11;
                graphics.drawLine(n4, n8, n4 + n3, n8);
            }
            if (this.lineStroke != null && graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setStroke(stroke);
            }
            if (!bl2) {
                Icon icon = bl ? this.expandedIcon : this.collapsedIcon;
                n2 = n4 - icon.getIconWidth() / 2;
                int n13 = n8 - icon.getIconHeight() / 2;
                icon.paintIcon(this.visualComponent, graphics, n2, n13);
            }
        }
        if (this.iconRenderer == null) {
            return;
        }
        Icon icon = this.getNodeIcon(treePath, object, clazz, bl2, bl);
        if (icon != null) {
            int n14 = bl3 ? n12 : n10 - n12 - icon.getIconWidth();
            n2 = 0;
            String string = "MotifTreeLeafIcon";
            if (this.isMotif && bl2 && JCEnvironment.isWorking(string) == 2) {
                n2 = 1;
                graphics.translate(n14, 0);
            }
            icon.paintIcon(this.visualComponent, graphics, n14, rectangle.y);
            if (n2 != 0) {
                graphics.translate(-n14, 0);
            }
        }
    }

    public int getNodeIndent(TreePath treePath) {
        if (treePath == null) {
            return 0;
        }
        int n2 = treePath.getPath().length;
        if (!this.rootVisible) {
            --n2;
        }
        if (!this.showsRootHandles) {
            --n2;
        }
        return n2 * this.getLevelIndent();
    }

    public int getRendererIndent(TreePath treePath) {
        return this.getRendererIndent(treePath, null, null);
    }

    public int getRendererIndent(TreePath treePath, Object object, Class<?> clazz) {
        if (treePath == null) {
            return 0;
        }
        int n2 = this.getNodeIndent(treePath);
        if (this.iconRenderer != null) {
            Icon icon = this.getNodeIcon(treePath, object, clazz, this.treetable.isLeaf(TreeTableSupport.getNode(treePath)), this.isExpanded(treePath));
            n2 += icon.getIconWidth();
        }
        return n2;
    }

    public int getLevelIndent() {
        return this.levelIndent;
    }

    public Class<?> getTreeColumnClass() {
        return this.treetable.getColumnClass(this.getTreeColumn());
    }

    public Object getTreeColumnValue(Object object) {
        return this.treetable.getValueAt(object, this.getTreeColumn());
    }

    public int getTreeColumn() {
        return this.treeColumn;
    }

    public Enumeration<TreePath> getExpandedDescendants(TreePath treePath) {
        if (!this.isExpanded(treePath)) {
            return null;
        }
        Vector<TreePath> vector = new Vector<TreePath>();
        this.getExpandedKids(treePath, vector);
        return vector.elements();
    }

    protected void getExpandedKids(TreePath treePath, Vector<TreePath> vector) {
        if (!this.isExpanded(treePath)) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        int n2 = this.treetable.getChildCount(object);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = this.treetable.getChild(object, i2);
            if (object2 == null) continue;
            TreePath treePath2 = treePath.pathByAddingChild(object2);
            vector.add(treePath2);
            if (this.treetable.isLeaf(object2)) continue;
            this.getExpandedKids(treePath2, vector);
        }
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.treeExpansionListeners = JCListenerList.add(this.treeExpansionListeners, treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.treeExpansionListeners = JCListenerList.remove(this.treeExpansionListeners, treeExpansionListener);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.treeWillExpandListeners = JCListenerList.add(this.treeWillExpandListeners, treeWillExpandListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.treeWillExpandListeners = JCListenerList.remove(this.treeWillExpandListeners, treeWillExpandListener);
    }

    public void collapsePath(TreePath treePath) {
        this.collapsePathRow(treePath, this.getRowForPath(1, treePath));
    }

    public void expandPath(TreePath treePath) {
        if (this.isExpanded(treePath)) {
            // empty if block
        }
        int n2 = this.getRowForPath(1, treePath);
        this.expandPathRow(treePath, n2);
    }

    protected void expandPathRow(TreePath treePath, int n2) {
        int n3;
        Object object;
        if (this.isExpanded(treePath)) {
            return;
        }
        if (n2 == -1) {
            int n4;
            TreePath treePath2 = null;
            int n5 = -1;
            int n6 = n4 = this.rootVisible ? 0 : 1;
            while (n4 < treePath.getPathCount() - 1) {
                object = treePath.getPathComponent(n4);
                if (treePath2 == null) {
                    treePath2 = new TreePath(treePath.getPathComponent(0));
                    if (n4 != 0) {
                        treePath2 = treePath2.pathByAddingChild(object);
                    }
                    n5 = this.getRowForPath(1, treePath2);
                } else {
                    treePath2 = treePath2.pathByAddingChild(treePath.getPathComponent(n4));
                    n5 = this.getRowForPath(1, treePath2);
                }
                if (!this.isExpanded(treePath2)) {
                    this.expandPathRow(treePath2, n5);
                }
                ++n4;
            }
            n4 = treePath.getPathCount();
            if (n4 > 1) {
                n2 += n5 + 2 + this.treetable.getIndexOfChild(treePath.getPathComponent(n4 - 2), treePath.getPathComponent(n4 - 1));
            }
        }
        int n7 = n2 + 1;
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this.visualComponent, treePath);
        Enumeration<Object> enumeration = JCListenerList.elements(this.treeWillExpandListeners);
        while (enumeration.hasMoreElements()) {
            object = (TreeWillExpandListener)enumeration.nextElement();
            try {
                object.treeWillExpand(treeExpansionEvent);
            }
            catch (ExpandVetoException expandVetoException) {
                return;
            }
        }
        object = TreeTableSupport.getNode(treePath);
        this.expandedState.put(treePath, Boolean.TRUE);
        if (!this.isExpanded(treePath)) {
            return;
        }
        TreePath treePath3 = null;
        boolean bl = false;
        boolean bl2 = false;
        JTable jTable = null;
        ListSelectionModel listSelectionModel = null;
        if (this.visualComponent instanceof JTable) {
            jTable = (JTable)this.visualComponent;
            listSelectionModel = jTable.getSelectionModel();
        }
        if (jTable != null && this.view == 1 && listSelectionModel.isSelectedIndex(n7)) {
            treePath3 = this.getPathForRow(n7);
            if (listSelectionModel.getSelectionMode() == 0) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        Vector<TreePath> vector = new Vector<TreePath>();
        this.addKids(object, treePath, vector);
        this.rowMap.addAll(n7, vector);
        TableModelEvent tableModelEvent = new TableModelEvent(this, n7, n2 + vector.size(), -1, 1);
        this.postTableModelChanged(tableModelEvent);
        enumeration = JCListenerList.elements(this.treeExpansionListeners);
        while (enumeration.hasMoreElements()) {
            TreeExpansionListener treeExpansionListener = (TreeExpansionListener)enumeration.nextElement();
            treeExpansionListener.treeExpanded(treeExpansionEvent);
        }
        if (jTable != null && this.view == 1) {
            int n8 = this.getRowForPath(treePath3);
            if (bl) {
                jTable.setRowSelectionInterval(n8, n8);
            } else if (bl2 && n8 - n7 > 0) {
                int n9 = listSelectionModel.getAnchorSelectionIndex();
                n3 = listSelectionModel.getLeadSelectionIndex();
                if (n9 >= n8 && n3 >= n8) {
                    listSelectionModel.removeSelectionInterval(n7, n8 - 1);
                    listSelectionModel.setAnchorSelectionIndex(n9);
                    listSelectionModel.setLeadSelectionIndex(n3);
                }
            }
        }
        if (this.getScrollsOnExpand() && jTable != null && this.visualComponent.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.visualComponent.getParent();
            if (!(jViewport.getParent() instanceof JScrollPane)) {
                return;
            }
            Point point = jViewport.getViewPosition();
            n3 = jViewport.getExtentSize().height;
            Rectangle rectangle = jTable.getCellRect(n2 + vector.size(), 0, true);
            if (rectangle.y + rectangle.height <= point.y + n3) {
                return;
            }
            Rectangle rectangle2 = jTable.getCellRect(n2, 0, true);
            Rectangle rectangle3 = new Rectangle(rectangle);
            rectangle3.height = n3;
            int n10 = rectangle.y - rectangle2.y + rectangle.height;
            rectangle3.y = n10 <= n3 ? rectangle.y + rectangle.height - n3 - point.y : rectangle2.y - point.y;
            jViewport.scrollRectToVisible(rectangle3);
        }
    }

    public boolean getScrollsOnExpand() {
        return this.scrollsOnExpand;
    }

    public void setScrollsOnExpand(boolean bl) {
        boolean bl2 = this.scrollsOnExpand;
        this.scrollsOnExpand = bl;
        this.visualComponent.firePropertyChange("scrollsOnExpand", bl2, bl);
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRootVisible(boolean bl) {
        boolean bl2 = this.rootVisible;
        this.rootVisible = bl;
        this.visualComponent.firePropertyChange("rootVisible", bl2, bl);
        if (this.treetable != null) {
            this.mapTreeTable(true);
        }
    }

    public boolean getShowsRootHandles() {
        return this.showsRootHandles;
    }

    public void setShowsRootHandles(boolean bl) {
        if (bl == this.showsRootHandles) {
            return;
        }
        boolean bl2 = this.showsRootHandles;
        this.showsRootHandles = bl;
        this.visualComponent.firePropertyChange("showsRootHandles", bl2, this.showsRootHandles);
        this.visualComponent.invalidate();
    }

    public void scrollPathToVisible(TreePath treePath) {
    }

    protected class DefaultNodeIcon
    implements Icon {
        public static final int OPEN = 0;
        public static final int CLOSED = 1;
        public static final int LEAF = 2;
        protected int width = 16;
        protected int height = 18;
        protected int state = 0;

        public DefaultNodeIcon(int n2) {
            this.state = n2;
        }

        public DefaultNodeIcon(int n2, int n3, int n4) {
            this.state = n2;
            this.width = n3;
            this.height = n4;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.clearRect(n2, n3, this.width - 1, this.height - 1);
            graphics.setColor(TreeTableSupport.this.lineColor);
            if (this.state == 1) {
                graphics.fillRect(n2, n3, this.width - 1, this.height - 1);
            } else if (this.state == 2) {
                graphics.drawRect(n2, n3, this.width - 1, this.height - 1);
                graphics.drawRect(n2 + 2, n3 + 2, this.width - 5, this.height - 5);
            } else {
                graphics.drawRect(n2, n3, this.width - 1, this.height - 1);
            }
        }
    }

    protected class DefaultIcon
    implements Icon {
        protected final int size = 9;
        protected final int halfsize = 4;
        protected boolean collapsed;

        public DefaultIcon(boolean bl) {
            this.collapsed = bl;
        }

        public int getIconHeight() {
            return 9;
        }

        public int getIconWidth() {
            return 9;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.clearRect(n2 - 4, n3, 8, 8);
            graphics.drawRect(n2 - 4, n3, 8, 8);
            graphics.drawLine(n2 - 4 + 2, n3 + 4, n2 + 4 - 2, n3 + 4);
            if (this.collapsed) {
                graphics.drawLine(n2, n3 + 2, n2, n3 + 9 - 3);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RemovableVector<E>
    extends Vector<E> {
        RemovableVector() {
        }

        public void remove(int n2, int n3) {
            this.removeRange(n2, n3);
        }
    }

    class ToggleViewAction
    extends JCAction {
        public ToggleViewAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TreeTableSupport.this.view == 2) {
                TreeTableSupport.this.setView(1);
            } else {
                TreeTableSupport.this.setView(2);
            }
        }
    }

    class TreeListener
    implements TreeModelListener,
    Serializable {
        TreeListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreeTableSupport.this.mapTreeTable(true);
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreeTableSupport.this.mapTreeTable(true);
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreeTableSupport.this.mapTreeTable(true);
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            TreeTableSupport.this.mapTreeTable(true);
        }
    }
}

