/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.JCVersion;
import com.klg.jclass.util.swing.AbstractSpinBox;
import com.klg.jclass.util.swing.DefaultSpinBoxModel;
import com.klg.jclass.util.swing.JCSpinBoxModel;
import com.klg.jclass.util.swing.JCSpinBoxMutableModel;
import com.klg.jclass.util.swing.resources.LocaleBundle;
import com.klg.jclass.util.value.JCValueEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCSpinBox
extends AbstractSpinBox
implements ItemSelectable {
    protected JCSpinBoxModel model;
    protected JCListenerList itemListeners = null;
    protected JCListenerList actionListeners = null;
    protected String actionCommand = "spinBoxChanged";
    protected ListDataListener listDataListener = new ListListener();
    protected boolean modelChanging = false;
    protected KeySelectionManager keySelectionManager;
    protected Object lastSelectedItem = null;
    protected boolean firstPaint = true;

    public JCSpinBox(JCSpinBoxModel jCSpinBoxModel) {
        this.setModel(jCSpinBoxModel);
        this.setOpaque(true);
        this.updateUI();
    }

    public JCSpinBox(Object[] objectArray) {
        this.setModel(new DefaultSpinBoxModel(objectArray));
        this.updateUI();
    }

    public JCSpinBox(Vector<?> vector) {
        this.setModel(new DefaultSpinBoxModel(vector));
        this.updateUI();
    }

    public JCSpinBox() {
        this.setModel(new DefaultSpinBoxModel());
        this.updateUI();
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.isEditable() && this.firstPaint) {
            this.firstPaint = false;
            Object object = this.getModel().getSelectedItem();
            if (object == null) {
                object = this.getItemAt(0);
            }
            this.setValue(object);
        }
        super.paint(graphics);
    }

    @Override
    protected Object spinUp() {
        int n2 = this.getSelectedIndex();
        if (++n2 < this.getItemCount()) {
            return this.getItemAt(n2);
        }
        return this.getItemAt(0);
    }

    @Override
    protected Object spinDown() {
        int n2 = this.getSelectedIndex();
        if (--n2 >= 0) {
            return this.getItemAt(n2);
        }
        return this.getItemAt(this.getItemCount() - 1);
    }

    @Override
    public Object[] getSelectedObjects() {
        Object object = this.getSelectedItem();
        if (object == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    @Override
    protected void processValueChanged(JCValueEvent jCValueEvent) {
        if (this.modelChanging) {
            return;
        }
        this.model.setSelectedItem(jCValueEvent.getNewValue());
        super.processValueChanged(jCValueEvent);
    }

    @Override
    protected void checkArrowButtons() {
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public void setModel(JCSpinBoxModel jCSpinBoxModel) {
        JCSpinBoxModel jCSpinBoxModel2 = this.model;
        if (this.model != null) {
            this.model.removeListDataListener(this.listDataListener);
        }
        this.model = jCSpinBoxModel;
        this.firePropertyChange("model", jCSpinBoxModel2, this.model);
        this.model.addListDataListener(this.listDataListener);
        if (!this.isEditable()) {
            this.setValue(this.model.getElementAt(0));
        }
        this.invalidate();
    }

    public JCSpinBoxModel getModel() {
        return this.model;
    }

    public Object getItemAt(int n2) {
        return this.model.getElementAt(n2);
    }

    public int getItemCount() {
        return this.model.getSize();
    }

    public void setKeySelectionManager(KeySelectionManager keySelectionManager) {
        this.keySelectionManager = keySelectionManager;
    }

    public KeySelectionManager getKeySelectionManager() {
        return this.keySelectionManager;
    }

    public boolean selectWithKeyChar(char c2) {
        int n2;
        if (this.keySelectionManager == null) {
            this.keySelectionManager = new DefaultKeySelectionManager();
        }
        if ((n2 = this.keySelectionManager.selectionForKey(c2, this.getModel())) != -1) {
            this.setSelectedIndex(n2);
            return true;
        }
        return false;
    }

    public void setSelectedIndex(int n2) {
        int n3 = this.model.getSize();
        if (n2 == -1) {
            this.setSelectedItem(null);
        } else {
            if (n2 < -1 || n2 >= n3) {
                throw new IllegalArgumentException(LocaleBundle.string("Selected Index out of bounds: ") + n2);
            }
            this.setSelectedItem(this.model.getElementAt(n2));
        }
    }

    public int getSelectedIndex() {
        Object object = this.model.getSelectedItem();
        int n2 = this.model.getSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = this.model.getElementAt(i2);
            if (!e2.equals(object)) continue;
            return i2;
        }
        return -1;
    }

    public void setSelectedItem(Object object) {
        this.setValue(object);
    }

    public Object getSelectedItem() {
        return this.model.getSelectedItem();
    }

    public void insertItemAt(Object object, int n2) {
        this.checkSpinBoxMutableModel();
        ((JCSpinBoxMutableModel)this.model).insertElementAt(object, n2);
    }

    public void addItem(Object object) {
        this.checkSpinBoxMutableModel();
        ((JCSpinBoxMutableModel)this.model).addElement(object);
    }

    public void removeItem(Object object) {
        this.checkSpinBoxMutableModel();
        ((JCSpinBoxMutableModel)this.model).removeElement(object);
    }

    public void removeItemAt(int n2) {
        this.checkSpinBoxMutableModel();
        ((JCSpinBoxMutableModel)this.model).removeElementAt(n2);
    }

    public void removeAllItems() {
        this.checkSpinBoxMutableModel();
        JCSpinBoxMutableModel jCSpinBoxMutableModel = (JCSpinBoxMutableModel)this.model;
        int n2 = jCSpinBoxMutableModel.getSize();
        if (jCSpinBoxMutableModel instanceof DefaultSpinBoxModel) {
            ((DefaultSpinBoxModel)jCSpinBoxMutableModel).removeAllElements();
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                Object e2 = jCSpinBoxMutableModel.getElementAt(0);
                jCSpinBoxMutableModel.removeElement(e2);
            }
        }
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.itemListeners = JCListenerList.add(this.itemListeners, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.itemListeners = JCListenerList.remove(this.itemListeners, itemListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.add(this.actionListeners, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = JCListenerList.remove(this.actionListeners, actionListener);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    protected int preferredWidthOfView() {
        int n2 = 10;
        for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
            Component component;
            if (this.isEditable()) {
                this.editor.setItem(this.getItemAt(i2));
                component = this.editor.getEditorComponent();
                n2 = Math.max(n2, component.getPreferredSize().width);
                continue;
            }
            component = this.renderer.getComponent(this, this.getItemAt(i2));
            n2 = Math.max(n2, component.getPreferredSize().width + 8);
        }
        if (this.isEditable()) {
            this.editor.setItem(this.valueModel.getValue());
        } else {
            this.renderer.getComponent(this, this.valueModel.getValue());
        }
        return n2;
    }

    protected void checkSpinBoxMutableModel() {
        if (!(this.model instanceof JCSpinBoxMutableModel)) {
            throw new InternalError(LocaleBundle.string("Cannot use this method with a non-Mutable data model."));
        }
    }

    protected void modelChanged() {
        ItemListener itemListener;
        Enumeration<Object> enumeration;
        ItemEvent itemEvent;
        this.modelChanging = true;
        this.editor.setItem(this.model.getSelectedItem());
        this.renderer.getComponent(this, this.model.getSelectedItem());
        this.modelChanging = false;
        Object object = this.model.getSelectedItem();
        if (this.lastSelectedItem != object && this.lastSelectedItem != null) {
            itemEvent = new ItemEvent(this, 701, this.lastSelectedItem, 2);
            enumeration = JCListenerList.elements(this.itemListeners);
            while (enumeration.hasMoreElements()) {
                itemListener = (ItemListener)enumeration.nextElement();
                itemListener.itemStateChanged(itemEvent);
            }
        }
        this.lastSelectedItem = object;
        if (object != null) {
            itemEvent = new ItemEvent(this, 701, object, 1);
            enumeration = JCListenerList.elements(this.itemListeners);
            while (enumeration.hasMoreElements()) {
                itemListener = (ItemListener)enumeration.nextElement();
                itemListener.itemStateChanged(itemEvent);
            }
        }
    }

    @Override
    protected void handleKeyPressed(KeyEvent keyEvent) {
        if (!this.isEditable() && this.selectWithKeyChar(keyEvent.getKeyChar())) {
            keyEvent.consume();
        }
    }

    class DefaultKeySelectionManager
    implements KeySelectionManager,
    Serializable {
        DefaultKeySelectionManager() {
        }

        public int selectionForKey(char c2, JCSpinBoxModel jCSpinBoxModel) {
            String string;
            int n2;
            int n3;
            int n4 = -1;
            Object object = jCSpinBoxModel.getSelectedItem();
            if (object != null) {
                object = object.toString();
                n3 = jCSpinBoxModel.getSize();
                for (n2 = 0; n2 < n3; ++n2) {
                    if (!object.equals(jCSpinBoxModel.getElementAt(n2).toString())) continue;
                    n4 = n2;
                    break;
                }
            }
            String string2 = ("" + c2).toLowerCase();
            c2 = string2.charAt(0);
            n3 = jCSpinBoxModel.getSize();
            for (n2 = ++n4; n2 < n3; ++n2) {
                string = jCSpinBoxModel.getElementAt(n2).toString().toLowerCase();
                if (string.length() <= 0 || string.charAt(0) != c2) continue;
                return n2;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                string = jCSpinBoxModel.getElementAt(n2).toString().toLowerCase();
                if (string.length() <= 0 || string.charAt(0) != c2) continue;
                return n2;
            }
            return -1;
        }
    }

    public static interface KeySelectionManager {
        public int selectionForKey(char var1, JCSpinBoxModel var2);
    }

    class ListListener
    implements ListDataListener,
    Serializable {
        ListListener() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            JCSpinBox.this.modelChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            JCSpinBox.this.modelChanged();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            JCSpinBox.this.modelChanged();
        }
    }
}

