/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCLocaleManager;
import com.klg.jclass.util.JCVersion;
import com.klg.jclass.util.swing.FontChooserDialog;
import com.klg.jclass.util.swing.JCFontChooser;
import com.klg.jclass.util.swing.JCFontEvent;
import com.klg.jclass.util.swing.JCGridLayout;
import com.klg.jclass.util.swing.OKButtonListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JCFontChooserPane
extends JCFontChooser
implements ActionListener,
FocusListener,
ListSelectionListener,
Serializable {
    public static final int NONE = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    public static final int ALL = 7;
    private static final int SAMPLE_PREFERRED_HEIGHT = 100;
    private static final int SAMPLE_TEXT_X_LIMIT = 5;
    private static final int SAMPLE_TEXT_Y_LIMIT = 95;
    private static final String SAMPLE_TEXT = "AaBbYyZz";
    protected JTextField fontNameTextField;
    protected JList fontNameList;
    protected JTextField fontSizeTextField;
    protected JList fontSizeList;
    protected JCheckBox boldCheckbox;
    protected JCheckBox italicCheckbox;
    protected JCheckBox underlineCheckbox;
    protected JPanel stylePanel;
    protected boolean toolTipEnabled;
    protected int styleControls = 7;
    private JPanel listPanel;
    private SamplePanel samplePanel;
    private boolean ignoreEvents;

    public JCFontChooserPane() {
        this.init();
    }

    public JCFontChooserPane(Font font) {
        super(font);
        this.init();
    }

    public JCFontChooserPane(Font font, boolean bl) {
        super(font, bl);
        this.init();
    }

    public JCFontChooserPane(String string, int n2, int n3, boolean bl) {
        super(string, n2, n3, bl);
        this.init();
    }

    protected void init() {
        this.setLayout(new JCGridLayout(3, 1));
        JCLocaleManager jCLocaleManager = JCLocaleManager.getDefault();
        JLabel jLabel = new JLabel(jCLocaleManager.getString("Font: "));
        this.fontNameTextField = new JTextField();
        this.fontNameTextField.setEnabled(false);
        this.fontNameList = new JList();
        this.fontNameList.setSelectionMode(1);
        this.setNameList();
        this.fontNameList.setListData(this.getNameList());
        this.fontNameList.addListSelectionListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.fontNameTextField, "North");
        jPanel.add((Component)new JScrollPane(this.fontNameList), "Center");
        JLabel jLabel2 = new JLabel(jCLocaleManager.getString("Size: "));
        this.fontSizeTextField = new JTextField(5);
        this.fontSizeTextField.setEditable(true);
        this.fontSizeList = new JList();
        this.fontSizeList.setSelectionMode(1);
        this.fontSizeList.setListData(JCFontChooserPane.getSizeList());
        this.fontSizeTextField.addActionListener(this);
        this.fontSizeTextField.addFocusListener(this);
        this.fontSizeList.addListSelectionListener(this);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.fontSizeTextField, "North");
        jPanel2.add((Component)new JScrollPane(this.fontSizeList), "Center");
        this.listPanel = new JPanel(new JCGridLayout(3, 2, 5, 5));
        this.listPanel.add(jLabel);
        this.listPanel.add(jLabel2);
        this.listPanel.add(jPanel);
        this.listPanel.add(jPanel2);
        this.add(this.listPanel);
        this.stylePanel = new JPanel(new FlowLayout(0));
        this.stylePanel.setBorder(new TitledBorder(jCLocaleManager.getString("Style")));
        this.boldCheckbox = new JCheckBox(jCLocaleManager.getString("Bold"));
        this.italicCheckbox = new JCheckBox(jCLocaleManager.getString("Italic"));
        this.underlineCheckbox = new JCheckBox(jCLocaleManager.getString("Underline"));
        this.boldCheckbox.addActionListener(this);
        this.italicCheckbox.addActionListener(this);
        this.underlineCheckbox.addActionListener(this);
        this.stylePanel.add(this.boldCheckbox);
        this.stylePanel.add(this.italicCheckbox);
        this.stylePanel.add(this.underlineCheckbox);
        this.add(this.stylePanel);
        this.samplePanel = new SamplePanel();
        this.samplePanel.setLayout(new FlowLayout());
        this.samplePanel.setBorder(new TitledBorder(jCLocaleManager.getString("Sample")));
        this.add(this.samplePanel);
        this.setFontChooserPane();
        this.setToolTipEnabled(true);
    }

    public void setNameList(String[] stringArray) {
        super.setNameList(stringArray);
        this.fontNameList.removeListSelectionListener(this);
        this.fontNameList.setListData(stringArray);
        this.fontNameList.addListSelectionListener(this);
        this.fontNameList.setSelectedValue(this.getFontName(), true);
    }

    protected void setFontChooserPane() {
        this.fontNameList.setSelectedValue(this.getFontName(), true);
        this.fontNameTextField.setText(this.getFontName());
        this.fontSizeList.setSelectedValue(new Integer(this.getFontSize()).toString(), true);
        this.fontSizeTextField.setText(new Integer(this.getFontSize()).toString());
        this.boldCheckbox.setSelected(this.isBold());
        this.italicCheckbox.setSelected(this.isItalic());
        this.underlineCheckbox.setSelected(this.isUnderline());
        this.updateSamplePanel();
    }

    protected void updateSamplePanel() {
        this.samplePanel.repaint();
    }

    protected void updateControls() {
        this.boldCheckbox.setVisible((this.styleControls & 1) != 0);
        this.italicCheckbox.setVisible((this.styleControls & 2) != 0);
        this.underlineCheckbox.setVisible((this.styleControls & 4) != 0);
        this.remove(this.stylePanel);
        if (this.styleControls != 0) {
            this.add((Component)this.stylePanel, 1);
        }
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public void setStyleControls(int n2) {
        this.styleControls = n2;
        this.updateControls();
    }

    public int getStyleControls() {
        return this.styleControls;
    }

    public void setToolTipEnabled(boolean bl) {
        JCLocaleManager jCLocaleManager = JCLocaleManager.getDefault();
        this.toolTipEnabled = bl;
        if (bl) {
            this.fontNameList.setToolTipText(jCLocaleManager.getString("Font"));
            this.fontNameTextField.setToolTipText(jCLocaleManager.getString("Font"));
            this.fontSizeList.setToolTipText(jCLocaleManager.getString("Font Size"));
            this.fontSizeTextField.setToolTipText(jCLocaleManager.getString("Font Size"));
            this.boldCheckbox.setToolTipText(jCLocaleManager.getString("Bold"));
            this.italicCheckbox.setToolTipText(jCLocaleManager.getString("Italic"));
            this.underlineCheckbox.setToolTipText(jCLocaleManager.getString("Underline"));
        } else {
            this.setToolTipText(null);
            this.fontNameList.setToolTipText(null);
            this.fontNameTextField.setToolTipText(null);
            this.fontSizeList.setToolTipText(null);
            this.fontSizeTextField.setToolTipText(null);
            this.boldCheckbox.setToolTipText(null);
            this.italicCheckbox.setToolTipText(null);
            this.underlineCheckbox.setToolTipText(null);
        }
    }

    public boolean isToolTipEnabled() {
        return this.toolTipEnabled;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.boldCheckbox) {
            this.setOldFont();
            this.setBold(((JCheckBox)actionEvent.getSource()).isSelected());
            this.updateSamplePanel();
            this.fireJCFontEvent(4);
        } else if (actionEvent.getSource() == this.italicCheckbox) {
            this.setOldFont();
            this.setItalic(((JCheckBox)actionEvent.getSource()).isSelected());
            this.updateSamplePanel();
            this.fireJCFontEvent(5);
        } else if (actionEvent.getSource() == this.underlineCheckbox) {
            this.setOldFont();
            this.setUnderline(((JCheckBox)actionEvent.getSource()).isSelected());
            this.updateSamplePanel();
            this.fireJCFontEvent(6);
        } else if (actionEvent.getSource() == this.fontSizeTextField) {
            this.processFontSizeTextChange();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.fontSizeTextField) {
            this.processFontSizeTextChange();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.ignoreEvents || listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() == this.fontNameList) {
            this.setOldFont();
            this.setFontName(this.fontNameList.getSelectedValue().toString());
            this.fontNameTextField.setText(this.getFontName());
            this.updateSamplePanel();
            this.fireJCFontEvent(2);
        } else if (listSelectionEvent.getSource() == this.fontSizeList) {
            try {
                this.setOldFont();
                Object e2 = this.fontSizeList.getSelectedValue();
                this.setFontSize(Integer.parseInt(e2.toString()));
                this.fontSizeTextField.setText(new Integer(this.getFontSize()).toString());
                this.updateSamplePanel();
                this.fireJCFontEvent(3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void processFontSizeTextChange() {
        this.setOldFont();
        this.setFontSize(Integer.parseInt(this.fontSizeTextField.getText()));
        this.ignoreEvents = true;
        this.fontSizeList.clearSelection();
        this.fontSizeList.setSelectedValue(new Integer(this.getFontSize()).toString(), true);
        this.ignoreEvents = false;
        this.updateSamplePanel();
        this.fireJCFontEvent(3);
    }

    protected void fireJCFontEvent(int n2) {
        JCFontEvent jCFontEvent = new JCFontEvent(this, n2, this.oldFont, this.oldUnderline, this.getSelectedFont(), this.isUnderline(), true);
        this.fireJCFontChangingEvent(jCFontEvent);
        if (jCFontEvent.isCancelFontChange()) {
            this.setFontValues(this.oldFont, this.oldUnderline);
            this.setFontChooserPane();
        } else if (jCFontEvent.isFontChanged()) {
            this.setFontValues(jCFontEvent.getFont(), jCFontEvent.getUnderline());
            this.setFontChooserPane();
        }
        if (!jCFontEvent.isCancelFontChange()) {
            this.fireJCFontChangedEvent(new JCFontEvent(this, n2, this.oldFont, this.oldUnderline, this.getSelectedFont(), this.isUnderline(), false));
        }
    }

    public void setSelectedFont(String string, int n2, int n3, boolean bl) {
        this.setOldFont();
        super.setSelectedFont(string, n2, n3, bl);
        this.setFontChooserPane();
        this.fireJCFontEvent(1);
    }

    public void setSelectedFont(Font font, boolean bl) {
        this.setSelectedFont(font.getName(), font.getStyle(), font.getSize(), bl);
    }

    public void setSelectedFont(Font font) {
        this.setSelectedFont(font.getName(), font.getStyle(), font.getSize(), JCFontChooser.isUnderline(font));
    }

    public static Font showDialog(Component component, String string, int n2, Font font) {
        JCFontChooserPane jCFontChooserPane = new JCFontChooserPane(font != null ? font : new Font("Dialog", 0, 12));
        jCFontChooserPane.setStyleControls(n2);
        OKButtonListener oKButtonListener = new OKButtonListener(jCFontChooserPane);
        FontChooserDialog fontChooserDialog = new FontChooserDialog(component, string, true, jCFontChooserPane, oKButtonListener);
        fontChooserDialog.addWindowListener(new ClosingWindowAdapter());
        fontChooserDialog.addComponentListener(new DisposingAdapter());
        fontChooserDialog.setVisible(true);
        return oKButtonListener.getFont();
    }

    private static class DisposingAdapter
    extends ComponentAdapter
    implements Serializable {
        private DisposingAdapter() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            Window window = (Window)componentEvent.getComponent();
            window.dispose();
        }
    }

    private static class ClosingWindowAdapter
    extends WindowAdapter
    implements Serializable {
        private ClosingWindowAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Window window = windowEvent.getWindow();
            window.setVisible(false);
        }
    }

    class SamplePanel
    extends JPanel {
        SamplePanel() {
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            if (JCFontChooserPane.this.listPanel != null) {
                Dimension dimension = JCFontChooserPane.this.listPanel.getPreferredSize();
                return new Dimension(dimension.width, 100);
            }
            return new Dimension(234, 100);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Font font = JCFontChooserPane.this.getSelectedFont();
            Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() + 2);
            AttributedString attributedString = new AttributedString("Hack");
            attributedString.addAttribute(TextAttribute.FONT, font2);
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
            AttributedString attributedString2 = new AttributedString(JCFontChooserPane.SAMPLE_TEXT);
            attributedString2.addAttribute(TextAttribute.FONT, font);
            if (JCFontChooserPane.this.isUnderline()) {
                attributedString2.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            AttributedCharacterIterator attributedCharacterIterator2 = attributedString2.getIterator();
            TextLayout textLayout2 = new TextLayout(attributedCharacterIterator2, fontRenderContext);
            graphics2D.setColor(Color.black);
            Rectangle rectangle = graphics2D.getClipBounds();
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            int n2 = (rectangle.x + rectangle.width - fontMetrics.stringWidth(JCFontChooserPane.SAMPLE_TEXT)) / 2;
            n2 = Math.max(5, n2);
            int n3 = (100 + fontMetrics.getAscent()) / 2;
            n3 = Math.min(95, n3);
            textLayout2.draw(graphics2D, n2, n3);
        }
    }
}

