/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.swing.JCComparableRow;
import com.klg.jclass.util.swing.JCRowComparator;
import com.klg.jclass.util.swing.resources.LocaleBundle;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;

public class DefaultRowComparator
implements JCRowComparator,
Serializable {
    public static final int FORWARD = 1;
    public static final int REVERSE = -1;
    protected int order = 1;
    protected int[] keyColumns = new int[]{0};

    public DefaultRowComparator(int n2) {
        this.setSortOrder(n2);
    }

    public DefaultRowComparator(int n2, int[] nArray) {
        this.setSortOrder(n2);
        this.setKeyColumns(nArray);
    }

    public void setKeyColumns(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            String string = LocaleBundle.string("KeyColumns must by non-null and non-empty");
            throw new IllegalArgumentException(string);
        }
        this.keyColumns = nArray;
    }

    public int[] getKeyColumns() {
        return this.keyColumns;
    }

    public void setSortOrder(int n2) {
        if (n2 != 1 && n2 != -1) {
            String string = LocaleBundle.string("SortOrder must be one of FORWARD or REVERSE");
            throw new IllegalArgumentException(string);
        }
        this.order = n2;
    }

    public int getSortOrder() {
        return this.order;
    }

    public int compare(JCComparableRow jCComparableRow, JCComparableRow jCComparableRow2) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.keyColumns.length && n2 == 0; ++i2) {
            int n3;
            Object object;
            Object object2 = jCComparableRow.getValueAt(this.keyColumns[i2]);
            if (object2 == (object = jCComparableRow2.getValueAt(this.keyColumns[i2]))) continue;
            if (object2 == null) {
                n2 = -1;
                continue;
            }
            if (object == null) {
                n2 = 1;
                continue;
            }
            if (object2 instanceof String && object instanceof String) {
                n2 = ((String)object2).compareTo((String)object);
                continue;
            }
            if (object2 instanceof Boolean && object instanceof Boolean) {
                int n4 = ((Boolean)object2).booleanValue();
                n2 = n4 == (n3 = ((Boolean)object).booleanValue()) ? 0 : (n3 != 0 ? -1 : 1);
                continue;
            }
            if (object2 instanceof Date && object instanceof Date) {
                long l2;
                long l3 = ((Date)object2).getTime();
                n2 = l3 < (l2 = ((Date)object).getTime()) ? -1 : (l3 == l2 ? 0 : 1);
                continue;
            }
            if (object2 instanceof Float && object instanceof Float) {
                float f2;
                float f3 = ((Float)object2).floatValue();
                n2 = f3 < (f2 = ((Float)object).floatValue()) ? -1 : (f3 == f2 ? 0 : 1);
                continue;
            }
            if (object2 instanceof Double && object instanceof Double) {
                double d2;
                double d3 = (Double)object2;
                n2 = d3 < (d2 = ((Double)object).doubleValue()) ? -1 : (d3 == d2 ? 0 : 1);
                continue;
            }
            if (object2 instanceof Integer && object instanceof Integer) {
                int n5 = (Integer)object2;
                n2 = n5 < (n3 = ((Integer)object).intValue()) ? -1 : (n5 == n3 ? 0 : 1);
                continue;
            }
            if (object2 instanceof Long && object instanceof Long) {
                long l4;
                long l5 = (Long)object2;
                n2 = l5 < (l4 = ((Long)object).longValue()) ? -1 : (l5 == l4 ? 0 : 1);
                continue;
            }
            if (object2 instanceof BigInteger && object instanceof BigInteger) {
                n2 = ((BigInteger)object2).compareTo((BigInteger)object);
                continue;
            }
            if (object2 instanceof Number && object instanceof Number) {
                double d4;
                double d5 = ((Number)object2).doubleValue();
                n2 = d5 < (d4 = ((Number)object).doubleValue()) ? -1 : (d5 == d4 ? 0 : 1);
                continue;
            }
            if (!(object2 instanceof Comparable) || !(object instanceof Comparable)) continue;
            n2 = ((Comparable)object2).compareTo(object);
        }
        return this.order * n2;
    }
}

