/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.calendar.AbstractLabel;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueModel;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;

public class TimeLabel
extends AbstractLabel {
    protected DateFormat dateFormat;

    public TimeLabel(JCValueModel jCValueModel, Locale locale) {
        this.setLocale(locale);
        this.setCalendarModel(jCValueModel);
    }

    public TimeLabel(JCValueModel jCValueModel, DateFormat dateFormat) {
        this.setDateFormat(dateFormat);
        this.setCalendarModel(jCValueModel);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.updateLabel();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.setDateFormat(DateFormat.getTimeInstance(2, this.getLocale()));
    }

    public void setCalendarModel(JCValueModel jCValueModel) {
        super.setCalendarModel(jCValueModel);
        this.updateLabel();
    }

    public void valueChanged(JCValueEvent jCValueEvent) {
        this.updateLabel();
    }

    protected void updateLabel() {
        Calendar calendar;
        if (this.model != null && this.dateFormat != null && (calendar = (Calendar)this.model.getValue()) != null) {
            this.setText(this.dateFormat.format(calendar.getTime()));
        }
    }
}

