/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCVersion;
import com.klg.jclass.util.calendar.BoundsValidator;
import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.CalendarContainer;
import com.klg.jclass.util.calendar.DayTable;
import com.klg.jclass.util.calendar.JCCalendar;
import com.klg.jclass.util.calendar.MonthLabel;
import com.klg.jclass.util.calendar.MonthPopdown;
import com.klg.jclass.util.calendar.MonthSpin;
import com.klg.jclass.util.calendar.MonthTable;
import com.klg.jclass.util.calendar.YearLabel;
import com.klg.jclass.util.calendar.YearSpin;
import com.klg.jclass.util.value.CalendarValueModel;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.TableColumn;

public class JCDateChooser
extends CalendarContainer
implements Serializable {
    public static final int QUICK_SELECT = 1;
    public static final int DUAL_SPIN = 2;
    public static final int SPIN_POPDOWN = 3;
    public static final int READ_ONLY = 4;
    protected int chooserType;
    protected CalendarComponent year;
    protected CalendarComponent month;
    protected CalendarComponent day;
    protected String[] months = null;
    protected String[] shortMonths = null;
    protected String[] days = null;
    protected int componentSpacing = 4;
    protected BoundsValidator boundsValidator = new BoundsValidator(this);

    public JCDateChooser() {
        this(new CalendarValueModel(Calendar.getInstance()), Locale.getDefault(), 1, null, null, null);
    }

    public JCDateChooser(JCValueModel jCValueModel, Locale locale) {
        this(jCValueModel, locale, 1, null, null, null);
    }

    public JCDateChooser(JCValueModel jCValueModel, Locale locale, int n2) {
        this(jCValueModel, locale, n2, null, null, null);
    }

    public JCDateChooser(JCValueModel jCValueModel, Locale locale, int n2, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this.months = stringArray;
        this.shortMonths = stringArray2;
        this.days = stringArray3;
        this.setCalendarModel(jCValueModel);
        this.setLocale(locale);
        this.setLayout(new Layout());
        this.setChooserType(n2);
    }

    public int getChooserType() {
        return this.chooserType;
    }

    public void setChooserType(int n2) {
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException("Chooser type must be one of JCDateChooser.QUICK_SELECT,JCDateChooser.DUAL_SPIN,JCDateChooser.SPIN_POPDOWN, or JCDateChooser.READ_ONLY");
        }
        if (this.chooserType == n2) {
            return;
        }
        this.createComponents(n2);
        this.chooserType = n2;
    }

    protected void forceRelayout() {
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    public String getVersion() {
        return JCVersion.getVersionString();
    }

    public void setVersion(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public synchronized void setAbout(String string) {
    }

    public Calendar getValue() {
        return (Calendar)this.model.getValue();
    }

    public void setValue(Calendar calendar) {
        this.model.setValue(calendar);
    }

    public Calendar getMinimumDate() {
        return this.boundsValidator.getMinimumDate();
    }

    public void setMinimumDate(Calendar calendar) {
        this.boundsValidator.setMinimumDate(calendar);
    }

    public Calendar getMaximumDate() {
        return this.boundsValidator.getMaximumDate();
    }

    public void setMaximumDate(Calendar calendar) {
        this.boundsValidator.setMaximumDate(calendar);
    }

    protected boolean checkMonths(String[] stringArray, boolean bl) {
        boolean bl2 = true;
        String[] stringArray2 = JCCalendar.getMonths(this.getLocale(), bl);
        if (stringArray != null && stringArray.length < stringArray2.length) {
            throw new IllegalArgumentException("The months array must be at least " + stringArray2.length + " in size.");
        }
        return bl2;
    }

    public String[] getMonths() {
        return this.months;
    }

    public void setMonths(String[] stringArray) {
        if (this.checkMonths(stringArray, false)) {
            this.months = stringArray;
            this.createComponents(this.chooserType);
        }
    }

    public String[] getShortMonths() {
        return this.shortMonths;
    }

    public void setShortMonths(String[] stringArray) {
        if (this.checkMonths(stringArray, true)) {
            this.shortMonths = stringArray;
            this.createComponents(this.chooserType);
        }
    }

    public String[] getDays() {
        return this.days;
    }

    public void setDays(String[] stringArray) {
        String[] stringArray2 = JCCalendar.getDays(this.getLocale());
        if (stringArray != null && stringArray.length < stringArray2.length) {
            throw new IllegalArgumentException("The days array must be at least " + stringArray2.length + " in size.");
        }
        this.days = stringArray;
        this.createComponents(this.chooserType);
    }

    public void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
    }

    public void setCalendarModel(JCValueModel jCValueModel) {
        JCValueModel jCValueModel2 = this.model;
        super.setCalendarModel(jCValueModel);
        if (jCValueModel2 != null) {
            jCValueModel2.removeValueListener(this.boundsValidator);
        }
        if (jCValueModel != null) {
            jCValueModel.addValueListener(this.boundsValidator);
        }
    }

    public CalendarComponent getDayComponent() {
        return this.day;
    }

    public CalendarComponent getMonthComponent() {
        return this.month;
    }

    public CalendarComponent getYearComponent() {
        return this.year;
    }

    protected void createComponents(int n2) {
        JComponent jComponent = (JComponent)((Object)this.year);
        JComponent jComponent2 = (JComponent)((Object)this.month);
        JComponent jComponent3 = (JComponent)((Object)this.day);
        switch (n2) {
            case 3: {
                this.year = new YearSpin(this.model, this.locale);
                this.month = new MonthPopdown(this.model, this.locale, this.months);
                this.day = new DayTable(this.model, this.specialDates, this.locale, this.days);
                break;
            }
            case 2: {
                this.year = new YearSpin(this.model, this.locale);
                this.month = new MonthSpin(this.model, this.locale, this.months);
                this.day = new DayTable(this.model, this.specialDates, this.locale, this.days);
                break;
            }
            case 1: {
                this.year = new YearSpin(this.model, this.locale);
                this.month = new MonthTable(this.model, this.locale, this.shortMonths);
                this.day = new DayTable(this.model, this.specialDates, this.locale, this.days);
                break;
            }
            case 4: {
                this.year = new YearLabel(this.model, this.locale);
                this.month = new MonthLabel(this.model, this.locale, this.months);
                this.day = new DayTable(this.model, this.specialDates, this.locale, this.days);
                ((DayTable)this.day).setEditable(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for ChooserType");
            }
        }
        if (this.userFont != null) {
            ((Component)((Object)this.year)).setFont(this.userFont);
            ((Component)((Object)this.month)).setFont(this.userFont);
            ((Component)((Object)this.day)).setFont(this.userFont);
        }
        if (this.getComponentCount() != 0) {
            this.removeAll();
        }
        this.add((Component)((Object)this.year));
        this.add((Component)((Object)this.month));
        this.add((Component)((Object)this.day));
        if (jComponent != null) {
            this.remove(jComponent);
        }
        if (jComponent2 != null) {
            this.remove(jComponent2);
        }
        if (jComponent3 != null) {
            this.remove(jComponent3);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        ((JComponent)((Object)this.getYearComponent())).setEnabled(bl);
        ((DayTable)this.getDayComponent()).setEditable(bl);
        ((JComponent)((Object)this.getMonthComponent())).setEnabled(bl);
    }

    private class Layout
    implements LayoutManager2,
    Serializable {
        private Layout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Component component = (Component)((Object)JCDateChooser.this.year);
            Component component2 = (Component)((Object)JCDateChooser.this.month);
            Component component3 = (Component)((Object)JCDateChooser.this.day);
            Dimension dimension = component.getPreferredSize();
            Dimension dimension2 = component2.getPreferredSize();
            Dimension dimension3 = component3.getPreferredSize();
            if (JCDateChooser.this.chooserType == 1) {
                return new Dimension(Math.max(dimension3.width, Math.max(dimension.width, dimension2.width)), dimension2.height + dimension.height + dimension3.height + 3 * JCDateChooser.this.componentSpacing);
            }
            return new Dimension(Math.max(dimension3.width, dimension.width + dimension2.width + JCDateChooser.this.componentSpacing), Math.max(dimension2.height, dimension.height) + 2 * JCDateChooser.this.componentSpacing + dimension3.height);
        }

        public Dimension minimumLayoutSize(Container container) {
            Component component = (Component)((Object)JCDateChooser.this.year);
            Component component2 = (Component)((Object)JCDateChooser.this.month);
            Component component3 = (Component)((Object)JCDateChooser.this.day);
            Dimension dimension = component.getMinimumSize();
            Dimension dimension2 = component2.getMinimumSize();
            Dimension dimension3 = component3.getMinimumSize();
            if (JCDateChooser.this.chooserType == 1) {
                return new Dimension(Math.max(dimension3.width, Math.max(dimension.width, dimension2.width)), dimension2.height + dimension.height + dimension3.height + JCDateChooser.this.componentSpacing);
            }
            return new Dimension(Math.max(dimension3.width, dimension.width + dimension2.width), Math.max(dimension2.height, dimension.height) + dimension3.height + JCDateChooser.this.componentSpacing);
        }

        public void layoutContainer(Container container) {
            int n2;
            int n3;
            int n4;
            int n5;
            Component component = (Component)((Object)JCDateChooser.this.year);
            Component component2 = (Component)((Object)JCDateChooser.this.month);
            Component component3 = (Component)((Object)JCDateChooser.this.day);
            Dimension dimension = component.getPreferredSize();
            Dimension dimension2 = component2.getPreferredSize();
            Dimension dimension3 = component3.getPreferredSize();
            Dimension dimension4 = container.getSize();
            if (JCDateChooser.this.chooserType == 1) {
                n5 = JCDateChooser.this.componentSpacing;
                n4 = dimension.height;
                if (dimension4.width > dimension.width) {
                    n3 = (dimension4.width - dimension.width) / 2;
                    n2 = dimension.width;
                } else {
                    n3 = 0;
                    n2 = dimension4.width;
                }
                component.setBounds(n3, n5, n2, n4);
                n5 += n4;
                n4 = dimension2.height;
                n3 = 0;
                n2 = dimension4.width;
                component2.setBounds(n3, n5 += JCDateChooser.this.componentSpacing, n2, n4);
                if (JCEnvironment.getJavaVersion() < 130) {
                    MonthTable monthTable = (MonthTable)component2;
                    Enumeration<TableColumn> enumeration = monthTable.getColumnModel().getColumns();
                    while (enumeration.hasMoreElements()) {
                        TableColumn tableColumn = enumeration.nextElement();
                        Insets insets = monthTable.getInsets();
                        int n6 = (n2 + insets.left + insets.right + 5) / 6;
                        tableColumn.setMinWidth(n6);
                    }
                }
            } else {
                n5 = JCDateChooser.this.componentSpacing;
                n4 = Math.max(dimension.height, dimension2.height);
                if (dimension4.width > dimension.width + dimension2.width) {
                    n3 = (dimension4.width - (dimension.width + dimension2.width)) / 2;
                    n2 = -1;
                } else {
                    n3 = 0;
                    n2 = dimension4.width / 2;
                }
                int n7 = n2 == -1 ? dimension.width : n2;
                component.setBounds(n3, n5, n7, n4);
                n3 += n7;
                n7 = n2 == -1 ? dimension2.width : dimension4.width - n2;
                component2.setBounds(n3 += JCDateChooser.this.componentSpacing, n5, n7, n4);
            }
            n5 += n4;
            n4 = dimension3.height;
            n3 = 0;
            n2 = dimension4.width;
            component3.setBounds(n3, n5 += JCDateChooser.this.componentSpacing, n2, n4);
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public Dimension maximumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }
    }
}

