/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import com.klg.jclass.util.JCGraphicsUtil;
import java.awt.geom.Point2D;

public class JCNumberUtil
extends JCGraphicsUtil {
    public static final double M_PI = Math.PI;
    public static final double M_PI_2 = 1.5707963267948966;
    public static final double M_2PI = Math.PI * 2;
    public static final double M_SQRT2 = 1.4142135623730951;
    public static final double DEFAULT_FLOAT = Double.MAX_VALUE;
    public static final double LOG_TEN_BASE_E = 2.302585092994;
    public static char DECIMAL = '\u0000';
    static final String[] tens_str = new String[]{"0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000", "00000000000", "000000000000"};
    static double[] tens_val = new double[]{1.0E-12, 1.0E-11, 1.0E-10, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12};

    public static char getDecimalPointChar() {
        if (DECIMAL != '\u0000') {
            return DECIMAL;
        }
        DECIMAL = Double.toString(5.5).charAt(1);
        return DECIMAL;
    }

    public static boolean validUnit(int n2) {
        return n2 == 1 || n2 == 2 || n2 == 3;
    }

    public static double boundAngle(int n2, double d2) {
        double d3;
        boolean bl = d2 < 0.0;
        switch (n2) {
            case 1: {
                d3 = 360.0;
                break;
            }
            case 3: {
                d3 = 400.0;
                break;
            }
            default: {
                d3 = Math.PI * 2;
            }
        }
        double d4 = JCNumberUtil.fmod(Math.abs(d2), d3);
        if (bl && d4 != 0.0) {
            d4 = -d4;
        }
        return d4;
    }

    public static double log10(double d2) {
        double d3 = Math.log(d2);
        return d3 / 2.302585092994;
    }

    public static int intLog10(double d2) {
        return (int)JCNumberUtil.precCorrect(1, JCNumberUtil.log10(d2));
    }

    public static int nicePrecision(double d2) {
        if (d2 <= 0.0) {
            return 0;
        }
        int n2 = (int)Math.floor(JCNumberUtil.log10(d2));
        double d3 = d2 / JCNumberUtil.pow10(n2);
        boolean bl = d3 < 3.0;
        return (int)(-Math.floor(JCNumberUtil.log10(d2)) + (double)bl);
    }

    public static int tickBasedPrecision(double d2) {
        int n2;
        int n3;
        if (d2 <= 0.0) {
            return 0;
        }
        String string = new Double(d2).toString();
        int n4 = string.indexOf(46);
        if (n4 >= 0) {
            n3 = string.length() - n4 - 1;
            for (n2 = string.length() - 1; n2 > n4; --n2) {
                if (string.charAt(n2) == '0') {
                    --n3;
                    continue;
                }
                n2 = n4;
            }
            if (n3 > 0) {
                return n3;
            }
        } else {
            n4 = string.length();
        }
        n3 = 0;
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            if (string.charAt(n2) == '0') {
                ++n3;
                continue;
            }
            n2 = -1;
        }
        return -n3;
    }

    public static double clamp(double d2, double d3, double d4) {
        return d2 > d4 ? d4 : (d2 < d3 ? d3 : d2);
    }

    public static int clamp(int n2, int n3, int n4) {
        return n2 > n4 ? n4 : (n2 < n3 ? n3 : n2);
    }

    public static long clamp(long l2, long l3, long l4) {
        return l2 > l4 ? l4 : (l2 < l3 ? l3 : l2);
    }

    public static double precFloor(int n2, double d2) {
        double d3 = d2;
        if (d3 < 0.0) {
            d3 = -JCNumberUtil.precCeil(n2, -d3);
        } else if (n2 >= 0) {
            String string = JCNumberUtil.internalFormat(d3, n2 + 1);
            int n3 = string.length();
            if (n3 >= 1) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.setCharAt(n3 - 1, '0');
                string = new String(stringBuffer);
            }
            double d4 = d3;
            d3 = Double.valueOf(string);
            if (d3 > d4) {
                d3 -= JCNumberUtil.pow10(-n2);
            }
        } else {
            double d5 = JCNumberUtil.pow10(-n2);
            d3 = d5 * Math.floor(d3 / d5);
        }
        return d3;
    }

    public static double precCeil(int n2, double d2) {
        double d3 = d2;
        if (d3 < 0.0) {
            d3 = -JCNumberUtil.precFloor(n2, -d3);
        } else if (n2 >= 0) {
            int n3;
            char[] cArray = JCNumberUtil.internalFormat(d3, n2 + 1).toCharArray();
            if (cArray[n3 = cArray.length - 1] != '0') {
                cArray[n3] = 48;
                --n3;
                while (n3 >= 0) {
                    if (cArray[n3] != JCNumberUtil.getDecimalPointChar()) {
                        if (cArray[n3] != '9') {
                            int n4 = n3;
                            cArray[n4] = (char)(cArray[n4] + '\u0001');
                            break;
                        }
                        cArray[n3] = 48;
                    }
                    --n3;
                }
                if (n3 < 0) {
                    char[] cArray2 = cArray;
                    cArray = new char[cArray2.length + 1];
                    for (n3 = cArray2.length; n3 > 0; --n3) {
                        cArray[n3] = cArray2[n3 - 1];
                    }
                    cArray[0] = 49;
                }
            }
            double d4 = d3;
            d3 = Double.valueOf(new String(cArray));
            if (d3 < d4) {
                d3 += JCNumberUtil.pow10(-n2);
            }
        } else {
            double d5 = JCNumberUtil.pow10(-n2);
            d3 = d5 * Math.ceil(d3 / d5);
        }
        return d3;
    }

    public static String logFormat(int n2) {
        double d2 = JCNumberUtil.pow10(n2);
        return JCNumberUtil.format(d2, -n2);
    }

    public static String format(double d2, int n2) {
        double d3 = JCNumberUtil.precCorrect(n2, d2);
        String string = String.valueOf(d3);
        if (string.indexOf(101) != -1 || string.indexOf(69) != -1) {
            return string;
        }
        int n3 = JCNumberUtil.findDecimal(string);
        if (n2 > 0) {
            if (n3 < 0) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append(JCNumberUtil.getDecimalPointChar());
                for (int i2 = 0; i2 < n2; ++i2) {
                    stringBuffer.append('0');
                }
                string = new String(stringBuffer);
            } else {
                int n4 = string.length() - n3 - 1;
                int n5 = n4 - n2;
                if (n5 < 0) {
                    StringBuffer stringBuffer = new StringBuffer(string);
                    for (int i3 = 0; i3 > n5; --i3) {
                        stringBuffer.append('0');
                    }
                    string = new String(stringBuffer);
                } else if (n5 > 0) {
                    string = string.substring(0, string.length() - n5);
                }
            }
        } else if (n2 < 0) {
            int n6 = n3 < 0 ? string.length() : n3;
            int n7 = n6 + n2;
            if (n7 >= 0) {
                StringBuffer stringBuffer = new StringBuffer(string.substring(0, n7));
                for (int i4 = 0; i4 < n6 - n7; ++i4) {
                    stringBuffer.append('0');
                }
                string = new String(stringBuffer);
            } else {
                string = "0";
            }
        } else if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        return string;
    }

    public static String internalFormat(double d2, int n2) {
        String string = JCNumberUtil.format(d2, n2);
        if (string.indexOf(101) != -1 || string.indexOf(69) != -1) {
            string = JCNumberUtil.convertFromSN(string);
        }
        return string;
    }

    public static String convertFromSN(String string) {
        StringBuffer stringBuffer;
        block17: {
            int n2;
            String string2;
            int n3;
            block16: {
                int n4;
                int n5 = string.indexOf(101);
                if (n5 < 0) {
                    n5 = string.indexOf(69);
                }
                if (n5 < 0) {
                    return string;
                }
                n3 = 0;
                if (n5 + 1 < string.length()) {
                    string2 = string.substring(n5 + 1);
                    if (string2.charAt(0) == '+') {
                        n3 = 0;
                        if (string2.length() > 1) {
                            n3 = Integer.valueOf(string2.substring(1));
                        }
                    } else {
                        n3 = Integer.valueOf(string2);
                    }
                }
                string2 = string.substring(0, n5);
                if (n3 == 0) {
                    return string2;
                }
                stringBuffer = new StringBuffer();
                char c2 = string2.charAt(0);
                switch (c2) {
                    case '-': {
                        stringBuffer.append('-');
                    }
                    case '+': {
                        string2 = string2.substring(1);
                    }
                }
                if (n3 >= 0) break block16;
                stringBuffer.append("0.");
                for (n4 = -1; n4 > n3; --n4) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2.charAt(0));
                for (n4 = 2; n4 < string2.length(); ++n4) {
                    stringBuffer.append(string2.charAt(n4));
                }
                break block17;
            }
            stringBuffer.append(string2.charAt(0));
            for (n2 = 0; n2 < n3; ++n2) {
                if (n2 + 2 < string2.length()) {
                    stringBuffer.append(string2.charAt(n2 + 2));
                    continue;
                }
                stringBuffer.append('0');
            }
            if (n2 + 2 >= string2.length()) break block17;
            stringBuffer.append(JCNumberUtil.getDecimalPointChar());
            while (n2 + 2 < string2.length()) {
                stringBuffer.append(string2.charAt(n2 + 2));
                ++n2;
            }
        }
        return new String(stringBuffer);
    }

    private static int findDecimal(String string) {
        if (string == null) {
            return -1;
        }
        return string.indexOf(JCNumberUtil.getDecimalPointChar());
    }

    public static double pow10(int n2) {
        int n3 = 12 + n2;
        if (n3 >= 0 && n3 < tens_val.length) {
            return tens_val[n3];
        }
        return Math.pow(10.0, n2);
    }

    public static double precCorrect(int n2, double d2) {
        if (d2 == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (n2 >= 0) {
            double d3 = JCNumberUtil.pow10(n2);
            return Math.floor(d2 * d3 + 0.5) / d3;
        }
        double d4 = JCNumberUtil.pow10(-n2);
        return Math.floor(d2 / d4 + 0.5) * d4;
    }

    public static double max(double d2, double d3) {
        return d2 > d3 ? d2 : d3;
    }

    public static double min(double d2, double d3) {
        return d2 < d3 ? d2 : d3;
    }

    public static double abs(double d2) {
        return d2 > 0.0 ? d2 : -d2;
    }

    public static int abs(int n2) {
        return n2 > 0 ? n2 : -n2;
    }

    public static double fmod(double d2, double d3) {
        double d4 = 2.147483647E9;
        if (d3 != 0.0) {
            int n2 = JCNumberUtil.ifloor(d2 / d3);
            d4 = d2 - d3 * (double)n2;
        }
        return d4;
    }

    public static void trace() {
        try {
            throw new ArrayIndexOutOfBoundsException("");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    public static int iceil(double d2) {
        return d2 < 0.0 ? -JCNumberUtil.ifloor(-d2) : (int)Math.ceil(d2);
    }

    public static int ifloor(double d2) {
        int n2 = 0;
        if (d2 == Double.NEGATIVE_INFINITY) {
            return n2;
        }
        n2 = d2 < 0.0 ? -JCNumberUtil.iceil(-d2) : (int)d2;
        return n2;
    }

    public static double calcError(int n2) {
        return 0.5 * JCNumberUtil.pow10(-n2 - 1);
    }

    private static double dotProduct(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        double d2 = point2D.getX() - point2D2.getX();
        double d3 = point2D.getY() - point2D2.getY();
        double d4 = point2D3.getX() - point2D2.getX();
        double d5 = point2D3.getY() - point2D2.getY();
        return d2 * d4 + d3 * d5;
    }

    private static double crossProduct(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        double d2 = point2D.getX() - point2D2.getX();
        double d3 = point2D.getY() - point2D2.getY();
        double d4 = point2D3.getX() - point2D2.getX();
        double d5 = point2D3.getY() - point2D2.getY();
        return d2 * d5 - d3 * d4;
    }

    public static double getAngle(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        double d2 = JCNumberUtil.dotProduct(point2D, point2D2, point2D3);
        double d3 = JCNumberUtil.crossProduct(point2D, point2D2, point2D3);
        return Math.atan2(d3, d2);
    }
}

