/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTableDataEvent;
import com.klg.jclass.table.JCTableDataListener;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.beans.DataWrapper;
import com.klg.jclass.table.beans.TablePropertyEditor;
import com.klg.jclass.table.data.JCBeanFileDataSource;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.klg.jclass.util.graphics.GraphicsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EventObject;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DataEditor
extends TablePropertyEditor
implements ActionListener,
ItemListener,
FocusListener,
JCTableDataListener {
    private JRadioButton chbxTable;
    private JRadioButton chbxFile;
    private JTextField textFName;
    private JButton buttonColumns;
    private JButton buttonClear;
    private JButton buttonRows;
    private JButton buttonBrowse;
    private Point textDialogLocation = null;
    private JCEditableVectorDataSource tableSource = (JCEditableVectorDataSource)this.tableView.getDataSource();

    public DataEditor() {
        super(0);
        this.updatePixelWidth();
        this.repaint();
    }

    public Object getValue() {
        this.tableView.commitEdit(true);
        return this.tableView.getData();
    }

    public void setValue(Object object) {
        boolean bl;
        if (object == null) {
            return;
        }
        if (this.tableView.getDataSource() != null) {
            this.tableView.getDataSource().removeTableDataListener(this);
        }
        this.tableView.setData((DataWrapper)object);
        TableDataModel tableDataModel = this.tableView.getDataSource();
        if (tableDataModel != null) {
            tableDataModel.addTableDataListener(this);
        }
        if (bl = tableDataModel instanceof JCBeanFileDataSource) {
            this.textFName.setText(((JCBeanFileDataSource)tableDataModel).getName());
        }
        this.setStateFile(bl);
        super.setValue(object);
    }

    public String getAsText() {
        return this.tableView.getData().toString();
    }

    public String getJavaInitializationString() {
        return this.tableView.getData().getJavaInitializationString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.textChanged(actionEvent);
        this.buttonPressed(actionEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.textChanged(focusEvent);
    }

    public void dataChanged(JCTableDataEvent jCTableDataEvent) {
        this.updatePixelWidth();
        this.updateData();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        this.itemChanged(itemEvent);
    }

    protected void init() {
        super.init(true);
        this.tableView.setSelectionPolicy(0);
        this.tableView.setAllowCellResize(4);
    }

    protected JComponent makePropertyPanel() {
        this.chbxTable = new JRadioButton("table", true);
        this.chbxFile = new JRadioButton("file", false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.chbxTable);
        buttonGroup.add(this.chbxFile);
        this.textFName = new JTextField();
        this.buttonClear = new JButton("Clear Cells");
        this.buttonColumns = new JButton("Column Labels...");
        this.buttonRows = new JButton("Row Labels...");
        this.buttonBrowse = new JButton("Browse...");
        TablePropertyEditor.GroupPanel groupPanel = new TablePropertyEditor.GroupPanel(this, "Data source");
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        groupPanel.add((Component)this.chbxTable, gridBagConstraints);
        groupPanel.add((Component)this.buttonClear, gridBagConstraints);
        groupPanel.add((Component)this.buttonColumns, gridBagConstraints);
        groupPanel.add((Component)this.buttonRows, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)this.chbxFile, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        groupPanel.add((Component)this.textFName, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        groupPanel.add((Component)this.buttonBrowse, gridBagConstraints);
        this.chbxTable.addItemListener(this);
        this.chbxFile.addItemListener(this);
        this.buttonClear.addActionListener(this);
        this.buttonColumns.addActionListener(this);
        this.buttonRows.addActionListener(this);
        this.buttonBrowse.addActionListener(this);
        this.textFName.addActionListener(this);
        this.textFName.addFocusListener(this);
        return groupPanel;
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
    }

    protected void updateData() {
        this.support.firePropertyChange("dataSource", null, this.getValue());
    }

    private void setStateFile(boolean bl) {
        if (bl) {
            DataEditor.setSelected(this.chbxFile, true);
            this.tableView.setPixelWidth(-998, 33001);
        } else {
            DataEditor.setSelected(this.chbxTable, true);
            this.tableSource = (JCEditableVectorDataSource)this.tableView.getDataSource();
            this.updatePixelWidth();
        }
        this.setSelected(!bl);
    }

    private void browseFile() {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Load Data Source");
        jFileChooser.setFileSelectionMode(0);
        if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.textFName.setText(file.getAbsolutePath());
            this.showSource();
        }
    }

    private void clearData() {
        this.tableView.setRepaintEnabled(false);
        this.tableSource.removeTableDataListener(this);
        for (int i2 = 0; i2 < this.tableSource.getNumRows(); ++i2) {
            for (int i3 = 0; i3 < this.tableSource.getNumColumns(); ++i3) {
                this.tableSource.setCell(i2, i3, "");
            }
        }
        this.tableSource.addTableDataListener(this);
        this.updatePixelWidth();
        this.tableView.setRepaintEnabled(true);
        this.updateData();
    }

    private void updatePixelWidth() {
        for (int i2 = 0; i2 < this.tableSource.getNumColumns(); ++i2) {
            boolean bl = this.isEmpty(this.tableSource.getTableColumnLabel(i2));
            if (bl) {
                for (int i3 = 0; i3 < this.tableSource.getNumRows(); ++i3) {
                    Object object = this.tableSource.getTableDataItem(i3, i2);
                    if (this.isEmpty(object)) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                this.tableView.setPixelWidth(i2, 70);
                continue;
            }
            this.tableView.setPixelWidth(i2, 33001);
        }
    }

    private boolean isEmpty(Object object) {
        return object == null || !(object instanceof String) || ((String)object).trim().length() == 0;
    }

    private void editLabels(boolean bl) {
        TextDialog textDialog = new TextDialog(new JFrame(), (bl ? "Row" : "Column") + " Labels");
        JCEditableVectorDataSource jCEditableVectorDataSource = (JCEditableVectorDataSource)this.tableView.getDataSource();
        String string = bl ? DataEditor.toString(jCEditableVectorDataSource.getRowLabels(), "\n") : DataEditor.toString(jCEditableVectorDataSource.getColumnLabels(), "\n");
        textDialog.setText(string);
        textDialog.pack();
        if (this.textDialogLocation == null) {
            Rectangle rectangle = GraphicsUtil.getScreenBounds(textDialog.getContentPane());
            Dimension dimension = this.getSize();
            this.textDialogLocation = new Point(Math.max((rectangle.width - dimension.width) / 2, 0), Math.max((rectangle.height - dimension.height) / 2, 0));
        }
        textDialog.setLocation(this.textDialogLocation);
        textDialog.setVisible(true);
        this.textDialogLocation = textDialog.getLocation();
        if (textDialog.getResult()) {
            string = textDialog.getText();
            if (bl) {
                jCEditableVectorDataSource.setRowLabels(DataEditor.toVector(string, "\n"));
            } else {
                jCEditableVectorDataSource.setColumnLabels(DataEditor.toVector(string, "\n"));
            }
            this.updateData();
        }
        this.repaint();
    }

    private void setSelected(boolean bl) {
        this.buttonColumns.setEnabled(bl);
        this.buttonClear.setEnabled(bl);
        this.buttonRows.setEnabled(bl);
    }

    protected void showSource() {
        TableDataModel tableDataModel = this.tableView.getDataSource();
        String string = this.textFName.getText().trim();
        if (string.length() < 1) {
            return;
        }
        if (tableDataModel instanceof JCBeanFileDataSource && ((JCBeanFileDataSource)tableDataModel).getName().equalsIgnoreCase(string)) {
            return;
        }
        this.tableView.commitEdit(true);
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            JCBeanFileDataSource jCBeanFileDataSource = new JCBeanFileDataSource(string, fileInputStream);
            fileInputStream.close();
            this.setDataSource(jCBeanFileDataSource);
            this.setStateFile(true);
            this.updateSizePanel();
            this.updateData();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (string.length() == 0) {
                this.errorMessageBox("Please enter data file name first.");
            } else if (this.chbxFile.isSelected()) {
                this.errorMessageBox("Specified data file is not found.");
            }
        }
        catch (IOException iOException) {
            this.errorMessageBox("Specified data file is not valid: " + iOException);
        }
        this.setStateFile(false);
    }

    protected void setDataSource(TableDataModel tableDataModel) {
        if (this.tableView.getDataSource() != null) {
            this.tableView.getDataSource().removeTableDataListener(this);
        }
        this.tableView.setDataSource(tableDataModel);
        this.tableSource.addTableDataListener(this);
    }

    private void itemChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.chbxTable) || object.equals(this.chbxFile)) {
            this.tableView.commitEdit(true);
            if (this.chbxTable.isSelected()) {
                if (this.tableSource == null) {
                    this.tableSource = new JCEditableVectorDataSource();
                }
                this.setDataSource(this.tableSource);
                this.setStateFile(false);
                this.updateSizePanel();
                this.updateData();
            } else {
                this.showSource();
            }
        }
    }

    private void buttonPressed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.buttonBrowse)) {
            this.browseFile();
        } else if (object.equals(this.buttonClear)) {
            this.clearData();
        } else if (object.equals(this.buttonColumns) || object.equals(this.buttonRows)) {
            this.editLabels(object.equals(this.buttonRows));
        }
    }

    private void textChanged(EventObject eventObject) {
        Object object = eventObject.getSource();
        if (object.equals(this.textFName)) {
            this.showSource();
        }
    }

    public static Vector toVector(String string, String string2) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equalsIgnoreCase(string2)) {
                string3 = "";
            } else if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            vector.addElement(string3);
        }
        return vector;
    }

    public static String toString(Vector vector, String string) {
        if (vector == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Object e2 = vector.elementAt(i2);
            if (e2 instanceof String) {
                stringBuffer.append((String)e2);
            }
            stringBuffer.append(string);
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    class TextDialog
    extends JDialog
    implements ActionListener {
        private JTextArea text;
        private JButton buttonOK;
        private boolean result;

        TextDialog(Frame frame, String string) {
            super(frame, string, true);
            this.result = false;
            this.getContentPane().setLayout(new BorderLayout(0, 10));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            this.text = new JTextArea("", 15, 50);
            jPanel.add("Center", this.text);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(2, 8, 8));
            this.buttonOK = new JButton("OK");
            jPanel2.add(this.buttonOK);
            JButton jButton = new JButton("Cancel");
            jPanel2.add(jButton);
            this.getContentPane().add("Center", jPanel);
            this.getContentPane().add("South", jPanel2);
            jButton.addActionListener(this);
            this.buttonOK.addActionListener(this);
            this.setLocation();
            this.pack();
            this.repaint();
        }

        public void setText(String string) {
            this.text.setText(string);
        }

        public boolean getResult() {
            return this.result;
        }

        public String getText() {
            return this.text.getText();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JButton) {
                this.result = object.equals(this.buttonOK);
                this.setVisible(false);
            }
        }

        private void setLocation() {
            Container container = this.getParent();
            Point point = container.getLocation();
            Dimension dimension = container.getSize();
            this.setLocation(point.x + dimension.width / 2, point.y + dimension.height / 2);
        }
    }
}

