/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCResizeCellEvent;
import com.klg.jclass.table.JCResizeCellListener;
import com.klg.jclass.table.beans.CellSizeWrapper;
import com.klg.jclass.table.beans.EnumString;
import com.klg.jclass.table.beans.TablePropertyEditor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class CellSizeEditor
extends TablePropertyEditor
implements ActionListener,
FocusListener,
ItemListener,
JCResizeCellListener {
    protected JComboBox choiceWidth;
    protected JComboBox choiceHeight;
    protected JTextField textWidth;
    protected JTextField textHeight;
    protected static final String AS_IS = "As is";
    protected static final String VARIABLE = "Variable";
    protected static EnumString[] EnumCellSize = new EnumString[]{new EnumString(33000, "As is"), new EnumString(33001, "Variable")};

    public String getAsText() {
        return this.tableView.getCellSize().toString();
    }

    public String getJavaInitializationString() {
        return this.tableView.getCellSize().getJavaInitializationString();
    }

    public Object getValue() {
        return this.tableView.getCellSize();
    }

    public void setValue(Object object) {
        if (object == null) {
            return;
        }
        this.tableView.setCellSize((CellSizeWrapper)object);
        super.setValue(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.updateComponents) {
            return;
        }
        super.actionPerformed(actionEvent);
        this.textChanged(actionEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.updateComponents) {
            return;
        }
        super.focusLost(focusEvent);
        this.textChanged(focusEvent);
    }

    public void beforeResizeCell(JCResizeCellEvent jCResizeCellEvent) {
    }

    public void resizeCell(JCResizeCellEvent jCResizeCellEvent) {
    }

    public void afterResizeCell(JCResizeCellEvent jCResizeCellEvent) {
        if (!this.updateComponents) {
            return;
        }
        this.updatePropertyPanel(this.tableView.getSelectedRange());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.updateComponents) {
            return;
        }
        super.itemStateChanged(itemEvent);
        this.itemChanged(itemEvent);
    }

    protected void init() {
        super.init(false);
        this.tableView.setAllowCellResize(4);
        this.tableView.setAllowResizeBy(1);
        this.tableView.addResizeCellListener(this);
        this.updateCellSize(this.tableView.getSelectedRange());
    }

    protected JComponent makePropertyPanel() {
        this.choiceWidth = new JComboBox();
        this.choiceHeight = new JComboBox();
        this.textWidth = new JTextField(3);
        this.textHeight = new JTextField(3);
        this.choiceWidth.addItem(VARIABLE);
        this.choiceWidth.addItem(AS_IS);
        this.choiceHeight.addItem(VARIABLE);
        this.choiceHeight.addItem(AS_IS);
        TablePropertyEditor.GroupPanel groupPanel = new TablePropertyEditor.GroupPanel(this, "Cell size");
        groupPanel.setLayout(new FlowLayout(0, 10, 6));
        groupPanel.add(new JLabel("Width"));
        groupPanel.add(this.choiceWidth);
        groupPanel.add(this.textWidth);
        groupPanel.add(new JLabel("pixels  "));
        groupPanel.add(new JLabel("Height"));
        groupPanel.add(this.choiceHeight);
        groupPanel.add(this.textHeight);
        groupPanel.add(new JLabel("pixels  "));
        this.textWidth.addActionListener(this);
        this.textHeight.addActionListener(this);
        this.textWidth.addFocusListener(this);
        this.textHeight.addFocusListener(this);
        this.choiceWidth.addItemListener(this);
        this.choiceHeight.addItemListener(this);
        return groupPanel;
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        this.updateCellSize(jCCellRange);
        this.support.firePropertyChange("cellSize", null, this.getValue());
    }

    private void updateCellSize(JCCellRange jCCellRange) {
        this.updateComponents = false;
        if (jCCellRange == null) {
            this.textHeight.setEnabled(false);
            this.textWidth.setEnabled(false);
            this.choiceHeight.setEnabled(false);
            this.choiceWidth.setEnabled(false);
        } else {
            this.choiceHeight.setEnabled(true);
            this.choiceWidth.setEnabled(true);
            CellSizeEditor.setSelectedItem(this.choiceHeight, this.tableView.getPixelHeight(jCCellRange.start_row) == 33001 ? VARIABLE : AS_IS);
            CellSizeEditor.setSelectedItem(this.choiceWidth, this.tableView.getPixelWidth(jCCellRange.start_column) == 33001 ? VARIABLE : AS_IS);
            this.enableText(this.textHeight, this.choiceHeight, this.tableView.getRowPixelHeight(CellSizeEditor.getFirstCell(jCCellRange.start_row)));
            this.enableText(this.textWidth, this.choiceWidth, this.tableView.getColumnPixelWidth(CellSizeEditor.getFirstCell(jCCellRange.start_column)));
        }
        this.updateComponents = true;
    }

    private void setPixelHeight(JCCellRange jCCellRange, int n2) {
        if (jCCellRange.start_row == -998 || jCCellRange.start_row == -997) {
            this.tableView.setPixelHeight(jCCellRange.start_row, n2);
        } else {
            for (int i2 = jCCellRange.start_row; i2 <= jCCellRange.end_row; ++i2) {
                this.tableView.setPixelHeight(i2, n2);
            }
        }
    }

    private void setPixelWidth(JCCellRange jCCellRange, int n2) {
        if (jCCellRange.start_column == -998 || jCCellRange.start_column == -997) {
            this.tableView.setPixelWidth(jCCellRange.start_column, n2);
        } else {
            for (int i2 = jCCellRange.start_column; i2 <= jCCellRange.end_column; ++i2) {
                this.tableView.setPixelWidth(i2, n2);
            }
        }
    }

    private boolean enableText(JTextField jTextField, JComboBox jComboBox, int n2) {
        boolean bl = jComboBox.getSelectedItem().equals(AS_IS);
        jTextField.setEnabled(bl);
        jTextField.setText(bl ? n2 + "" : "");
        return bl;
    }

    private void itemChanged(ItemEvent itemEvent) {
        JCCellRange jCCellRange = this.tableView.getRangedSelection();
        if (jCCellRange == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object.equals(this.choiceHeight)) {
            int n2 = this.tableView.getRowPixelHeight(CellSizeEditor.getFirstCell(jCCellRange.start_row));
            boolean bl = !this.enableText(this.textHeight, this.choiceHeight, n2);
            this.setPixelHeight(jCCellRange, bl ? 33001 : n2);
        } else if (object.equals(this.choiceWidth)) {
            int n3 = this.tableView.getColumnPixelWidth(CellSizeEditor.getFirstCell(jCCellRange.start_column));
            boolean bl = !this.enableText(this.textWidth, this.choiceWidth, n3);
            this.setPixelWidth(jCCellRange, bl ? 33001 : n3);
        } else {
            return;
        }
        this.support.firePropertyChange("cellSize", null, this.getValue());
    }

    private void textChanged(EventObject eventObject) {
        JCCellRange jCCellRange = this.tableView.getRangedSelection();
        if (jCCellRange == null) {
            return;
        }
        Object object = eventObject.getSource();
        if (object.equals(this.textHeight)) {
            int n2 = this.getInt(this.textHeight);
            if (n2 < 0) {
                return;
            }
            this.setPixelHeight(jCCellRange, n2);
        } else if (object.equals(this.textWidth)) {
            int n3 = this.getInt(this.textWidth);
            if (n3 < 0) {
                return;
            }
            this.setPixelWidth(jCCellRange, n3);
        } else {
            return;
        }
        this.support.firePropertyChange("cellSize", null, this.getValue());
    }

    private int getInt(JTextField jTextField) {
        try {
            Integer n2 = Integer.valueOf(jTextField.getText());
            return Math.max(Math.min(n2, 1024), 0);
        }
        catch (NumberFormatException numberFormatException) {
            this.errorMessageBox("Invalid dimension.");
            return Integer.MIN_VALUE;
        }
    }
}

