/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCKeyModifier;
import com.klg.jclass.table.DataViewModel;
import com.klg.jclass.table.EditTraverseHandler;
import com.klg.jclass.table.InputHandler;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;

public class KeyInputHandler
extends InputHandler
implements KeyListener,
Serializable {
    private static final int KEY_DOWN = 40;
    private static final int KEY_UP = 38;
    private static final int KEY_LEFT = 37;
    private static final int KEY_RIGHT = 39;
    private static final int KEY_PAGE_UP = 33;
    private static final int KEY_PAGE_DOWN = 34;
    private static final int KEY_TAB = 9;
    private static final int KEY_ESCAPE = 27;
    private static final int KEY_HOME = 36;
    private static final int KEY_END = 35;
    private static final int KEY_ENTER = 10;

    public KeyInputHandler(JCTable jCTable) {
        super(jCTable);
    }

    public void keyPressed(KeyEvent keyEvent) {
        JCCellEditor jCCellEditor;
        Serializable serializable;
        int n2 = keyEvent.getKeyCode();
        int n3 = keyEvent.getModifiers();
        if (keyEvent.isConsumed() && n2 == 10) {
            return;
        }
        if (!this.table.repaint_enabled) {
            return;
        }
        if (this.isCopyAction(keyEvent, this.table.current_row, this.table.current_column)) {
            this.performCopyAction();
            return;
        }
        if (this.isPasteAction(keyEvent, this.table.current_row, this.table.current_column)) {
            this.performPasteAction();
            return;
        }
        EditTraverseHandler editTraverseHandler = this.table.getEditTraverseHandler();
        JCCellEditor jCCellEditor2 = editTraverseHandler.getCellEditor();
        DataViewModel dataViewModel = this.table.getDataView();
        if (jCCellEditor2 != null) {
            if (this.matchKey(jCCellEditor2, n2, n3) != null) {
                return;
            }
        } else if (this.table.current_row >= 0 && this.table.current_column >= 0 && !this.isContainerReserved(n2, n3) && (serializable = this.matchKey(jCCellEditor = dataViewModel.getCellEditor(this.table.current_row, this.table.current_column), n2, n3)) != null && serializable.canInitializeEdit) {
            editTraverseHandler.traverse(this.table.current_row, this.table.current_column, false, keyEvent, 11, true);
            return;
        }
        if (n2 == 9) {
            keyEvent.consume();
        }
        if (n2 == 10) {
            editTraverseHandler.traverse(this.table.getCurrentRow(), this.table.getCurrentColumn(), false, null, 0, true);
            return;
        }
        this.SELECTING = false;
        if (n2 == 9) {
            if (this.isControl(n3)) {
                this.table.getFocusManager().handleControlTab(this.isShift(n3), true);
            } else if (this.isShift(n3)) {
                this.traverse(3);
            } else {
                this.traverse(4);
            }
        } else if (n2 == 40) {
            if (this.isShift(n3) && this.table.getSelectionModel() != null) {
                this.SELECTING = this.table.getSelectionModel().select(0, this.table.current_row, this.table.current_column);
                int n4 = Math.min(this.table.getNumRows() - 1, this.table.current_row + 1);
                this.SELECTING = this.table.getSelectionModel().select(2, n4, this.table.current_column);
            }
            if (!this.SELECTING) {
                this.table.clearSelectedCells();
            }
            this.traverse(1);
        } else if (n2 == 38) {
            if (this.isShift(n3) && this.table.getSelectionModel() != null) {
                this.SELECTING = this.table.getSelectionModel().select(0, this.table.current_row, this.table.current_column);
                int n5 = Math.max(this.table.current_row - 1, 0);
                this.SELECTING = this.table.getSelectionModel().select(2, n5, this.table.current_column);
            }
            if (!this.SELECTING) {
                this.table.clearSelectedCells();
            }
            this.traverse(2);
        } else if (n2 == 37) {
            if (this.isShift(n3) && this.table.getSelectionModel() != null) {
                this.SELECTING = this.table.getSelectionModel().select(0, this.table.current_row, this.table.current_column);
                int n6 = Math.max(this.table.current_column - 1, 0);
                this.SELECTING = this.table.getSelectionModel().select(2, this.table.current_row, n6);
            }
            if (!this.SELECTING) {
                this.table.clearSelectedCells();
            }
            this.traverse(3);
        } else if (n2 == 39) {
            if (this.isShift(n3) && this.table.getSelectionModel() != null) {
                this.SELECTING = this.table.getSelectionModel().select(0, this.table.current_row, this.table.current_column);
                int n7 = Math.min(this.table.getNumColumns() - 1, this.table.current_column + 1);
                this.SELECTING = this.table.getSelectionModel().select(2, this.table.current_row, n7);
            }
            if (!this.SELECTING) {
                this.table.clearSelectedCells();
            }
            this.traverse(4);
        } else if (n2 == 36 && this.isControl(n3)) {
            this.traverse(7);
        } else if (n2 == 34 && this.isControl(n3)) {
            this.traverse(10);
        } else if (n2 == 35 && this.isControl(n3)) {
            this.traverse(8);
        } else if (n2 == 33 && this.isControl(n3)) {
            this.traverse(9);
        } else if (n2 == 34) {
            this.traverse(6);
        } else if (n2 == 33) {
            this.traverse(5);
        } else if (n2 == 27) {
            this.table.clearSelection();
            this.SELECTING = false;
        } else if (!this.isModifierKey(n2) && jCCellEditor2 == null) {
            boolean bl = true;
            if (this.table.current_row >= 0 && this.table.current_column >= 0) {
                serializable = dataViewModel.getCellEditor(this.table.current_row, this.table.current_column);
                JCKeyModifier jCKeyModifier = this.matchKey((JCCellEditor)serializable, n2, n3);
                bl = jCKeyModifier == null || jCKeyModifier.canInitializeEdit;
            }
            editTraverseHandler.traverse(this.table.current_row, this.table.current_column, false, keyEvent, 11, bl);
        }
        if (!this.SELECTING) {
            switch (n2) {
                case 9: 
                case 33: 
                case 34: {
                    this.table.clearSelectedCells();
                    break;
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.SELECTING && keyEvent.getKeyCode() == 16) {
            this.table.getSelectionModel().select(4, this.table.current_row, this.table.current_column);
            this.SELECTING = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected boolean traverse(int n2) {
        EditTraverseHandler editTraverseHandler;
        int n3 = this.table.current_row;
        int n4 = this.table.current_column;
        JCCellPosition jCCellPosition = this.findTraversableCell(n2, n3, n4);
        if (jCCellPosition == null) {
            return false;
        }
        if (!this.table.isTraverseCycle()) {
            if (n2 == 4 && (n3 != jCCellPosition.row || jCCellPosition.column < n4)) {
                return false;
            }
            if (n2 == 3 && (n3 != jCCellPosition.row || jCCellPosition.column > n4)) {
                return false;
            }
            if (n2 == 2 && (jCCellPosition.row > n3 || n4 != jCCellPosition.column)) {
                return false;
            }
            if (n2 == 1 && (jCCellPosition.row < n3 || n4 != jCCellPosition.column)) {
                return false;
            }
        }
        if (!(editTraverseHandler = this.table.getEditTraverseHandler()).commit(true)) {
            return false;
        }
        return editTraverseHandler.traverse(jCCellPosition.row, jCCellPosition.column, false, null, n2, false);
    }

    protected JCCellPosition findTraversableCell(int n2, int n3, int n4) {
        block38: {
            int n5;
            int n6;
            block44: {
                int n7;
                block43: {
                    block42: {
                        block41: {
                            block40: {
                                block39: {
                                    block37: {
                                        if (n3 < 0 || n4 < 0 || this.table.getNumColumns() == 0 || this.table.getNumRows() == 0) {
                                            return null;
                                        }
                                        n6 = n3;
                                        n5 = n4;
                                        if (n2 != 4) break block37;
                                        n5 = n4 + 1;
                                        while (n6 != n3 || n5 != n4) {
                                            int n8 = this.table.getNumColumns();
                                            while (n5 < n8) {
                                                if (n6 == n3 && n5 == n4) {
                                                    return null;
                                                }
                                                if (this.table.isTraversable(n6, n5)) {
                                                    return new JCCellPosition(n6, n5);
                                                }
                                                ++n5;
                                            }
                                            n6 = n6 == this.table.getNumRows() - 1 ? 0 : ++n6;
                                            n5 = 0;
                                        }
                                        break block38;
                                    }
                                    if (n2 != 3) break block39;
                                    n5 = n4 - 1;
                                    while (n6 != n3 || n5 != n4) {
                                        while (n5 >= 0) {
                                            if (n6 == n3 && n5 == n4) {
                                                return null;
                                            }
                                            if (this.table.isTraversable(n6, n5)) {
                                                return new JCCellPosition(n6, n5);
                                            }
                                            --n5;
                                        }
                                        n6 = n6 == 0 ? this.table.getNumRows() - 1 : --n6;
                                        n5 = this.table.getNumColumns() - 1;
                                    }
                                    break block38;
                                }
                                if (n2 != 1) break block40;
                                n6 = n3 + 1;
                                while (n6 != n3 || n5 != n4) {
                                    int n9 = this.table.getNumRows();
                                    while (n6 < n9) {
                                        if (n6 == n3 && n5 == n4) {
                                            return null;
                                        }
                                        if (this.table.isTraversable(n6, n5)) {
                                            return new JCCellPosition(n6, n5);
                                        }
                                        ++n6;
                                    }
                                    n5 = n5 == this.table.getNumColumns() - 1 ? 0 : ++n5;
                                    n6 = 0;
                                }
                                break block38;
                            }
                            if (n2 != 2) break block41;
                            n6 = n3 - 1;
                            while (n6 != n3 || n5 != n4) {
                                while (n6 >= 0) {
                                    if (n6 == n3 && n5 == n4) {
                                        return null;
                                    }
                                    if (this.table.isTraversable(n6, n5)) {
                                        return new JCCellPosition(n6, n5);
                                    }
                                    --n6;
                                }
                                n5 = n5 == 0 ? this.table.getNumColumns() - 1 : --n5;
                                n6 = this.table.getNumRows() - 1;
                            }
                            break block38;
                        }
                        if (n2 != 7) break block42;
                        n6 = 0;
                        n5 = 0;
                        if (this.table.isTraversable(n6, n5)) {
                            return new JCCellPosition(n6, n5);
                        }
                        for (n6 = 0; n6 < this.table.getNumRows(); ++n6) {
                            for (n5 = 0; n5 < this.table.getNumColumns(); ++n5) {
                                if (!this.table.isTraversable(n6, n5)) continue;
                                return new JCCellPosition(n6, n5);
                            }
                        }
                        break block38;
                    }
                    if (n2 == 5) {
                        int n10 = this.table.getNumRows();
                        JCCellRange jCCellRange = this.table.getVisibleCells();
                        int n11 = 0;
                        for (n6 = jCCellRange.start_row; n6 < jCCellRange.end_row && n6 < n10; ++n6) {
                            if (this.table.isRowHidden(n6)) continue;
                            ++n11;
                        }
                        for (n6 = n3; n6 >= 0 && n11 > 0; --n6) {
                            if (this.table.isRowHidden(n6)) continue;
                            --n11;
                        }
                        n5 = n4;
                        while (n6 >= 0) {
                            if (this.table.isTraversable(n6, n5)) {
                                return new JCCellPosition(n6, n5);
                            }
                            --n6;
                        }
                        return this.findTraversableCell(9, n3, n4);
                    }
                    if (n2 != 9) break block43;
                    n6 = 0;
                    n5 = n4;
                    if (this.table.isTraversable(n6, n5)) {
                        return new JCCellPosition(n6, n5);
                    }
                    for (n6 = 0; n6 < this.table.getNumRows(); ++n6) {
                        if (!this.table.isTraversable(n6, n5)) continue;
                        return new JCCellPosition(n6, n5);
                    }
                    break block38;
                }
                if (n2 == 6) {
                    int n12 = this.table.getNumRows();
                    JCCellRange jCCellRange = this.table.getVisibleCells();
                    int n13 = 0;
                    for (n6 = jCCellRange.start_row; n6 < jCCellRange.end_row && n6 < n12; ++n6) {
                        if (this.table.isRowHidden(n6)) continue;
                        ++n13;
                    }
                    for (n6 = n3; n6 < n12 && n13 > 0; ++n6) {
                        if (this.table.isRowHidden(n6)) continue;
                        --n13;
                    }
                    n5 = n4;
                    while (n6 < n12) {
                        if (this.table.isTraversable(n6, n5)) {
                            return new JCCellPosition(n6, n5);
                        }
                        ++n6;
                    }
                    return this.findTraversableCell(10, n3, n4);
                }
                if (n2 != 8) break block44;
                int n14 = this.table.getNumRows();
                n6 = n14 - 1;
                if (this.table.isTraversable(n6, n5 = (n7 = this.table.getNumColumns()) - 1)) {
                    return new JCCellPosition(n6, n5);
                }
                for (n6 = n14 - 1; n6 >= 0; --n6) {
                    for (n5 = n7 - 1; n5 >= 0; --n5) {
                        if (!this.table.isTraversable(n6, n5)) continue;
                        return new JCCellPosition(n6, n5);
                    }
                }
                break block38;
            }
            if (n2 != 10) break block38;
            int n15 = this.table.getNumRows();
            n6 = n15 - 1;
            if (this.table.isTraversable(n6, n5 = n4)) {
                return new JCCellPosition(n6, n5);
            }
            for (n6 = n15 - 1; n6 >= 0; --n6) {
                if (!this.table.isTraversable(n6, n5)) continue;
                return new JCCellPosition(n6, n5);
            }
        }
        return null;
    }

    public boolean isModifierKey(int n2) {
        return n2 == 17 || n2 == 16 || n2 == 157 || n2 == 18;
    }

    private JCKeyModifier matchKey(JCCellEditor jCCellEditor, int n2, int n3) {
        if (jCCellEditor == null) {
            return null;
        }
        JCKeyModifier[] jCKeyModifierArray = jCCellEditor.getReservedKeys();
        if (jCKeyModifierArray != null && jCKeyModifierArray.length > 0) {
            for (int i2 = 0; i2 < jCKeyModifierArray.length; ++i2) {
                if (jCKeyModifierArray[i2] == null || !jCKeyModifierArray[i2].match(n2, n3) || this.isContainerReserved(jCKeyModifierArray[i2])) continue;
                return jCKeyModifierArray[i2];
            }
        }
        return null;
    }

    private boolean isContainerReserved(JCKeyModifier jCKeyModifier) {
        return this.isContainerReserved(jCKeyModifier.key, jCKeyModifier.modifier);
    }

    private boolean isContainerReserved(int n2, int n3) {
        return n2 == 27 || n2 == 9 && (n3 == 0 || this.isShift(n3));
    }
}

