/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.JCPrintTable;
import com.klg.jclass.table.resources.LocaleBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JCPrintPreview
extends JFrame
implements WindowListener,
ActionListener {
    protected JButton first_button;
    protected JButton prev_button;
    protected JButton next_button;
    protected JButton last_button;
    protected JButton format_button;
    protected JButton print_button;
    protected JButton printall_button;
    protected JButton close_button;
    protected JLabel status;
    protected JScrollPane pane;
    protected JCPrintTable table;
    protected PageFormat page_format;
    protected PrinterJob job;
    protected PageImage page_image;
    protected int current_page = 0;
    protected int num_pages = 0;
    protected int width;
    protected int height;

    public JCPrintPreview(String string, JCPrintTable jCPrintTable, JFrame jFrame) {
        this(string, jCPrintTable);
    }

    public JCPrintPreview(String string, JCPrintTable jCPrintTable) {
        super(string);
        this.table = jCPrintTable;
        this.job = PrinterJob.getPrinterJob();
        if (this.job == null) {
            return;
        }
        this.job.setJobName(LocaleBundle.string("PrintJobName"));
        this.page_format = jCPrintTable.getPageFormat();
        if (this.page_format == null) {
            this.page_format = this.job.defaultPage();
        }
        this.job.setPrintable(jCPrintTable);
        try {
            this.setupPrintTable();
        }
        catch (JCPrintTable.IllegalSizeException illegalSizeException) {
            System.out.println("The table cannot be printed: " + illegalSizeException.getMessage());
            return;
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 1, 1));
        this.first_button = new JButton(LocaleBundle.string("PP_First"));
        jPanel.add(this.first_button);
        this.first_button.addActionListener(this);
        this.prev_button = new JButton(LocaleBundle.string("PP_Previous"));
        jPanel.add(this.prev_button);
        this.prev_button.addActionListener(this);
        this.next_button = new JButton(LocaleBundle.string("PP_Next"));
        jPanel.add(this.next_button);
        this.next_button.addActionListener(this);
        this.last_button = new JButton(LocaleBundle.string("PP_Last"));
        jPanel.add(this.last_button);
        this.last_button.addActionListener(this);
        this.format_button = new JButton(LocaleBundle.string("PP_Page_Format"));
        jPanel.add(this.format_button);
        this.format_button.addActionListener(this);
        this.print_button = new JButton(LocaleBundle.string("PP_Print"));
        jPanel.add(this.print_button);
        this.print_button.addActionListener(this);
        this.printall_button = new JButton(LocaleBundle.string("PP_PrintAll"));
        jPanel.add(this.printall_button);
        this.printall_button.addActionListener(this);
        this.close_button = new JButton(LocaleBundle.string("PP_Close"));
        jPanel.add(this.close_button);
        this.close_button.addActionListener(this);
        this.getContentPane().add((Component)jPanel, "North");
        Dimension dimension = new Dimension((int)((double)this.width * 1.05), (int)((double)this.height * 1.05));
        this.page_image = new PageImage(dimension);
        this.page_image.setSize(this.page_image.getPreferredSize());
        this.pane = new JScrollPane(this.page_image);
        this.getContentPane().add((Component)this.pane, "Center");
        this.status = new JLabel("", 2);
        this.getContentPane().add((Component)this.status, "South");
        this.addWindowListener(this);
        this.setSize(600, 500);
        this.setVisible(true);
    }

    public void setupPrintTable() {
        Dimension dimension = new Dimension(0, 0);
        this.table.setPageFormat(this.page_format);
        dimension.height = (int)this.page_format.getHeight();
        dimension.width = (int)this.page_format.getWidth();
        this.height = dimension.height;
        this.width = dimension.width;
        this.table.setPageDimensions(dimension.width, dimension.height);
        this.num_pages = this.table.getNumPages();
    }

    public void showPage(int n2) {
        if (this.job == null) {
            return;
        }
        this.current_page = n2;
        if (this.width <= 0 || this.height <= 0) {
            return;
        }
        Image image = this.createImage(this.width, this.height);
        Graphics graphics = image.getGraphics();
        this.table.printPage(graphics, n2);
        this.page_image.setImage(image);
        graphics.dispose();
        this.status.setText(LocaleBundle.string("Page ") + (this.current_page + 1) + LocaleBundle.string(" of ") + this.num_pages);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.equals(this.first_button)) {
                this.showPage(0);
            } else if (jButton.equals(this.prev_button)) {
                if (this.current_page > 0) {
                    this.showPage(this.current_page - 1);
                }
            } else if (jButton.equals(this.next_button)) {
                if (this.current_page + 1 < this.num_pages) {
                    this.showPage(this.current_page + 1);
                }
            } else if (jButton.equals(this.last_button)) {
                this.showPage(this.num_pages - 1);
            } else if (jButton.equals(this.format_button)) {
                this.page_format = this.job.pageDialog(this.page_format);
                this.setupPrintTable();
                this.page_image.preferredDimension = new Dimension((int)((double)this.width * 1.05), (int)((double)this.height * 1.05));
                this.page_image.setSize(new Dimension((int)((double)this.width * 1.05), (int)((double)this.height * 1.05)));
                this.showPage(0);
                this.pane.revalidate();
            } else if (jButton.equals(this.print_button)) {
                if (this.job != null) {
                    try {
                        this.table.setPrintPage(this.current_page);
                        this.job.setPrintable(this.table, this.page_format);
                        this.job.print();
                    }
                    catch (PrinterException printerException) {
                        System.out.println(printerException);
                    }
                }
            } else if (jButton.equals(this.printall_button)) {
                if (this.job != null) {
                    try {
                        this.table.setPrintPage(-1);
                        this.job.setPrintable(this.table, this.page_format);
                        this.job.print();
                    }
                    catch (PrinterException printerException) {
                        System.out.println(printerException);
                    }
                }
            } else if (jButton.equals(this.close_button)) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    protected class PageImage
    extends JPanel {
        protected Image page;
        protected Dimension preferredDimension;

        PageImage(Dimension dimension) {
            this.preferredDimension = dimension;
        }

        public void setImage(Image image) {
            this.page = image;
            this.repaint();
        }

        public Dimension getPreferredSize() {
            return this.preferredDimension;
        }

        public void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            try {
                Image image = this.createImage(dimension.width, dimension.height);
                Graphics graphics2 = image.getGraphics();
                graphics2.setColor(Color.gray);
                graphics2.fillRect(0, 0, dimension.width, dimension.height);
                if (this.page != null) {
                    Dimension dimension2 = new Dimension(this.page.getWidth(this), this.page.getHeight(this));
                    Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
                    graphics2.setColor(Color.black);
                    graphics2.drawRect(point.x - 2, point.y - 2, dimension2.width + 2, dimension2.height + 2);
                    graphics2.setColor(Color.white);
                    graphics2.fillRect(point.x - 1, point.y - 1, dimension2.width + 1, dimension2.height + 1);
                    graphics2.drawImage(this.page, point.x, point.y, this);
                    graphics.drawImage(image, 0, 0, this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

