/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.JCComponentCellRenderer;
import com.klg.jclass.cell.JCLightCellRenderer;
import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.CellAreaHandler;
import com.klg.jclass.table.CellLayoutModel;
import com.klg.jclass.table.CellSize;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.PositionCellSize;
import com.klg.jclass.table.TableCellInfoModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;

class CellSizeHandler {
    static Hashtable cachedFontHeights = null;

    CellSizeHandler() {
    }

    protected static void resetDimensions(JCTable jCTable) {
        if (!jCTable.repaint_enabled) {
            jCTable.setRecalcRequired(true);
            return;
        }
        CellSizeHandler.calcColumnWidths(jCTable, -1, Integer.MAX_VALUE, -1, Integer.MAX_VALUE);
        CellSizeHandler.calcRowHeights(jCTable, -1, Integer.MAX_VALUE, -1, Integer.MAX_VALUE);
    }

    protected static boolean calcColumnLabelHeight(JCTable jCTable, int n2, int n3) {
        return CellSizeHandler.calcRowHeights(jCTable, -1, -1, n2, n3);
    }

    protected static boolean calcRowHeights(JCTable jCTable, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        boolean bl = false;
        if (!jCTable.repaint_enabled) {
            jCTable.setRecalcRequired(true);
            return bl;
        }
        int n8 = jCTable.getNumRows();
        int n9 = jCTable.getNumColumns();
        int n10 = n8 == 0 ? -1 : n8 - 1;
        int n11 = n7 = n9 == 0 ? -1 : n9 - 1;
        if (n2 == -998) {
            n2 = -1;
            n3 = n10;
        } else if (n2 == -997) {
            n2 = 0;
            n3 = n10;
        }
        if (n4 == -998) {
            n4 = -1;
            n5 = n7;
        } else if (n4 == -997) {
            n4 = 0;
            n5 = n7;
        }
        if (n2 == -1 && n9 == 0 && ((n6 = jCTable.getRowCellSize(-1).getPixelValue()) == 33001 || n6 == 33002)) {
            n2 = 0;
        }
        if (n4 == -1 && n8 == 0) {
            n4 = 0;
        }
        if (n3 == Integer.MAX_VALUE) {
            n3 = n10;
        }
        if (n5 == Integer.MAX_VALUE) {
            n5 = n7;
        }
        if (n2 > n3 || n4 > n5) {
            return bl;
        }
        if (n2 == n3) {
            return bl |= CellSizeHandler.setPixelHeight(jCTable, n2, n2, n3, n4, n5);
        }
        CellLayoutModel cellLayoutModel = jCTable.getCellLayout();
        cellLayoutModel.setHeight(-1, 0);
        if (n2 == -1) {
            bl |= CellSizeHandler.setPixelHeight(jCTable, n2, n2, n3, n4, n5);
        }
        cellLayoutModel.resetRows();
        bl |= CellSizeHandler.setPixelHeight(jCTable, -997, 0, n3, n4, n5);
        List list = jCTable.getRowHeightValues();
        for (PositionCellSize positionCellSize : list) {
            CellSize cellSize;
            int n12;
            int n13 = positionCellSize.position;
            if (n13 >= 0) {
                bl |= CellSizeHandler.setPixelHeight(jCTable, n13, n13, n13, n4, n5);
                continue;
            }
            if (n13 != -998 && n13 != -997 || (n12 = (cellSize = jCTable.getRowCellSize(n13)).getPixelValue()) != 33001 && n12 != 33002) continue;
            for (int i2 = n2; i2 <= n3; ++i2) {
                bl |= CellSizeHandler.setPixelHeight(jCTable, i2, i2, i2, n4, n5);
            }
        }
        return bl;
    }

    protected static boolean setPixelHeight(JCTable jCTable, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = false;
        int n7 = jCTable.getTextHeightOffset() * 2;
        CellLayoutModel cellLayoutModel = jCTable.getCellLayout();
        CellSize cellSize = jCTable.getRowCellSize(n2);
        int n8 = cellLayoutModel.getHeight(n2);
        int n9 = cellSize.getPixelValue();
        if (cellSize.isHidden()) {
            n9 = 0;
        } else if (n2 == -1 && !jCTable.isColumnLabelDisplay()) {
            n9 = 0;
        } else {
            switch (n9) {
                case -999: {
                    n9 = Math.max(0, cellSize.getCharValue() * CellSizeHandler.getFontHeight(jCTable, n2, n5) + n7);
                    break;
                }
                case 33000: {
                    if (n8 < 0) {
                        n9 = Math.max(0, cellSize.getCharValue() * CellSizeHandler.getFontHeight(jCTable, n2, n5) + n7);
                        break;
                    }
                    n9 = n8;
                    break;
                }
                case 33001: {
                    if (n2 == -998) {
                        n9 = CellSizeHandler.getVariableCellHeight(jCTable, -1, n4, n5, n6, n7);
                        break;
                    }
                    if (n2 == -997) {
                        n9 = CellSizeHandler.getVariableCellHeight(jCTable, 0, n4, n5, n6, n7);
                        break;
                    }
                    n9 = CellSizeHandler.getVariableCellHeight(jCTable, n2, n2, n5, n6, n7);
                    break;
                }
                case 33002: {
                    if (n2 == -998) {
                        n9 = CellSizeHandler.getVariableEstimateCellHeight(jCTable, -1, n4, n5, n6, n7);
                        break;
                    }
                    if (n2 == -997) {
                        n9 = CellSizeHandler.getVariableEstimateCellHeight(jCTable, 0, n4, n5, n6, n7);
                        break;
                    }
                    n9 = CellSizeHandler.getVariableEstimateCellHeight(jCTable, n2, n2, n5, n6, n7);
                    break;
                }
            }
            n9 = Math.min(cellSize.getMaxValue(), Math.max(cellSize.getMinValue(), n9));
        }
        if (n8 != n9) {
            bl = true;
        }
        CellSizeHandler.setCellLayoutHeight(cellLayoutModel, n3, n4, n9);
        return bl;
    }

    protected static int getVariableCellHeight(JCTable jCTable, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            int n8 = CellSizeHandler.getLargestCellHeight(jCTable, n4, n5, i2);
            n7 = Math.max(n7, n8 + n6);
        }
        return n7;
    }

    protected static int getVariableEstimateCellHeight(JCTable jCTable, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = jCTable.getNumColumns();
        int n10 = Math.min(jCTable.variable_estimate_count, n9 - 1);
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (n10 == -998) {
                n8 = CellSizeHandler.getLargestCellHeight(jCTable, n4, n5, i2);
            } else if (n10 == -1) {
                n8 = CellSizeHandler.getLargestCellHeight(jCTable, -1, -1, i2);
            } else if (n10 == -997) {
                n8 = CellSizeHandler.getLargestCellHeight(jCTable, 0, n9 - 1, i2);
            } else if (n10 == -996) {
                CellArea cellArea;
                n8 = CellSizeHandler.getCellHeight(jCTable, i2, -1);
                CellAreaHandler cellAreaHandler = jCTable.getCellAreaHandler();
                JCCellRange jCCellRange = cellAreaHandler.getVisibleCells();
                if (jCCellRange.start_column != -999 && jCCellRange.end_column != -999) {
                    n8 = Math.max(n8, CellSizeHandler.getLargestCellHeight(jCTable, jCCellRange.start_column, jCCellRange.end_column, i2));
                }
                if ((cellArea = cellAreaHandler.findByType(3)) != null) {
                    n8 = Math.max(n8, CellSizeHandler.getLargestCellHeight(jCTable, cellArea.start_column, cellArea.end_column, i2));
                }
            } else if (n10 >= 0) {
                n8 = CellSizeHandler.getLargestCellHeight(jCTable, -1, n10, i2);
            }
            n7 = Math.max(n7, n8 += n6);
        }
        return n7;
    }

    protected static void setCellLayoutHeight(CellLayoutModel cellLayoutModel, int n2, int n3, int n4) {
        if (n2 == -1) {
            cellLayoutModel.setHeight(n2, n4);
        } else {
            cellLayoutModel.setHeight(n2, n3, n4);
        }
    }

    protected static int getCellHeight(JCTable jCTable, int n2, int n3) {
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return 0;
        }
        Component component = jCTable.getComponent(n2, n3);
        if (component != null) {
            return component.getPreferredSize().height;
        }
        Object object = jCTable.getDataView().getObject(n2, n3);
        JCCellRenderer jCCellRenderer = jCTable.getDataView().getCellRenderer(n2, n3, object);
        return CellSizeHandler.getCellHeight(jCTable, n2, n3, object, jCCellRenderer);
    }

    protected static int getCellHeight(JCTable jCTable, int n2, int n3, Object object, JCCellRenderer jCCellRenderer) {
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return 0;
        }
        TableCellInfoModel tableCellInfoModel = jCTable.getCellAreaHandler().getTableCellInfo();
        tableCellInfoModel.initialize(jCTable, object, n2, n3);
        Dimension dimension = null;
        if (jCCellRenderer instanceof JCLightCellRenderer) {
            JCLightCellRenderer jCLightCellRenderer = (JCLightCellRenderer)jCCellRenderer;
            dimension = jCLightCellRenderer.getPreferredSize(jCTable.getGraphics(), tableCellInfoModel, object);
        } else if (jCCellRenderer instanceof JCComponentCellRenderer) {
            JCComponentCellRenderer jCComponentCellRenderer = (JCComponentCellRenderer)jCCellRenderer;
            Component component = jCComponentCellRenderer.getRendererComponent(tableCellInfoModel, object, jCTable.isSelected(n2, n3));
            dimension = component.getPreferredSize();
        }
        if (dimension == null && jCTable.getGraphics() != null && jCTable.getGraphics().getFontMetrics() != null) {
            return CellSizeHandler.getHeight(jCTable.getGraphics().getFontMetrics(tableCellInfoModel.getFont()), object == null ? "" : object.toString());
        }
        return dimension.height;
    }

    protected static final int getHeight(FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n2 = 1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != '\n') continue;
            ++n2;
        }
        return fontMetrics.getHeight() * n2;
    }

    protected static final int getLargestCellHeight(JCTable jCTable, int n2, int n3, int n4) {
        int n5;
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return 0;
        }
        int n6 = 0;
        if (n4 < 0 && n2 < 0) {
            n2 = 0;
        }
        if (n3 >= (n5 = jCTable.getDataView().getNumColumns())) {
            n3 = n5 - 1;
        }
        for (int i2 = n2; i2 <= n3; ++i2) {
            JCCellRange jCCellRange;
            if (jCTable.spanHandler != null && (jCCellRange = jCTable.getSpannedRange(n4, i2)) != null && jCCellRange.start_row != jCCellRange.end_row) continue;
            n6 = Math.max(n6, CellSizeHandler.getCellHeight(jCTable, n4, i2));
        }
        return n6;
    }

    protected static boolean calcRowLabelWidth(JCTable jCTable, int n2, int n3) {
        return CellSizeHandler.calcColumnWidths(jCTable, n2, n3, -1, -1);
    }

    protected static boolean calcColumnWidths(JCTable jCTable, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        boolean bl = false;
        if (!jCTable.repaint_enabled) {
            jCTable.setRecalcRequired(true);
            return false;
        }
        int n8 = jCTable.getNumRows();
        int n9 = jCTable.getNumColumns();
        int n10 = n8 == 0 ? -1 : n8 - 1;
        int n11 = n7 = n9 == 0 ? -1 : n9 - 1;
        if (n2 == -998) {
            n2 = -1;
            n3 = n10;
        } else if (n2 == -997) {
            n2 = 0;
            n3 = n10;
        }
        if (n4 == -998) {
            n4 = -1;
            n5 = n7;
        } else if (n4 == -997) {
            n4 = 0;
            n5 = n7;
        }
        if (n2 == -1 && n9 == 0) {
            n2 = 0;
        }
        if (n4 == -1 && n8 == 0 && ((n6 = jCTable.getColumnCellSize(-1).getPixelValue()) == 33001 || n6 == 33002)) {
            n4 = 0;
        }
        if (n3 == Integer.MAX_VALUE) {
            n3 = n10;
        }
        if (n5 == Integer.MAX_VALUE) {
            n5 = n7;
        }
        if (n2 > n3 || n4 > n5) {
            return bl;
        }
        if (n4 == n5) {
            return bl |= CellSizeHandler.setPixelWidth(jCTable, n4, n2, n3, n4, n5);
        }
        CellLayoutModel cellLayoutModel = jCTable.getCellLayout();
        cellLayoutModel.setWidth(-1, 0);
        if (n4 == -1) {
            bl |= CellSizeHandler.setPixelWidth(jCTable, n4, n2, n3, n4, n5);
        }
        cellLayoutModel.resetColumns();
        bl |= CellSizeHandler.setPixelWidth(jCTable, -997, n2, n3, 0, n5);
        List list = jCTable.getColumnWidthValues();
        for (PositionCellSize positionCellSize : list) {
            CellSize cellSize;
            int n12;
            int n13 = positionCellSize.position;
            if (n13 >= 0) {
                bl |= CellSizeHandler.setPixelWidth(jCTable, n13, n2, n3, n13, n13);
                continue;
            }
            if (n13 != -998 && n13 != -997 || (n12 = (cellSize = jCTable.getColumnCellSize(n13)).getPixelValue()) != 33001 && n12 != 33002) continue;
            for (int i2 = n4; i2 <= n5; ++i2) {
                bl |= CellSizeHandler.setPixelWidth(jCTable, i2, n2, n3, i2, i2);
            }
        }
        return bl;
    }

    protected static boolean setPixelWidth(JCTable jCTable, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = false;
        int n7 = jCTable.getTextWidthOffset() * 2;
        CellLayoutModel cellLayoutModel = jCTable.getCellLayout();
        CellSize cellSize = jCTable.getColumnCellSize(n2);
        int n8 = jCTable.getCellLayout().getWidth(n2);
        int n9 = cellSize.getPixelValue();
        if (cellSize.isHidden()) {
            n9 = 0;
        } else if (n2 == -1 && !jCTable.isRowLabelDisplay()) {
            n9 = 0;
        } else {
            switch (n9) {
                case -999: {
                    n9 = Math.max(0, cellSize.getCharValue() * CellSizeHandler.getFontWidth(jCTable, n3, n2) + n7);
                    break;
                }
                case 33000: {
                    if (n8 < 0) {
                        n9 = Math.max(0, cellSize.getCharValue() * CellSizeHandler.getFontWidth(jCTable, n3, n2) + n7);
                        break;
                    }
                    n9 = n8;
                    break;
                }
                case 33001: {
                    if (n2 == -998) {
                        n9 = CellSizeHandler.getVariableCellWidth(jCTable, n3, n4, -1, n6, n7);
                        break;
                    }
                    if (n2 == -997) {
                        n9 = CellSizeHandler.getVariableCellWidth(jCTable, n3, n4, 0, n6, n7);
                        break;
                    }
                    n9 = CellSizeHandler.getVariableCellWidth(jCTable, n3, n4, n2, n2, n7);
                    break;
                }
                case 33002: {
                    if (n2 == -998) {
                        n9 = CellSizeHandler.getVariableEstimateCellWidth(jCTable, n3, n4, -1, n6, n7);
                        break;
                    }
                    if (n2 == -997) {
                        n9 = CellSizeHandler.getVariableEstimateCellWidth(jCTable, n3, n4, 0, n6, n7);
                        break;
                    }
                    n9 = CellSizeHandler.getVariableEstimateCellWidth(jCTable, n3, n4, n2, n2, n7);
                    break;
                }
            }
            n9 = Math.min(cellSize.getMaxValue(), Math.max(cellSize.getMinValue(), n9));
        }
        if (n8 != n9) {
            bl = true;
        }
        CellSizeHandler.setCellLayoutWidth(cellLayoutModel, n5, n6, n9);
        return bl;
    }

    protected static int getVariableCellWidth(JCTable jCTable, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        for (int i2 = n4; i2 <= n5; ++i2) {
            int n8 = CellSizeHandler.getLargestCellWidth(jCTable, n2, n3, i2);
            n7 = Math.max(n7, n8 + n6);
        }
        return n7;
    }

    protected static int getVariableEstimateCellWidth(JCTable jCTable, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = jCTable.getNumRows();
        int n10 = Math.min(jCTable.variable_estimate_count, n9 - 1);
        for (int i2 = n4; i2 <= n5; ++i2) {
            if (n10 == -998) {
                n8 = CellSizeHandler.getLargestCellWidth(jCTable, n2, n3, i2);
            } else if (n10 == -1) {
                n8 = CellSizeHandler.getLargestCellWidth(jCTable, -1, -1, i2);
            } else if (n10 == -997) {
                n8 = CellSizeHandler.getLargestCellWidth(jCTable, 0, n9 - 1, i2);
            } else if (n10 == -996) {
                CellArea cellArea;
                int n11 = CellSizeHandler.getCellWidth(jCTable, -1, i2);
                CellAreaHandler cellAreaHandler = jCTable.getCellAreaHandler();
                JCCellRange jCCellRange = cellAreaHandler.getVisibleCells();
                if (jCCellRange.start_row != -999 && jCCellRange.end_row != -999) {
                    n8 = Math.max(n11, CellSizeHandler.getLargestCellWidth(jCTable, jCCellRange.start_row, jCCellRange.end_row, i2));
                }
                if ((cellArea = cellAreaHandler.findByType(1)) != null) {
                    n8 = Math.max(n8, CellSizeHandler.getLargestCellWidth(jCTable, cellArea.start_row, cellArea.end_row, i2));
                }
            } else if (n10 >= 0) {
                n8 = CellSizeHandler.getLargestCellWidth(jCTable, -1, n10, i2);
            }
            n7 = Math.max(n7, n8 += n6);
        }
        return n7;
    }

    protected static void setCellLayoutWidth(CellLayoutModel cellLayoutModel, int n2, int n3, int n4) {
        if (n2 == -1) {
            cellLayoutModel.setWidth(n2, n4);
        } else {
            cellLayoutModel.setWidth(n2, n3, n4);
        }
    }

    protected static int getCellWidth(JCTable jCTable, int n2, int n3) {
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return 0;
        }
        Component component = jCTable.getComponent(n2, n3);
        if (component != null) {
            return component.getPreferredSize().width;
        }
        Object object = jCTable.getDataView().getObject(n2, n3);
        JCCellRenderer jCCellRenderer = jCTable.getDataView().getCellRenderer(n2, n3, object);
        return CellSizeHandler.getCellWidth(jCTable, n2, n3, object, jCCellRenderer);
    }

    protected static int getCellWidth(JCTable jCTable, int n2, int n3, Object object, JCCellRenderer jCCellRenderer) {
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return 0;
        }
        TableCellInfoModel tableCellInfoModel = jCTable.getCellAreaHandler().getTableCellInfo();
        tableCellInfoModel.initialize(jCTable, object, n2, n3);
        Dimension dimension = null;
        if (jCCellRenderer instanceof JCLightCellRenderer) {
            JCLightCellRenderer jCLightCellRenderer = (JCLightCellRenderer)jCCellRenderer;
            dimension = jCLightCellRenderer.getPreferredSize(jCTable.getGraphics(), tableCellInfoModel, object);
        } else if (jCCellRenderer instanceof JCComponentCellRenderer) {
            JCComponentCellRenderer jCComponentCellRenderer = (JCComponentCellRenderer)jCCellRenderer;
            Component component = jCComponentCellRenderer.getRendererComponent(tableCellInfoModel, object, jCTable.isSelected(n2, n3));
            dimension = component.getPreferredSize();
        }
        if (dimension == null) {
            return CellSizeHandler.getWidth(jCTable.getGraphics().getFontMetrics(tableCellInfoModel.getFont()), object.toString());
        }
        return dimension.width;
    }

    protected static final int getLargestCellWidth(JCTable jCTable, int n2, int n3, int n4) {
        int n5;
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return 0;
        }
        int n6 = 0;
        if (n4 < 0 && n2 < 0) {
            n2 = 0;
        }
        if (n3 >= (n5 = jCTable.getDataView().getNumRows())) {
            n3 = n5 - 1;
        }
        for (int i2 = n2; i2 <= n3; ++i2) {
            JCCellRange jCCellRange;
            if (jCTable.spanHandler != null && (jCCellRange = jCTable.getSpannedRange(i2, n4)) != null && jCCellRange.start_column != jCCellRange.end_column) continue;
            n6 = Math.max(n6, CellSizeHandler.getCellWidth(jCTable, i2, n4));
        }
        return n6;
    }

    protected static final int getWidth(FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        if (string.indexOf(10) != -1) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            while ((n2 = string.indexOf(10, n3)) != -1) {
                n4 = Math.max(n4, fontMetrics.stringWidth(string.substring(n3, n2)));
                n3 = n2 + 1;
            }
            return Math.max(n4, fontMetrics.stringWidth(string.substring(n3, string.length())));
        }
        return fontMetrics.stringWidth(string);
    }

    protected static Dimension getCellDimensions(JCTable jCTable, int n2, int n3) {
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return new Dimension(0, 0);
        }
        Object object = jCTable.getDataView().getObject(n2, n3);
        JCCellRenderer jCCellRenderer = jCTable.getDataView().getCellRenderer(n2, n3, object);
        return CellSizeHandler.getCellDimensions(jCTable, n2, n3, object, jCCellRenderer);
    }

    protected static Dimension getCellDimensions(JCTable jCTable, int n2, int n3, Object object, JCCellRenderer jCCellRenderer) {
        Serializable serializable;
        if (jCTable.getGraphics() == null) {
            jCTable.setRecalcRequired(true);
            return new Dimension(0, 0);
        }
        TableCellInfoModel tableCellInfoModel = jCTable.getCellAreaHandler().getTableCellInfo();
        tableCellInfoModel.initialize(jCTable, object, n2, n3);
        Dimension dimension = null;
        if (jCCellRenderer instanceof JCLightCellRenderer) {
            serializable = (JCLightCellRenderer)jCCellRenderer;
            dimension = serializable.getPreferredSize(jCTable.getGraphics(), tableCellInfoModel, object);
        } else if (jCCellRenderer instanceof JCComponentCellRenderer) {
            serializable = (JCComponentCellRenderer)jCCellRenderer;
            Component component = serializable.getRendererComponent(tableCellInfoModel, object, jCTable.isSelected(n2, n3));
            dimension = component.getPreferredSize();
        }
        if (dimension == null) {
            serializable = jCTable.getGraphics().getFontMetrics(tableCellInfoModel.getFont());
            return new Dimension(CellSizeHandler.getWidth((FontMetrics)serializable, object.toString()), CellSizeHandler.getHeight((FontMetrics)serializable, object.toString()));
        }
        return dimension;
    }

    protected static int getFontHeight(JCTable jCTable, int n2, int n3) {
        Object v;
        Font font = jCTable.getCellStyle(n2, n3).getFont();
        if (font == null) {
            return 0;
        }
        if (cachedFontHeights == null) {
            cachedFontHeights = new Hashtable();
        }
        if ((v = cachedFontHeights.get(font)) != null && v instanceof Integer) {
            return (Integer)v;
        }
        int n4 = jCTable.getFontMetrics(font).getHeight();
        cachedFontHeights.put(font, new Integer(n4));
        return n4;
    }

    protected static int getFontWidth(JCTable jCTable, int n2, int n3) {
        Font font = jCTable.getCellStyle(n2, n3).getFont();
        if (font == null) {
            return 0;
        }
        return jCTable.getFontMetrics(font).charWidth('W');
    }
}

