/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.plaf;

import com.klg.jclass.swing.JCPopupCalendar;
import com.klg.jclass.swing.JCPopupCalendarEditor;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.swing.JCPopupEvent;
import com.klg.jclass.util.swing.JCPopupListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;

public class CalendarPopup
extends BasicComboPopup
implements Serializable {
    protected JCPopupCalendarEditor popup = null;
    protected JCPopupCalendar popupCalendar;
    protected PopupListener popupListener = new PopupListener();
    protected Date originalDate = null;

    public CalendarPopup(JComboBox jComboBox, JCPopupCalendarEditor jCPopupCalendarEditor) {
        super(jComboBox);
        this.popupCalendar = (JCPopupCalendar)jComboBox;
        this.setPopupCalendarEditor(jCPopupCalendarEditor);
    }

    public void setPopupCalendarEditor(JCPopupCalendarEditor jCPopupCalendarEditor) {
        if (jCPopupCalendarEditor == null) {
            return;
        }
        if (this.popup != null) {
            this.popup.removePopupListener(this.popupListener);
            this.remove(this.popup.getEditorComponent());
        }
        this.popup = jCPopupCalendarEditor;
        this.popup.addPopupListener(this.popupListener);
        JComponent jComponent = this.popup.getEditorComponent();
        this.add(jComponent);
        this.setFocusableOnTree(jComponent, false);
    }

    protected void setFocusableOnTree(Component component, boolean bl) {
        if (component == null) {
            return;
        }
        component.setFocusable(false);
        if (component instanceof Container) {
            Component[] componentArray;
            for (Component component2 : componentArray = ((Container)component).getComponents()) {
                this.setFocusableOnTree(component2, bl);
            }
        }
    }

    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setRequestFocusEnabled(false);
    }

    public void show() {
        if (this.popup == null || this.popup.getEditorComponent() == null) {
            return;
        }
        this.originalDate = this.popupCalendar.getValue();
        if (this.originalDate != null) {
            this.popup.setValue(this.originalDate);
        }
        JComponent jComponent = this.popup.getEditorComponent();
        Rectangle rectangle = this.computePopupBounds(0, this.popupCalendar.getBounds().height, jComponent.getWidth(), jComponent.getHeight());
        this.setLightWeightPopupEnabled(this.popupCalendar.isLightWeightPopupEnabled());
        this.show(this.popupCalendar, rectangle.x, rectangle.y);
    }

    public Date getOriginalDate() {
        return this.originalDate;
    }

    protected Rectangle computePopupBounds(int n2, int n3, int n4, int n5) {
        Cloneable cloneable;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point point = new Point(0, 0);
        SwingUtilities.convertPointFromScreen(point, this.comboBox);
        GraphicsConfiguration graphicsConfiguration = this.comboBox.getGraphicsConfiguration();
        Rectangle rectangle = GraphicsUtil.getScreenBounds(this.comboBox);
        if (graphicsConfiguration != null) {
            cloneable = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle.width -= cloneable.left + cloneable.right;
            rectangle.height -= cloneable.top + cloneable.bottom;
            rectangle.x += point.x + cloneable.left;
            rectangle.y += point.y + cloneable.top;
        } else {
            rectangle.x += point.x;
            rectangle.y += point.y;
        }
        cloneable = new Rectangle(n2, n3, n4, n5);
        if (this.isRectangleContainingRectangle(rectangle, (Rectangle)cloneable)) {
            return cloneable;
        }
        Insets insets = this.getInsets();
        if (!this.isRectangleContainingRectangleFitRight(rectangle, (Rectangle)cloneable)) {
            ((Rectangle)cloneable).x += rectangle.x + rectangle.width - (((Rectangle)cloneable).width + insets.left + insets.right);
        }
        if (!this.isRectangleContainingRectangleFitLeft(rectangle, (Rectangle)cloneable)) {
            ((Rectangle)cloneable).x = rectangle.x;
        }
        if (!this.isRectangleContainingRectangleFitDown(rectangle, (Rectangle)cloneable)) {
            ((Rectangle)cloneable).y = -(((Rectangle)cloneable).height + insets.top + insets.bottom);
        }
        return cloneable;
    }

    public final boolean isRectangleContainingRectangle(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width && rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height;
    }

    public final boolean isRectangleContainingRectangleFitLeft(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.x < 0;
    }

    public final boolean isRectangleContainingRectangleFitRight(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.x + rectangle2.width < rectangle.x + rectangle.width;
    }

    public final boolean isRectangleContainingRectangleFitDown(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height;
    }

    public void hide() {
        super.hide();
        if (!this.popupListener.inCommit && this.popup != null) {
            this.popup.firePopupEvent();
        }
    }

    class PopupListener
    implements JCPopupListener,
    Serializable {
        boolean inCommit = false;

        PopupListener() {
        }

        public void commit(JCPopupEvent jCPopupEvent) {
            this.inCommit = true;
            CalendarPopup.this.hide();
            this.inCommit = false;
        }
    }
}

