/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing;

import com.klg.jclass.cell.EditorRendererRegistry;
import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.swing.JCCellEditorToJTable;
import com.klg.jclass.cell.swing.JCCellRendererToJTable;
import com.klg.jclass.swing.DefaultTreeTableSelectionModel;
import com.klg.jclass.swing.JCTreeTableSelectionModel;
import com.klg.jclass.swing.JCVersion;
import com.klg.jclass.swing.resources.LocaleBundle;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.graphics.UIDComponent;
import com.klg.jclass.util.graphics.UIResourceUtil;
import com.klg.jclass.util.swing.JCBrace;
import com.klg.jclass.util.swing.JCElasticLayout;
import com.klg.jclass.util.swing.JCSortableTable;
import com.klg.jclass.util.swing.JCTableColumn;
import com.klg.jclass.util.treetable.EmptyTreeTableModel;
import com.klg.jclass.util.treetable.JCTreeIconRenderer;
import com.klg.jclass.util.treetable.JCTreeTableColumnModel;
import com.klg.jclass.util.treetable.JCTreeTableModel;
import com.klg.jclass.util.treetable.TreeTableSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCTreeTable
extends JCSortableTable {
    public static final int TREE = 1;
    public static final int TABLE = 2;
    public static final int SWITCH_VIEW_NEVER = 1;
    public static final int SWITCH_VIEW_TO_TABLE_ON_SORT = 2;
    public static final int SWITCH_VIEW_ON_ICON_ONLY = 3;
    public static final int SWITCH_BUTTON_DONT_SHOW = 4;
    public static final int NODE_LINES_SHOW = 1;
    public static final int NODE_LINES_HIDE = 2;
    public static final int NODE_LINES_USE_PLAF = 3;
    protected static final int ICON_SIZE = 16;
    protected int switchPolicy = 3;
    protected TreeTableSupport support;
    private static final Border emptyBorder = new EmptyBorder(0, 0, 0, 0);
    protected JCTreeTableSelectionModel treeSelectionModel;
    protected boolean sortable = true;
    protected boolean expandInTreeColumnOnly = false;
    protected boolean treeColumnMoveable = false;

    public JCTreeTable() {
        this((JCTreeTableModel)null);
    }

    public JCTreeTable(JCTreeTableModel jCTreeTableModel) {
        this(jCTreeTableModel, new Dimension(0, 0));
    }

    public JCTreeTable(JCTreeTableModel jCTreeTableModel, Dimension dimension) {
        this.setDefaultRenderer(TreePath.class, new Renderer());
        this.setDefaultEditor(TreePath.class, new Editor());
        this.support = new TreeTableSupport(this);
        this.setIntercellSpacing(dimension);
        this.setColumnModel(new JCTreeTableColumnModel(this));
        if (jCTreeTableModel == null) {
            jCTreeTableModel = new EmptyTreeTableModel(EmptyTreeTableModel.makeDefaultTree());
        }
        this.support.setTreeTableModel(jCTreeTableModel);
        this.setTreeTableSelectionModel(new DefaultTreeTableSelectionModel());
        this.setModel(this.support);
        this.updateUI();
        if (this.support.getMaxIconHeight() > this.getRowHeight()) {
            this.setRowHeight(this.support.getMaxIconHeight());
        }
    }

    @Override
    public void setUI(TableUI tableUI) {
        if (this.support != null) {
            this.support.inferLookAndFeel();
        }
        super.setUI(tableUI);
    }

    @Override
    public void updateUI() {
        Object object;
        Serializable serializable;
        Color color;
        Object object2;
        Object object3;
        Serializable serializable2;
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        boolean bl = lookAndFeel != null && "Synth".equals(lookAndFeel.getID());
        SynthContext synthContext = null;
        if (bl) {
            serializable2 = new UIDComponent("TableUI");
            object3 = SynthLookAndFeel.getRegion(serializable2);
            object2 = SynthLookAndFeel.getStyle(serializable2, (Region)object3);
            synthContext = new SynthContext((JComponent)serializable2, (Region)object3, (SynthStyle)object2, 1);
            ((SynthStyle)object2).installDefaults(synthContext);
        }
        serializable2 = UIResourceUtil.getUIResourceColor("Table.background", synthContext, ColorType.BACKGROUND, Color.white);
        object3 = UIResourceUtil.getUIResourceColor("Table.foreground", synthContext, ColorType.FOREGROUND, Color.black);
        object2 = UIResourceUtil.getUIResourceObject("Table.gridColor", synthContext, Color.black);
        Color color2 = color = object2 instanceof Color ? (Color)object2 : Color.black;
        if (bl) {
            serializable = (UIDComponent)synthContext.getComponent();
            object = SynthLookAndFeel.getRegion(serializable);
            SynthStyle synthStyle = SynthLookAndFeel.getStyle(serializable, (Region)object);
            synthContext = new SynthContext((JComponent)serializable, (Region)object, synthStyle, 512);
            synthStyle.installDefaults(synthContext);
        }
        serializable = UIResourceUtil.getUIResourceColor("Table.selectionBackground", synthContext, ColorType.BACKGROUND, Color.gray);
        object = UIResourceUtil.getUIResourceColor("Table.selectionForeground", synthContext, ColorType.FOREGROUND, Color.white);
        UIManager.put("Table.background", serializable2);
        UIManager.put("Table.foreground", object3);
        UIManager.put("Table.selectionBackground", serializable);
        UIManager.put("Table.selectionForeground", object);
        UIManager.put("Table.gridColor", color);
        this.setUI(new TreeTableUI());
    }

    @Override
    public Dimension getPreferredSize() {
        if (JCEnvironment.isDesignTime()) {
            this.expandRow(0);
            return new Dimension(200, 200);
        }
        return super.getPreferredSize();
    }

    @Override
    public void setAbout(String string) {
    }

    @Override
    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean bl) {
        this.support.setSortable(bl);
        this.sortable = bl;
    }

    public void setSwitchPolicy(int n2) {
        if (n2 < 1 || n2 > 4) {
            String string = LocaleBundle.string("Invalid switch policy.  Must be one of: SWITCH_VIEW_NEVER,  SWITCH_VIEW_TO_TABLE_ON_SORT, SWITCH_VIEW_ON_ICON_ONLY, or SWITCH_BUTTON_DONT_SHOW");
            throw new IllegalArgumentException(string);
        }
        this.switchPolicy = n2;
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (!(tableCellRenderer instanceof SwitchRenderer)) continue;
            SwitchRenderer switchRenderer = (SwitchRenderer)tableCellRenderer;
            switchRenderer.setSwitchPolicy(this.switchPolicy);
            boolean bl = this.getComponentOrientation().isLeftToRight();
            switchRenderer.reLayout(bl);
            this.getTableHeader().repaint();
        }
    }

    public int getSwitchPolicy() {
        return this.switchPolicy;
    }

    public void setView(int n2) {
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (!(tableCellRenderer instanceof SwitchRenderer)) continue;
            ((SwitchRenderer)tableCellRenderer).setView(n2);
        }
        this.support.setView(n2);
    }

    public int getView() {
        if (this.support != null) {
            return this.support.getView();
        }
        return 1;
    }

    public TreeTableSupport getTreeTableSupport() {
        return this.support;
    }

    public void setShowNodeLines(int n2) {
        this.support.setShowNodeLines(n2);
    }

    public int getShowNodeLines() {
        return this.support.getShowNodeLines();
    }

    public boolean isExpandInTreeColumnOnly() {
        return this.expandInTreeColumnOnly;
    }

    public void setExpandInTreeColumnOnly(boolean bl) {
        this.expandInTreeColumnOnly = bl;
    }

    public boolean isTreeColumnMoveable() {
        return this.treeColumnMoveable;
    }

    public void setTreeColumnMoveable(boolean bl) {
        this.treeColumnMoveable = bl;
    }

    public int getTreeColumn() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!(tableColumnModel.getColumn(i2) instanceof SwitchTableColumn)) continue;
            return i2;
        }
        return 0;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n2, int n3) {
        TableCellRenderer tableCellRenderer = this.support.getView() == 1 && n3 == this.getTreeColumn() ? this.getDefaultRenderer(TreePath.class) : super.getCellRenderer(n2, n3);
        return tableCellRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int n2, int n3) {
        TableCellEditor tableCellEditor = this.support.getView() == 1 && n3 == this.getTreeColumn() ? this.getDefaultEditor(TreePath.class) : super.getCellEditor(n2, n3);
        return tableCellEditor;
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.support.addTreeExpansionListener(treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.support.removeTreeExpansionListener(treeExpansionListener);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.support.addTreeWillExpandListener(treeWillExpandListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.support.removeTreeWillExpandListener(treeWillExpandListener);
    }

    public void setTreeIconRenderer(JCTreeIconRenderer jCTreeIconRenderer) {
        this.support.setTreeIconRenderer(jCTreeIconRenderer);
    }

    public JCTreeIconRenderer getTreeIconRenderer() {
        return this.support.getTreeIconRenderer();
    }

    public void collapseRow(int n2) {
        this.support.collapseRow(n2);
    }

    public void collapsePath(TreePath treePath) {
        this.support.collapsePath(treePath);
    }

    public void expandRow(int n2) {
        this.support.expandRow(n2);
    }

    public void expandPath(TreePath treePath) {
        this.support.expandPath(treePath);
    }

    public void makeVisible(TreePath treePath) {
        TreePath treePath2;
        if (treePath != null && (treePath2 = treePath.getParentPath()) != null) {
            this.expandPath(treePath2);
        }
    }

    public TreePath getClosestPathForLocation(int n2, int n3) {
        int n4 = this.rowAtPoint(new Point(n2, n3));
        return this.support.getPathForRow(n4);
    }

    public int getClosestRowForLocation(int n2, int n3) {
        return this.rowAtPoint(new Point(n2, n3));
    }

    public TreePath getEditingPath() {
        int n2 = this.getEditingRow();
        if (n2 == -1) {
            return null;
        }
        return this.support.getPathForRow(n2);
    }

    public Enumeration<TreePath> getExpandedDescendants(TreePath treePath) {
        return this.support.getExpandedDescendants(treePath);
    }

    public JCTreeTableModel getTreeTableModel() {
        return this.support.getTreeTableModel();
    }

    public void setTreeTableModel(JCTreeTableModel jCTreeTableModel) {
        this.support.setTreeTableModel(jCTreeTableModel);
        this.setModel(new DefaultTableModel());
        this.setModel(this.support);
        this.revalidate();
    }

    public Rectangle getPathBounds(TreePath treePath) {
        return null;
    }

    public TreePath getPathForLocation(int n2, int n3) {
        return this.getClosestPathForLocation(n2, n3);
    }

    public int getRowForLocation(int n2, int n3) {
        return this.getClosestRowForLocation(n2, n3);
    }

    public Rectangle getRowBounds(int n2) {
        return null;
    }

    public int getRowForPath(TreePath treePath) {
        return this.support.getRowForPath(treePath);
    }

    public TreePath getPathForRow(int n2) {
        return this.support.getPathForRow(n2);
    }

    public boolean getScrollsOnExpand() {
        return this.support.getScrollsOnExpand();
    }

    public void setScrollsOnExpand(boolean bl) {
        this.support.setScrollsOnExpand(bl);
    }

    public boolean isRootVisible() {
        return this.support.isRootVisible();
    }

    public void setRootVisible(boolean bl) {
        this.support.setRootVisible(bl);
    }

    public boolean getShowsRootHandles() {
        return this.support.getShowsRootHandles();
    }

    public void setShowsRootHandles(boolean bl) {
        this.support.setShowsRootHandles(bl);
    }

    public int[] getRowsForPaths(TreePath[] treePathArray) {
        return this.support.getRowsForPaths(treePathArray);
    }

    public void addSelectionPath(TreePath treePath) {
        this.makeVisible(treePath);
        this.treeSelectionModel.addSelectionPath(treePath);
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null) {
            for (int i2 = treePathArray.length - 1; i2 >= 0; --i2) {
                this.makeVisible(treePathArray[i2]);
            }
        }
        this.treeSelectionModel.addSelectionPaths(treePathArray);
    }

    public void setSelectionPath(TreePath treePath) {
        this.makeVisible(treePath);
        this.treeSelectionModel.setSelectionPath(treePath);
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null) {
            for (int i2 = treePathArray.length - 1; i2 >= 0; --i2) {
                this.makeVisible(treePathArray[i2]);
            }
        }
        this.treeSelectionModel.setSelectionPaths(treePathArray);
    }

    public boolean isPathSelected(TreePath treePath) {
        return this.treeSelectionModel != null && this.treeSelectionModel.isPathSelected(treePath);
    }

    public TreePath getSelectionPath() {
        int n2 = this.getSelectedRow();
        if (n2 < 0) {
            return null;
        }
        return this.support.getPathForRow(n2);
    }

    public TreePath[] getSelectionPaths() {
        int[] nArray = this.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        TreePath[] treePathArray = new TreePath[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            treePathArray[i2] = this.support.getPathForRow(nArray[i2]);
        }
        return treePathArray;
    }

    public void setTreeTableSelectionModel(JCTreeTableSelectionModel jCTreeTableSelectionModel) {
        if (jCTreeTableSelectionModel == null) {
            jCTreeTableSelectionModel = EmptyTreeSelectionModel.getSharedInstance();
        }
        JCTreeTableSelectionModel jCTreeTableSelectionModel2 = this.treeSelectionModel;
        this.treeSelectionModel = jCTreeTableSelectionModel;
        this.treeSelectionModel.setRowMapper(this.support);
        this.setSelectionModel(this.treeSelectionModel.getListSelectionModel());
        this.firePropertyChange("treeSelectionModel", jCTreeTableSelectionModel2, this.selectionModel);
    }

    public JCTreeTableSelectionModel getTreeSelectionModel() {
        return this.treeSelectionModel;
    }

    protected boolean isPointOverSwitch(Point point) {
        int n2;
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        boolean bl = this.getComponentOrientation().isLeftToRight();
        int n3 = n2 = bl ? 0 : this.getWidth();
        while (enumeration.hasMoreElements()) {
            boolean bl2;
            TableColumn tableColumn = enumeration.nextElement();
            int n4 = tableColumn.getWidth();
            boolean bl3 = bl ? n2 + n4 > point.x : (bl2 = n2 - n4 < point.x);
            if (bl2) {
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer instanceof SwitchRenderer) {
                    int n5;
                    SwitchRenderer switchRenderer = (SwitchRenderer)tableCellRenderer;
                    boolean bl4 = switchRenderer.isCurrentLayoutLeft();
                    Insets insets = switchRenderer.getInsets();
                    int n6 = switchRenderer.getSwitchButton().getSize().width;
                    int n7 = bl ? n2 : n2 - n4;
                    int n8 = bl ? n2 + n4 : n2;
                    int n9 = bl4 ? point.x - n7 : n8 - point.x;
                    int n10 = n5 = bl4 ? n6 + insets.left : n6 + insets.right + 1;
                    if (n9 <= n5) {
                        return true;
                    }
                }
                return false;
            }
            n2 = bl ? n2 + n4 : n2 - n4;
        }
        return false;
    }

    protected void toggleView() {
        if (this.getView() == 1) {
            this.setView(2);
        } else {
            this.setView(1);
        }
    }

    @Override
    protected MouseAdapter createTableHeaderMouseListener() {
        return new TableHeaderMouseAdapter();
    }

    @Override
    protected void reLayoutColumnRenderers() {
        TableCellRenderer tableCellRenderer;
        super.reLayoutColumnRenderers();
        TableCellRenderer tableCellRenderer2 = this.getDefaultRenderer(TreePath.class);
        if (tableCellRenderer2 instanceof Renderer && (tableCellRenderer = ((Renderer)tableCellRenderer2).renderer) instanceof JCCellRendererToJTable) {
            boolean bl = this.getComponentOrientation().isLeftToRight();
            int n2 = bl ? 2 : 4;
            ((JCCellRendererToJTable)tableCellRenderer).setHorizontalAlignment(n2);
        }
    }

    @Override
    public TableColumn createSortableTableColumn(int n2) {
        if (n2 == this.getTreeColumn()) {
            return new SwitchTableColumn(n2);
        }
        return super.createSortableTableColumn(n2);
    }

    protected static class EmptyTreeSelectionModel
    extends DefaultTreeTableSelectionModel {
        protected static EmptyTreeSelectionModel emptyModel = new EmptyTreeSelectionModel();

        protected EmptyTreeSelectionModel() {
        }

        public static EmptyTreeSelectionModel getSharedInstance() {
            return emptyModel;
        }

        public void setSelectionPaths(TreePath[] treePathArray) {
        }

        public void addSelectionPaths(TreePath[] treePathArray) {
        }

        public void removeSelectionPaths(TreePath[] treePathArray) {
        }
    }

    protected static class SwitchIcon
    implements Icon,
    Serializable {
        protected boolean orientationLeft = true;
        protected int view = 1;
        protected Color background = null;
        protected Color foreground = Color.black;

        public SwitchIcon() {
        }

        public SwitchIcon(boolean bl, int n2) {
            this.setOrientationLeft(bl);
            this.setView(n2);
        }

        public boolean isOrientationLeft() {
            return this.orientationLeft;
        }

        public void setOrientationLeft(boolean bl) {
            this.orientationLeft = bl;
        }

        public void setView(int n2) {
            if (n2 != 1 && n2 != 2) {
                throw new IllegalArgumentException(LocaleBundle.string("View must be one of JCTreeTable.TREE or JCTreeTable.Table"));
            }
            this.view = n2;
        }

        public int getView() {
            return this.view;
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public Color getBackground() {
            return this.background;
        }

        public void setBackground(Color color) {
            this.background = color;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public void setForeground(Color color) {
            this.foreground = color == null ? Color.black : color;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            if (this.background != null) {
                graphics.setColor(this.background);
                graphics.fillRect(n2, n3, this.getIconWidth(), this.getIconHeight());
            }
            graphics.setColor(this.foreground);
            if (this.view == 2) {
                for (int i2 = 0; i2 < 15; i2 += 3) {
                    for (int i3 = 0; i3 < 16; i3 += 4) {
                        graphics.drawLine(n2 + i3, n3 + i2 + 1, n2 + i3 + 2, n3 + i2 + 1);
                        graphics.drawLine(n2 + i3, n3 + i2 + 1 + 1, n2 + i3 + 2, n3 + i2 + 1 + 1);
                    }
                }
            } else {
                int n4 = 14;
                int n5 = n3 + 1;
                int n6 = this.orientationLeft ? n2 : n2 + n4;
                int n7 = this.orientationLeft ? n2 + 4 + 2 : n2 + n4 - 6;
                graphics.drawLine(n6, n5, n7, n5);
                graphics.drawLine(n6, n5 + 1, n7, n5 + 1);
                n6 = this.orientationLeft ? n2 + 3 : n2 + n4 - 3;
                graphics.drawLine(n6, n5 += 3, n7, n5);
                graphics.drawLine(n6, n5 + 1, n7, n5 + 1);
                graphics.drawLine(n6, n5 += 3, n7, n5);
                graphics.drawLine(n6, n5 + 1, n7, n5 + 1);
                n6 = this.orientationLeft ? n2 : n2 + n4;
                graphics.drawLine(n6, n5 += 3, n7, n5);
                graphics.drawLine(n6, n5 + 1, n7, n5 + 1);
                for (int i4 = 0; i4 < 15; i4 += 3) {
                    for (int i5 = 8; i5 < 16; i5 += 4) {
                        n6 = this.orientationLeft ? n2 + i5 : n2 + n4 - i5;
                        n7 = this.orientationLeft ? n2 + i5 + 2 : n2 + n4 - (i5 + 2);
                        n5 = n3 + i4 + 1;
                        graphics.drawLine(n6, n5, n7, n5);
                        graphics.drawLine(n6, n5 + 1, n7, n5 + 1);
                    }
                }
            }
        }
    }

    protected class SwitchRenderer
    extends JCSortableTable.SortableHeaderRenderer
    implements TableCellRenderer,
    JCSortableTable.SortableColumnHeader {
        protected int switchPolicy;
        protected JButton switchButton;
        protected Icon icon;
        protected boolean initialized;

        public SwitchRenderer() {
            this(3, true);
        }

        public SwitchRenderer(int n2) {
            this(n2, true);
        }

        public SwitchRenderer(int n2, boolean bl) {
            super(bl);
            this.switchPolicy = 3;
            this.switchButton = null;
            this.icon = null;
            this.initialized = false;
            this.setSwitchPolicy(n2);
            int n3 = JCTreeTable.this != null ? JCTreeTable.this.getView() : 1;
            this.setSwitchIcon(new SwitchIcon(bl, n3));
            this.initialized = true;
            this.reLayout(bl);
        }

        public void setView(int n2) {
            if (this.icon instanceof SwitchIcon) {
                ((SwitchIcon)this.icon).setView(n2);
            }
        }

        public void setSwitchPolicy(int n2) {
            this.switchPolicy = n2;
        }

        public void setSwitchIcon(Icon icon) {
            if (icon == null) {
                throw new IllegalArgumentException(LocaleBundle.string("Icon cannot be null."));
            }
            this.icon = icon;
            if (this.switchButton != null) {
                this.switchButton.setIcon(icon);
            }
        }

        protected JButton getSwitchButton() {
            return this.switchButton;
        }

        protected void setProperties(JTable jTable) {
            if (jTable == null) {
                return;
            }
            super.setProperties(jTable);
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (jTableHeader != null && this.icon instanceof SwitchIcon) {
                SwitchIcon switchIcon = (SwitchIcon)this.icon;
                switchIcon.setBackground(jTableHeader.getBackground());
                switchIcon.setForeground(jTableHeader.getForeground());
            }
        }

        public void reLayout(boolean bl) {
            if (!this.initialized) {
                return;
            }
            this.removeAll();
            if (this.icon instanceof SwitchIcon && bl != ((SwitchIcon)this.icon).isOrientationLeft()) {
                int n2 = JCTreeTable.this != null ? JCTreeTable.this.getView() : 1;
                this.icon = new SwitchIcon(bl, n2);
                this.switchButton = null;
            }
            if (bl != this.currentLayoutLeft) {
                ComponentOrientation componentOrientation = bl ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT;
                JCTreeTable.setComponentOrientation(this.label, componentOrientation, true);
            }
            if (this.switchPolicy == 4) {
                this.switchButton = null;
            } else if (this.switchButton == null) {
                this.switchButton = new JButton(this.icon);
                this.switchButton.setBorder(emptyBorder);
            }
            if (bl) {
                if (this.switchButton != null) {
                    this.add(this.switchButton);
                    this.add(new JSeparator(1));
                }
                this.add((Component)this.label, JCElasticLayout.HORIZONTALLY_ELASTIC_CONSTRAINT);
            }
            if (this.sortIcon != null) {
                this.add(this.sortButton);
                this.add(this.brace);
            }
            if (!bl) {
                this.add((Component)this.label, JCElasticLayout.HORIZONTALLY_ELASTIC_CONSTRAINT);
                if (this.switchButton != null) {
                    this.add(new JSeparator(1));
                    this.add(this.switchButton);
                    this.add(JCBrace.createHorizontalBrace(1));
                }
            }
            this.currentLayoutLeft = bl;
        }
    }

    protected class SwitchTableColumn
    extends JCTableColumn {
        public SwitchTableColumn(int n2) {
            super(n2);
            this.setHeaderRenderer(this.createDefaultHeaderRenderer());
        }

        protected TableCellRenderer createDefaultHeaderRenderer() {
            boolean bl = ComponentOrientation.UNKNOWN.isLeftToRight();
            int n2 = 3;
            if (JCTreeTable.this != null) {
                bl = JCTreeTable.this.getComponentOrientation().isLeftToRight();
                n2 = JCTreeTable.this.switchPolicy;
            }
            return new SwitchRenderer(n2, bl);
        }
    }

    protected class Editor
    extends TreeRendererEditor
    implements TableCellEditor {
        protected TableCellEditor editor;

        protected TableCellEditor getEditor() {
            return this.getEditor(JCTreeTable.this);
        }

        protected TableCellEditor getEditor(JTable jTable) {
            if (this.editor == null) {
                String string;
                Class<?> clazz;
                EditorRendererRegistry editorRendererRegistry;
                JCCellEditor jCCellEditor;
                TableColumn tableColumn = JCTreeTable.this.getColumnModel().getColumn(0);
                this.editor = tableColumn.getCellEditor();
                if (this.editor == null && tableColumn instanceof JCTableColumn && (jCCellEditor = (editorRendererRegistry = EditorRendererRegistry.getCentralRegistry()).getCellEditorInstance(clazz = JCTreeTable.this.support.getTreeColumnClass(), string = ((JCTableColumn)tableColumn).getRegistryType())) != null) {
                    this.editor = new JCCellEditorToJTable(jCCellEditor);
                }
                if (this.editor == null) {
                    this.editor = JCTreeTable.this.getDefaultEditor(JCTreeTable.this.support.getTreeColumnClass());
                }
            }
            return this.editor;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
            this.path = (TreePath)object;
            Object object2 = JCTreeTable.this.support.getTreeColumnValue(this.path.getLastPathComponent());
            Component component = this.getEditor(jTable).getTableCellEditorComponent(jTable, object2, bl, n2, n3);
            ComponentOrientation componentOrientation = JCTreeTable.this.getComponentOrientation();
            JCTreeTable.setComponentOrientation(component, componentOrientation, false);
            if (component.getParent() != this) {
                this.removeAll();
                this.add(component);
            }
            return this;
        }

        public Object getCellEditorValue() {
            return this.getEditor().getCellEditorValue();
        }

        public boolean isCellEditable(EventObject eventObject) {
            return this.getEditor().isCellEditable(eventObject);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return this.getEditor().shouldSelectCell(eventObject);
        }

        public boolean stopCellEditing() {
            return this.getEditor().stopCellEditing();
        }

        public void cancelCellEditing() {
            this.getEditor().cancelCellEditing();
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.getEditor().addCellEditorListener(cellEditorListener);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.getEditor().removeCellEditorListener(cellEditorListener);
        }
    }

    protected class Renderer
    extends TreeRendererEditor
    implements TableCellRenderer {
        protected TableCellRenderer renderer;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
            if (jTable != null) {
                Serializable serializable;
                ComponentOrientation componentOrientation = JCTreeTable.this.getComponentOrientation();
                if (this.renderer == null) {
                    Object object2;
                    serializable = jTable.getColumnModel().getColumn(n3);
                    if (serializable != null && (object2 = ((TableColumn)serializable).getCellRenderer()) != null) {
                        this.renderer = object2;
                    }
                    if (this.renderer == null && serializable instanceof JCTableColumn) {
                        String string;
                        Class<?> clazz;
                        object2 = (JCTableColumn)serializable;
                        EditorRendererRegistry editorRendererRegistry = EditorRendererRegistry.getCentralRegistry();
                        JCCellRenderer jCCellRenderer = editorRendererRegistry.getCellRendererInstance(clazz = JCTreeTable.this.support.getTreeColumnClass(), string = ((JCTableColumn)object2).getRegistryType());
                        if (jCCellRenderer != null) {
                            JCCellRendererToJTable jCCellRendererToJTable = new JCCellRendererToJTable(jCCellRenderer);
                            if (!componentOrientation.isLeftToRight()) {
                                jCCellRendererToJTable.setHorizontalAlignment(4);
                            }
                            this.renderer = jCCellRendererToJTable;
                        }
                    }
                    if (this.renderer == null) {
                        this.renderer = JCTreeTable.this.getDefaultRenderer(JCTreeTable.this.support.getTreeColumnClass());
                    }
                }
                if (object instanceof TreePath) {
                    this.path = (TreePath)object;
                    this.value = JCTreeTable.this.support.getTreeColumnValue(this.path.getLastPathComponent());
                } else {
                    this.path = null;
                    this.value = object;
                }
                this.value_class = this.value != null ? this.value.getClass() : null;
                serializable = this.renderer.getTableCellRendererComponent(jTable, this.value, bl, bl2, n2, n3);
                JCTreeTable.setComponentOrientation((Component)serializable, componentOrientation, false);
                if (((Component)serializable).getParent() != this) {
                    this.removeAll();
                    this.add((Component)serializable);
                }
            }
            return this;
        }

        public Dimension getPreferredSize() {
            if (this.getComponentCount() == 0) {
                return super.getPreferredSize();
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            return new Dimension(dimension.width + JCTreeTable.this.support.getRendererIndent(this.path, this.value, this.value_class), dimension.height);
        }
    }

    protected class TreeRendererEditor
    extends JPanel {
        protected Insets insets = new Insets(0, 0, 0, 0);
        protected TreePath path = null;
        protected Object value;
        protected Class<?> value_class;

        protected TreeRendererEditor() {
        }

        public Insets getInsets() {
            return this.insets;
        }

        public void doLayout() {
            if (this.getComponentCount() == 0 || this.path == null) {
                return;
            }
            Component component = this.getComponent(0);
            Dimension dimension = this.getSize();
            boolean bl = JCTreeTable.this.getComponentOrientation().isLeftToRight();
            int n2 = JCTreeTable.this.support.getRendererIndent(this.path, this.value, this.value_class);
            int n3 = bl ? n2 : 0;
            component.setBounds(n3, 0, dimension.width - n2, dimension.height);
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            JCTreeTable.this.support.prepareCellForRender(graphics, dimension.width, dimension.height);
            super.paint(graphics);
            JCTreeTable.this.support.renderHierarchy(graphics, new Rectangle(new Point(0, 0), dimension), this.path, this.value, this.value_class);
        }

        public boolean isOpaque() {
            return false;
        }
    }

    protected class TreeTableUI
    extends BasicTableUI {
        protected TreeTableUI() {
        }

        protected MouseInputListener createMouseInputListener() {
            return new TreeTableMouseInputHandler();
        }

        protected class TreeTableMouseInputHandler
        extends BasicTableUI.MouseInputHandler {
            protected boolean mousePressedInControlBox;

            protected TreeTableMouseInputHandler() {
                super(TreeTableUI.this);
                this.mousePressedInControlBox = false;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                Point point;
                int n2;
                Point point2 = mouseEvent.getPoint();
                int n3 = JCTreeTable.this.rowAtPoint(point2);
                if (!JCTreeTable.this.support.processClickInTreeColumn(mouseEvent, n3, n2 = JCTreeTable.this.columnAtPoint(point2), point = new Point(point2), JCTreeTable.this.getRowHeight())) {
                    this.mousePressedInControlBox = false;
                    super.mousePressed(mouseEvent);
                } else {
                    this.mousePressedInControlBox = true;
                    JCTreeTable.this.removeEditor();
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (!this.mousePressedInControlBox) {
                    super.mouseDragged(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (JCEnvironment.getJavaVersion() < 140 || !this.mousePressedInControlBox) {
                    super.mouseReleased(mouseEvent);
                }
            }
        }
    }

    protected class TableHeaderMouseAdapter
    extends JCSortableTable.TableHeaderMouseListener {
        protected TableHeaderMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (!this.isPopupTrigger) {
                int n2 = JCTreeTable.this.columnAtPoint(point);
                boolean bl = false;
                if (JCTreeTable.this.switchPolicy == 3 || JCTreeTable.this.switchPolicy == 2) {
                    bl = JCTreeTable.this.isPointOverSwitch(point);
                }
                if (bl) {
                    JCTreeTable.this.toggleView();
                } else if (JCTreeTable.this.isSortable() && JCTreeTable.this.switchPolicy == 2 && JCTreeTable.this.getView() == 1) {
                    JCTreeTable.this.setView(2);
                    JCTreeTable.this.sort(n2);
                } else if (JCTreeTable.this.isSortable()) {
                    JCTreeTable.this.sort(n2);
                }
            }
        }
    }
}

