/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.render;

import com.klg.jclass.cell.EditorRendererRegistry;
import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.JCComponentCellRenderer;
import com.klg.jclass.cell.JCLightCellRenderer;
import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.Markup;
import com.klg.jclass.page.PageTableCellInfo;
import com.klg.jclass.page.render.Render;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.util.formulae.ExpressionVariable;
import com.klg.jclass.util.formulae.MathScalar;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;

public class TableCellRender
extends Render
implements Cloneable {
    protected TableDataModel tableData;
    protected int row;
    protected int column;
    protected JCPageTable table;
    protected static CellRendererPane cellRendererPane = new CellRendererPane();
    protected int horizontalAlignment;
    protected int verticalAlignment;
    protected boolean fillBackground;

    public TableCellRender() {
    }

    public TableCellRender(JCPageTable jCPageTable, int n2, int n3) {
        this(jCPageTable, n2, n3, null);
    }

    public TableCellRender(JCPageTable jCPageTable, int n2, int n3, JCUnit.Dimension dimension) {
        this.tableData = jCPageTable.getTableData();
        if (n2 < 0 || n2 > this.tableData.getNumRows() || n3 < 0 || n3 > this.tableData.getNumColumns()) {
            throw new ArrayIndexOutOfBoundsException("Cell (" + n2 + ", " + n3 + ") is out of bounds");
        }
        this.row = n2;
        this.column = n3;
        this.table = jCPageTable;
        if (dimension != null) {
            this.bounds.assign(dimension);
        }
    }

    public TableDataModel getTableData() {
        return this.tableData;
    }

    public void setTableData(TableDataModel tableDataModel) {
        if (this.row < 0 || this.row > this.tableData.getNumRows() || this.column < 0 || this.column > this.tableData.getNumColumns()) {
            throw new ArrayIndexOutOfBoundsException("Cell (" + this.row + ", " + this.column + ") is out of bounds");
        }
        this.tableData = tableDataModel;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public void setCellPosition(int n2, int n3) {
        if (n2 < 0 || n2 > this.tableData.getNumRows() || n3 < 0 || n3 > this.tableData.getNumColumns()) {
            throw new ArrayIndexOutOfBoundsException("Cell (" + n2 + ", " + n3 + ") is out of bounds");
        }
        this.row = n2;
        this.column = n3;
    }

    public boolean isAtomic() {
        return true;
    }

    public void draw(Graphics2D graphics2D) {
        Object object = this.tableData.getTableDataItem(this.row, this.column);
        if (object == null || graphics2D instanceof Markup) {
            return;
        }
        ExpressionVariable.setVariable(this.table, "currentRow", new MathScalar(this.row));
        ExpressionVariable.setVariable(this.table, "currentColumn", new MathScalar(this.column));
        Class<?> clazz = object.getClass();
        EditorRendererRegistry editorRendererRegistry = EditorRendererRegistry.getCentralRegistry();
        JCCellRenderer jCCellRenderer = editorRendererRegistry.getCellRendererInstance(clazz, null);
        PageTableCellInfo pageTableCellInfo = new PageTableCellInfo(this.table, this.row, this.column);
        int n2 = (int)JCUnit.getAsPoints(this.origin.units, this.origin.x);
        int n3 = (int)JCUnit.getAsPoints(this.origin.units, this.origin.y);
        int n4 = (int)JCUnit.getAsPoints(this.bounds.units, this.bounds.width);
        int n5 = (int)JCUnit.getAsPoints(this.bounds.units, this.bounds.height);
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.clipRect(n2, n3, n4, n5);
        if (jCCellRenderer instanceof JCLightCellRenderer) {
            graphics2D.setFont(pageTableCellInfo.getFont());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n6 = fontMetrics.getAscent() - (fontMetrics.getHeight() - 4);
            n3 += n6;
            graphics2D.translate(++n2, ++n3);
            pageTableCellInfo.setDrawingArea(new Rectangle(0, 0, --n4, --n5));
            ((JCLightCellRenderer)jCCellRenderer).draw(graphics2D, pageTableCellInfo, object, false);
            graphics2D.translate(-n2, -n3);
        } else if (jCCellRenderer instanceof JCComponentCellRenderer) {
            JCComponentCellRenderer jCComponentCellRenderer = (JCComponentCellRenderer)jCCellRenderer;
            Component component = jCComponentCellRenderer.getRendererComponent(pageTableCellInfo, object, false);
            cellRendererPane.paintComponent(graphics2D, component, new Frame(), n2, n3, n4, n5, true);
        }
        graphics2D.setClip(rectangle);
    }

    public Object clone() {
        TableCellRender tableCellRender = (TableCellRender)super.clone();
        return tableCellRender;
    }
}

