/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.render;

import com.klg.jclass.page.FontBase;
import com.klg.jclass.page.FontMetricsBase;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.render.Render;
import com.klg.jclass.page.render.Splitable;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.List;
import java.util.Vector;

public class StringRender
extends Render
implements Splitable,
Cloneable {
    protected String text;
    protected String fullText;
    protected int textStart;
    protected int textEnd;
    protected JCTextStyle style;
    protected Graphics2D saved_gc;
    protected int macroFlags;
    protected JCUnit.Measure leadingSpace;
    protected JCUnit.Measure trailingSpace;
    protected int splitIndex;
    protected JCUnit.Measure splitDistance;

    public StringRender() {
        this.style = null;
        this.text = null;
        this.fullText = null;
        this.textStart = -1;
        this.textEnd = -1;
        this.origin = new JCUnit.Point(JCUnit.POINTS);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS);
    }

    public StringRender(Graphics2D graphics2D, String string, JCTextStyle jCTextStyle) {
        this.style = jCTextStyle;
        this.text = string;
        this.fullText = string;
        this.textStart = 0;
        this.textEnd = string.length();
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, jCTextStyle);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, string, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.origin = new JCUnit.Point(JCUnit.POINTS);
    }

    public StringRender(Graphics2D graphics2D, String string, int n2, int n3, JCTextStyle jCTextStyle) {
        this.style = jCTextStyle;
        this.text = StringRender.substring(string, n2, n3);
        this.fullText = string;
        this.textStart = n2;
        this.textEnd = n3;
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, jCTextStyle);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.origin = new JCUnit.Point(JCUnit.POINTS);
    }

    public String getText() {
        return this.text;
    }

    public void setText(Graphics2D graphics2D, String string) {
        this.text = string;
        this.fullText = string;
        this.textStart = 0;
        this.textEnd = string.length();
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, this.style);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, string, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void setText(Graphics2D graphics2D, String string, int n2, int n3) {
        this.fullText = string;
        this.text = StringRender.substring(string, n2, n3);
        this.textStart = n2;
        this.textEnd = n3;
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, this.style);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, string, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public String getFullText() {
        return this.fullText;
    }

    public void setFullText(String string) {
        this.fullText = string;
        int n2 = this.fullText.indexOf(this.text);
        if (n2 != -1) {
            this.textStart = n2;
            this.textEnd = n2 + this.text.length();
        }
    }

    public int getStartIndex() {
        return this.textStart;
    }

    public int getEndIndex() {
        return this.textEnd;
    }

    public JCTextStyle getStyle() {
        return this.style;
    }

    public void setStyle(Graphics2D graphics2D, JCTextStyle jCTextStyle) {
        this.style = jCTextStyle;
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, jCTextStyle);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public int getMacroFlags() {
        return this.macroFlags;
    }

    protected JCUnit.Measure getLeadingSpace() {
        return this.leadingSpace;
    }

    protected JCUnit.Measure getTrailingSpace() {
        return this.trailingSpace;
    }

    public boolean isAtomic() {
        return false;
    }

    public JCUnit.Measure getTrimWidth(Graphics2D graphics2D) {
        int n2;
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, this.style);
        for (n2 = this.text.length(); n2 > 0 && n2 <= this.text.length() && Character.isWhitespace(this.text.charAt(n2 - 1)); --n2) {
        }
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, StringRender.substring(this.text, 0, n2), graphics2D);
        return new JCUnit.Measure(JCUnit.POINTS, rectangle2D.getWidth());
    }

    public Render splitBefore(Graphics2D graphics2D, JCUnit.Measure measure) {
        int n2;
        int n3;
        double d2 = measure.getAs(JCUnit.POINTS);
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(this.text);
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, this.style);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, StringRender.substring(this.text, 0, n3), graphics2D);
        if (rectangle2D.getWidth() <= d2) {
            for (n3 = (int)(d2 / this.bounds.getWidth().getAs(JCUnit.POINTS) * (double)this.text.length()); n3 > 0 && n3 <= this.text.length() && !Character.isWhitespace(this.text.charAt(n3 - 1)); --n3) {
            }
            int n4 = n3;
            while (rectangle2D.getWidth() < d2) {
                n4 = n3;
                try {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    n2 = n3 = n4;
                    break;
                }
                for (n2 = n3 = breakIterator.following(n4); n2 > 0 && n2 <= this.text.length() && Character.isWhitespace(this.text.charAt(n2 - 1)); --n2) {
                }
                rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, StringRender.substring(this.text, 0, n2), graphics2D);
            }
            n3 = n4;
        } else {
            while (rectangle2D.getWidth() > d2) {
                for (n3 = breakIterator.preceding(n3); n3 > 0 && n3 <= this.text.length() && Character.isWhitespace(this.text.charAt(n3 - 1)); --n3) {
                }
                rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, StringRender.substring(this.text, 0, n3), graphics2D);
            }
        }
        this.splitIndex = n3;
        this.splitDistance = measure;
        for (n2 = n3; n2 > 0 && n2 <= this.text.length() && Character.isWhitespace(this.text.charAt(n2 - 1)); --n2) {
        }
        StringRender stringRender = new StringRender(graphics2D, this.text, 0, n2, this.style);
        if (n2 == 0 && n3 != 0) {
            JCUnit.Dimension dimension = stringRender.getSize();
            dimension.setWidth(new JCUnit.Measure(JCUnit.POINTS, 0.01));
            stringRender.setSize(dimension);
        }
        return stringRender;
    }

    public Render splitAfter(Graphics2D graphics2D, JCUnit.Measure measure) {
        if (!measure.equals(this.splitDistance)) {
            this.splitBefore(graphics2D, measure);
        }
        this.fullText = this.text;
        this.textStart = this.splitIndex;
        this.textEnd = this.text.length();
        while (this.splitIndex < this.textEnd && this.splitIndex >= 0 && Character.isWhitespace(this.text.charAt(this.splitIndex))) {
            ++this.splitIndex;
        }
        this.text = this.text.substring(this.splitIndex);
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, this.style);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
        return this;
    }

    public Render forceSplit(Graphics2D graphics2D, JCUnit.Measure measure) {
        double d2 = measure.getAs(JCUnit.POINTS);
        int n2 = (int)(d2 / this.bounds.getWidth().getAs(JCUnit.POINTS) * (double)this.text.length());
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, this.style);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, StringRender.substring(this.text, 0, n2), graphics2D);
        if (rectangle2D.getWidth() <= d2) {
            while (n2 < this.text.length() && rectangle2D.getWidth() <= d2) {
                rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, StringRender.substring(this.text, 0, ++n2), graphics2D);
            }
            --n2;
        } else {
            while (n2 > 0 && rectangle2D.getWidth() > d2) {
                rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, StringRender.substring(this.text, 0, --n2), graphics2D);
            }
        }
        if (n2 == 0) {
            ++n2;
        }
        this.splitIndex = n2;
        this.splitDistance = measure;
        StringRender stringRender = new StringRender(graphics2D, this.text, 0, n2, this.style);
        return stringRender;
    }

    public void unsplit(Graphics2D graphics2D, Render render) {
        StringRender stringRender = (StringRender)render;
        int n2 = stringRender.getStartIndex();
        if (n2 < this.textEnd) {
            throw new IllegalArgumentException("Strings do not adjoin");
        }
        for (int i2 = this.textEnd; i2 < n2; ++i2) {
            if (Character.isWhitespace(this.fullText.charAt(i2))) continue;
            throw new IllegalArgumentException("Strings do not adjoin");
        }
        this.text = StringRender.substring(this.fullText, this.textStart, stringRender.getEndIndex());
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D, this.style);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void trimTrailingWhitespace() {
        int n2;
        for (n2 = this.text.length() - 1; n2 >= 0 && n2 < this.text.length() && Character.isWhitespace(this.text.charAt(n2)); --n2) {
            --this.textEnd;
        }
        if (n2 < 0) {
            this.textEnd = 0;
            this.text = StringRender.substring(this.fullText, this.textStart, this.textEnd);
            this.bounds.setWidth(new JCUnit.Measure(JCUnit.POINTS, 0.05));
            return;
        }
        if (n2 < this.text.length() - 1) {
            this.text = StringRender.substring(this.fullText, this.textStart, this.textEnd);
            FontMetrics fontMetrics = this.getFontMetrics(this.saved_gc, this.style);
            Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text, this.saved_gc);
            this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
    }

    public List splitIntoWords() {
        StringRender stringRender;
        JCUnit.Point point;
        int n2;
        boolean bl = false;
        Vector<StringRender> vector = new Vector<StringRender>();
        FontMetrics fontMetrics = this.getFontMetrics(this.saved_gc, this.style);
        int n3 = n2 = this.text.length();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (Character.isWhitespace(this.text.charAt(i2))) {
                if (!bl) continue;
                Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, StringRender.substring(this.text, 0, i2 + 1), this.saved_gc);
                JCUnit.Measure measure = this.origin.getX();
                measure.add(new JCUnit.Measure(JCUnit.POINTS, rectangle2D.getWidth()));
                point = (JCUnit.Point)this.origin.clone();
                point.setX(measure);
                stringRender = new StringRender(this.saved_gc, this.text, i2 + 1, n3, this.style);
                stringRender.setLocation(point);
                vector.add(stringRender);
                bl = false;
                continue;
            }
            if (bl) continue;
            bl = true;
            n3 = i2 + 1;
        }
        if (bl) {
            point = (JCUnit.Point)this.origin.clone();
            stringRender = new StringRender(this.saved_gc, this.text, 0, n3, this.style);
            stringRender.setLocation(point);
            vector.add(stringRender);
        }
        return vector;
    }

    public boolean hasDecimal() {
        return this.text.indexOf(".") != -1;
    }

    public JCUnit.Measure getDecimalPosition() {
        int n2 = this.text.indexOf(".");
        if (n2 == -1) {
            return new JCUnit.Measure(JCUnit.POINTS, -1.0);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.saved_gc, this.style);
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, StringRender.substring(this.text, 0, n2), this.saved_gc);
        JCUnit.Measure measure = new JCUnit.Measure(JCUnit.POINTS, rectangle2D.getWidth());
        rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, StringRender.substring(this.text, 0, n2 + 1), this.saved_gc);
        measure.add(new JCUnit.Measure(JCUnit.POINTS, rectangle2D.getWidth()));
        measure.divide(2.0);
        return measure;
    }

    public void draw(Graphics2D graphics2D) {
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        float f2 = (float)JCUnit.getAsPoints(this.origin.units, this.origin.x);
        float f3 = (float)JCUnit.getAsPoints(this.origin.units, this.origin.y);
        AttributedString attributedString = new AttributedString(this.text);
        int n2 = this.text.length();
        Font font = this.style.getFont();
        int n3 = this.style.getBaselineOffset();
        float f4 = (float)this.style.getPointSize();
        if (n3 == 2 || n3 == 3) {
            f4 *= (float)this.style.getSubscriptRatio();
        }
        font = FontBase.deriveFont(font, f4);
        attributedString.addAttribute(TextAttribute.FONT, font, 0, n2);
        if (this.style.getUnderlining() == 2) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, 0, n2);
        }
        graphics2D.setColor(this.style.getColor());
        graphics2D.drawString(attributedString.getIterator(), f2, f3);
    }

    public Object clone() {
        StringRender stringRender = (StringRender)super.clone();
        stringRender.text = this.text;
        stringRender.fullText = this.fullText;
        return stringRender;
    }

    private FontMetrics getFontMetrics(Graphics2D graphics2D, JCTextStyle jCTextStyle) {
        FontMetrics fontMetrics;
        Font font = jCTextStyle.getFont();
        if (jCTextStyle.getBaselineOffset() == 2 || jCTextStyle.getBaselineOffset() == 3) {
            double d2 = (double)FontBase.getSize2D(font) * jCTextStyle.getSubscriptRatio();
            Font font2 = FontBase.deriveFont(font, (float)d2);
            fontMetrics = graphics2D.getFontMetrics(font2);
        } else {
            fontMetrics = graphics2D.getFontMetrics(font);
        }
        return fontMetrics;
    }

    public String toString() {
        return "StringRender: " + this.text;
    }

    private static String substring(String string, int n2, int n3) {
        if (string == null || string.trim().equals("") || n2 > string.length() || n3 < 0 || n2 > n3) {
            return "";
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > string.length()) {
            n3 = string.length();
        }
        return string.substring(n2, n3);
    }
}

