/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.render;

import com.klg.jclass.page.JCDrawStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.render.Render;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;

public class RoundRectRender
extends Render
implements Cloneable {
    protected JCUnit.Measure radius;
    protected JCUnit.Point lowerLeft;
    protected JCUnit.Point upperRight;
    protected JCDrawStyle style;
    protected boolean fill;

    public RoundRectRender() {
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS);
        this.origin = new JCUnit.Point(JCUnit.POINTS);
        this.radius = new JCUnit.Measure(JCUnit.POINTS);
        this.style = null;
    }

    public RoundRectRender(JCUnit.Point point, JCUnit.Point point2, JCDrawStyle jCDrawStyle) {
        double d2;
        double d3;
        double d4;
        double d5;
        this.style = jCDrawStyle;
        if (point.units != point2.units) {
            point2.x = JCUnit.getAs(point.units, point2.units, point2.x);
            point2.y = JCUnit.getAs(point.units, point2.units, point2.y);
            point2.units = point.units;
        }
        if (point.x > point2.x) {
            d5 = point2.x;
            d4 = point.x;
        } else {
            d5 = point.x;
            d4 = point2.x;
        }
        if (point.y > point2.y) {
            d3 = point2.y;
            d2 = point.y;
        } else {
            d3 = point.y;
            d2 = point2.y;
        }
        this.lowerLeft = new JCUnit.Point(point.units, d5, d3);
        this.upperRight = new JCUnit.Point(point.units, d4, d2);
        this.origin = new JCUnit.Point(point.units, d5, d3);
        this.bounds = new JCUnit.Dimension(point.units, d4 - d5, d2 - d3);
        this.radius = new JCUnit.Measure();
    }

    public RoundRectRender(JCUnit.Point point, JCUnit.Point point2, JCUnit.Measure measure, JCDrawStyle jCDrawStyle) {
        double d2;
        double d3;
        double d4;
        double d5;
        this.style = jCDrawStyle;
        if (point.units != point2.units) {
            point2.x = JCUnit.getAs(point.units, point2.units, point2.x);
            point2.y = JCUnit.getAs(point.units, point2.units, point2.y);
            point2.units = point.units;
        }
        if (point.x > point2.x) {
            d5 = point2.x;
            d4 = point.x;
        } else {
            d5 = point.x;
            d4 = point2.x;
        }
        if (point.y > point2.y) {
            d3 = point2.y;
            d2 = point.y;
        } else {
            d3 = point.y;
            d2 = point2.y;
        }
        this.lowerLeft = new JCUnit.Point(point.units, d5, d3);
        this.upperRight = new JCUnit.Point(point.units, d4, d2);
        this.origin = new JCUnit.Point(point.units, d5, d3);
        this.bounds = new JCUnit.Dimension(point.units, d4 - d5, d2 - d3);
        this.radius = (JCUnit.Measure)measure.clone();
    }

    public RoundRectRender(JCUnit.Point point, JCUnit.Dimension dimension, JCDrawStyle jCDrawStyle) {
        this.style = jCDrawStyle;
        this.origin = (JCUnit.Point)point.clone();
        this.bounds = (JCUnit.Dimension)dimension.clone();
        this.radius = new JCUnit.Measure();
        this.lowerLeft = (JCUnit.Point)point.clone();
        JCUnit.Measure measure = this.origin.getX();
        measure.add(this.bounds.getWidth());
        JCUnit.Measure measure2 = this.origin.getY();
        measure2.add(this.bounds.getHeight());
        this.upperRight = new JCUnit.Point(this.origin.units, measure.distance, measure2.distance);
    }

    public RoundRectRender(JCUnit.Point point, JCUnit.Dimension dimension, JCUnit.Measure measure, JCDrawStyle jCDrawStyle) {
        this.style = jCDrawStyle;
        this.origin = (JCUnit.Point)point.clone();
        this.bounds = (JCUnit.Dimension)dimension.clone();
        this.radius = (JCUnit.Measure)measure.clone();
        this.lowerLeft = (JCUnit.Point)point.clone();
        JCUnit.Measure measure2 = this.origin.getX();
        measure2.add(this.bounds.getWidth());
        JCUnit.Measure measure3 = this.origin.getY();
        measure3.add(this.bounds.getHeight());
        this.upperRight = new JCUnit.Point(this.origin.units, measure2.distance, measure3.distance);
    }

    public JCUnit.Point[] getPoints() {
        JCUnit.Point[] pointArray = new JCUnit.Point[4];
        pointArray[0] = (JCUnit.Point)this.lowerLeft.clone();
        pointArray[1] = (JCUnit.Point)this.lowerLeft.clone();
        pointArray[1].setX(this.upperRight.getX());
        pointArray[2] = (JCUnit.Point)this.upperRight.clone();
        pointArray[3] = (JCUnit.Point)this.upperRight.clone();
        pointArray[3].setX(this.lowerLeft.getX());
        return pointArray;
    }

    public JCUnit.Point getLowerLeft() {
        return this.lowerLeft;
    }

    public JCUnit.Point getUpperRight() {
        return this.upperRight;
    }

    public void setLocation(JCUnit.Point point) {
        this.origin = point;
        this.lowerLeft = (JCUnit.Point)this.origin.clone();
        JCUnit.Measure measure = this.origin.getX();
        measure.add(this.bounds.getWidth());
        JCUnit.Measure measure2 = this.origin.getY();
        measure2.add(this.bounds.getHeight());
        this.upperRight = new JCUnit.Point(this.origin.units, measure.distance, measure2.distance);
    }

    public void setSize(JCUnit.Dimension dimension) {
        this.bounds = dimension;
        JCUnit.Measure measure = this.origin.getX();
        measure.add(this.bounds.getWidth());
        JCUnit.Measure measure2 = this.origin.getY();
        measure2.add(this.bounds.getHeight());
        this.upperRight = new JCUnit.Point(this.origin.units, measure.distance, measure2.distance);
    }

    public JCUnit.Measure getCornerRadius() {
        return this.radius;
    }

    public void setCornerRadius(JCUnit.Measure measure) {
        if (measure.distance < 0.0) {
            throw new IllegalArgumentException("Corner radius must be non-negative");
        }
        this.radius = measure;
    }

    public JCDrawStyle getStyle() {
        return this.style;
    }

    public void setStyle(JCDrawStyle jCDrawStyle) {
        this.style = jCDrawStyle;
    }

    public boolean isFilled() {
        return this.fill;
    }

    public void setFilled(boolean bl) {
        this.fill = bl;
    }

    public boolean isAtomic() {
        return true;
    }

    public void draw(Graphics2D graphics2D) {
        BasicStroke basicStroke;
        Color color;
        if (this.fill) {
            color = this.style.getFillForegroundColor();
            if (color == null) {
                color = this.style.getForegroundColor();
            }
        } else {
            color = this.style.getForegroundColor();
        }
        if (color == null) {
            return;
        }
        graphics2D.setColor(color);
        double d2 = this.style.getLineWidth().getAs(JCUnit.POINTS);
        int n2 = this.style.getLineType();
        if (n2 == 3) {
            float[] fArray = new float[2];
            double d3 = this.style.getDashLength().getAs(JCUnit.POINTS);
            fArray[0] = (float)d3;
            fArray[1] = (float)d3;
            basicStroke = new BasicStroke((float)d2, 2, 0, 10.0f, fArray, 0.0f);
        } else if (n2 == 4) {
            double d4 = this.style.getLineSpacing().getAs(JCUnit.POINTS);
            d2 = d2 * 2.0 + d4;
            basicStroke = new BasicStroke((float)d2, 2, 0);
        } else if (n2 == 2 || n2 == 2) {
            basicStroke = new BasicStroke((float)d2, 2, 0);
        } else {
            return;
        }
        graphics2D.setStroke(basicStroke);
        double d5 = this.radius.getAs(JCUnit.POINTS);
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(JCUnit.getAsPoints(this.origin.units, this.origin.x), JCUnit.getAsPoints(this.origin.units, this.origin.y), JCUnit.getAsPoints(this.bounds.units, this.bounds.width), JCUnit.getAsPoints(this.bounds.units, this.bounds.height), d5, d5);
        if (this.fill) {
            graphics2D.fill(double_);
        } else {
            graphics2D.draw(double_);
        }
    }

    public Object clone() {
        RoundRectRender roundRectRender = (RoundRectRender)super.clone();
        roundRectRender.radius = (JCUnit.Measure)this.radius.clone();
        roundRectRender.lowerLeft = (JCUnit.Point)this.lowerLeft.clone();
        roundRectRender.upperRight = (JCUnit.Point)this.upperRight.clone();
        return roundRectRender;
    }
}

