/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.render;

import com.klg.jclass.page.EPSImage;
import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.Markup;
import com.klg.jclass.page.render.Embedable;
import com.klg.jclass.page.render.Floatable;
import com.klg.jclass.page.render.Render;
import com.klg.jclass.util.ServerRenderable;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ImageRender
extends Render
implements Floatable,
Embedable,
ImageObserver,
Cloneable {
    protected Object image;
    protected int horizontalAlignment;
    protected int verticalAlignment;
    protected boolean fillBackground;
    protected boolean scaleImage;
    private int imageID;
    private static ImComponent imageComponent = new ImComponent();
    private static MediaTracker tracker = new MediaTracker(imageComponent);
    private static int nextImageID = 0;

    public ImageRender() {
        this(null, null, 4);
    }

    public ImageRender(Object object) {
        this(object, null, 4);
    }

    public ImageRender(Object object, JCUnit.Dimension dimension) {
        this(object, dimension, 4);
    }

    public ImageRender(Object object, int n2) {
        this(object, null, n2);
    }

    public ImageRender(Object object, JCUnit.Dimension dimension, int n2) {
        this.image = object;
        this.bounds.assign(dimension);
        this.horizontalAlignment = n2;
        this.verticalAlignment = 3;
        this.scaleImage = false;
        this.imageID = nextImageID++;
    }

    public Object getImage() {
        return this.image;
    }

    public void setImage(Object object) {
        this.image = object;
    }

    public int getAlignment() {
        return this.horizontalAlignment;
    }

    public void setAlignment(int n2) {
        if (n2 <= 0 || n2 > 5) {
            throw new IllegalArgumentException("Unrecognised horizontal alignment");
        }
        this.horizontalAlignment = n2;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n2) {
        if (n2 <= 0 || n2 > 7) {
            throw new IllegalArgumentException("Unrecognised vertical alignment");
        }
        this.verticalAlignment = n2;
    }

    public boolean isFilled() {
        return this.fillBackground;
    }

    public void setFilled(boolean bl) {
        this.fillBackground = bl;
    }

    public boolean isScaleImage() {
        return this.scaleImage;
    }

    public void setScaleImage(boolean bl) {
        this.scaleImage = bl;
    }

    public boolean isAtomic() {
        return true;
    }

    public void draw(Graphics2D graphics2D) {
        if (graphics2D instanceof Markup) {
            return;
        }
        double d2 = JCUnit.getAsPoints(this.origin.units, this.origin.x);
        double d3 = JCUnit.getAsPoints(this.origin.units, this.origin.y);
        double d4 = JCUnit.getAsPoints(this.bounds.units, this.bounds.width);
        double d5 = JCUnit.getAsPoints(this.bounds.units, this.bounds.height);
        if (this.image instanceof EPSImage) {
            graphics2D.drawImage((Image)this.image, (int)d2, (int)d3, (int)d4, (int)d5, this);
        } else if (this.image instanceof Image || this.image instanceof Icon) {
            Image image;
            if (this.image instanceof Image) {
                image = (Image)this.image;
            } else if (this.image instanceof ImageIcon) {
                image = ((ImageIcon)this.image).getImage();
            } else {
                throw new IllegalArgumentException("Unknown Icon type");
            }
            int n2 = image.getWidth(this);
            int n3 = image.getHeight(this);
            if (this.scaleImage && (n2 != (int)d4 || n3 != (int)d5)) {
                image = image.getScaledInstance((int)d4, (int)d5, 1);
            }
            tracker.addImage(image, this.imageID);
            try {
                tracker.waitForID(this.imageID);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            graphics2D.drawImage(image, (int)d2, (int)d3, (int)d4, (int)d5, this);
            tracker.removeImage(image);
        } else if (this.image instanceof Component) {
            Object object;
            Component component = (Component)this.image;
            int n4 = component.getWidth();
            int n5 = component.getHeight();
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            graphics2D2.translate(d2, d3);
            if (d4 > 0.0 && d5 > 0.0 && (n4 != (int)d4 || n5 != (int)d5)) {
                graphics2D2.scale(d4 / (double)n4, d5 / (double)n5);
                graphics2D2.setClip(new Rectangle2D.Double(0.0, 0.0, n4, n5));
            } else {
                object = graphics2D2.getClipBounds();
                graphics2D2.setClip(new Rectangle2D.Double(0.0, 0.0, Math.min(((Rectangle)object).width, n4), Math.min(((Rectangle)object).height, n5)));
            }
            graphics2D2.setStroke(new BasicStroke());
            if (this.image instanceof ServerRenderable) {
                object = (ServerRenderable)this.image;
                object.serverPaint(graphics2D2);
            } else if (graphics2D2 instanceof Graphics2DBase && component instanceof JComponent) {
                ((Graphics2DBase)graphics2D2).setComponent(component);
                component.paint(graphics2D2);
                ((Graphics2DBase)graphics2D2).setComponent(null);
            } else {
                component.paint(graphics2D2);
            }
            graphics2D2.dispose();
        } else {
            throw new IllegalArgumentException("Bad image type");
        }
    }

    public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
        if ((n2 & 1) == 0 || (n2 & 2) == 0) {
            return true;
        }
        if (this.bounds.getWidth().isZero()) {
            this.bounds.setWidth(new JCUnit.Measure(JCUnit.POINTS, n5));
        }
        if (this.bounds.getHeight().isZero()) {
            this.bounds.setHeight(new JCUnit.Measure(JCUnit.POINTS, n6));
        }
        return (n2 & 0x20) == 0;
    }

    public Object clone() {
        return super.clone();
    }

    protected static class ImComponent
    extends Component {
        protected ImComponent() {
        }
    }
}

