/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.pcl;

import com.klg.jclass.page.FontBase;
import com.klg.jclass.page.FontParser;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.pcl.CharSetEntryPCL;
import com.klg.jclass.page.pcl.FontMetricsPCL;
import com.klg.jclass.page.pcl.GlyphVectorPCL;
import com.klg.jclass.page.pcl.TFMParser;
import com.klg.jclass.page.pcl.TypeFacePCL;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class FontPCL
extends FontBase
implements Cloneable {
    protected TypeFacePCL typeface;
    protected static Hashtable fonts = new Hashtable();
    protected static String defaultFontMap = "com.klg.jclass.page.pcl.JCPCLFontMap";
    protected static String defaultJarLocation = "/com/klg/jclass/page/pcl/fonts.jar";
    protected static String defaultFileExtension = ".tfm";
    protected static boolean loaded = false;
    public String version;
    public char processor;
    protected static ResourceBundle userFontBundle;
    protected static ResourceBundle defaultFontBundle;
    protected int cpi = -1;

    public FontPCL(String string, int n2, int n3, TypeFacePCL typeFacePCL) {
        super(string, n2, n3);
        this.typeface = typeFacePCL;
    }

    protected Object clone() {
        try {
            return (FontPCL)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public static Font decode(String string) {
        Font font = Font.decode(string);
        String string2 = font.getName() + FontPCL.getStyleString(font.getStyle());
        string2 = string2.replace(' ', REPLACEMENT_CHARACTER);
        String string3 = null;
        try {
            if (userFontBundle == null) {
                throw new MissingResourceException("lets", "try", "default, then");
            }
            string3 = userFontBundle.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                string3 = defaultFontBundle.getString(string2);
            }
            catch (MissingResourceException missingResourceException2) {
                string3 = new String("M Times New");
            }
        }
        FontPCL fontPCL = (FontPCL)fonts.get(string3);
        return fontPCL.deriveFont(font.getStyle(), font.getSize());
    }

    public Font deriveFont(int n2, float f2) {
        FontPCL fontPCL = (FontPCL)this.clone();
        fontPCL.style = n2;
        fontPCL.size = (int)f2;
        return fontPCL;
    }

    public String getFamily() {
        return this.typeface.getFamily();
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        FontMetricsPCL fontMetricsPCL = new FontMetricsPCL(this);
        return new GlyphVectorPCL(fontMetricsPCL, fontRenderContext, string);
    }

    public Rectangle2D getStringBounds(String string, FontRenderContext fontRenderContext) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (string != null && string.length() > 0) {
            FontMetricsPCL fontMetricsPCL = new FontMetricsPCL(this);
            int n2 = fontMetricsPCL.getFont().getSize();
            double d2 = fontMetricsPCL.stringWidth(JCUnit.POINTS, n2, string);
            double d3 = fontMetricsPCL.getLeadingSpace(JCUnit.POINTS, n2, string) + fontMetricsPCL.getTrailingSpace(JCUnit.POINTS, n2, string);
            double d4 = -fontMetricsPCL.getAscender(JCUnit.POINTS, n2);
            double d5 = fontMetricsPCL.getHeight(JCUnit.POINTS, n2);
            rectangle.setRect(d3, d4, d2, d5);
        }
        return rectangle;
    }

    public TypeFacePCL getTypeface() {
        return this.typeface;
    }

    public CharSetEntryPCL getCharMetric(char c2) {
        return this.typeface.charMetrics.findEntryByCode((short)c2);
    }

    public int getXHeight() {
        return this.typeface.getTypefaceMetrics().getXHeight();
    }

    public int getCharsPerInch() {
        int n2 = -1;
        if ((this.typeface.getStyle() & 0x40) != 0) {
            n2 = (int)(72.0 * this.typeface.typefaceMetrics.designUnits / (double)(this.typeface.typefaceMetrics.spacing * this.getSize()) + 0.5);
        }
        return n2;
    }

    public static Font[] getAllFonts() {
        TFMParser tFMParser = new TFMParser();
        FontPCL.getFontBundles(defaultFontMap, defaultFontMap);
        Font[] fontArray = FontPCL.getFonts(tFMParser, defaultJarLocation, defaultFileExtension, fonts, loaded);
        loaded = true;
        return fontArray;
    }

    public static Font[] getAllFonts(FontParser fontParser, String string, String string2, String string3) {
        FontPCL.getFontBundles(defaultFontMap, string3);
        Font[] fontArray = FontPCL.getFonts(fontParser, string, string2, fonts, loaded);
        FontPCL.getFonts(fontParser, defaultJarLocation, defaultFileExtension, fonts, loaded);
        loaded = true;
        return fontArray;
    }

    public static Font getNativeFont(Font font) {
        String string = font.getName();
        int n2 = font.getStyle();
        int n3 = font.getSize();
        Font font2 = FontPCL.decode(FontPCL.getDecodeString(string, n2, n3));
        return font2;
    }

    protected static void getFontBundles(String string, String string2) {
        try {
            userFontBundle = ResourceBundle.getBundle(string2);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            defaultFontBundle = ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException.toString());
        }
    }
}

