/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.pcl;

import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.pcl.CharSetEntryPCL;
import com.klg.jclass.page.pcl.CharacterPCL;
import com.klg.jclass.page.pcl.FontPCL;
import com.klg.jclass.page.pcl.KernPairPCL;
import com.klg.jclass.page.pcl.LineMetricsPCL;
import com.klg.jclass.page.pcl.MetricsPCL;
import com.klg.jclass.page.pcl.TypeFacePCL;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.LineMetrics;
import java.text.CharacterIterator;

public class FontMetricsPCL
extends FontMetrics {
    public FontMetricsPCL(FontPCL fontPCL) {
        super(fontPCL);
        if (!(fontPCL instanceof FontPCL)) {
            throw new IllegalArgumentException("font must be instance of FontPCL");
        }
    }

    public int getAscent() {
        return (int)this.getAscender(JCUnit.POINTS, this.font.getSize());
    }

    public int getDescent() {
        return (int)(-this.getDescender(JCUnit.POINTS, this.font.getSize()));
    }

    public int getMaxAscent() {
        return (int)this.getAscender(JCUnit.POINTS, this.font.getSize());
    }

    public int getMaxDescent() {
        return (int)this.getDescender(JCUnit.POINTS, this.font.getSize());
    }

    public int charWidth(char c2) {
        return (int)(this.preciseCharWidth(c2) + 0.5);
    }

    protected double preciseCharWidth(char c2) {
        CharSetEntryPCL charSetEntryPCL = ((FontPCL)this.font).getCharMetric(c2);
        short s = charSetEntryPCL.metrics.getHorizontalEscapement();
        double d2 = this.convertToDecipoints(s, this.font.getSize());
        return this.convertFromDeciPoints(JCUnit.POINTS, d2);
    }

    public int charsWidth(char[] cArray, int n2, int n3) {
        double d2 = 0.0;
        for (int i2 = n2; i2 < n3; ++i2) {
            d2 += this.preciseCharWidth(cArray[i2]);
        }
        return (int)(d2 + 0.5);
    }

    public LineMetrics getLineMetrics(String string, Graphics graphics) {
        return new LineMetricsPCL(this, string);
    }

    public LineMetrics getLineMetrics(String string, int n2, int n3, Graphics graphics) {
        String string2 = string.toString().substring(n2, n3);
        return new LineMetricsPCL(this, string2);
    }

    public LineMetrics getLineMetrics(char[] cArray, int n2, int n3, Graphics graphics) {
        return new LineMetricsPCL(this, new String(cArray, n2, n3));
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n2, int n3, Graphics graphics) {
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = characterIterator.first();
        while (c2 != '\uffff') {
            stringBuffer.append(c2);
            c2 = characterIterator.next();
        }
        String string = stringBuffer.toString().substring(n2, n3);
        return new LineMetricsPCL(this, string);
    }

    protected double getHeight(JCUnit jCUnit, int n2) {
        return this.getAscent() - this.getDescent();
    }

    protected double getXHeight(JCUnit jCUnit, int n2) {
        double d2 = this.convertToDecipoints(((FontPCL)this.font).getXHeight(), n2);
        return this.convertFromDeciPoints(jCUnit, d2);
    }

    protected double getAscender(JCUnit jCUnit, int n2) {
        TypeFacePCL typeFacePCL = ((FontPCL)this.font).getTypeface();
        short s = typeFacePCL.typefaceMetrics.getLowercaseAscent();
        double d2 = this.convertToDecipoints(s, n2);
        return this.convertFromDeciPoints(jCUnit, d2);
    }

    protected double getDescender(JCUnit jCUnit, int n2) {
        TypeFacePCL typeFacePCL = ((FontPCL)this.font).getTypeface();
        short s = typeFacePCL.typefaceMetrics.getLowercaseDescent();
        double d2 = this.convertToDecipoints(s, n2);
        return this.convertFromDeciPoints(jCUnit, d2);
    }

    protected double convertFromDeciPoints(JCUnit jCUnit, double d2) {
        double d3 = 0.0;
        d2 = this.convertWorldToPoints(d2);
        if (jCUnit == JCUnit.POINTS) {
            d3 = d2;
        } else if (jCUnit == JCUnit.INCHES) {
            d3 = JCUnit.getAsInches(JCUnit.POINTS, d2);
        } else if (jCUnit == JCUnit.CM) {
            d3 = JCUnit.getAsCentimeters(JCUnit.POINTS, d2);
        } else {
            throw new IllegalArgumentException("Unknown units " + jCUnit);
        }
        return d3;
    }

    protected double charWidth(JCUnit jCUnit, int n2, char c2) {
        int n3 = this.charWidth(c2);
        double d2 = this.convertToDecipoints(n3, n2);
        return this.convertFromDeciPoints(jCUnit, d2);
    }

    protected double stringWidth(JCUnit jCUnit, int n2, String string) {
        double d2 = 0.0;
        CharSetEntryPCL charSetEntryPCL = null;
        TypeFacePCL typeFacePCL = ((FontPCL)this.font).getTypeface();
        int n3 = ((FontPCL)this.font).getCharsPerInch();
        if (n3 < 0) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                Integer n4;
                KernPairPCL kernPairPCL;
                CharSetEntryPCL charSetEntryPCL2 = ((FontPCL)this.font).getCharMetric(string.charAt(i2));
                d2 += (double)charSetEntryPCL2.getMetrics().getHorizontalEscapement();
                if (charSetEntryPCL != null && charSetEntryPCL.getKerns().size() > 0 && (kernPairPCL = charSetEntryPCL.getKernPair(n4 = new Integer(charSetEntryPCL2.getIndex()))) != null) {
                    d2 += (double)kernPairPCL.kernValue;
                }
                charSetEntryPCL = charSetEntryPCL2;
            }
            double d3 = this.convertToDecipoints(d2, n2);
            return this.convertFromDeciPoints(jCUnit, d3);
        }
        double d4 = 720.0 * (double)string.length() / (double)n3;
        return this.convertFromDeciPoints(jCUnit, d4);
    }

    protected double getLeadingSpace(JCUnit jCUnit, int n2, String string) {
        CharacterPCL characterPCL = ((FontPCL)this.font).getCharMetric(string.charAt(0)).getMetrics();
        double d2 = 0.0;
        if (characterPCL != null && characterPCL.getLeftExtent() < 0) {
            d2 = -characterPCL.getLeftExtent();
            d2 = this.convertToDecipoints(d2, n2);
        }
        return this.convertFromDeciPoints(jCUnit, d2);
    }

    protected double getTrailingSpace(JCUnit jCUnit, int n2, String string) {
        int n3 = string.length() - 1;
        CharacterPCL characterPCL = ((FontPCL)this.font).getCharMetric(string.charAt(n3)).getMetrics();
        double d2 = 0.0;
        if (characterPCL != null && characterPCL.getHorizontalEscapement() < characterPCL.getLeftExtent() + characterPCL.getRightExtent()) {
            d2 = -characterPCL.getLeftExtent() + characterPCL.getRightExtent() - characterPCL.getHorizontalEscapement();
            d2 = this.convertToDecipoints(d2, n2);
        }
        return this.convertFromDeciPoints(jCUnit, d2);
    }

    double convertToDecipoints(double d2, int n2) {
        TypeFacePCL typeFacePCL = ((FontPCL)this.font).getTypeface();
        MetricsPCL metricsPCL = typeFacePCL.getTypefaceMetrics();
        return d2 * (double)n2 * 10.0 / metricsPCL.getDesignUnits();
    }

    double convertWorldToPoints(double d2) {
        return d2 / 10.0;
    }
}

