/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.adobe.postscript;

import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.adobe.postscript.CharMetricPS;
import com.klg.jclass.page.adobe.postscript.EncoderFontMetrics;
import com.klg.jclass.page.adobe.postscript.FontPS;
import com.klg.jclass.page.adobe.postscript.LineMetricsPS;
import com.klg.jclass.page.adobe.postscript.PairKern;
import com.klg.jclass.util.graphics.JCFontMetrics;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.LineMetrics;
import java.text.CharacterIterator;

public class FontMetricsPS
extends FontMetrics
implements JCFontMetrics {
    public static int AFM_DIVISOR = 1000;

    public FontMetricsPS(FontPS fontPS) {
        super(fontPS);
        if (fontPS == null) {
            throw new IllegalArgumentException("font must not be null");
        }
    }

    public int getAscent() {
        return (int)this.getAscender(JCUnit.POINTS, this.font.getSize());
    }

    public int getDescent() {
        return (int)(-this.getDescender(JCUnit.POINTS, this.font.getSize()));
    }

    public int getMaxAscent() {
        return this.getAscent();
    }

    public int getMaxDescent() {
        return this.getDescent();
    }

    public int charWidth(char c2) {
        return (int)(this.preciseCharWidth(c2) + 0.5);
    }

    public double charWidthDouble(char c2) {
        return this.preciseCharWidth(c2);
    }

    protected double preciseCharWidth(char c2) {
        CharMetricPS charMetricPS = ((FontPS)this.font).getCharMetric(c2);
        int n2 = charMetricPS == null ? 0 : charMetricPS.getWx();
        return FontMetricsPS.asPoints(n2, this.font.getSize());
    }

    public int charsWidth(char[] cArray, int n2, int n3) {
        double d2 = 0.0;
        for (int i2 = n2; i2 < n3; ++i2) {
            d2 += this.preciseCharWidth(cArray[i2]);
        }
        return (int)(d2 + 0.5);
    }

    public double stringWidthDouble(String string, boolean bl) {
        double d2 = 0.0;
        if (string != null) {
            int n2 = string.length();
            char[] cArray = new char[n2];
            string.getChars(0, n2, cArray, 0);
            for (int i2 = 0; i2 < n2; ++i2) {
                d2 += this.preciseCharWidth(cArray[i2]);
            }
        }
        return d2;
    }

    public LineMetrics getLineMetrics(String string, Graphics graphics) {
        return new LineMetricsPS(this, string);
    }

    public LineMetrics getLineMetrics(String string, int n2, int n3, Graphics graphics) {
        return new LineMetricsPS(this, string.substring(n2, n3));
    }

    public LineMetrics getLineMetrics(char[] cArray, int n2, int n3, Graphics graphics) {
        return new LineMetricsPS(this, new String(cArray, n2, n3));
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n2, int n3, Graphics graphics) {
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = characterIterator.first();
        while (c2 != '\uffff') {
            stringBuffer.append(c2);
            c2 = characterIterator.next();
        }
        String string = stringBuffer.toString().substring(n2, n3);
        return new LineMetricsPS(this, string);
    }

    public double getHeight(JCUnit jCUnit, int n2) {
        int n3 = ((FontPS)this.font).getAscender();
        int n4 = ((FontPS)this.font).getDescender();
        double d2 = FontMetricsPS.asPoints(n3 - n4, n2);
        return FontMetricsPS.convertFromPoints(jCUnit, d2);
    }

    public double getXHeight(JCUnit jCUnit, int n2) {
        double d2 = FontMetricsPS.asPoints(((FontPS)this.font).getXHeight(), n2);
        return FontMetricsPS.convertFromPoints(jCUnit, d2);
    }

    public double getAscender(JCUnit jCUnit, int n2) {
        double d2 = FontMetricsPS.asPoints(((FontPS)this.font).getAscender(), n2);
        return FontMetricsPS.convertFromPoints(jCUnit, d2);
    }

    public double getDescender(JCUnit jCUnit, int n2) {
        double d2 = FontMetricsPS.asPoints(((FontPS)this.font).getDescender(), n2);
        return FontMetricsPS.convertFromPoints(jCUnit, d2);
    }

    public static double asPoints(double d2, int n2) {
        return d2 * (double)n2 / (double)AFM_DIVISOR;
    }

    protected static double convertFromPoints(JCUnit jCUnit, double d2) {
        double d3 = 0.0;
        if (jCUnit == JCUnit.POINTS) {
            d3 = d2;
        } else if (jCUnit == JCUnit.INCHES) {
            d3 = JCUnit.getAsInches(JCUnit.POINTS, d2);
        } else if (jCUnit == JCUnit.CM) {
            d3 = JCUnit.getAsCentimeters(JCUnit.POINTS, d2);
        } else {
            throw new IllegalArgumentException("Unknown units " + jCUnit);
        }
        return d3;
    }

    public double charWidth(JCUnit jCUnit, int n2, char c2) {
        CharMetricPS charMetricPS = ((FontPS)this.font).getCharMetric(c2);
        double d2 = 0.0;
        if (charMetricPS != null) {
            d2 = FontMetricsPS.asPoints(charMetricPS.getWx(), n2);
        }
        return FontMetricsPS.convertFromPoints(jCUnit, d2);
    }

    public double stringWidth(JCUnit jCUnit, int n2, String string) {
        double d2 = 0.0;
        CharMetricPS charMetricPS = null;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            PairKern pairKern;
            CharMetricPS charMetricPS2 = ((FontPS)this.font).getCharMetric(string.charAt(i2));
            d2 += (double)charMetricPS2.getWx();
            if (charMetricPS != null && (pairKern = charMetricPS.getKernByName(charMetricPS2.getName())) != null) {
                d2 += (double)pairKern.xAmount;
            }
            charMetricPS = charMetricPS2;
        }
        double d3 = FontMetricsPS.asPoints(d2, n2);
        return FontMetricsPS.convertFromPoints(jCUnit, d3);
    }

    public double getLeadingSpace(JCUnit jCUnit, int n2, String string) {
        CharMetricPS charMetricPS = ((FontPS)this.font).getCharMetric(string.charAt(0));
        double d2 = 0.0;
        if (charMetricPS != null && charMetricPS.getCharBBox().llx < 0) {
            d2 = -charMetricPS.getCharBBox().llx;
            d2 = FontMetricsPS.asPoints(d2, n2);
        }
        return FontMetricsPS.convertFromPoints(jCUnit, d2);
    }

    public double getTrailingSpace(JCUnit jCUnit, int n2, String string) {
        int n3 = string.length() - 1;
        CharMetricPS charMetricPS = ((FontPS)this.font).getCharMetric(string.charAt(n3));
        double d2 = 0.0;
        if (charMetricPS != null && charMetricPS.getCharBBox().llx < 0) {
            d2 = -charMetricPS.getCharBBox().llx;
            d2 = FontMetricsPS.asPoints(d2, n2);
        }
        return FontMetricsPS.convertFromPoints(jCUnit, d2);
    }

    public FontMetrics getEncoderFontMetrics() {
        return new EncoderFontMetrics((FontPS)this.font);
    }
}

