/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.adobe.pdf;

import com.klg.jclass.page.EPSImage;
import com.klg.jclass.page.FontLibrary;
import com.klg.jclass.page.Graphics2DBase;
import com.klg.jclass.page.adobe.pdf.AcroFontEntry;
import com.klg.jclass.page.adobe.pdf.Ascii85OutputStream;
import com.klg.jclass.page.adobe.pdf.JCPDFPrinter;
import com.klg.jclass.page.adobe.pdf.ShadedPattern;
import com.klg.jclass.page.adobe.postscript.CharMetricPS;
import com.klg.jclass.page.adobe.postscript.FontMetricsPS;
import com.klg.jclass.page.adobe.postscript.FontPS;
import com.klg.jclass.page.adobe.postscript.PairKern;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.label.JCLabel;
import com.klg.jclass.util.swing.JCSwingUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class Graphics2DPDF
extends Graphics2DBase {
    protected JCPDFPrinter printer;
    protected AffineTransform pdfTransform = new AffineTransform();
    protected static final char[] hd = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected Color currentLineColor = null;
    protected boolean lineColorChanged = true;
    protected Color currentFillColor = null;
    protected boolean fillColorChanged = true;
    protected Paint currentPaint = null;
    protected static Hashtable<Font, FontPS> convertedFonts = new Hashtable();

    public Graphics2DPDF(OutputStream outputStream, JCPDFPrinter jCPDFPrinter) {
        super(outputStream);
        this.printer = jCPDFPrinter;
    }

    public void drawString(String string, float f2, float f3) {
        Object object;
        Object object2;
        Cloneable cloneable;
        Serializable serializable;
        Object object3;
        Object object4;
        if (string == null || string.equals("")) {
            return;
        }
        Component component = this.getComponent();
        if (component instanceof JComponent) {
            object4 = (JComponent)component;
            if (Graphics2DPDF.getStoreFontMetricInfo() == 2) {
                object3 = this.getFontMetrics(this.currentFont);
                if (object4 instanceof AbstractButton || object4 instanceof JLabel && (!(object4 instanceof JCLabel) || !JCLabel.isUsingAlternativeLabelUI())) {
                    serializable = GraphicsUtil.getDrawingArea((JComponent)object4, null);
                    cloneable = new Rectangle();
                    object2 = new Rectangle();
                    object = JCSwingUtilities.layoutCompoundLabel((JComponent)object4, (FontMetrics)object3, (Rectangle)serializable, (Rectangle)cloneable, (Rectangle)object2);
                    f2 = ((Rectangle)object2).x;
                    f3 = ((Rectangle)object2).y + ((FontMetrics)object3).getAscent();
                    string = object;
                }
            }
        }
        this.updateContext();
        f3 = -f3;
        object3 = null;
        this.outputCurrentPaint("rg");
        this.initializeOutString(f2, f3);
        this.printer.streamInfo.textPresent = true;
        this.output("BT");
        serializable = new StringBuffer();
        ((StringBuffer)serializable).append(f2);
        ((StringBuffer)serializable).append(" ");
        ((StringBuffer)serializable).append(f3);
        ((StringBuffer)serializable).append(" Td");
        this.output(((StringBuffer)serializable).toString());
        cloneable = (FontPS)this.getFont();
        object2 = this.getFont().getName();
        object = this.printer.getFontEntry((String)object2);
        boolean bl = false;
        if (((AcroFontEntry)object).usingTTF) {
            bl = ((AcroFontEntry)object).expectedCharacterRange == 0;
        }
        Set set = null;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            Object object5;
            boolean bl4;
            int n3;
            int n4 = string.charAt(i2);
            if (n4 == 8364 && (((AcroFontEntry)object).expectedCharacterRange == 1 || ((AcroFontEntry)object).expectedCharacterRange == 0)) {
                n3 = 128;
            } else if (n4 > 255 && ((AcroFontEntry)object).expectedCharacterRange == 1) {
                System.err.println("Warning: expecting single-byte character, found multi-byte character 0x" + Integer.toHexString(n4));
                n3 = n4 = 32;
            } else {
                n3 = n4;
            }
            boolean bl5 = bl4 = n3 > 255;
            if (((AcroFontEntry)object).usingTTF && (bl && bl4 || !bl && ((AcroFontEntry)object).usingUnicode) && (n2 = ((FontPS)cloneable).ttfParser.unicodeToGlyphCode(n4)) < 0) {
                n2 = 0;
            }
            object4 = ((FontPS)cloneable).getCharMetric((char)n4);
            if (object3 != null) {
                object5 = ((AcroFontEntry)object).usingTTF ? ((CharMetricPS)object3).getKernByUnicode(((CharMetricPS)object4).getCode()) : ((CharMetricPS)object3).getKernByName(((CharMetricPS)object4).getName());
                boolean bl6 = false;
                if (object5 != null && ((PairKern)object5).xAmount != 0) {
                    this.endTextSegment(bl2);
                    if (bl) {
                        bl6 = bl3 != bl4;
                    }
                    this.addKerning(((PairKern)object5).xAmount, bl2, !bl6);
                }
                if (bl && bl3 != bl4) {
                    this.printOutString(bl2, !bl6);
                    this.out.text.delete(0, this.out.text.length());
                }
            }
            if (object3 == null || bl && bl3 != bl4) {
                if (bl) {
                    bl2 = bl4;
                    if (bl4) {
                        ((AcroFontEntry)object).usingUnicode = true;
                    } else {
                        ((AcroFontEntry)object).usingAnsi = true;
                    }
                    this.loadFont((String)object2, bl4);
                    set = bl4 ? ((AcroFontEntry)object).unicodeCharactersUsed : ((AcroFontEntry)object).ansiCharactersUsed;
                } else {
                    bl2 = ((AcroFontEntry)object).usingUnicode;
                    this.loadFont((String)object2, ((AcroFontEntry)object).usingUnicode);
                    set = ((AcroFontEntry)object).usingUnicode ? ((AcroFontEntry)object).unicodeCharactersUsed : ((AcroFontEntry)object).ansiCharactersUsed;
                }
            }
            if (bl2 && ((AcroFontEntry)object).usingTTF) {
                object5 = new Integer(n2);
                if (!set.contains(object5)) {
                    set.add(object5);
                    Integer n5 = new Integer(((CharMetricPS)object4).getWx());
                    Integer n6 = (Integer)((AcroFontEntry)object).unicodeWidths.get(n5);
                    if (n6 == null) {
                        ((AcroFontEntry)object).unicodeWidths.put(n5, new Integer(1));
                    } else {
                        ((AcroFontEntry)object).unicodeWidths.put(n5, new Integer(n6 + 1));
                    }
                }
                this.appendToOutString(n2, ((CharMetricPS)object4).getWx(), (FontPS)cloneable, bl2);
            } else {
                set.add(new Integer(n3));
                this.appendToOutString(n3, ((CharMetricPS)object4).getWx(), (FontPS)cloneable, bl2);
            }
            object3 = object4;
            bl3 = bl4;
        }
        this.printOutString(bl2, true);
        this.output("ET");
        if (this.underline) {
            double d2 = FontMetricsPS.asPoints(((FontPS)cloneable).getUnderlineThickness(), ((Font)((Object)cloneable)).getSize());
            this.setStroke(new BasicStroke((float)d2));
            f3 = (float)((double)(-f3) - FontMetricsPS.asPoints(((FontPS)cloneable).getUnderlinePosition(), ((Font)((Object)cloneable)).getSize()));
            this.drawLinePW(f2, f3, this.out.x, f3);
        }
    }

    public void translate(int n2, int n3) {
        this.translate((double)n2, (double)n3);
    }

    public void translate(double d2, double d3) {
        this.transform.translate(d2, d3);
        this.pdfTransform.translate(d2, d3);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-d2, -d3);
        this.clip = affineTransform.createTransformedShape(this.clip);
        if (this.isContextCurrent()) {
            this.output("1 0 0 1 " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(-d3) + " cm");
        }
    }

    public void scale(double d2, double d3) {
        this.transform.scale(d2, d3);
        this.pdfTransform.scale(d2, d3);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0 / d2, 1.0 / d3);
        this.clip = affineTransform.createTransformedShape(this.clip);
        if (this.isContextCurrent()) {
            this.output(this.truncateDecimalDigits(d2) + " 0 0 " + this.truncateDecimalDigits(d3) + " 0 0 cm");
        }
    }

    public void rotate(double d2) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-d2);
        this.clip = affineTransform.createTransformedShape(this.clip);
        this.transform.rotate(d2);
        d2 = Math.PI * 2 - d2;
        this.pdfTransform.rotate(d2);
        if (this.isContextCurrent()) {
            this.output(this.truncateDecimalDigits(Math.cos(d2)) + " " + this.truncateDecimalDigits(Math.sin(d2)) + " " + this.truncateDecimalDigits(-1.0 * Math.sin(d2)) + " " + this.truncateDecimalDigits(Math.cos(d2)) + " " + " 0 0 cm");
        }
    }

    public void rotate(double d2, double d3, double d4) {
        this.translate(d3, d4);
        this.rotate(d2);
        this.translate(-d3, -d4);
    }

    public void clipRect(int n2, int n3, int n4, int n5) {
        this.clipRect((double)n2, (double)n3, (double)n4, (double)n5);
    }

    public void clipRect(double d2, double d3, double d4, double d5) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, d4, d5);
        if (this.clipSet) {
            Shape shape;
            if (this.clip instanceof Rectangle2D) {
                shape = new Rectangle2D.Double();
                Rectangle2D.intersect((Rectangle2D)this.clip, double_, shape);
            } else {
                Area area = new Area(this.clip);
                area.intersect(new Area(double_));
                shape = new GeneralPath();
                ((GeneralPath)shape).append(area, false);
            }
            this.clip = shape;
        } else {
            this.clip = double_;
            this.clipSet = true;
        }
        if (this.isContextCurrent()) {
            this.outputClip();
        }
    }

    public void setPaint(Paint paint) {
        this.currentPaint = paint;
        if (paint == null || paint instanceof Color) {
            this.setColor((Color)paint);
        }
    }

    public Paint getPaint() {
        return this.currentPaint != null ? this.currentPaint : this.getColor();
    }

    public void setColor(Color color) {
        super.setColor(color);
        this.currentPaint = color;
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        this.updateContext();
        this.outputCurrentPaint("RG");
        this.setLineStroke();
        this.output(nArray[0] + " " + -nArray2[0] + " m");
        for (int i2 = 1; i2 < n2; ++i2) {
            this.output(nArray[i2] + " " + -nArray2[i2] + " l");
        }
        this.output("S");
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        this.printPolygon(nArray, nArray2, n2, "S");
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        this.printPolygon(nArray, nArray2, n2, "f");
    }

    public void setFont(Font font) {
        Object object;
        this.updateContext();
        if (!(font instanceof FontPS)) {
            if (convertedFonts.containsKey(font)) {
                font = convertedFonts.get(font);
            } else {
                object = font;
                try {
                    font = FontPS.getNativeFont((Font)object);
                }
                catch (NullPointerException nullPointerException) {
                    this.addFont((Font)object);
                    font = FontPS.getNativeFont((Font)object);
                }
                convertedFonts.put((Font)object, (FontPS)font);
            }
        }
        if (this.currentFont != null && this.currentFont.equals(font) && this.currentFont.getStyle() == font.getStyle() && this.currentFont.getSize() == font.getSize()) {
            return;
        }
        this.currentFont = font;
        this.fontChanged = true;
        object = font.getName();
        Object v = this.printer.fontList.get(object);
        if (v == null) {
            this.printer.addFontToList((FontPS)font);
        }
        this.printer.getFontAbbreviation((String)object);
    }

    public FontMetrics getFontMetrics(Font font) {
        if (!(font instanceof FontPS)) {
            if (convertedFonts.containsKey(font)) {
                font = convertedFonts.get(font);
            } else {
                if (!this.printer.fontList.containsKey(font.getName())) {
                    this.setFont(font);
                }
                Font font2 = font;
                font = FontPS.getNativeFont(font2);
                convertedFonts.put(font2, (FontPS)font);
            }
        }
        return new FontMetricsPS((FontPS)font);
    }

    public void addFont(Font font) {
        if (FontLibrary.availableFonts[0].containsKey(font.getName())) {
            FontPS.loadFont(font.getName());
        }
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        Object object;
        if (image == null) {
            return false;
        }
        Component component = this.getComponent();
        if (component instanceof JComponent) {
            object = (JComponent)component;
            if (Graphics2DPDF.getStoreFontMetricInfo() == 2) {
                FontMetrics fontMetrics = this.getFontMetrics(this.currentFont);
                if (object instanceof AbstractButton || object instanceof JLabel && (!(object instanceof JCLabel) || !JCLabel.isUsingAlternativeLabelUI())) {
                    Rectangle rectangle = GraphicsUtil.getDrawingArea((JComponent)object, null);
                    Rectangle rectangle2 = new Rectangle();
                    Rectangle rectangle3 = new Rectangle();
                    JCSwingUtilities.layoutCompoundLabel((JComponent)object, fontMetrics, rectangle, rectangle2, rectangle3);
                    n2 = rectangle2.x;
                    n3 = rectangle2.y;
                }
            }
        }
        this.updateContext();
        if (image instanceof EPSImage) {
            object = this.getColor();
            this.setColor(Color.lightGray);
            this.fillRect(n2, n3, n4, n5);
            this.setColor((Color)object);
            return true;
        }
        object = new Int();
        this.drawJavaImage(image, n2, n3, n4, n5, color, imageObserver, false, true, (Int)object);
        return this.drawJavaImage(image, n2, n3, n4, n5, color, imageObserver, true, false, (Int)object);
    }

    public Graphics create() {
        Graphics graphics = super.create();
        if (graphics instanceof Graphics2DPDF) {
            Graphics2DPDF graphics2DPDF = (Graphics2DPDF)graphics;
            graphics2DPDF.pdfTransform = this.isFrameGraphics ? new AffineTransform() : new AffineTransform(this.pdfTransform);
        }
        return graphics;
    }

    public void setTransform(AffineTransform affineTransform) {
        super.setTransform(affineTransform);
        this.pdfTransform = new AffineTransform(affineTransform);
    }

    public Graphics newGraphics() {
        return new Graphics2DPDF(this.getOutputStream(), this.printer);
    }

    public void startContext() {
        if (this.printer.isDocOpen()) {
            this.output("q");
            double[] dArray = new double[6];
            this.pdfTransform.getMatrix(dArray);
            this.output("" + this.truncateDecimalDigits(dArray[0]) + " " + this.truncateDecimalDigits(dArray[1]) + " " + this.truncateDecimalDigits(dArray[2]) + " " + this.truncateDecimalDigits(dArray[3]) + " " + this.truncateDecimalDigits(dArray[4]) + " " + this.truncateDecimalDigits(-1.0 * dArray[5]) + " cm");
            this.outputClip();
            this.lineColorChanged = true;
            this.fillColorChanged = true;
            this.strokeChanged = true;
        }
    }

    public void outputClip() {
        if (this.clip == null) {
            return;
        }
        if (this.clip instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)this.clip;
            this.output(this.truncateDecimalDigits(rectangle2D.getX()) + " " + this.truncateDecimalDigits(-rectangle2D.getY()) + " " + this.truncateDecimalDigits(rectangle2D.getWidth()) + " " + this.truncateDecimalDigits(-rectangle2D.getHeight()) + " re W n");
        } else if (this.clip instanceof GeneralPath) {
            PathIterator pathIterator = this.clip.getPathIterator(null);
            double[] dArray = new double[6];
            boolean bl = false;
            while (!pathIterator.isDone()) {
                int n2 = pathIterator.currentSegment(dArray);
                switch (n2) {
                    case 0: {
                        this.output(this.truncateDecimalDigits(dArray[0]) + " " + this.truncateDecimalDigits(-dArray[1]) + " m");
                        bl = true;
                        break;
                    }
                    case 1: {
                        this.output(this.truncateDecimalDigits(dArray[0]) + " " + this.truncateDecimalDigits(-dArray[1]) + " l");
                        bl = true;
                        break;
                    }
                    case 4: {
                        this.output("h");
                        bl = true;
                        break;
                    }
                }
                pathIterator.next();
            }
            if (bl) {
                this.output("W n");
            }
        } else {
            Rectangle2D rectangle2D = this.clip.getBounds2D();
            this.output(this.truncateDecimalDigits(rectangle2D.getX()) + " " + this.truncateDecimalDigits(-rectangle2D.getY()) + " " + this.truncateDecimalDigits(rectangle2D.getWidth()) + " " + this.truncateDecimalDigits(-rectangle2D.getHeight()) + " re W n");
        }
    }

    public void endContext() {
        this.output("Q");
        this.lineColorChanged = true;
        this.fillColorChanged = true;
    }

    public void fillShape(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        this.updateContext();
        this.outputCurrentPaint("rg");
        this.windingRule = ((GeneralPath)shape).getWindingRule();
        String string = this.windingRule == 1 ? "f*" : "f";
        this.fillShape(pathIterator, string);
    }

    public void fillPath2D(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        String string = "f";
        this.updateContext();
        this.outputCurrentPaint("rg");
        this.windingRule = this.getWindingRuleForPath2D(shape);
        string = this.windingRule == 0 ? "f*" : "f";
        this.fillShape(pathIterator, string);
    }

    private void fillShape(PathIterator pathIterator, String string) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        boolean bl = true;
        while (!pathIterator.isDone()) {
            float[] fArray = new float[6];
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    this.output(this.truncateDecimalDigits(fArray[0]) + " " + this.truncateDecimalDigits(-fArray[1]) + " m");
                    f4 = fArray[0];
                    f5 = fArray[1];
                    f2 = fArray[0];
                    f3 = fArray[1];
                    bl = false;
                    break;
                }
                case 1: {
                    this.output(this.truncateDecimalDigits(fArray[0]) + " " + this.truncateDecimalDigits(-fArray[1]) + " l");
                    f4 = fArray[0];
                    f5 = fArray[1];
                    break;
                }
                case 3: {
                    this.output(this.truncateDecimalDigits(fArray[0]) + " " + this.truncateDecimalDigits(-fArray[1]) + " " + this.truncateDecimalDigits(fArray[2]) + " " + this.truncateDecimalDigits(-fArray[3]) + " " + this.truncateDecimalDigits(fArray[4]) + " " + this.truncateDecimalDigits(-fArray[5]) + " c");
                    f4 = fArray[4];
                    f5 = fArray[5];
                    break;
                }
                case 2: {
                    float f6 = this.cvtQuadraticCPToFirstCubicCP(fArray[0], f4);
                    float f7 = -this.cvtQuadraticCPToFirstCubicCP(fArray[1], f5);
                    float f8 = this.cvtQuadraticCPToSecondCubicCP(fArray[0], fArray[2]);
                    float f9 = -this.cvtQuadraticCPToSecondCubicCP(fArray[1], fArray[3]);
                    float f10 = fArray[2];
                    float f11 = -fArray[3];
                    this.output(this.truncateDecimalDigits(f6) + " " + this.truncateDecimalDigits(f7) + " " + this.truncateDecimalDigits(f8) + " " + this.truncateDecimalDigits(f9) + " " + this.truncateDecimalDigits(f10) + " " + this.truncateDecimalDigits(f11) + " c");
                    f4 = fArray[2];
                    f5 = fArray[3];
                    break;
                }
                case 4: {
                    f4 = f2;
                    f5 = f3;
                    this.output("h");
                    bl = true;
                    break;
                }
            }
            pathIterator.next();
        }
        if (!bl) {
            this.output("h " + string);
        } else {
            this.output(string);
        }
    }

    private float cvtQuadraticCPToFirstCubicCP(float f2, float f3) {
        return 2.0f * (f2 - f3) / 3.0f + f3;
    }

    private float cvtQuadraticCPToSecondCubicCP(float f2, float f3) {
        return (f3 - f2) / 3.0f + f2;
    }

    public void drawArcPW(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        this.updateContext();
        this.setLineStroke();
        this.outputCurrentPaint("RG");
        double d8 = d4 / 2.0;
        double d9 = d5 / 2.0;
        d3 = -(d3 + d9);
        double d10 = d7 < 0.0 ? (d6 + d7) / 180.0 * Math.PI : d6 / 180.0 * Math.PI;
        double d11 = (d2 += d8) + d8 * Math.cos(d10);
        double d12 = d3 + d9 * Math.sin(d10);
        this.output(this.truncateDecimalDigits(d11) + " " + this.truncateDecimalDigits(d12) + " m");
        this.traceArcPath(d2, d3, d8, d9, d6, d7);
        this.output("S");
    }

    public void fillArcPW(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        this.updateContext();
        this.outputCurrentPaint("rg");
        double d8 = d4 / 2.0;
        double d9 = d5 / 2.0;
        d3 = -(d3 + d9);
        double d10 = d7 < 0.0 ? (d6 + d7) / 180.0 * Math.PI : d6 / 180.0 * Math.PI;
        double d11 = (d2 += d8) + d8 * Math.cos(d10);
        double d12 = d3 + d9 * Math.sin(d10);
        this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3) + " m " + this.truncateDecimalDigits(d11) + " " + this.truncateDecimalDigits(d12) + " l");
        this.traceArcPath(d2, d3, d8, d9, d6, d7);
        this.output("h f");
    }

    public void setClip(Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.setClipPW(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            this.setClipPW(shape);
        }
    }

    protected void setClipPW(Shape shape) {
        boolean bl = this.isContextCurrent();
        if (bl) {
            this.endContext();
        }
        if (this.parent != null && ((Graphics2DPDF)this.parent).clipSet) {
            Shape shape2 = this.getTransformedParentClip();
            Area area = new Area(shape2);
            area.intersect(new Area(shape));
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(area, false);
            this.clip = generalPath;
        } else {
            this.clip = shape;
        }
        this.clipSet = true;
        if (bl) {
            this.startContext();
        }
    }

    protected Shape getTransformedParentClip() {
        Shape shape;
        Shape shape2 = this.parent.getClip();
        try {
            AffineTransform affineTransform;
            if (((Graphics2DBase)this.parent).isFrameRoot()) {
                affineTransform = this.pdfTransform.createInverse();
            } else {
                AffineTransform affineTransform2 = (AffineTransform)((Graphics2D)this.parent).getTransform().clone();
                if (affineTransform2.isIdentity()) {
                    affineTransform = this.pdfTransform.createInverse();
                } else {
                    affineTransform = affineTransform2.createInverse();
                    affineTransform.concatenate(this.pdfTransform);
                    affineTransform = affineTransform.createInverse();
                }
            }
            shape = affineTransform.createTransformedShape(shape2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            shape = shape2;
        }
        return shape;
    }

    public void setClipPW(double d2, double d3, double d4, double d5) {
        boolean bl = this.isContextCurrent();
        if (bl) {
            this.endContext();
        }
        if (this.parent != null && ((Graphics2DPDF)this.parent).clipSet) {
            Shape shape;
            Cloneable cloneable;
            Object object;
            Cloneable cloneable2;
            Shape shape2 = this.parent.getClip();
            try {
                if (((Graphics2DBase)this.parent).isFrameRoot()) {
                    cloneable2 = this.pdfTransform.createInverse();
                } else {
                    object = (Graphics2D)this.parent;
                    cloneable = (AffineTransform)((Graphics2D)object).getTransform().clone();
                    if (((AffineTransform)cloneable).isIdentity()) {
                        cloneable2 = this.pdfTransform.createInverse();
                    } else {
                        cloneable2 = ((AffineTransform)cloneable).createInverse();
                        ((AffineTransform)cloneable2).concatenate(this.pdfTransform);
                        cloneable2 = ((AffineTransform)cloneable2).createInverse();
                    }
                }
                shape = ((AffineTransform)cloneable2).createTransformedShape(shape2);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                shape = shape2;
            }
            cloneable2 = new Rectangle2D.Double(d2, d3, d4, d5);
            if (shape instanceof Rectangle2D) {
                object = new Rectangle2D.Double();
                Rectangle2D.intersect((Rectangle2D)shape, (Rectangle2D)cloneable2, (Rectangle2D)object);
            } else {
                cloneable = new Area(shape);
                ((Area)cloneable).intersect(new Area((Shape)((Object)cloneable2)));
                object = new GeneralPath();
                ((GeneralPath)object).append((Shape)((Object)cloneable), false);
            }
            this.clip = object;
        } else {
            this.clip = new Rectangle2D.Double(d2, d3, d4, d5);
        }
        this.clipSet = true;
        if (bl) {
            this.startContext();
        }
    }

    public void fillRectPW(double d2, double d3, double d4, double d5) {
        this.printRect(d2, d3, d4, d5, "f");
    }

    public void drawRectPW(double d2, double d3, double d4, double d5) {
        this.printRect(d2, d3, d4, d5, "S");
    }

    public void drawLinePW(double d2, double d3, double d4, double d5) {
        this.updateContext();
        this.outputCurrentPaint("RG");
        this.setLineStroke();
        this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(-d3) + " m " + this.truncateDecimalDigits(d4) + " " + this.truncateDecimalDigits(-d5) + " l S");
    }

    public void drawRoundRectPW(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.drawRRect(d2, d3, d4, d5, d6, d7, "S");
    }

    public void fillRoundRectPW(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.drawRRect(d2, d3, d4, d5, d6, d7, "f");
    }

    protected void appendToOutString(int n2, double d2, FontPS fontPS, boolean bl) {
        String string = "\\()";
        char c2 = '\\';
        if (bl) {
            int n3 = n2 >> 8;
            if (n3 <= 15) {
                this.out.text.append("0");
            }
            this.out.text.append(Integer.toHexString(n3));
            n3 = n2 & 0xFF;
            if (n3 <= 15) {
                this.out.text.append("0");
            }
            this.out.text.append(Integer.toHexString(n3));
        } else if (n2 < 32 || n2 > 126) {
            if (n2 <= 255) {
                this.out.text.append(this.octal3((char)(n2 & 0xFF)));
            } else if (n2 == 8364) {
                this.out.text.append(this.octal3('\u0080'));
            } else {
                System.err.println("Warning: expecting single-byte character, found multi-byte character 0x" + Integer.toHexString(n2));
                this.out.text.append(' ');
            }
        } else {
            if (string.indexOf((char)n2) != -1) {
                this.out.text.append(c2);
            }
            this.out.text.append((char)n2);
        }
        this.out.width += FontMetricsPS.asPoints(d2, this.getFont().getSize());
    }

    protected void printOutString(boolean bl, boolean bl2) {
        int n2 = this.out.text.length() + 7;
        StringBuffer stringBuffer = new StringBuffer(n2);
        if (bl) {
            stringBuffer.append("[<");
            stringBuffer.append(this.out.text.toString());
            if (bl2) {
                stringBuffer.append(">");
            }
        } else {
            stringBuffer.append("[(");
            stringBuffer.append(this.out.text.toString());
            if (bl2) {
                stringBuffer.append(")");
            }
        }
        stringBuffer.append("]TJ");
        this.output(stringBuffer.toString());
        this.out.x += this.out.width;
        this.out.width = 0.0;
    }

    protected void endTextSegment(boolean bl) {
        if (bl) {
            this.out.text.append(">");
        } else {
            this.out.text.append(")");
        }
    }

    protected void addKerning(int n2, boolean bl, boolean bl2) {
        this.out.text.append(-n2);
        if (bl2) {
            if (bl) {
                this.out.text.append("<");
            } else {
                this.out.text.append("(");
            }
        }
    }

    protected void outputColor(String string, Color color) {
        int n2;
        if (color == null) {
            return;
        }
        if (string.equals("RG")) {
            if (color.equals(this.currentLineColor) && !this.lineColorChanged) {
                return;
            }
            this.currentLineColor = color;
            this.lineColorChanged = false;
        } else {
            if (color.equals(this.currentFillColor) && !this.fillColorChanged) {
                return;
            }
            this.currentFillColor = color;
            this.fillColorChanged = false;
        }
        double d2 = (double)color.getRed() / 255.0;
        double d3 = (double)color.getGreen() / 255.0;
        double d4 = (double)color.getBlue() / 255.0;
        this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(d4) + " " + string);
        double d5 = (double)color.getAlpha() / 255.0;
        JCPDFPrinter jCPDFPrinter = this.printer;
        jCPDFPrinter.getClass();
        JCPDFPrinter.AlphaTransparency alphaTransparency = new JCPDFPrinter.AlphaTransparency(jCPDFPrinter, d5, string.equals("rg"));
        if (this.printer.alphaValues.containsKey(alphaTransparency)) {
            n2 = this.printer.alphaValues.get(alphaTransparency);
        } else {
            n2 = ++this.printer.objectNumber;
            this.printer.alphaValues.put(alphaTransparency, n2);
        }
        this.output("/GS" + n2 + " gs");
        this.colorChanged = false;
    }

    protected void outputTexture(TexturePaint texturePaint) {
        String string = "/P" + this.printer.patternIndex++;
        this.output("/Pattern cs " + string + " scn");
        this.printer.addPattern(string, texturePaint.getImage());
        this.outputPatternObjectDictionaries(texturePaint.getImage());
        this.fillColorChanged = true;
    }

    protected void outputGradient(GradientPaint gradientPaint) {
        Graphics2DPDF graphics2DPDF = (Graphics2DPDF)this.getFrameRoot();
        double d2 = graphics2DPDF.getTransform().getTranslateX();
        double d3 = graphics2DPDF.getTransform().getTranslateY();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d2, d3);
        ShadedPattern shadedPattern = new ShadedPattern(gradientPaint, new AffineTransform(this.pdfTransform), affineTransform);
        String string = "/P" + this.printer.patternIndex++;
        this.output("/Pattern cs " + string + " scn");
        int n2 = ++this.printer.objectNumber;
        this.printer.addPattern(string, shadedPattern, n2);
        this.fillColorChanged = true;
    }

    protected void outputCurrentPaint(String string) {
        Paint paint = this.getPaint();
        if (string.equals("RG") || paint == null) {
            this.outputColor(string, this.getColor());
        } else if (paint instanceof Color) {
            this.outputColor(string, (Color)paint);
        } else if (paint instanceof TexturePaint) {
            this.outputTexture((TexturePaint)paint);
        } else if (paint instanceof GradientPaint) {
            this.outputGradient((GradientPaint)paint);
        }
    }

    protected void outputCurrentColor(String string) {
        this.outputColor(string, this.getColor());
    }

    protected void printPolygon(int[] nArray, int[] nArray2, int n2, String string) {
        this.updateContext();
        String string2 = string.equals("S") ? "RG" : "rg";
        this.outputCurrentPaint(string2);
        this.output(nArray[0] + " " + -nArray2[0] + " m");
        for (int i2 = 1; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            int n4 = -nArray2[i2];
            this.output(n3 + " " + n4 + " l");
        }
        if (string.equals("f") && this.getWindingRule() == 1) {
            string = "f*";
        }
        this.output("h " + string);
    }

    protected void drawRRect(double d2, double d3, double d4, double d5, double d6, double d7, String string) {
        this.updateContext();
        d3 = -d3;
        String string2 = string.equals("S") ? "RG" : "rg";
        this.outputCurrentPaint(string2);
        this.setLineStroke();
        double d8 = d6 * 0.448;
        double d9 = d7 * 0.448;
        this.output(this.truncateDecimalDigits(d2 + d6) + " " + this.truncateDecimalDigits(d3) + " m");
        this.output(this.truncateDecimalDigits(d2 + d8) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3 - d9) + " " + this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3 - d7) + " c");
        if (d5 > d7 * 2.0) {
            this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3 - d5 + d7) + " l");
        }
        this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3 - d5 + d9) + " " + this.truncateDecimalDigits(d2 + d8) + " " + this.truncateDecimalDigits(d3 - d5) + " " + this.truncateDecimalDigits(d2 + d6) + " " + this.truncateDecimalDigits(d3 - d5) + " c");
        if (d4 > d6 * 2.0) {
            this.output(this.truncateDecimalDigits(d2 + d4 - d6) + " " + this.truncateDecimalDigits(d3 - d5) + " l");
        }
        this.output(this.truncateDecimalDigits(d2 + d4 - d8) + " " + this.truncateDecimalDigits(d3 - d5) + " " + this.truncateDecimalDigits(d2 + d4) + " " + this.truncateDecimalDigits(d3 - d5 + d9) + " " + this.truncateDecimalDigits(d2 + d4) + " " + this.truncateDecimalDigits(d3 - d5 + d7) + " c");
        if (d5 > d7 * 2.0) {
            this.output(this.truncateDecimalDigits(d2 + d4) + " " + this.truncateDecimalDigits(d3 - d7) + " l");
        }
        this.output(this.truncateDecimalDigits(d2 + d4) + " " + this.truncateDecimalDigits(d3 - d9) + " " + this.truncateDecimalDigits(d2 + d4 - d8) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(d2 + d4 - d6) + " " + this.truncateDecimalDigits(d3) + " c h");
        this.output(string);
    }

    protected void setLineStroke() {
        if (this.strokeChanged) {
            float f2 = ((BasicStroke)this.currentStroke).getLineWidth();
            this.output(this.truncateDecimalDigits(f2) + " w");
            float[] fArray = ((BasicStroke)this.currentStroke).getDashArray();
            float f3 = ((BasicStroke)this.currentStroke).getDashPhase();
            if (fArray != null) {
                this.output("[ ");
                for (float f4 : fArray) {
                    this.output(this.truncateDecimalDigits(f4) + " ");
                }
                this.output("] ");
                this.output(String.valueOf(f3));
                this.output(" d");
                this.dashMode = true;
            } else if (this.dashMode) {
                this.output("[] 0 d");
                this.dashMode = false;
            }
        }
        this.strokeChanged = false;
    }

    protected void loadFont(String string, boolean bl) {
        String string2 = this.printer.getFontAbbreviation(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Font not found " + string);
        }
        this.printer.streamInfo.fontList.put(bl ? string + "-Unicode" : string, string);
        this.output("/" + string2 + (bl ? "U" : "") + " " + this.getFont().getSize() + " Tf");
    }

    public void traceArcPath(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9;
        double d10;
        double d11;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        if (d7 < 0.0) {
            d6 += d7;
            d7 = -d7;
        }
        if (Math.abs(d7) < 0.001) {
            double d20 = (d6 + d7) / 180.0 * Math.PI;
            d12 = d2 + d4 * Math.cos(d20);
            d16 = d3 + d5 * Math.sin(d20);
            this.output(this.truncateDecimalDigits(d12) + " " + this.truncateDecimalDigits(-d16) + " l");
            return;
        }
        if (d4 <= 0.0) {
            double d21 = (d6 + d7) / 180.0 * Math.PI;
            d16 = d3 + d5 * Math.sin(d21);
            this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(-d16) + " l");
            return;
        }
        if (d5 <= 0.0) {
            double d22 = (d6 + d7) / 180.0 * Math.PI;
            d12 = d2 + d4 * Math.cos(d22);
            this.output(this.truncateDecimalDigits(d12) + " " + this.truncateDecimalDigits(-d3) + " l");
            return;
        }
        double d23 = 0.5522848 * d4;
        double d24 = 0.5522848 * d5;
        double d25 = d11 = d4 / d5;
        double d26 = 1.0 / d25;
        double d27 = d6 / 180.0 * Math.PI;
        d12 = d2 + d4 * Math.cos(d27);
        d16 = d3 + d5 * Math.sin(d27);
        double d28 = (int)d6 / 90 * 90;
        if (Math.abs(d28 - d6) > 0.001) {
            if (d6 > 0.0) {
                d28 += 90.0;
            }
            if ((d10 = d6 + d7) > d28) {
                d10 = d28;
            }
            d27 = d10 / 180.0 * Math.PI;
            d15 = d2 + d4 * Math.cos(d27);
            d19 = d3 + d5 * Math.sin(d27);
            d9 = d10 - d6;
            d8 = this.computeControlPointFactor(d9);
            d13 = d12 - d8 * d25 * (d16 - d3);
            d17 = d16 + d8 * d26 * (d12 - d2);
            d14 = d15 + d8 * d25 * (d19 - d3);
            d18 = d19 - d8 * d26 * (d15 - d2);
            this.drawSegment(d13, d17, d14, d18, d15, d19);
            d12 = d15;
            d16 = d19;
        }
        d10 = d6 + d7;
        while (d28 + 90.0 <= d10) {
            int n2 = (int)d28 % 360;
            if (n2 == 0) {
                d13 = 0.0;
                d17 = d24;
                d14 = d23;
                d18 = 0.0;
            } else if (n2 == 90 || n2 == -270) {
                d13 = -d23;
                d17 = 0.0;
                d14 = 0.0;
                d18 = d24;
            } else if (n2 == 180 || n2 == -180) {
                d13 = 0.0;
                d17 = -d24;
                d14 = -d23;
                d18 = 0.0;
            } else if (n2 == 270 || n2 == -90) {
                d13 = d23;
                d17 = 0.0;
                d14 = 0.0;
                d18 = -d24;
            }
            d27 = (d28 += 90.0) / 180.0 * Math.PI;
            d15 = d2 + d4 * Math.cos(d27);
            d19 = d3 + d5 * Math.sin(d27);
            this.drawSegment(d13 += d12, d17 += d16, d14 += d15, d18 += d19, d15, d19);
            d12 = d15;
            d16 = d19;
        }
        if (d28 < d10 && Math.abs(d28 - d10) > 0.001) {
            d27 = d10 / 180.0 * Math.PI;
            d15 = d2 + d4 * Math.cos(d27);
            d19 = d3 + d5 * Math.sin(d27);
            d9 = d10 - d28;
            d8 = this.computeControlPointFactor(d9);
            d13 = d12 - d8 * d25 * (d16 - d3);
            d17 = d16 + d8 * d26 * (d12 - d2);
            d14 = d15 + d8 * d25 * (d19 - d3);
            d18 = d19 - d8 * d26 * (d15 - d2);
            this.drawSegment(d13, d17, d14, d18, d15, d19);
            d12 = d15;
            d16 = d19;
        }
    }

    protected double computeControlPointFactor(double d2) {
        double d3 = d2 / 2.0 / 180.0 * Math.PI;
        double d4 = 1.3333333333333333 * (1.0 - Math.cos(d3)) / Math.sin(d3);
        return d4;
    }

    protected void drawSegment(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(d4) + " " + this.truncateDecimalDigits(d5) + " " + this.truncateDecimalDigits(d6) + " " + this.truncateDecimalDigits(d7) + " c");
    }

    protected void printRect(double d2, double d3, double d4, double d5, String string) {
        this.updateContext();
        d3 = -d3;
        String string2 = string.equals("S") ? "RG" : "rg";
        this.outputCurrentPaint(string2);
        this.setLineStroke();
        this.output(this.truncateDecimalDigits(d2) + " " + this.truncateDecimalDigits(d3) + " " + this.truncateDecimalDigits(d4) + " " + this.truncateDecimalDigits(-d5) + " re " + string);
    }

    protected void output(String string) {
        this.printer.output(string);
    }

    protected void outputPatternObjectDictionaries(BufferedImage bufferedImage) {
        Int intVal = new Int();
        this.drawJavaImage(bufferedImage, 0, 0, 0, 0, null, null, false, true, intVal);
        this.drawJavaImage(bufferedImage, 0, 0, 0, 0, null, null, false, false, intVal);
    }

    protected void outputImageXObjectDictionary(int n2, int n3, int n4, PixelGrabber pixelGrabber, int[] nArray, boolean bl, Int intVal) {
        int n5;
        this.printer.storeObjectReference(n2, this.printer.getCurrentOffset());
        this.printer.streamInfo.imagePresent = !bl;
        this.printer.streamInfo.maskPresent = bl;
        this.output(n2 + " 0 obj\n<<");
        this.output("/Type /XObject\n/Subtype /Image");
        this.output("/Name /Im" + this.printer.imageNumber++);
        this.output("/Width " + n3 + "\n/Height " + n4);
        this.output("/BitsPerComponent 8");
        String string = bl ? "/DeviceGray" : "/DeviceRGB";
        this.output("/ColorSpace " + string);
        this.output("/Filter [ /ASCII85Decode /FlateDecode ]");
        this.output("/Length " + (n2 + 1) + " 0 R");
        if (!bl && intVal != null) {
            this.output("/SMask " + intVal.value + " 0 R");
        }
        this.output("/Resources " + (n2 + 2) + " 0 R\n>>");
        this.output("stream");
        long l2 = this.printer.getCurrentOffset();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(new Ascii85OutputStream(byteArrayOutputStream));
        int n6 = bl ? n3 : n3 * 3;
        byte[] byArray = new byte[n6];
        int n7 = pixelGrabber.getHeight();
        int n8 = pixelGrabber.getWidth();
        for (int i2 = 0; i2 < n7; ++i2) {
            int n9 = 0;
            for (int i3 = 0; i3 < n8; ++i3) {
                n5 = nArray[i2 * n8 + i3];
                if (bl) {
                    byArray[n9++] = (byte)(n5 >> 24 & 0xFF);
                    continue;
                }
                byArray[n9++] = (byte)(n5 >> 16 & 0xFF);
                byArray[n9++] = (byte)(n5 >> 8 & 0xFF);
                byArray[n9++] = (byte)(n5 & 0xFF);
            }
            try {
                deflaterOutputStream.write(byArray);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            deflaterOutputStream.finish();
            deflaterOutputStream.flush();
            deflaterOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n10 = byteArrayOutputStream.size();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        int n11 = 0;
        while (n11 + 72 < n10) {
            this.printer.output(byArray2, n11, 72);
            n11 += 72;
            this.printer.output((byte)10);
        }
        this.printer.output(byArray2, n11, n10 - n11);
        this.printer.output((byte)10);
        n5 = (int)(this.printer.getCurrentOffset() - l2 - 1L);
        this.output("endstream\nendobj");
        this.printer.storeObjectReference(++this.printer.objectNumber, this.printer.getCurrentOffset());
        this.output(this.printer.objectNumber + " 0 obj\n" + n5 + " \nendobj");
        this.printer.storeObjectReference(++this.printer.objectNumber, this.printer.getCurrentOffset());
        this.output(this.printer.objectNumber + " 0 obj\n<<");
        this.printer.writeResourcesDictionary();
        this.output(">>\nendobj");
    }

    protected boolean drawJavaImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver, boolean bl, boolean bl2, Int intVal) {
        int n6;
        n3 = -n3 - n5;
        boolean bl3 = false;
        if (this.printer.imageCache.containsKey(image)) {
            n6 = (Integer)this.printer.imageCache.get(image);
            bl3 = true;
        } else {
            n6 = this.printer.imageNumber;
        }
        if (bl3) {
            if (!bl2) {
                if (bl) {
                    this.outputImageDraw(n6, n2, n3, n4, n5);
                }
                this.printer.streamInfo.imagePresent = true;
                Integer n7 = new Integer(n6);
                if (!this.printer.streamInfo.imageList.contains(n7)) {
                    this.printer.streamInfo.imageList.add(n7);
                    this.printer.streamInfo.xObjectList.add(this.printer.docImageList.get(n6));
                }
            }
            return true;
        }
        int n8 = image.getWidth(null);
        int n9 = image.getHeight(null);
        int[] nArray = new int[n8 * n9];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n8, n9, nArray, 0, n8);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return false;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return false;
        }
        if (bl) {
            this.outputImageDraw(n6, n2, n3, n4, n5);
        }
        Integer n10 = new Integer(n6);
        if (!bl2) {
            this.printer.imageCache.put(image, n10);
        }
        this.printer.streamInfo.imageList.add(n10);
        int n11 = ++this.printer.objectNumber;
        Integer n12 = new Integer(n11);
        this.printer.docImageList.add(n12);
        this.printer.streamInfo.xObjectList.add(n12);
        if (bl2 && intVal != null) {
            intVal.value = n11;
        }
        this.printer.switchToNewStream();
        this.outputImageXObjectDictionary(n11, n8, n9, pixelGrabber, nArray, bl2, intVal);
        this.printer.switchBackToOldStream();
        return true;
    }

    protected void outputImageDraw(int n2, double d2, double d3, double d4, double d5) {
        this.output("q");
        this.output(d4 + " 0 0 " + d5 + " " + d2 + " " + d3 + " cm");
        this.output("0 0 1 1 re W n");
        this.output("/Im" + n2 + " Do");
        this.output("Q");
    }

    protected String octal3(char c2) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(Integer.toOctalString(c2));
        for (int i2 = n2 = stringBuffer.length(); i2 < 3; ++i2) {
            stringBuffer.insert(0, 0);
        }
        stringBuffer.insert(0, '\\');
        return stringBuffer.toString();
    }

    protected class Int {
        int value = -1;

        protected Int() {
        }
    }
}

