/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.FontParser;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.IOException;
import java.io.InputStream;
import java.text.CharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class FontBase
extends Font {
    protected static int DEFAULT_FONT_SIZE = 12;
    protected static char REPLACEMENT_CHARACTER = (char)95;

    public FontBase(String string, int n2, int n3) {
        super(string, n2, n3);
    }

    private static void loadFonts(FontParser fontParser, String string, String string2, Hashtable hashtable) throws IOException {
        String string3 = string2.toLowerCase();
        InputStream inputStream = FontBase.class.getResourceAsStream(string);
        if (inputStream == null) {
            throw new RuntimeException("Font archive not found: " + string);
        }
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!zipEntry.getName().toLowerCase().endsWith(string3)) continue;
            Vector vector = fontParser.parse(zipInputStream);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Font font = (Font)enumeration.nextElement();
                hashtable.put(font.getName().trim(), font);
            }
            zipInputStream.closeEntry();
        }
        zipInputStream.close();
    }

    public static Font getFont(String string) {
        return FontBase.decode(string);
    }

    public static Font getFont(String string, Font font) {
        return FontBase.decode(string);
    }

    protected static Font[] getFonts(FontParser fontParser, String string, String string2, Hashtable hashtable, boolean bl) {
        if (!bl) {
            try {
                FontBase.loadFonts(fontParser, string, string2, hashtable);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
        Font[] fontArray = new Font[hashtable.size()];
        int n2 = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            fontArray[n2++] = (Font)enumeration.nextElement();
        }
        return fontArray;
    }

    public static String getDecodeString(String string, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = FontBase.getStyleString(n2);
        if (!string2.equals("")) {
            stringBuffer.append(string2);
        }
        stringBuffer.append("-");
        stringBuffer.append(n3);
        return stringBuffer.toString();
    }

    protected static String getStyleString(int n2) {
        String string = "";
        if (n2 == 3) {
            string = "-BoldItalic";
        } else if (n2 == 1) {
            string = "-Bold";
        } else if (n2 == 2) {
            string = "-Italic";
        }
        return string;
    }

    public static Font deriveFont(Font font, int n2, float f2) {
        return font.deriveFont(n2, f2);
    }

    public static Font deriveFont(Font font, int n2) {
        return font.deriveFont(n2);
    }

    public static Font deriveFont(Font font, float f2) {
        return font.deriveFont(f2);
    }

    public static float getSize2D(Font font) {
        return font.getSize2D();
    }

    public static GlyphVector createGlyphVector(Font font, FontRenderContext fontRenderContext, String string) {
        return font.createGlyphVector(fontRenderContext, string);
    }

    public static GlyphVector createGlyphVector(Font font, FontRenderContext fontRenderContext, char[] cArray) {
        return font.createGlyphVector(fontRenderContext, cArray);
    }

    public static GlyphVector createGlyphVector(Font font, FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        return font.createGlyphVector(fontRenderContext, characterIterator);
    }
}

