/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid.customizer;

import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.higrid.NodeCellFormat;
import com.klg.jclass.higrid.RowFormat;
import com.klg.jclass.higrid.SortData;
import com.klg.jclass.higrid.beans.JCHiGridConverter;
import com.klg.jclass.higrid.beans.JCHiGridEvent;
import com.klg.jclass.higrid.beans.JCHiGridNode;
import com.klg.jclass.higrid.customizer.ChooserDialog;
import com.klg.jclass.higrid.customizer.ChooserDialogParent;
import com.klg.jclass.higrid.customizer.ColorEditor;
import com.klg.jclass.higrid.customizer.FormatPage;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.swing.JCGridLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SectionsPage
extends FormatPage
implements ActionListener,
ItemListener,
ChooserDialogParent {
    JButton btnRetrieveFields;
    JButton btnClearFormat;
    JButton btnRetrieveAllFields;
    JButton btnClearAllFormat;
    JCheckBox[] showing;
    JTextField sortDataColumn;
    JButton sortDataColumnButton;
    JComboBox sortDataDirection;
    ColorEditor nodeIndicatorForegroundColor;
    static String[] labels = new String[]{"Header", "Footer", "Before Details", "After Details"};
    static int[] showSections = new int[]{0, 4, 1, 3};
    static int NUM_SHOWING = 4;
    transient Frame frame;
    transient boolean useOwnFrame;
    transient Vector columnVector;
    transient int columnIndex;
    transient boolean sortDataChanged;
    transient boolean firstTimeFlag = true;
    transient boolean showingCheckboxes;

    public SectionsPage() {
        super(LocaleBundle.string("Sections"));
        this.init();
    }

    public void init() {
        this.setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(LocaleBundle.string("Show")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 5.0;
        this.showing = new JCheckBox[NUM_SHOWING];
        int n2 = 0;
        while (n2 < NUM_SHOWING) {
            gridBagConstraints.gridy = n2;
            gridBagConstraints.insets = new Insets(0, 5, n2 + 1 == NUM_SHOWING ? 5 : 0, 0);
            this.showing[n2] = new JCheckBox(LocaleBundle.string(labels[n2]));
            jPanel.add((Component)this.showing[n2], gridBagConstraints);
            this.showing[n2].addItemListener(this);
            ++n2;
        }
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (SectionsPage.this.isInitializing()) {
                    return;
                }
                SectionsPage.this.nodeIndicatorForegroundColor.checkColorSource(focusEvent.getSource());
                SectionsPage.this.valueChanged();
            }
        };
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (SectionsPage.this.isInitializing()) {
                    return;
                }
                SectionsPage.this.nodeIndicatorForegroundColor.checkColorSource(itemEvent.getSource());
                SectionsPage.this.valueChanged();
            }
        };
        this.nodeIndicatorForegroundColor = new ColorEditor(itemListener, this, focusAdapter, LocaleBundle.string("NodeIndicatorFgColort"), false);
        String string = new String(LocaleBundle.string("ChoiceStringNone"));
        this.sortDataColumn = new JTextField(string, 16);
        this.sortDataColumnButton = new JButton("...");
        this.sortDataDirection = new JComboBox();
        JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
        JLabel jLabel = new JLabel(LocaleBundle.string("SortDataColumn"));
        JLabel jLabel2 = new JLabel(LocaleBundle.string("SortDataDirection"));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel(new BorderLayout());
        this.btnRetrieveFields = new JButton(LocaleBundle.string("Retrieve Fields"));
        this.btnClearFormat = new JButton(LocaleBundle.string("Clear Format"));
        this.btnRetrieveAllFields = new JButton(LocaleBundle.string("Retrieve Fields"));
        this.btnClearAllFormat = new JButton(LocaleBundle.string("Clear Format"));
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(new TitledBorder(LocaleBundle.string("DefaultSortData")));
        JPanel jPanel9 = new JPanel();
        jPanel9.setBorder(new TitledBorder(LocaleBundle.string("Current Level")));
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(new TitledBorder(LocaleBundle.string("All Levels")));
        this.sortDataColumn.setEditable(false);
        this.sortDataColumnButton.addActionListener(this);
        String[] stringArray = JCHiGridConverter.getSortDataDirectionStrings();
        int n3 = 0;
        while (n3 < stringArray.length) {
            this.sortDataDirection.addItem(stringArray[n3]);
            ++n3;
        }
        this.sortDataDirection.addItemListener(this);
        jPanel8.setLayout(new JCGridLayout(0, 2, 5, 5));
        jPanel2.add((Component)this.sortDataColumn, "Center");
        jPanel2.add((Component)this.sortDataColumnButton, "East");
        jPanel8.add(jLabel);
        jPanel8.add(jPanel2);
        jPanel8.add(jLabel2);
        jPanel8.add(this.sortDataDirection);
        jPanel3.add((Component)jPanel, "North");
        jPanel4.add((Component)this.nodeIndicatorForegroundColor, "North");
        jPanel5.add((Component)jPanel4, "North");
        jPanel5.add((Component)jPanel8, "South");
        jPanel3.add((Component)jPanel5, "South");
        this.btnRetrieveFields.addActionListener(this);
        this.btnClearFormat.addActionListener(this);
        this.btnRetrieveAllFields.addActionListener(this);
        this.btnClearAllFormat.addActionListener(this);
        jPanel9.setLayout(new FlowLayout());
        jPanel10.setLayout(new FlowLayout());
        jPanel9.add(this.btnRetrieveFields);
        jPanel9.add(this.btnClearFormat);
        jPanel10.add(this.btnRetrieveAllFields);
        jPanel10.add(this.btnClearAllFormat);
        jPanel6.setLayout(new GridLayout(2, 1));
        jPanel6.add(jPanel9);
        jPanel6.add(jPanel10);
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)jPanel3, "North");
        jPanel7.add((Component)jPanel6, "South");
        this.add(jPanel7);
    }

    public void setJCHiGridNode(JCHiGridNode jCHiGridNode) {
        if (this.firstTime(jCHiGridNode)) {
            this.clearFormat();
        }
        this.showValue();
    }

    private boolean firstTime(JCHiGridNode jCHiGridNode) {
        if (this.firstTimeFlag) {
            this.firstTimeFlag = false;
            if (jCHiGridNode == null) {
                return true;
            }
            Object var2_2 = null;
            Vector vector = jCHiGridNode.getRowFormat(2).getIndicatorFormats();
            if (vector == null) {
                return true;
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CellFormat cellFormat = (CellFormat)enumeration.nextElement();
                if (!(cellFormat instanceof NodeCellFormat)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    void clearFormat() {
        this.editor.resetRecordAndHeader(this.getJCHiGridNode(), true, true);
        this.getJCHiGridNode().getGridProperties().fireJCHiGridEvent(new JCHiGridEvent((Object)this.getJCHiGridNode().getGridProperties(), this.getJCHiGridNode()));
    }

    void retrieveFields() {
        this.editor.resetRecordAndHeader(this.getJCHiGridNode(), false, false);
        this.getJCHiGridNode().setChanged();
        this.getJCHiGridNode().getGridProperties().fireJCHiGridEvent(new JCHiGridEvent((Object)this.getJCHiGridNode().getGridProperties(), this.getJCHiGridNode()));
    }

    void clearAllFormat() {
        this.editor.clearAllFormat();
        this.getJCHiGridNode().getGridProperties().fireJCHiGridEvent(new JCHiGridEvent((Object)this.getJCHiGridNode().getGridProperties(), this.getJCHiGridNode()));
    }

    void retrieveAllFields() {
        this.editor.retrieveAllFields();
        this.getJCHiGridNode().setChanged();
        this.getJCHiGridNode().getGridProperties().fireJCHiGridEvent(new JCHiGridEvent((Object)this.getJCHiGridNode().getGridProperties(), this.getJCHiGridNode()));
    }

    public void valueChanged() {
        JCHiGridNode jCHiGridNode = this.getJCHiGridNode();
        int n2 = 0;
        while (n2 < NUM_SHOWING) {
            jCHiGridNode.setSectionShowing(showSections[n2], this.showing[n2].isSelected());
            ++n2;
        }
        Color color = this.nodeIndicatorForegroundColor.getColor();
        if (!color.equals(this.getNodeIndicatorForegroundColor())) {
            this.setNodeIndicatorForegroundColor(color);
            this.getJCHiGridNode().setChanged();
        }
        String string = (String)this.sortDataDirection.getSelectedItem();
        JCTypeConverter jCTypeConverter = new JCTypeConverter();
        int n3 = JCHiGridConverter.toSortDataDirection(jCTypeConverter, string, 0);
        if (jCHiGridNode.getDefaultSortData() != null && jCHiGridNode.getDefaultSortData().getDirection() != n3) {
            this.sortDataChanged = true;
        }
        if (this.sortDataChanged) {
            this.sortDataChanged = false;
            SortData sortData = null;
            sortData = this.columnIndex < 1 || this.columnVector == null ? new SortData("", 0) : new SortData((String)this.columnVector.elementAt(this.columnIndex), n3);
            jCHiGridNode.setDefaultSortData(sortData);
        }
        this.getJCHiGridNode().getGridProperties().fireJCHiGridEvent(new JCHiGridEvent((Object)this.getJCHiGridNode().getGridProperties(), this.getJCHiGridNode()));
    }

    public void showValue() {
        SortData sortData;
        JCHiGridNode jCHiGridNode = this.getJCHiGridNode();
        this.showingCheckboxes = true;
        int n2 = 0;
        while (n2 < NUM_SHOWING) {
            this.showing[n2].setSelected(jCHiGridNode.isSectionShowing(showSections[n2]));
            ++n2;
        }
        this.showingCheckboxes = false;
        Color color = this.getNodeIndicatorForegroundColor();
        if (color != null) {
            this.nodeIndicatorForegroundColor.selectColor(color);
        }
        if ((sortData = jCHiGridNode.getDefaultSortData()) == null) {
            sortData = new SortData("", 0);
            jCHiGridNode.setDefaultSortData(sortData);
        }
        String string = sortData.getColumnName();
        boolean bl = true;
        if (string == null || string.length() == 0) {
            string = new String(LocaleBundle.string("ChoiceStringNone"));
            bl = false;
        }
        this.sortDataColumn.setText(string);
        this.getChoiceList();
        this.columnIndex = this.columnVector.indexOf(string);
        int n3 = sortData.getDirection();
        int n4 = -1;
        if (string.length() > 0) {
            int n5 = 0;
            while (n5 < JCHiGridConverter.sortDataDirectionStrings.length) {
                if (n3 == JCHiGridConverter.sortDataDirectionValues[n5]) {
                    n4 = n5;
                    break;
                }
                ++n5;
            }
        }
        n4 = Math.max(0, n4);
        this.sortDataDirection.setSelectedIndex(n4);
        this.sortDataDirection.setEnabled(bl);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isInitializing()) {
            return;
        }
        if (this.showingCheckboxes) {
            return;
        }
        this.valueChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isInitializing()) {
            return;
        }
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.equals(this.btnRetrieveFields)) {
                this.retrieveFields();
            } else if (jButton.equals(this.btnClearFormat)) {
                this.clearFormat();
            } else if (jButton.equals(this.btnRetrieveAllFields)) {
                this.retrieveAllFields();
            } else if (jButton.equals(this.btnClearAllFormat)) {
                this.clearAllFormat();
            } else if (jButton.equals(this.sortDataColumnButton)) {
                this.getSortDataColumnField();
            }
        }
        this.nodeIndicatorForegroundColor.checkColorSource(actionEvent.getSource());
        this.valueChanged();
    }

    void setNodeIndicatorForegroundColor(Color color) {
        JCHiGridNode jCHiGridNode = this.getJCHiGridNode();
        if (jCHiGridNode == null || color == null) {
            return;
        }
        if (color.equals(this.getNodeIndicatorForegroundColor())) {
            return;
        }
        NodeCellFormat nodeCellFormat = null;
        int n2 = 0;
        while (n2 < 5) {
            Vector vector = jCHiGridNode.getRowFormat(n2).getIndicatorFormats();
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    CellFormat cellFormat = (CellFormat)enumeration.nextElement();
                    if (!(cellFormat instanceof NodeCellFormat)) continue;
                    nodeCellFormat = (NodeCellFormat)cellFormat;
                    nodeCellFormat.setForeground(color);
                    break;
                }
            }
            ++n2;
        }
    }

    Color getNodeIndicatorForegroundColor() {
        Color color = null;
        JCHiGridNode jCHiGridNode = this.getJCHiGridNode();
        if (jCHiGridNode == null) {
            return color;
        }
        NodeCellFormat nodeCellFormat = null;
        Vector vector = jCHiGridNode.getRowFormat(2).getIndicatorFormats();
        if (vector == null) {
            return color;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (!(cellFormat instanceof NodeCellFormat)) continue;
            nodeCellFormat = (NodeCellFormat)cellFormat;
            color = nodeCellFormat.getForeground();
            break;
        }
        return color;
    }

    void getSortDataColumnField() {
        if (this.editor == null) {
            return;
        }
        ChooserDialog chooserDialog = new ChooserDialog(this);
        chooserDialog.show();
        if (this.useOwnFrame) {
            this.useOwnFrame = false;
            this.frame.dispose();
        }
    }

    public Frame getFrame() {
        return null;
    }

    public String getTitle() {
        return LocaleBundle.string("ColumnChooser");
    }

    public Vector getChoiceList() {
        RowFormat rowFormat = this.getJCHiGridNode().getRowFormat(2);
        Vector vector = rowFormat.getDataFormats();
        this.columnVector = new Vector();
        if (vector != null) {
            this.columnVector.addElement(LocaleBundle.string("SortDataColumnNone"));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CellFormat cellFormat = (CellFormat)enumeration.nextElement();
                String string = new String(cellFormat.getName());
                this.columnVector.addElement(string);
            }
        }
        return this.columnVector;
    }

    public void choiceSelected(int n2) {
        this.columnIndex = n2;
        this.sortDataChanged = true;
        if (n2 < 0) {
            return;
        }
        this.sortDataColumn.setText(n2 == 0 ? LocaleBundle.string("ChoiceStringNone") : (String)this.columnVector.elementAt(n2));
    }
}

