/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid.customizer;

import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.SummaryColumn;
import com.klg.jclass.higrid.beans.JCHiGridNode;
import com.klg.jclass.higrid.customizer.CellColorPage;
import com.klg.jclass.higrid.customizer.CellEditPage;
import com.klg.jclass.higrid.customizer.CellFontPage;
import com.klg.jclass.higrid.customizer.CellFormatPage;
import com.klg.jclass.higrid.customizer.CellGeneralPage;
import com.klg.jclass.higrid.customizer.CellSummaryColumnPage;
import com.klg.jclass.higrid.customizer.GridPropertiesEditor;
import javax.swing.JTabbedPane;

public class CellTabs
extends JTabbedPane {
    private static final boolean TRACE = false;
    public static final int CELL_GENERAL_PAGE = 0;
    public static final int CELL_FONT_PAGE = 1;
    public static final int CELL_COLOR_PAGE = 2;
    public static final int CELL_EDIT_PAGE = 3;
    public static final int CELL_SUMMARY_COLUMN_PAGE = 4;
    public static final int NUM_OF_PAGES = 5;
    static CellFormatPage[] pages;
    static int[] pagesHeader;
    static int[] pagesRecord;
    static int[] pagesSummary;
    JCHiGridNode node;
    int section;

    public CellTabs(int n2) {
        this.section = n2;
        this.init();
    }

    public void init() {
        if (pages == null) {
            pages = new CellFormatPage[5];
            CellTabs.pages[0] = new CellGeneralPage();
            CellTabs.pages[1] = new CellFontPage();
            CellTabs.pages[2] = new CellColorPage();
            CellTabs.pages[3] = new CellEditPage();
            CellTabs.pages[4] = new CellSummaryColumnPage();
            int n2 = 0;
            while (n2 < pages.length) {
                try {
                    CellFormatPage cellFormatPage = pages[n2];
                    this.addTab(cellFormatPage.getPageName(), cellFormatPage);
                    this.setEnabledAt(n2, false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n2;
            }
        }
        if (this.getTabCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void setEditor(GridPropertiesEditor gridPropertiesEditor) {
        int n2 = 0;
        while (n2 < pages.length) {
            pages[n2].setEditor(gridPropertiesEditor);
            ++n2;
        }
    }

    public void setJCHiGridNode(JCHiGridNode jCHiGridNode, CellFormat cellFormat, SummaryColumn summaryColumn) {
        this.node = jCHiGridNode;
        CellFormatPage[] cellFormatPageArray = this.getCurrentPages();
        int n2 = 0;
        while (n2 < cellFormatPageArray.length) {
            cellFormatPageArray[n2].init(jCHiGridNode, cellFormat, summaryColumn);
            ++n2;
        }
    }

    public void setSelectedColumn(CellFormat cellFormat, SummaryColumn summaryColumn) {
        if (cellFormat == null) {
            this.disableAllTabs();
        } else {
            this.enableTabs();
        }
        CellFormatPage[] cellFormatPageArray = this.getCurrentPages();
        int n2 = 0;
        while (n2 < cellFormatPageArray.length) {
            boolean bl = cellFormatPageArray[n2].isInitializing();
            cellFormatPageArray[n2].setInitializing(true);
            cellFormatPageArray[n2].setSelectedColumn(cellFormat, summaryColumn);
            cellFormatPageArray[n2].setInitializing(bl);
            ++n2;
        }
    }

    public void setSection(int n2) {
        if (this.section == n2) {
            return;
        }
        this.section = n2;
        this.updateTabs();
    }

    private int[] getCurrentPageIndices() {
        int[] nArray = null;
        switch (this.section) {
            case 0: {
                nArray = pagesHeader;
                break;
            }
            case 2: {
                nArray = pagesRecord;
                break;
            }
            default: {
                nArray = pagesSummary;
            }
        }
        return nArray;
    }

    private CellFormatPage[] getCurrentPages() {
        int[] nArray = this.getCurrentPageIndices();
        int n2 = nArray.length;
        CellFormatPage[] cellFormatPageArray = new CellFormatPage[n2];
        int n3 = 0;
        while (n3 < nArray.length) {
            cellFormatPageArray[n3] = pages[nArray[n3]];
            ++n3;
        }
        return cellFormatPageArray;
    }

    private void updateTabs() {
        CellFormatPage[] cellFormatPageArray = this.getCurrentPages();
        int n2 = 0;
        while (n2 < cellFormatPageArray.length) {
            try {
                CellFormatPage cellFormatPage = cellFormatPageArray[n2];
                cellFormatPage.init(this.section);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        this.enableTabs();
        if (this.getTabCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    private void enableTabs() {
        if (this.getTabCount() > 0) {
            int n2 = 0;
            while (n2 < pages.length) {
                this.setEnabledAt(n2, this.isTabUsed(n2));
                if (this.getComponentAt(n2) != null) {
                    this.getComponentAt(n2).setEnabled(this.isTabUsed(n2));
                }
                ++n2;
            }
        }
    }

    public void disableAllTabs() {
        if (this.getTabCount() > 0) {
            int n2 = 0;
            while (n2 < pages.length) {
                this.setEnabledAt(n2, false);
                if (this.getComponentAt(n2) != null) {
                    this.getComponentAt(n2).setEnabled(false);
                }
                ++n2;
            }
        }
    }

    private boolean isTabUsed(int n2) {
        boolean bl = false;
        int[] nArray = this.getCurrentPageIndices();
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] == n2) {
                bl = true;
                break;
            }
            ++n3;
        }
        return bl;
    }

    static {
        pagesHeader = new int[]{0, 1, 2};
        pagesRecord = new int[]{0, 1, 2, 3};
        pagesSummary = new int[]{0, 1, 2, 4};
    }
}

