/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid.customizer;

import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.higrid.beans.JCHiGridConverter;
import com.klg.jclass.higrid.beans.JCHiGridEvent;
import com.klg.jclass.higrid.beans.JCHiGridNode;
import com.klg.jclass.higrid.customizer.ColorEditor;
import com.klg.jclass.higrid.customizer.FontEditor;
import com.klg.jclass.higrid.customizer.FormatPage;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.swing.JCGridLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class BaseLevelPage
extends FormatPage
implements ActionListener,
ItemListener {
    protected int section;
    JTextField height;
    JTextField borderInsets;
    JCheckBox allowHeightSizing;
    JComboBox borderStyle;
    JComboBox autoTraverse;
    JCheckBox repeatHeader;
    ColorEditor levelForegroundColor;
    ColorEditor levelBackgroundColor;
    FontEditor levelFontEditor;

    public BaseLevelPage(int n2) {
        super(LocaleBundle.string("Level"));
        this.init();
        this.section = n2;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(LocaleBundle.string("Font")));
        this.levelFontEditor = new FontEditor(this, true);
        jPanel.add(this.levelFontEditor);
        JLabel jLabel = new JLabel(LocaleBundle.string("Height"));
        JLabel jLabel2 = new JLabel("");
        JLabel jLabel3 = new JLabel("");
        JLabel jLabel4 = new JLabel("");
        JLabel jLabel5 = new JLabel(LocaleBundle.string("AutoTraverse"));
        this.height = new JTextField("", 15);
        this.allowHeightSizing = new JCheckBox(LocaleBundle.string("Allow Height Sizing"), true);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.borderInsets = new JTextField("", 15);
        this.borderStyle = new JComboBox();
        JLabel jLabel6 = new JLabel(LocaleBundle.string("Style"));
        JLabel jLabel7 = new JLabel(LocaleBundle.string("Insets"));
        this.autoTraverse = new JComboBox();
        String[] stringArray = JCHiGridConverter.getAutoTraverseStrings();
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.autoTraverse.addItem(stringArray[n2]);
            ++n2;
        }
        this.autoTraverse.addItemListener(this);
        this.repeatHeader = new JCheckBox(LocaleBundle.string("Repeat Header"), false);
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(new TitledBorder(LocaleBundle.string("Border")));
        jPanel2.setLayout(new JCGridLayout(0, 2, 5, 5));
        jPanel2.add(jLabel2);
        jPanel2.add(jPanel);
        jPanel2.add(jLabel);
        jPanel2.add(this.height);
        jPanel2.add(jLabel3);
        jPanel2.add(this.allowHeightSizing);
        jPanel2.add(jLabel5);
        jPanel2.add(this.autoTraverse);
        jPanel2.add(jLabel4);
        jPanel2.add(this.repeatHeader);
        this.height.addActionListener(this);
        this.allowHeightSizing.addItemListener(this);
        jPanel3.setLayout(new BorderLayout());
        jPanel6.setLayout(new JCGridLayout(0, 2, 5, 5));
        jPanel6.add(jLabel6);
        jPanel6.add(this.borderStyle);
        jPanel6.add(jLabel7);
        jPanel6.add(this.borderInsets);
        String[] stringArray2 = JCHiGridConverter.getRowFormatBorderStyleStrings();
        int n3 = 0;
        while (n3 < stringArray2.length) {
            this.borderStyle.addItem(stringArray2[n3]);
            ++n3;
        }
        this.borderInsets.addActionListener(this);
        this.allowHeightSizing.addItemListener(this);
        this.borderStyle.addItemListener(this);
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                BaseLevelPage.this.levelForegroundColor.checkColorSource(focusEvent.getSource());
                BaseLevelPage.this.levelBackgroundColor.checkColorSource(focusEvent.getSource());
                BaseLevelPage.this.valueChanged();
            }
        };
        this.levelForegroundColor = new ColorEditor(this, this, focusAdapter, LocaleBundle.string("ForegroundColor"), true);
        this.levelBackgroundColor = new ColorEditor(this, this, focusAdapter, LocaleBundle.string("BackgroundColor"), true);
        this.repeatHeader.addItemListener(this);
        jPanel3.add((Component)jPanel6, "North");
        jPanel4.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel4, "Center");
        jPanel4.add((Component)this.levelForegroundColor, "North");
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this.levelBackgroundColor, "North");
        jPanel4.add((Component)jPanel5, "Center");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "North");
        this.height.addFocusListener(focusAdapter);
        this.borderInsets.addFocusListener(focusAdapter);
    }

    public void setSection(int n2) {
        this.section = n2;
    }

    public void valueChanged() {
        String string = this.height.getText();
        int n2 = 0;
        try {
            n2 = new Integer(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getJCHiGridNode().setHeight(this.section, n2);
        this.getJCHiGridNode().setAllowHeightResizing(this.section, this.allowHeightSizing.isSelected());
        string = this.borderInsets.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[]{2, 2, 2, 2};
        int n3 = 0;
        while (n3 < 4) {
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    nArray[n3] = new Integer(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n3;
        }
        this.getJCHiGridNode().setBorderInsets(this.section, new Insets(nArray[0], nArray[1], nArray[2], nArray[3]));
        string = (String)this.borderStyle.getSelectedItem();
        JCTypeConverter jCTypeConverter = new JCTypeConverter();
        int n4 = JCHiGridConverter.toRowFormatBorderStyle(jCTypeConverter, string, 1);
        this.getJCHiGridNode().setBorderStyle(this.section, n4);
        Color color = this.levelForegroundColor.getColor();
        if (color != null) {
            this.getJCHiGridNode().setForeground(this.section, color);
        }
        if ((color = this.levelBackgroundColor.getColor()) != null) {
            this.getJCHiGridNode().setBackground(this.section, color);
        }
        this.getJCHiGridNode().setFont(this.section, this.levelFontEditor.getFontName(), this.levelFontEditor.getFontStyle(), this.levelFontEditor.getFontSize(), this.getFontMetrics(new Font(this.levelFontEditor.getFontName(), this.levelFontEditor.getFontStyle(), this.levelFontEditor.getFontSize())));
        if (this.section == 2) {
            string = (String)this.autoTraverse.getSelectedItem();
            this.getJCHiGridNode().setAutoTraverse(JCHiGridConverter.toAutoTraverse(jCTypeConverter, string, 0));
        }
        if (this.section == 0) {
            this.getJCHiGridNode().setRepeatHeader(this.repeatHeader.isSelected());
        }
        this.getJCHiGridNode().getGridProperties().fireJCHiGridEvent(new JCHiGridEvent((Object)this.getJCHiGridNode().getGridProperties(), this.getJCHiGridNode()));
    }

    public void showValue() {
        this.height.setText(new Integer(this.getJCHiGridNode().getHeight(this.section)).toString());
        this.allowHeightSizing.setSelected(this.getJCHiGridNode().getAllowHeightResizing(this.section));
        Insets insets = this.getJCHiGridNode().getBorderInsets(this.section);
        this.borderInsets.setText(new String(insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right));
        int n2 = this.getJCHiGridNode().getBorderStyle(this.section);
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n5 < JCHiGridConverter.rowFormatBorderStyleValues.length) {
            if (JCHiGridConverter.rowFormatBorderStyleValues[n5] == 1) {
                n4 = n5;
            }
            if (n2 == JCHiGridConverter.rowFormatBorderStyleValues[n5]) {
                n3 = n5;
                break;
            }
            ++n5;
        }
        if (n3 == -1) {
            n3 = n4;
        }
        this.borderStyle.setSelectedIndex(n3);
        if (this.section == 2) {
            n3 = 0;
            int n6 = this.getJCHiGridNode().getAutoTraverse();
            int n7 = 0;
            int n8 = 0;
            while (n8 < JCHiGridConverter.autoTraverseValues.length) {
                if (JCHiGridConverter.autoTraverseValues[n8] == 0) {
                    n7 = n8;
                }
                if (n6 == JCHiGridConverter.autoTraverseValues[n8]) {
                    n3 = n8;
                    break;
                }
                ++n8;
            }
            if (n3 == -1) {
                n3 = n7;
            }
            this.autoTraverse.setSelectedIndex(n3);
        } else if (this.section == 0) {
            this.repeatHeader.setSelected(this.getJCHiGridNode().isRepeatHeader());
        }
        this.levelForegroundColor.selectColor(this.getJCHiGridNode().getForeground(this.section));
        this.levelBackgroundColor.selectColor(this.getJCHiGridNode().getBackground(this.section));
        this.levelFontEditor.selectFont(this.getJCHiGridNode().getFontName(this.section), this.getJCHiGridNode().getFontStyle(this.section), this.getJCHiGridNode().getFontSize(this.section));
        this.autoTraverse.setEnabled(this.section == 2);
        this.repeatHeader.setEnabled(this.section == 0);
    }

    public void setJCHiGridNode(JCHiGridNode jCHiGridNode) {
        this.showValue();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isInitializing()) {
            return;
        }
        this.checkColorEditors(actionEvent.getSource());
        this.valueChanged();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isInitializing()) {
            return;
        }
        System.out.println("ItemEvent is " + itemEvent);
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        this.checkColorEditors(itemEvent.getSource());
        this.valueChanged();
    }

    void checkColorEditors(Object object) {
        if (this.levelForegroundColor.checkColorSource(object) || !this.levelBackgroundColor.checkColorSource(object)) {
            // empty if block
        }
    }
}

