/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.datasource.MetaDataModel;
import java.io.Serializable;

public class SummaryColumn
implements Serializable {
    static final long serialVersionUID = -4348474341309558899L;
    private int table;
    private String name;
    private int columnType;
    private int dataType;
    private int aggregateType;
    private String columnIdentifier;
    public static final int COLUMN_TYPE_UNKNOWN = 0;
    public static final int COLUMN_TYPE_LABEL = 1;
    public static final int COLUMN_TYPE_DATASOURCE = 2;
    public static final int COLUMN_TYPE_AGGREGATE = 3;
    public static final int COLUMN_TYPE_UNBOUND = 4;
    public static final int AGGREGATE_TYPE_NONE = 0;
    public static final int AGGREGATE_TYPE_COUNT = 1;
    public static final int AGGREGATE_TYPE_SUM = 2;
    public static final int AGGREGATE_TYPE_AVERAGE = 3;
    public static final int AGGREGATE_TYPE_MIN = 4;
    public static final int AGGREGATE_TYPE_MAX = 5;
    public static final int AGGREGATE_TYPE_FIRST = 6;
    public static final int AGGREGATE_TYPE_LAST = 7;

    public SummaryColumn(String string) {
        this.init(0, string, 1, 0, 1005);
    }

    public SummaryColumn(MetaDataModel metaDataModel, String string, int n2) {
        int n3 = 1005;
        try {
            n3 = metaDataModel.getJavaColumnType(string);
        }
        catch (Exception exception) {
            this.init(0, string, 1, 0, 1005);
            return;
        }
        if (n2 == 2) {
            this.init(metaDataModel.getMetaID(), string, n2, 0, n3);
        } else if (n2 == 3) {
            int n4 = this.getDefaultAggregateType(n3);
            this.init(metaDataModel.getMetaID(), string, n2, n4, n3);
        } else {
            this.init(0, string, 1, 0, 1005);
        }
    }

    public SummaryColumn(MetaDataModel metaDataModel, String string, int n2, int n3) {
        if (n2 != 3) {
            this.init(0, string, 1, 0, 1005);
            return;
        }
        int n4 = 1004;
        if (n3 != 1) {
            try {
                n4 = metaDataModel.getJavaColumnType(string);
            }
            catch (Exception exception) {
                this.init(0, string, 1, 0, 1005);
                return;
            }
        }
        this.init(metaDataModel.getMetaID(), string, n2, n3, n4);
    }

    public SummaryColumn(MetaDataModel metaDataModel, String string, int n2, int n3, int n4) {
        this.init(metaDataModel.getMetaID(), string, n2, n3, n4);
    }

    public SummaryColumn(int n2, String string, int n3, int n4, int n5) {
        this.init(n2, string, n3, n4, n5);
    }

    public void init(int n2, String string, int n3, int n4, int n5) {
        this.name = string;
        this.table = n2;
        this.columnType = n3;
        this.aggregateType = n4;
        this.dataType = n5;
        this.setIdentifier();
    }

    public int getDefaultAggregateType(int n2) {
        int n3 = 0;
        switch (n2) {
            case 1002: 
            case 1003: 
            case 1004: 
            case 1006: 
            case 1007: 
            case 1011: 
            case 1012: {
                n3 = 2;
                break;
            }
            default: {
                n3 = 1;
            }
        }
        return n3;
    }

    public String getIdentifier() {
        return this.columnIdentifier;
    }

    public void setIdentifier() {
        this.columnIdentifier = new String(this.name + "." + this.table + "." + this.columnType + "." + this.aggregateType);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = new String(string);
    }

    public int getTable() {
        return this.table;
    }

    public void setTable(int n2) {
        this.table = n2;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public void setColumnType(int n2) {
        this.columnType = n2;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int n2) {
        this.dataType = n2;
    }

    public int getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(int n2) {
        this.aggregateType = n2;
    }
}

