/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.JCComponentCellRenderer;
import com.klg.jclass.cell.JCLightCellRenderer;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.CellPosition;
import com.klg.jclass.higrid.CellStyle;
import com.klg.jclass.higrid.CellStyleModel;
import com.klg.jclass.higrid.EditStatus;
import com.klg.jclass.higrid.EditStatusCellFormat;
import com.klg.jclass.higrid.FormatNode;
import com.klg.jclass.higrid.HeaderFormat;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridBorder;
import com.klg.jclass.higrid.HiGridEditStatusRenderer;
import com.klg.jclass.higrid.HiGridErrorEvent;
import com.klg.jclass.higrid.HiGridException;
import com.klg.jclass.higrid.HiGridInternalData;
import com.klg.jclass.higrid.HiGridNodeRenderer;
import com.klg.jclass.higrid.HiGridRepaintEvent;
import com.klg.jclass.higrid.IndicatorCellFormat;
import com.klg.jclass.higrid.NodeCellFormat;
import com.klg.jclass.higrid.NodeStatus;
import com.klg.jclass.higrid.NullGraphics;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.RowTree;
import com.klg.jclass.higrid.SortData;
import com.klg.jclass.higrid.SortLabel;
import com.klg.jclass.higrid.SummaryDataTable;
import com.klg.jclass.util.JCEnvironment;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.CellRendererPane;

public abstract class RowFormat
implements Serializable {
    static final long serialVersionUID = 7179966897087512288L;
    private static final int USE_DEFAULT_HEIGHT_VALUE = -1;
    public static final int MIXED_BORDER_STYLES = -1;
    protected static final int ROW_SIZING_TOLERANCE = 8;
    protected static final int COLUMN_SIZING_TOLERANCE = 4;
    public static final int MIXED_STYLE = -1;
    public static final int MIXED_SIZE = -1;
    private int height = -1;
    private int width = 0;
    private boolean allowHeightSizing = true;
    private FormatNode parent = null;
    private Vector indicatorFormats = new Vector();
    private Vector dataFormats = new Vector();
    private transient MetaDataModel metaData = null;
    private int printRectOffset = 0;
    private int cachedPreferredHeight = -1;
    private static CellRendererPane rendererPane = new CellRendererPane();

    protected FormatNode getParent() {
        return this.parent;
    }

    protected void setParent(FormatNode formatNode) {
        this.parent = formatNode;
    }

    public int getHeight() {
        if (this.height == -1) {
            return this.getPreferredHeight();
        }
        return this.height;
    }

    public void setHeight(int n2) {
        Object object;
        this.height = n2;
        Enumeration enumeration = this.getIndicatorFormats().elements();
        while (enumeration.hasMoreElements()) {
            object = (CellFormat)enumeration.nextElement();
            ((CellFormat)object).rowHeightChanged();
        }
        object = this.getDataFormats().elements();
        while (object.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)object.nextElement();
            cellFormat.rowHeightChanged();
        }
    }

    public int getWidth() {
        return this.width;
    }

    protected void setWidth(int n2) {
        this.width = n2;
    }

    public MetaDataModel getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaDataModel metaDataModel) {
        this.metaData = metaDataModel;
    }

    public boolean isShowing() {
        return true;
    }

    public void setShowing(boolean bl) {
    }

    protected int getFirstVisibleCell() {
        if (this instanceof RecordFormat && !this.dataFormats.isEmpty()) {
            int n2 = 0;
            int n3 = this.dataFormats.size() - 1;
            while (n2 <= n3) {
                if (((CellFormat)this.dataFormats.elementAt(n2)).isShowing()) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    protected int getLastVisibleCell() {
        if (this instanceof RecordFormat && !this.dataFormats.isEmpty()) {
            int n2 = this.dataFormats.size() - 1;
            while (n2 >= 0) {
                if (((CellFormat)this.dataFormats.elementAt(n2)).isShowing()) {
                    return n2;
                }
                --n2;
            }
        }
        return -1;
    }

    public boolean getAllowHeightSizing() {
        return this.allowHeightSizing;
    }

    public void setAllowHeightSizing(boolean bl) {
        this.allowHeightSizing = bl;
    }

    public void setCellStyle(CellStyleModel cellStyleModel) {
        this.setIndicatorCellStyle(cellStyleModel);
        this.setDataCellStyle(cellStyleModel);
    }

    public void setIndicatorCellStyle(CellStyleModel cellStyleModel) {
        this.setCellStyle(cellStyleModel, this.getIndicatorFormats());
    }

    public void setDataCellStyle(CellStyleModel cellStyleModel) {
        this.setCellStyle(cellStyleModel, this.getDataFormats());
    }

    protected void setCellStyle(CellStyleModel cellStyleModel, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            cellFormat.copyFromCellStyle(cellStyleModel);
        }
    }

    public int getBorderStyle() {
        Object object;
        int n2 = -1;
        Enumeration enumeration = this.getIndicatorFormats().elements();
        while (enumeration.hasMoreElements()) {
            object = (CellFormat)enumeration.nextElement();
            if (n2 == -1) {
                n2 = ((CellStyle)object).getBorderStyle();
                continue;
            }
            if (n2 == ((CellStyle)object).getBorderStyle()) continue;
            return -1;
        }
        object = this.getDataFormats().elements();
        while (object.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)object.nextElement();
            if (n2 == -1) {
                n2 = cellFormat.getBorderStyle();
                continue;
            }
            if (n2 == cellFormat.getBorderStyle()) continue;
            return -1;
        }
        return n2;
    }

    public void setBorderStyle(int n2) {
        Object object;
        Enumeration enumeration = this.getIndicatorFormats().elements();
        while (enumeration.hasMoreElements()) {
            object = (CellFormat)enumeration.nextElement();
            ((CellStyle)object).setBorderStyle(n2);
        }
        object = this.getDataFormats().elements();
        while (object.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)object.nextElement();
            cellFormat.setBorderStyle(n2);
        }
    }

    public Insets getBorderInsets() {
        Object object;
        Insets insets = null;
        Insets insets2 = new Insets(2, 2, 2, 2);
        Enumeration enumeration = this.getIndicatorFormats().elements();
        while (enumeration.hasMoreElements()) {
            object = (CellFormat)enumeration.nextElement();
            if (insets == null) {
                insets = ((CellStyle)object).getBorderInsets();
                continue;
            }
            if (insets.equals(((CellStyle)object).getBorderInsets())) continue;
            return insets2;
        }
        object = this.getDataFormats().elements();
        while (object.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)object.nextElement();
            if (insets == null) {
                insets = cellFormat.getBorderInsets();
                continue;
            }
            if (insets.equals(cellFormat.getBorderInsets())) continue;
            return insets2;
        }
        if (insets == null) {
            insets = insets2;
        }
        return insets;
    }

    public void setBorderInsets(Insets insets) {
        Object object;
        Enumeration enumeration = this.getIndicatorFormats().elements();
        while (enumeration.hasMoreElements()) {
            object = (CellFormat)enumeration.nextElement();
            ((CellFormat)object).setBorderInsets(insets);
        }
        object = this.getDataFormats().elements();
        while (object.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)object.nextElement();
            cellFormat.setBorderInsets(insets);
        }
    }

    public Color getForeground() {
        Color color = null;
        Enumeration enumeration = this.getDataFormats().elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (color == null) {
                color = cellFormat.getForeground();
                continue;
            }
            if (color.equals(cellFormat.getForeground())) continue;
            return null;
        }
        return color;
    }

    public void setForeground(Color color) {
        if (color != null) {
            Enumeration enumeration = this.getDataFormats().elements();
            while (enumeration.hasMoreElements()) {
                CellFormat cellFormat = (CellFormat)enumeration.nextElement();
                cellFormat.setForeground(color);
            }
        }
    }

    public Color getBackground() {
        Color color = null;
        Enumeration enumeration = this.getDataFormats().elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (color == null) {
                color = cellFormat.getBackground();
                continue;
            }
            if (color.equals(cellFormat.getBackground())) continue;
            return null;
        }
        return color;
    }

    public void setBackground(Color color) {
        if (color != null) {
            Enumeration enumeration = this.getDataFormats().elements();
            while (enumeration.hasMoreElements()) {
                CellFormat cellFormat = (CellFormat)enumeration.nextElement();
                cellFormat.setBackground(color);
            }
        }
    }

    public String getFontName() {
        String string = null;
        Enumeration enumeration = this.getDataFormats().elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (string == null) {
                string = cellFormat.getFont().getName();
                continue;
            }
            if (string.equals(cellFormat.getFont().getName())) continue;
            return null;
        }
        return string;
    }

    public int getFontStyle() {
        int n2 = -1;
        Enumeration enumeration = this.getDataFormats().elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (n2 == -1) {
                n2 = cellFormat.getFont().getStyle();
                continue;
            }
            if (n2 == cellFormat.getFont().getStyle()) continue;
            return -1;
        }
        return n2;
    }

    public int getFontSize() {
        int n2 = -1;
        Enumeration enumeration = this.getDataFormats().elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (n2 == -1) {
                n2 = cellFormat.getFont().getSize();
                continue;
            }
            if (n2 == cellFormat.getFont().getSize()) continue;
            return -1;
        }
        return n2;
    }

    public void setFont(String string, int n2, int n3, FontMetrics fontMetrics) {
        if (string == null && n2 == -1 && n3 == -1) {
            return;
        }
        Font font = null;
        if (string != null && n2 != -1 && n3 != -1) {
            font = new Font(string, n2, n3);
        }
        Enumeration enumeration = this.getDataFormats().elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (font != null) {
                cellFormat.setFont(fontMetrics, font);
                continue;
            }
            cellFormat.setFont(fontMetrics, new Font(string == null ? cellFormat.getFont().getName() : string, n2 == -1 ? cellFormat.getFont().getStyle() : n2, n3 == -1 ? cellFormat.getFont().getSize() : n3));
        }
    }

    public Vector getIndicatorFormats() {
        return this.indicatorFormats;
    }

    public void setIndicatorFormats(Vector vector) {
        this.indicatorFormats = vector;
        this.computeSize(this.indicatorFormats);
        this.heightChanged();
    }

    public Vector getDataFormats() {
        return this.dataFormats;
    }

    public void setDataFormats(Vector vector) {
        this.dataFormats = vector;
        this.computeSize(this.dataFormats);
        this.heightChanged();
    }

    protected void setCellWidths(int n2) {
        Enumeration enumeration = this.getDataFormats().elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            cellFormat.setWidth(n2, true);
        }
    }

    protected void heightChanged() {
        this.cachedPreferredHeight = -1;
        this.setHeight(this.height);
    }

    public int getPreferredHeight() {
        if (this.cachedPreferredHeight == -1) {
            this.cachedPreferredHeight = this.calculatePreferredHeight();
        }
        return this.cachedPreferredHeight;
    }

    protected int calculatePreferredHeight() {
        Cloneable cloneable;
        Object object;
        int n2 = 0;
        Enumeration enumeration = this.getIndicatorFormats().elements();
        while (enumeration.hasMoreElements()) {
            object = (CellFormat)enumeration.nextElement();
            cloneable = ((CellFormat)object).getPreferredTotalArea();
            n2 = Math.max(n2, ((Rectangle)cloneable).height);
        }
        object = this.getDataFormats().elements();
        while (object.hasMoreElements()) {
            cloneable = (CellFormat)object.nextElement();
            if (!((CellFormat)cloneable).isShowing()) continue;
            Rectangle rectangle = ((CellFormat)cloneable).getPreferredTotalArea();
            n2 = Math.max(n2, rectangle.height);
        }
        return n2;
    }

    protected int getDataWidth() {
        int n2 = 0;
        Enumeration enumeration = this.getDataFormats().elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (!cellFormat.isShowing()) continue;
            n2 += cellFormat.getPreferredTotalArea().width;
        }
        return n2;
    }

    protected void computeWidth() {
        int n2 = 0;
        Enumeration enumeration = this.getIndicatorFormats().elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            n2 += cellFormat.getPreferredTotalArea().width;
        }
        this.setWidth(n2 += this.getDataWidth());
    }

    protected void computeSize(Vector vector) {
        this.getHeight();
        this.computeWidth();
    }

    protected int getTotalWidth(HiGrid hiGrid, FormatNode formatNode) {
        this.computeWidth();
        return this.getInitialLevelIndent(hiGrid, formatNode) + this.getWidth();
    }

    protected int getTotalPrintWidth(HiGrid hiGrid, FormatNode formatNode, int n2) {
        CellFormat cellFormat;
        Enumeration enumeration;
        int n3 = this.getInitialLevelIndent(hiGrid, formatNode);
        int n4 = 0;
        int n5 = 0;
        if (hiGrid.isDrawingFoldersAndConnections()) {
            enumeration = this.getIndicatorFormats().elements();
            while (enumeration.hasMoreElements()) {
                cellFormat = (CellFormat)enumeration.nextElement();
                n5 = cellFormat.getPreferredTotalArea().width;
                if (n3 + n5 > n2) {
                    n4 += n2;
                    n3 = n5;
                    continue;
                }
                n3 += n5;
            }
        }
        enumeration = this.getDataFormats().elements();
        while (enumeration.hasMoreElements()) {
            cellFormat = (CellFormat)enumeration.nextElement();
            if (!cellFormat.isShowing()) continue;
            n5 = cellFormat.getPreferredTotalArea().width;
            if (n3 + n5 > n2) {
                n4 += n2;
                n3 = n5;
                continue;
            }
            n3 += n5;
        }
        return n4 += n3;
    }

    protected int getNodeIndent(HiGrid hiGrid, Vector vector) {
        int n2 = hiGrid.getIndicatorIndex(vector, -10);
        CellFormat cellFormat = (CellFormat)vector.elementAt(n2);
        int n3 = cellFormat.getWidth() + cellFormat.getBorderInsets().left + cellFormat.getBorderInsets().right + cellFormat.getMarginInsets().left + cellFormat.getMarginInsets().right;
        return n3;
    }

    public int getInitialLevelIndent(HiGrid hiGrid, FormatNode formatNode) {
        if (hiGrid.isLevelIndented()) {
            int n2 = this.getNodeIndent(hiGrid, formatNode.getRecordFormat().getIndicatorFormats());
            return formatNode.getIndent() * n2;
        }
        return 0;
    }

    public int getIndicatorIndent(HiGrid hiGrid, FormatNode formatNode) {
        CellFormat cellFormat;
        int n2 = this.getNodeIndent(hiGrid, formatNode.getRecordFormat().getIndicatorFormats());
        int n3 = hiGrid.isLevelIndented() ? formatNode.getIndent() : 0;
        int n4 = (n3 + 1) * n2;
        int n5 = hiGrid.getIndicatorIndex(this.indicatorFormats, -11);
        if (n5 != -1 && (cellFormat = (CellFormat)this.indicatorFormats.elementAt(n5)).isShowing()) {
            n4 += cellFormat.getTotalArea().width;
        }
        return n4;
    }

    protected void nextRow(Graphics graphics, HiGrid hiGrid, RowNode rowNode) {
        if (graphics instanceof NullGraphics) {
            NullGraphics nullGraphics = (NullGraphics)graphics;
            if (nullGraphics.cell != null) {
                nullGraphics.cell.point.y += rowNode.getHeight();
            }
            nullGraphics.gridAreaRowsHeight += rowNode.getHeight();
        } else {
            graphics.translate(0, rowNode.getHeight());
        }
    }

    protected boolean shouldConnect(RowNode rowNode) {
        if (rowNode == null) {
            return false;
        }
        return !(rowNode.getRowFormat() instanceof HeaderFormat);
    }

    public void drawCells(Graphics graphics, HiGrid hiGrid, RowNode rowNode, Vector vector, Rectangle rectangle, Rectangle rectangle2) {
        DataTableModel dataTableModel = rowNode.getDataTableModel();
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        if (hiGrid.isPrinting()) {
            n4 = hiGrid.getPrintColumnPageIndex();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n5;
            int n6;
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (!cellFormat.isShowing()) continue;
            String string = cellFormat.getName();
            Rectangle rectangle3 = cellFormat.getTotalArea();
            n2 = rectangle3.width;
            graphics.setClip(rectangle3);
            if (hiGrid.isPrinting()) {
                int n7 = hiGrid.getPrintGrid().getPrintableWidth();
                n6 = n3 * n7;
                n5 = n6 + n7;
                this.printRectOffset += n2;
                bl = false;
                if (this.printRectOffset > n6 && this.printRectOffset <= n5) {
                    if (n3 == n4) {
                        bl = true;
                    }
                } else if (this.printRectOffset > n5) {
                    this.printRectOffset = n5;
                    if (n3 == n4) break;
                    this.printRectOffset += n2;
                    if (++n3 == n4) {
                        bl = true;
                    }
                }
                if (!bl) {
                    continue;
                }
            } else {
                boolean bl2 = bl = rectangle.x + n2 >= rectangle2.x && rectangle.x <= rectangle2.x + rectangle2.width;
            }
            if (bl) {
                JCCellRenderer jCCellRenderer = hiGrid.lookupTable.getCellRendererInstance(cellFormat.getCellRenderer());
                if (rowNode.getRowFormat() instanceof RecordFormat && string != null && !(cellFormat instanceof IndicatorCellFormat)) {
                    n6 = 1005;
                    MetaDataModel metaDataModel = rowNode.getFormatNode().getRecordFormat().getMetaData();
                    if (metaDataModel != null) {
                        try {
                            n6 = metaDataModel.getJavaColumnType(string);
                        }
                        catch (Exception exception) {
                            if (JCEnvironment.isDesignTime()) {
                                hiGrid.adviseClearAllFormats = true;
                            }
                            hiGrid.fireHiGridErrorEvent(new HiGridErrorEvent(hiGrid, exception));
                        }
                    }
                }
                Object object = null;
                if (cellFormat instanceof NodeCellFormat) {
                    if (jCCellRenderer == null || !(jCCellRenderer instanceof HiGridNodeRenderer)) {
                        cellFormat.setCellRenderer(hiGrid.lookupTable.getNodeRenderer().getClass());
                        jCCellRenderer = hiGrid.lookupTable.getCellRendererInstance(cellFormat.getCellRenderer());
                    }
                    if (jCCellRenderer instanceof HiGridNodeRenderer) {
                        n5 = rowNode.getState();
                        object = new NodeStatus(hiGrid, n5, hiGrid.getFolderIcon(n5));
                    }
                } else if (cellFormat instanceof EditStatusCellFormat) {
                    if (jCCellRenderer == null || !(jCCellRenderer instanceof HiGridEditStatusRenderer)) {
                        cellFormat.setCellRenderer(hiGrid.lookupTable.getEditStatusRenderer().getClass());
                        jCCellRenderer = hiGrid.lookupTable.getCellRendererInstance(cellFormat.getCellRenderer());
                    }
                    if (jCCellRenderer instanceof HiGridEditStatusRenderer && this instanceof RecordFormat) {
                        CellPosition cellPosition = hiGrid.getCurrentCell();
                        boolean bl3 = cellPosition == null ? false : cellPosition.row == rowNode;
                        object = new EditStatus(hiGrid, dataTableModel.getRowStatus(rowNode.getBookmark()), bl3, rowNode.getBookmark());
                    }
                } else if (this instanceof RecordFormat) {
                    try {
                        object = dataTableModel.getResultData(rowNode.getBookmark(), string);
                    }
                    catch (Exception exception) {
                        if (JCEnvironment.isDesignTime()) {
                            hiGrid.adviseClearAllFormats = true;
                        }
                    }
                } else {
                    object = this instanceof HeaderFormat ? this.getHeaderLabel(hiGrid, rowNode, cellFormat) : ((SummaryDataTable)((HiGridInternalData)dataTableModel.getInternalData(hiGrid)).getDataTable()).getResultData(hiGrid, dataTableModel, this, rowNode, string);
                }
                if (!(jCCellRenderer instanceof HiGridNodeRenderer)) {
                    RowFormat.prepareDrawingArea(graphics, cellFormat, rectangle3, rowNode.isSelected());
                }
                Point point = cellFormat.getTranslationOffset();
                Rectangle rectangle4 = cellFormat.getDrawingArea();
                if (jCCellRenderer instanceof JCLightCellRenderer) {
                    graphics.translate(point.x, point.y);
                    graphics.setClip(rectangle4);
                    ((JCLightCellRenderer)jCCellRenderer).draw(graphics, cellFormat, object, rowNode.isSelected());
                    graphics.translate(-point.x, -point.y);
                } else if (jCCellRenderer instanceof JCComponentCellRenderer) {
                    Component component = ((JCComponentCellRenderer)jCCellRenderer).getRendererComponent(cellFormat, object, rowNode.isSelected());
                    rendererPane.paintComponent(graphics, component, hiGrid, point.x, point.y, rectangle4.width, rectangle4.height, true);
                } else {
                    throw new HiGridException("Bad cell renderer: " + jCCellRenderer);
                }
            }
            rectangle.x += n2;
            graphics.translate(n2, 0);
        }
        graphics.setClip(-rectangle.x, 0, rectangle.width, rectangle.height);
    }

    public boolean draw(Graphics graphics, HiGrid hiGrid, RowNode rowNode) {
        if (graphics instanceof NullGraphics) {
            return this.nullDraw((NullGraphics)graphics, hiGrid, rowNode);
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (-rectangle.y > rectangle.height) {
            return false;
        }
        int n2 = this.getInitialLevelIndent(hiGrid, rowNode.getFormatNode());
        Rectangle rectangle2 = new Rectangle(0, 0, n2 + rowNode.getWidth(), rowNode.getHeight());
        Rectangle rectangle3 = rectangle2.intersection(rectangle);
        if (!rectangle3.isEmpty()) {
            int n3;
            int n4;
            hiGrid.fireHiGridRepaintEvent(new HiGridRepaintEvent(hiGrid, 1, rowNode, rectangle3));
            Rectangle rectangle4 = new Rectangle(0, 0, 0, rowNode.getHeight());
            int n5 = this.getNodeIndent(hiGrid, rowNode.getRowFormat().getIndicatorFormats());
            RowNode rowNode2 = rowNode;
            RowTree rowTree = hiGrid.getRowTree();
            boolean bl = hiGrid.isDrawingFoldersAndConnections();
            boolean bl2 = hiGrid.isConnectionsVisible() && bl && !hiGrid.isPrintingSubsequentColumnPages();
            boolean bl3 = !hiGrid.isPrintingSubsequentColumnPages();
            rectangle4.x += n2;
            int n6 = n4 = hiGrid.isLevelIndented() ? n5 : 0;
            if (rectangle4.x >= rectangle3.x && rectangle4.x <= rectangle3.x + rectangle3.width) {
                n3 = 0;
                while (n3 < rowNode.getFormatNode().getIndent()) {
                    rectangle4.x -= n4;
                    graphics.translate(rectangle4.x, 0);
                    if (rowTree.getNextUncle(rowNode2) != null && bl2) {
                        Vector vector = ((RowNode)rowNode2.getParent()).getRowFormat().getIndicatorFormats();
                        graphics.setColor(((CellFormat)vector.elementAt(hiGrid.getIndicatorIndex(vector, -10))).getForeground());
                        graphics.drawLine(n5 / 2, 0, n5 / 2, rowNode.getHeight());
                    }
                    rowNode2 = (RowNode)rowNode2.getParent();
                    graphics.translate(-rectangle4.x, 0);
                    ++n3;
                }
                rectangle4.x += n2;
            }
            n3 = 0;
            if (bl3) {
                graphics.translate(rectangle4.x, 0);
            } else {
                n3 = rectangle4.x;
            }
            int n7 = (rowNode.getHeight() - 1) / 2;
            if (bl2) {
                boolean bl4 = rowNode.getNextSibling() != null;
                Vector vector = rowNode.getRowFormat().getIndicatorFormats();
                graphics.setColor(((CellFormat)vector.elementAt(hiGrid.getIndicatorIndex(vector, -10))).getForeground());
                graphics.drawLine(n5 / 2, 0, n5 / 2, bl4 ? rowNode.getHeight() : n7);
                if (this.shouldConnect(rowNode)) {
                    graphics.drawLine(n5 / 2, n7, n5, n7);
                }
            }
            if (hiGrid.isPrinting()) {
                this.printRectOffset = rectangle4.x;
            }
            if (bl) {
                this.drawCells(graphics, hiGrid, rowNode, this.getIndicatorFormats(), rectangle4, rectangle3);
            }
            this.drawCells(graphics, hiGrid, rowNode, this.getDataFormats(), rectangle4, rectangle3);
            graphics.translate(-rectangle4.x + n3, 0);
            graphics.setClip(rectangle);
        }
        this.nextRow(graphics, hiGrid, rowNode);
        return true;
    }

    protected boolean nullDraw(NullGraphics nullGraphics, HiGrid hiGrid, RowNode rowNode) {
        if (nullGraphics.gridAreaRowsHeight > nullGraphics.gridAreaHeight) {
            return false;
        }
        if (nullGraphics.finishedOperation) {
            return false;
        }
        nullGraphics.fullyVisible = nullGraphics.gridAreaRowsHeight + rowNode.getHeight() <= nullGraphics.gridAreaHeight;
        switch (nullGraphics.operation) {
            case 3: {
                int n2 = rowNode.getHeight();
                if (nullGraphics.mouse.y >= n2) {
                    nullGraphics.mouse.y -= n2;
                    break;
                }
                nullGraphics.cell.row = rowNode;
                this.hitTest(nullGraphics, hiGrid, nullGraphics.cell.row);
                nullGraphics.finishedOperation = true;
                break;
            }
            case 1: 
            case 2: {
                if (nullGraphics.cell.row != rowNode) break;
                this.getXPosition(nullGraphics, hiGrid, rowNode, nullGraphics.operation);
                nullGraphics.cell.row = rowNode;
                nullGraphics.finishedOperation = true;
                break;
            }
            case 4: {
                if (nullGraphics.fullyVisible) {
                    ++nullGraphics.numberOfGridAreaRows;
                    break;
                }
                nullGraphics.finishedOperation = true;
                break;
            }
        }
        if (!nullGraphics.finishedOperation) {
            this.nextRow(nullGraphics, hiGrid, rowNode);
        }
        return true;
    }

    protected boolean findFromFormat(NullGraphics nullGraphics, Enumeration enumeration, int n2) {
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (cellFormat == nullGraphics.cell.format) {
                nullGraphics.cell.point.x = n2;
                nullGraphics.cell.columnIndex = n3;
                return true;
            }
            if (cellFormat.isShowing()) {
                n2 += cellFormat.getTotalArea().width;
            }
            ++n3;
        }
        return false;
    }

    protected void getXPosition(NullGraphics nullGraphics, HiGrid hiGrid, RowNode rowNode, int n2) {
        nullGraphics.cell.isIndicator = false;
        if (rowNode == null) {
            return;
        }
        int n3 = this.getInitialLevelIndent(hiGrid, rowNode.getFormatNode());
        Enumeration enumeration = this.getIndicatorFormats().elements();
        if (n2 == 2) {
            if (this.findFromFormat(nullGraphics, enumeration, n3)) {
                nullGraphics.cell.isIndicator = true;
            }
        } else if (n2 == 1) {
            int n4 = 0;
            while (enumeration.hasMoreElements()) {
                CellFormat cellFormat = (CellFormat)enumeration.nextElement();
                if (cellFormat.isShowing()) {
                    n3 += cellFormat.getTotalArea().width;
                }
                ++n4;
            }
            enumeration = this.getDataFormats().elements();
            this.findFromFormat(nullGraphics, enumeration, n3);
        }
    }

    protected int hitTestWithinRow(NullGraphics nullGraphics, HiGrid hiGrid, RowNode rowNode, Vector vector, int n2) {
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements() && nullGraphics.mouse.x > n2 && !bl) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (cellFormat.isShowing()) {
                int n4 = n2 + cellFormat.getTotalArea().width;
                if (nullGraphics.mouse.x >= n2 && nullGraphics.mouse.x < n4) {
                    if (!nullGraphics.overColumnDivider) {
                        // empty if block
                    }
                    nullGraphics.cell.format = cellFormat;
                    nullGraphics.cell.point.x = n2;
                    nullGraphics.cell.columnIndex = n3;
                    bl = true;
                }
                if (nullGraphics.mouse.x >= n4 - 4 && nullGraphics.mouse.x <= n4 + 4) {
                    nullGraphics.overColumnDivider = true;
                    nullGraphics.columnX = n4;
                    nullGraphics.columnIndex = n3;
                    nullGraphics.resizeFormat = cellFormat;
                    nullGraphics.cell.format = cellFormat;
                    nullGraphics.cell.point.x = n2;
                    bl = true;
                }
                n2 += cellFormat.getTotalArea().width;
            }
            ++n3;
        }
        if (bl) {
            n2 = -1;
        }
        return n2;
    }

    protected void checkForRowResizing(NullGraphics nullGraphics, RowNode rowNode) {
        int n2 = rowNode.getHeight() - nullGraphics.mouse.y;
        if (n2 < 8) {
            nullGraphics.overRowDivider = true;
            nullGraphics.rowYOffset = n2;
        }
    }

    public int getVisibleColumnCount() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.dataFormats.size()) {
            if (((CellFormat)this.dataFormats.elementAt(n3)).isShowing()) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public int getVisibleColumnIndex(int n2) {
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.dataFormats.size()) {
            if (((CellFormat)this.dataFormats.elementAt(n4)).isShowing()) {
                ++n3;
            }
            if (n4 >= n2) break;
            ++n4;
        }
        return n3;
    }

    public int getActualColumnIndex(int n2) {
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.dataFormats.size()) {
            ++n3;
            if (((CellFormat)this.dataFormats.elementAt(n4)).isShowing()) {
                --n2;
            }
            if (n2 < 0) break;
            ++n4;
        }
        return n3;
    }

    protected void hitTest(NullGraphics nullGraphics, HiGrid hiGrid, RowNode rowNode) {
        nullGraphics.cellLocation = 0;
        nullGraphics.cell.isIndicator = false;
        if (rowNode == null) {
            return;
        }
        int n2 = this.getInitialLevelIndent(hiGrid, rowNode.getFormatNode());
        n2 = this.hitTestWithinRow(nullGraphics, hiGrid, rowNode, this.getIndicatorFormats(), n2);
        if (n2 == -1) {
            nullGraphics.cellLocation = 1;
            nullGraphics.cell.isIndicator = true;
            if (nullGraphics.cell.columnIndex == hiGrid.getIndicatorIndex(rowNode.getFormatNode(), -10)) {
                if (rowNode.getRowFormat() instanceof RecordFormat) {
                    nullGraphics.overFolderIcon = true;
                }
            } else if (nullGraphics.cell.columnIndex == hiGrid.getIndicatorIndex(rowNode.getFormatNode(), -11)) {
                this.checkForRowResizing(nullGraphics, rowNode);
            }
        } else {
            n2 = this.hitTestWithinRow(nullGraphics, hiGrid, rowNode, this.getDataFormats(), n2);
            if (n2 == -1) {
                nullGraphics.cellLocation = 2;
                if (hiGrid.isRowHeightResizingAll()) {
                    this.checkForRowResizing(nullGraphics, rowNode);
                }
            }
        }
    }

    public static void prepareDrawingArea(Graphics graphics, CellFormat cellFormat, Rectangle rectangle, boolean bl) {
        Color color = bl ? cellFormat.getSelectedBackground() : cellFormat.getBackground();
        graphics.setColor(color);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(cellFormat.getForeground());
        HiGridBorder.draw(graphics, cellFormat.getBorderStyle(), cellFormat.getBorderInsets().left, 0, 0, rectangle.width, rectangle.height, color, cellFormat.getForeground());
    }

    public Object getHeaderLabel(HiGrid hiGrid, RowNode rowNode, CellFormat cellFormat) {
        SortData sortData;
        HiGridInternalData hiGridInternalData;
        SortLabel sortLabel = null;
        String string = cellFormat.getName();
        String string2 = cellFormat.getText();
        int n2 = 0;
        if (rowNode.getDataTableModel() != null && (hiGridInternalData = (HiGridInternalData)rowNode.getDataTableModel().getInternalData(hiGrid)) != null && (sortData = hiGridInternalData.getSortData()) != null && sortData.getColumnName().compareTo(string) == 0) {
            n2 = sortData.getDirection();
        }
        sortLabel = new SortLabel(string2, n2);
        return sortLabel;
    }

    public void createIndicatorFormats(HiGrid hiGrid) {
        Vector<CellFormat> vector = new Vector<CellFormat>(2);
        vector.addElement(this.createNodeFormat(hiGrid));
        vector.addElement(this.createEditStatus(hiGrid));
        this.setIndicatorFormats(vector);
    }

    protected CellFormat createEditStatus(HiGrid hiGrid) {
        EditStatusCellFormat editStatusCellFormat = new EditStatusCellFormat(hiGrid);
        editStatusCellFormat.setParent(this);
        if (hiGrid != null) {
            editStatusCellFormat.setFont(hiGrid.getFontMetrics(editStatusCellFormat.getFont()), editStatusCellFormat.getFont());
            editStatusCellFormat.setCellRenderer(hiGrid.lookupTable.getEditStatusRenderer().getClass());
            editStatusCellFormat.setWidth(hiGrid.getEditStatusWidth());
        } else {
            editStatusCellFormat.setWidth(20);
        }
        return editStatusCellFormat;
    }

    protected CellFormat createNodeFormat(HiGrid hiGrid) {
        NodeCellFormat nodeCellFormat = new NodeCellFormat(hiGrid);
        nodeCellFormat.setParent(this);
        if (hiGrid != null) {
            nodeCellFormat.setFont(hiGrid.getFontMetrics(nodeCellFormat.getFont()), nodeCellFormat.getFont());
            nodeCellFormat.setCellRenderer(hiGrid.lookupTable.getNodeRenderer().getClass());
            nodeCellFormat.setWidth(hiGrid.getNodeWidth());
        } else {
            nodeCellFormat.setWidth(20);
        }
        return nodeCellFormat;
    }
}

