/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.PrintGrid;
import com.klg.jclass.higrid.PrintGrid12;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.Walkable;
import java.awt.Graphics;
import java.awt.print.PageFormat;

class PrintWalk
implements Walkable {
    static final long serialVersionUID = 320638883999410839L;
    private PrintGrid printGrid;
    private HiGrid grid;
    private Graphics gc;
    private int printableHeight;
    private int printableWidth;
    private int height;
    private int currentPage;
    private RowNode lastRowNode;
    private boolean firstRowDrawn;
    private boolean stop;

    public PrintWalk(PrintGrid12 printGrid12, HiGrid hiGrid, PageFormat pageFormat) {
        this.printGrid = printGrid12;
        this.grid = hiGrid;
        this.height = 0;
        this.currentPage = 0;
        this.lastRowNode = null;
        this.firstRowDrawn = false;
        if (hiGrid == null || printGrid12 == null) {
            this.stop = true;
            return;
        }
        this.printableHeight = (int)pageFormat.getImageableHeight();
        this.printableWidth = (int)pageFormat.getImageableWidth();
        this.stop = false;
    }

    public boolean getDownward() {
        return true;
    }

    public boolean done() {
        return this.stop;
    }

    public void next(RowNode rowNode) {
        int n2 = rowNode.getHeight();
        if (this.firstRowDrawn && this.height + n2 > this.printableHeight) {
            this.lastRowNode = rowNode;
            this.stop = true;
        } else {
            this.height += n2;
            rowNode.draw(this.gc, this.grid);
            this.firstRowDrawn = true;
        }
    }

    public void previous(RowNode rowNode) {
    }

    public boolean find(RowNode rowNode) {
        return this.stop;
    }

    protected void init(Graphics graphics, int n2) {
        this.gc = graphics;
        this.currentPage = n2;
        this.lastRowNode = null;
        this.firstRowDrawn = false;
        this.height = 0;
        this.stop = false;
    }

    public RowNode getLastRowNode() {
        return this.lastRowNode;
    }

    public int getHeight() {
        return this.height;
    }
}

