/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.cell.EditorRendererRegistry;
import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.editors.JCStringCellEditor;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridEditStatusRenderer;
import com.klg.jclass.higrid.HiGridHeaderRenderer;
import com.klg.jclass.higrid.HiGridNodeRenderer;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JComponent;

public class LookupTable
implements Serializable {
    static final long serialVersionUID = -1273774710302779797L;
    protected HiGrid grid;
    protected Hashtable defaultRenderers = null;
    protected Hashtable defaultEditors = null;
    protected Hashtable runtimeRenderers = null;
    protected Hashtable runtimeEditors = null;
    protected HiGridEditStatusRenderer editStatusRenderer = null;
    protected HiGridNodeRenderer nodeRenderer = null;
    protected HiGridHeaderRenderer headerRenderer = null;
    static /* synthetic */ Class array$B;

    public LookupTable(HiGrid hiGrid) {
        this.grid = hiGrid;
        this.initDefaultRendererHashtable();
        this.initRuntimeRendererHashtable();
        this.initDefaultEditorHashtable();
        this.initRuntimeEditorHashtable();
    }

    public static Class getDefaultNodeRenderer() {
        try {
            return Class.forName("com.klg.jclass.higrid.DefaultNodeRenderer");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Class getDefaultEditStatusRenderer() {
        try {
            return Class.forName("com.klg.jclass.higrid.DefaultEditStatusRenderer");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Class getDefaultHeaderRenderer() {
        try {
            return Class.forName("com.klg.jclass.higrid.SortLabelCellRenderer");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public HiGridNodeRenderer getNodeRenderer() {
        return this.nodeRenderer;
    }

    public HiGridEditStatusRenderer getEditStatusRenderer() {
        return this.editStatusRenderer;
    }

    public HiGridHeaderRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setNodeRenderer(HiGridNodeRenderer hiGridNodeRenderer) {
        this.nodeRenderer = hiGridNodeRenderer;
        this.runtimeRenderers.put(hiGridNodeRenderer.getClass(), hiGridNodeRenderer);
    }

    public void setEditStatusRenderer(HiGridEditStatusRenderer hiGridEditStatusRenderer) {
        this.editStatusRenderer = hiGridEditStatusRenderer;
        this.runtimeRenderers.put(hiGridEditStatusRenderer.getClass(), hiGridEditStatusRenderer);
    }

    public void setHeaderRenderer(HiGridHeaderRenderer hiGridHeaderRenderer) {
        this.headerRenderer = hiGridHeaderRenderer;
        this.runtimeRenderers.put(hiGridHeaderRenderer.getClass(), hiGridHeaderRenderer);
    }

    protected void initDefaultRendererHashtable() {
        this.defaultRenderers = new Hashtable();
        this.setDefaultRenderer(1000);
        this.setDefaultRenderer(1001);
        this.setDefaultRenderer(1002);
        this.setDefaultRenderer(1003);
        this.setDefaultRenderer(1004);
        this.setDefaultRenderer(1005);
        this.setDefaultRenderer(1006);
        this.setDefaultRenderer(1007);
        this.setDefaultRenderer(1008);
        this.setDefaultRenderer(1009);
        this.setDefaultRenderer(1010);
        this.setDefaultRenderer(1011);
        this.setDefaultRenderer(1012);
        this.setDefaultRenderer(1013);
        this.setDefaultRenderer(1014);
    }

    protected void setDefaultRenderer(int n2) {
        try {
            this.defaultRenderers.put(new Integer(n2), Class.forName(LookupTable.getDefaultCellRendererName(n2)));
        }
        catch (Exception exception) {
            try {
                this.defaultRenderers.put(new Integer(n2), Class.forName(LookupTable.getAlternateCellRendererName(n2)));
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    protected void initRuntimeRendererHashtable() {
        this.runtimeRenderers = new Hashtable();
        try {
            this.setNodeRenderer((HiGridNodeRenderer)LookupTable.getDefaultNodeRenderer().newInstance());
            this.setEditStatusRenderer((HiGridEditStatusRenderer)LookupTable.getDefaultEditStatusRenderer().newInstance());
            this.setHeaderRenderer((HiGridHeaderRenderer)LookupTable.getDefaultHeaderRenderer().newInstance());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Hashtable getDefaultRenderersTable() {
        return this.defaultRenderers;
    }

    public Hashtable getRuntimeRenderersTable() {
        return this.runtimeRenderers;
    }

    public Class getDefaultCellRenderer(int n2) {
        return (Class)this.defaultRenderers.get(new Integer(n2));
    }

    protected JCCellRenderer getCellRendererInstance(Class clazz) {
        JCCellRenderer jCCellRenderer = null;
        try {
            Object v;
            if (clazz == null) {
                clazz = Class.forName("com.klg.jclass.cell.renderers.JCStringCellRenderer");
            }
            if ((v = this.runtimeRenderers.get(clazz)) == null || v instanceof Class) {
                jCCellRenderer = (JCCellRenderer)clazz.newInstance();
                this.runtimeRenderers.put(clazz, jCCellRenderer);
            } else {
                jCCellRenderer = (JCCellRenderer)v;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jCCellRenderer;
    }

    protected void initDefaultEditorHashtable() {
        this.defaultEditors = new Hashtable();
        this.setDefaultEditor(1000);
        this.setDefaultEditor(1001);
        this.setDefaultEditor(1002);
        this.setDefaultEditor(1003);
        this.setDefaultEditor(1004);
        this.setDefaultEditor(1005);
        this.setDefaultEditor(1006);
        this.setDefaultEditor(1007);
        this.setDefaultEditor(1008);
        this.setDefaultEditor(1009);
        this.setDefaultEditor(1010);
        this.setDefaultEditor(1011);
        this.setDefaultEditor(1012);
        this.setDefaultEditor(1013);
        this.setDefaultEditor(1014);
    }

    protected void setDefaultEditor(int n2) {
        try {
            this.defaultEditors.put(new Integer(n2), Class.forName(LookupTable.getDefaultCellEditorName(n2)));
        }
        catch (Exception exception) {
            try {
                this.defaultEditors.put(new Integer(n2), Class.forName(LookupTable.getAlternateCellEditorName(n2)));
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    protected void initRuntimeEditorHashtable() {
        this.runtimeEditors = new Hashtable();
        try {
            this.runtimeEditors.put(Class.forName("com.klg.jclass.cell.editors.JCStringCellEditor"), new JCStringCellEditor());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Hashtable getDefaultEditorsTable() {
        return this.defaultEditors;
    }

    public Hashtable getRuntimeEditorsTable() {
        return this.runtimeEditors;
    }

    public Class getDefaultCellEditor(int n2) {
        return (Class)this.defaultEditors.get(new Integer(n2));
    }

    protected JCCellEditor getCellEditorInstance(Class clazz) {
        Object object;
        JCCellEditor jCCellEditor = null;
        try {
            if (clazz == null) {
                clazz = Class.forName("com.klg.jclass.cell.editors.JCStringCellEditor");
            }
            if ((object = this.runtimeEditors.get(clazz)) == null || object instanceof Class) {
                jCCellEditor = (JCCellEditor)clazz.newInstance();
                this.runtimeEditors.put(clazz, jCCellEditor);
            } else {
                jCCellEditor = (JCCellEditor)object;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (jCCellEditor instanceof JComponent && ((JComponent)(object = (JComponent)((Object)jCCellEditor))).getBorder() != this.grid.getEditorBorder()) {
            ((JComponent)object).setBorder(this.grid.getEditorBorder());
        }
        return jCCellEditor;
    }

    public static String getCellRendererName(int n2) {
        String string = LookupTable.getDefaultCellRendererName(n2);
        if (string == null) {
            string = LookupTable.getAlternateCellRendererName(n2);
        }
        return string;
    }

    public static String getAlternateCellRendererName(int n2) {
        String string = null;
        switch (n2) {
            case 1001: 
            case 1008: 
            case 1009: 
            case 1014: {
                string = new String("com.klg.jclass.cell.renderers.JCStringCellRenderer");
                break;
            }
            case 1013: {
                string = new String("com.klg.jclass.cell.renderers.JCRawImageCellRenderer");
                break;
            }
            case 1002: 
            case 1003: {
                string = new String("com.klg.jclass.cell.renderers.JCStringCellRenderer");
                break;
            }
            case 1004: 
            case 1011: 
            case 1012: {
                string = new String("com.klg.jclass.cell.renderers.JCStringCellRenderer");
                break;
            }
            case 1000: {
                string = new String("com.klg.jclass.cell.renderers.JCCheckBoxCellRenderer");
                break;
            }
            case 1005: 
            case 1006: 
            case 1007: 
            case 1010: {
                string = new String("com.klg.jclass.cell.renderers.JCStringCellRenderer");
                break;
            }
            default: {
                string = new String("com.klg.jclass.cell.renderers.JCStringCellRenderer");
            }
        }
        return string;
    }

    public static String getDefaultCellRendererName(int n2) {
        String string = null;
        try {
            switch (n2) {
                case 1000: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.lang.Boolean"), null);
                    break;
                }
                case 1001: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.sql.Date"), null);
                    break;
                }
                case 1002: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.lang.Double"), null);
                    break;
                }
                case 1003: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.lang.Float"), null);
                    break;
                }
                case 1004: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.lang.Integer"), null);
                    break;
                }
                case 1005: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.lang.String"), null);
                    break;
                }
                case 1006: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.math.BigDecimal"), null);
                    break;
                }
                case 1007: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.lang.Long"), null);
                    break;
                }
                case 1008: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.sql.Time"), null);
                    break;
                }
                case 1009: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.sql.Timestamp"), null);
                    break;
                }
                case 1010: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.lang.Object"), null);
                    break;
                }
                case 1011: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.lang.Byte"), null);
                    break;
                }
                case 1012: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.lang.Short"), null);
                    break;
                }
                case 1013: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(array$B == null ? (array$B = LookupTable.class$("[B")) : array$B, null);
                    break;
                }
                case 1014: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.util.Date"), null);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            string = null;
        }
        return string;
    }

    public static String getRemainingCellRendererName(int n2) {
        String string = null;
        switch (n2) {
            case 0: {
                string = new String("com.klg.jclass.cell.renderers.JCEllipsisCellRenderer");
                break;
            }
            case 1: {
                try {
                    string = EditorRendererRegistry.getCentralRegistry().getCellRendererString(Class.forName("java.lang.String"), "WordWrap");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    string = null;
                }
                if (string != null) break;
                string = new String("com.klg.jclass.cell.renderers.JCWordWrapCellRenderer");
                break;
            }
        }
        return string;
    }

    public static String getCellEditorName(int n2) {
        String string = LookupTable.getDefaultCellEditorName(n2);
        if (string == null) {
            string = LookupTable.getAlternateCellEditorName(n2);
        }
        return string;
    }

    public static String getAlternateCellEditorName(int n2) {
        String string = null;
        switch (n2) {
            case 1000: {
                string = new String("com.klg.jclass.cell.editors.JCCheckBoxCellEditor");
                break;
            }
            case 1002: {
                string = new String("com.klg.jclass.cell.editors.JCDoubleCellEditor");
                break;
            }
            case 1003: {
                string = new String("com.klg.jclass.cell.editors.JCFloatCellEditor");
                break;
            }
            case 1004: {
                string = new String("com.klg.jclass.cell.editors.JCIntegerCellEditor");
                break;
            }
            case 1005: {
                string = new String("com.klg.jclass.cell.editors.JCStringCellEditor");
                break;
            }
            case 1006: {
                string = new String("com.klg.jclass.cell.editors.JCBigDecimalCellEditor");
                break;
            }
            case 1007: {
                string = new String("com.klg.jclass.cell.editors.JCLongCellEditor");
                break;
            }
            case 1010: {
                string = new String("com.klg.jclass.cell.editors.JCStringCellEditor");
                break;
            }
            case 1011: {
                string = new String("com.klg.jclass.cell.editors.JCByteCellEditor");
                break;
            }
            case 1012: {
                string = new String("com.klg.jclass.cell.editors.JCShortCellEditor");
                break;
            }
            case 1013: {
                string = new String("com.klg.jclass.cell.editors.JCImageCellEditor");
                break;
            }
            case 1014: {
                string = new String("com.klg.jclass.cell.editors.JCDateCellEditor");
                break;
            }
            case 1001: {
                string = new String("com.klg.jclass.cell.editors.JCSqlDateCellEditor");
                break;
            }
            case 1008: {
                string = new String("com.klg.jclass.cell.editors.JCSqlTimeCellEditor");
                break;
            }
            case 1009: {
                string = new String("com.klg.jclass.cell.editors.JCSqlTimestampCellEditor");
                break;
            }
            default: {
                string = new String("com.klg.jclass.cell.editors.JCStringCellEditor");
            }
        }
        return string;
    }

    public static String getDefaultCellEditorName(int n2) {
        String string = null;
        try {
            switch (n2) {
                case 1000: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.lang.Boolean"), null);
                    break;
                }
                case 1001: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.sql.Date"), null);
                    break;
                }
                case 1002: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.lang.Double"), null);
                    break;
                }
                case 1003: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.lang.Float"), null);
                    break;
                }
                case 1004: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.lang.Integer"), null);
                    break;
                }
                case 1005: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.lang.String"), null);
                    break;
                }
                case 1006: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.math.BigDecimal"), null);
                    break;
                }
                case 1007: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.lang.Long"), null);
                    break;
                }
                case 1008: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.sql.Time"), null);
                    break;
                }
                case 1009: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.sql.Timestamp"), null);
                    break;
                }
                case 1010: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.lang.Object"), null);
                    break;
                }
                case 1011: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.lang.Byte"), null);
                    break;
                }
                case 1012: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.lang.Short"), null);
                    break;
                }
                case 1013: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(array$B == null ? (array$B = LookupTable.class$("[B")) : array$B, null);
                    break;
                }
                case 1014: {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.util.Date"), null);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            string = null;
        }
        return string;
    }

    public static String getRemainingCellEditorName(int n2) {
        String string = null;
        switch (n2) {
            case 0: {
                try {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.lang.String"), "MultiLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    string = null;
                }
                if (string != null) break;
                string = new String("com.klg.jclass.cell.editors.JCMultilineCellEditor");
                break;
            }
            case 1: {
                try {
                    string = EditorRendererRegistry.getCentralRegistry().getCellEditorString(Class.forName("java.lang.String"), "WordWrap");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    string = null;
                }
                if (string != null) break;
                string = new String("com.klg.jclass.cell.editors.JCWordWrapCellEditor");
                break;
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

