/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.ActionInitiator;
import com.klg.jclass.higrid.CellPosition;
import com.klg.jclass.higrid.HeaderFormat;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowNode;
import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;

public class HiGridAction
implements Serializable {
    static final long serialVersionUID = 2539170986365960859L;
    protected ActionInitiator initiator;
    protected int action;
    public static final int NO_ACTION = 0;
    public static final int MOVE_LEFT_ACTION = 1;
    public static final int MOVE_RIGHT_ACTION = 2;
    public static final int MOVE_UP_ACTION = 3;
    public static final int MOVE_DOWN_ACTION = 4;
    public static final int MOVE_PAGE_UP_ACTION = 5;
    public static final int MOVE_PAGE_DOWN_ACTION = 6;
    public static final int MOVE_PAGE_LEFT_ACTION = 7;
    public static final int MOVE_PAGE_RIGHT_ACTION = 8;
    public static final int MOVE_HOME_ACTION = 9;
    public static final int MOVE_END_ACTION = 10;
    public static final int MOVE_GRID_HOME_ACTION = 11;
    public static final int MOVE_GRID_END_ACTION = 12;
    public static final int MOVE_NEXT_ACTION = 13;
    public static final int MOVE_PREVIOUS_ACTION = 14;
    public static final int OPEN_TABLE_ACTION = 15;
    public static final int CLOSE_TABLE_ACTION = 16;
    public static final int STOP_EDIT_ACTION = 17;
    public static final int CANCEL_EDIT_ACTION = 18;
    public static final int POPUP_MENU_ACTION = 19;
    public static final int COLUMN_SELECT_ACTION = 20;
    public static final int SINGLE_ROW_SELECT_ACTION = 21;
    public static final int GROUP_ROW_SELECT_ACTION = 22;
    public static final int IGNORE_ACTION = 23;
    public static final int COPY_ACTION = 24;
    public static final int PASTE_ACTION = 25;

    public HiGridAction(ActionInitiator actionInitiator, int n2) {
        this.setInitiator(actionInitiator);
        this.setAction(n2);
    }

    public ActionInitiator getInitiator() {
        return this.initiator;
    }

    public void setInitiator(ActionInitiator actionInitiator) {
        this.initiator = actionInitiator;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int n2) {
        this.action = n2;
    }

    public boolean isMatch(HiGrid hiGrid, AWTEvent aWTEvent) {
        boolean bl = this.initiator.isMatch(aWTEvent);
        if (!bl) {
            return false;
        }
        switch (this.action) {
            case 20: 
            case 21: 
            case 22: {
                Serializable serializable;
                CellPosition cellPosition = null;
                if (aWTEvent instanceof MouseEvent) {
                    serializable = (MouseEvent)aWTEvent;
                    cellPosition = hiGrid.getHorizontalScrollableCellPositionFromPoint(new Point(((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY()));
                } else if (aWTEvent instanceof KeyEvent) {
                    cellPosition = hiGrid.getCurrentCellPosition();
                }
                if (cellPosition == null) {
                    return false;
                }
                serializable = cellPosition.getRowNode();
                if (serializable == null) {
                    return false;
                }
                if (this.action == 20) {
                    return ((RowNode)serializable).getRowFormat() instanceof HeaderFormat;
                }
                if (this.action == 21 || this.action == 22) {
                    return ((RowNode)serializable).getRowFormat() instanceof RecordFormat;
                }
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "Initiator: " + this.initiator + " Action=" + this.action;
    }
}

