/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.Controller;
import com.klg.jclass.higrid.GridScrollbarCallback;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridErrorEvent;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.RowNodeWalk;
import com.klg.jclass.higrid.RowTree;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JScrollBar;

public class GridScrollbar
implements Serializable,
AdjustmentListener,
GridScrollbarCallback {
    static final long serialVersionUID = 2256552432959303071L;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int DISPLAY_AS_NEEDED = 0;
    public static final int DISPLAY_ALWAYS = 1;
    public static final int DISPLAY_NEVER = 2;
    private static final int INITIAL_ROWTIP_WIDTH = 100;
    protected static final int MAGIC_BLOCK_INCREMENT = 2;
    private Adjustable adjustable;
    private Component component;
    private HiGrid grid;
    private int display = 0;
    private int trackValue = -1;
    private int startValue = 0;
    private int draggingValue = 0;
    private RowNode oldTopRowNode = null;
    private boolean waitingForTrack = false;
    private boolean settingVisibility = false;
    private JLabel rowtip = null;
    private GridScrollbarCallback rowtipCallback = null;
    private boolean rowtipVisible = true;

    public GridScrollbar(HiGrid hiGrid, int n2) {
        this.grid = hiGrid;
        JScrollBar jScrollBar = new JScrollBar(n2);
        this.adjustable = jScrollBar;
        this.component = jScrollBar;
        this.adjustable.addAdjustmentListener(this);
        if (n2 == 1) {
            this.rowtip = new JLabel();
            this.rowtip.setHorizontalAlignment(0);
            this.rowtip.setOpaque(true);
            this.rowtip.setFont(new Font("Serif", 0, 12));
            this.rowtip.setForeground(Color.black);
            this.rowtip.setBackground(new Color(255, 255, 225));
            this.setRowtipCallback(this);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.grid.resetScrollbarConstraints();
        this.grid.layoutGrid();
    }

    public void setAdjustable(Adjustable adjustable) {
        this.adjustable.removeAdjustmentListener(this);
        this.adjustable = adjustable;
        this.adjustable.addAdjustmentListener(this);
    }

    public Adjustable getAdjustable() {
        return this.adjustable;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.adjustable == null || this.component == null || this.adjustable != adjustmentEvent.getAdjustable()) {
            return;
        }
        if (this.settingVisibility) {
            return;
        }
        int n2 = adjustmentEvent.getValue();
        int n3 = adjustmentEvent.getAdjustmentType();
        int n4 = this.adjustable.getOrientation();
        if (n4 == 1) {
            if (this.oldTopRowNode == null) {
                this.oldTopRowNode = this.grid.getRowTree().getTopRowNode();
            }
            boolean bl = false;
            int n5 = n2 - this.draggingValue;
            int n6 = this.grid.getController().getCurrentAction();
            if (this.startValue == this.draggingValue && (n6 == 0 || n6 == 6 || n6 == 5) && Math.abs(n5) == this.getBlockIncrement()) {
                bl = true;
                if (n5 < 0) {
                    n2 += 2;
                    n2 = this.grid.getRowTree().doPageUp(n2);
                } else if (n5 > 0) {
                    n2 -= 2;
                    n2 = this.grid.getRowTree().doPageDown(n2);
                }
            }
            this.draggingValue = n2 = this.getAdjustedValue(n2);
            if (this.adjustable instanceof JScrollBar) {
                if (((JScrollBar)this.adjustable).getValueIsAdjusting()) {
                    if (this.rowtip.getParent() == null) {
                        this.addRowtip(n2);
                    } else {
                        this.trackValue = n2;
                        this.updateRowtip(n2);
                        this.placeRowtip();
                    }
                } else {
                    bl = n2 != this.startValue;
                    this.trackValue = -1;
                    this.removeRowtip();
                    if (!bl) {
                        this.grid.refresh(false);
                    }
                }
            } else {
                if (this.trackValue == -1 && !this.waitingForTrack) {
                    this.addRowtip(n2);
                }
                if (this.trackValue == n2) {
                    bl = n2 != this.startValue;
                    this.trackValue = -1;
                    this.grid.getGridArea().remove(this.rowtip);
                } else {
                    this.trackValue = n2;
                    this.updateRowtip(n2);
                    this.placeRowtip();
                }
            }
            if (bl) {
                this.removeRowtip();
                this.grid.getRowTree().setTopRow(n2);
                boolean bl2 = n2 > this.startValue;
                this.grid.refresh(this.oldTopRowNode, this.grid.getRowTree().getTopRowNode(), bl2);
                Controller controller = this.grid.getController();
                controller.showEditor(false);
                controller.positionEditor();
                controller.showEditor(true);
                controller.acquireFocusForCellEditor();
                this.waitingForTrack = false;
                this.trackValue = -1;
                this.startValue = n2;
                this.draggingValue = n2;
                this.oldTopRowNode = this.grid.getRowTree().getTopRowNode();
            }
        } else if (n4 == 0 && this.trackValue != n2) {
            this.trackValue = n2;
            this.adjustable.setValue(n2);
            this.grid.refresh(false);
            this.grid.getController().acquireFocusForCellEditor();
        }
    }

    public int getDisplay() {
        return this.display;
    }

    public void setDisplay(int n2) {
        this.display = n2;
        this.grid.layoutGrid();
    }

    public void setVisible(boolean bl) {
        this.component.setVisible(bl);
    }

    public boolean isVisible() {
        return this.component.isVisible();
    }

    public void setSize(Dimension dimension) {
        this.component.setSize(dimension);
    }

    public void setUnitIncrement(int n2) {
    }

    public int getUnitIncrement() {
        return this.adjustable.getUnitIncrement();
    }

    public void setBlockIncrement(int n2) {
    }

    public int getBlockIncrement() {
        return this.adjustable.getBlockIncrement();
    }

    public void setValues(int n2, int n3, int n4, int n5) {
        this.adjustable.setMinimum(n4);
        this.adjustable.setMaximum(n5);
        this.adjustable.setVisibleAmount(n3);
        this.adjustable.setValue(n2);
    }

    public void setValue(int n2) {
        if (n2 == this.adjustable.getValue()) {
            return;
        }
        this.adjustable.setValue(n2);
        if (this.adjustable.getOrientation() == 0) {
            this.adjustmentValueChanged(new AdjustmentEvent(this.adjustable, 601, 5, n2));
        }
    }

    public int getValue() {
        return this.adjustable.getValue();
    }

    public int getOrientation() {
        return this.adjustable.getOrientation();
    }

    public void setMinimum(int n2) {
        this.adjustable.setMinimum(n2);
    }

    public int getMinimum() {
        return this.adjustable.getMinimum();
    }

    public void setMaximum(int n2) {
        this.adjustable.setMaximum(n2);
    }

    public int getMaximum() {
        return this.adjustable.getMaximum();
    }

    public boolean atEnd() {
        int n2 = this.adjustable.getValue();
        int n3 = this.adjustable.getMaximum();
        int n4 = this.adjustable.getVisibleAmount();
        return n2 == 0 || n2 >= n3 - n4;
    }

    public void scrollLineDown() {
        int n2 = this.getValue() + this.getUnitIncrement();
        int n3 = 1;
        this.adjustmentValueChanged(new AdjustmentEvent(this.getAdjustable(), 601, n3, n2));
    }

    public void scrollLineUp() {
        int n2 = this.getValue() - this.getUnitIncrement();
        int n3 = 2;
        this.adjustmentValueChanged(new AdjustmentEvent(this.getAdjustable(), 601, n3, n2));
    }

    public void scrollPageDown() {
        int n2 = this.getValue() + this.getBlockIncrement();
        int n3 = 4;
        this.adjustmentValueChanged(new AdjustmentEvent(this.getAdjustable(), 601, n3, n2));
    }

    public void scrollPageUp() {
        int n2 = this.getValue();
        if (n2 == 0) {
            return;
        }
        if ((n2 -= this.getBlockIncrement()) <= 0) {
            this.setValue(0);
            return;
        }
        int n3 = 3;
        this.adjustmentValueChanged(new AdjustmentEvent(this.getAdjustable(), 601, n3, n2));
    }

    public void initValues() {
        this.adjustable.setMinimum(0);
        this.adjustable.setMaximum(100);
        this.adjustable.setValue(0);
        this.adjustable.setUnitIncrement(this.adjustable.getOrientation() == 0 ? 10 : 1);
        this.adjustable.setBlockIncrement(2);
        this.adjustable.setVisibleAmount(10);
    }

    public void adjustValues(int n2, int n3) {
        if (n3 >= n2 || n2 == this.adjustable.getMaximum() && n3 == this.adjustable.getVisibleAmount()) {
            return;
        }
        this.adjustable.setMaximum(n2);
        this.settingVisibility = true;
        this.adjustable.setVisibleAmount(n3);
        this.settingVisibility = false;
        if (this.adjustable.getOrientation() == 0) {
            this.adjustable.setBlockIncrement(n3);
        }
    }

    protected int getAdjustedValue(int n2) {
        if (n2 < this.adjustable.getMinimum()) {
            n2 = this.adjustable.getMinimum();
        }
        if (n2 > this.adjustable.getMaximum() - this.adjustable.getVisibleAmount()) {
            n2 = this.adjustable.getMaximum() - this.adjustable.getVisibleAmount();
        }
        return n2;
    }

    protected RowNode getLabelRowNode(int n2) {
        RowTree rowTree = this.grid.getRowTree();
        if (rowTree == null || rowTree.getRoot() == null) {
            return null;
        }
        RowNodeWalk rowNodeWalk = new RowNodeWalk(n2);
        rowTree.walk((RowNode)rowTree.getRootNode().getFirstChild(), rowNodeWalk);
        return rowNodeWalk.getFoundNode();
    }

    public GridScrollbarCallback getRowtipCallback() {
        return this.rowtipCallback;
    }

    public void setRowtipCallback(GridScrollbarCallback gridScrollbarCallback) {
        this.rowtipCallback = gridScrollbarCallback;
    }

    public String getRowtipText() {
        return this.rowtip.getText();
    }

    public Component getRowtip() {
        return this.rowtip;
    }

    protected boolean isRowtipVisible() {
        return this.rowtipVisible;
    }

    protected void setRowtipVisible(boolean bl) {
        this.rowtipVisible = bl;
    }

    protected void removeRowtip() {
        this.grid.getGridArea().remove(this.rowtip);
    }

    protected void addRowtip(int n2) {
        if (this.rowtipCallback != null && this.isRowtipVisible()) {
            this.rowtip.setText("");
            this.rowtip.setVisible(false);
            this.updateRowtip(n2);
            this.placeRowtip();
            this.grid.getGridArea().add((Component)this.rowtip, 0);
            this.rowtip.setVisible(true);
        }
    }

    protected void placeRowtip() {
        if (this.rowtipCallback != null && this.isRowtipVisible()) {
            this.rowtipCallback.positionRowtip(this.grid.getGridArea(), this.rowtip);
        }
    }

    protected void updateRowtip(int n2) {
        if (this.rowtipCallback != null && this.isRowtipVisible()) {
            RowNode rowNode = this.getLabelRowNode(n2);
            if (rowNode == null) {
                return;
            }
            String string = this.rowtipCallback.setRowtipText(rowNode, n2, this.adjustable);
            if (string != null) {
                this.rowtip.setText(string);
            }
        }
    }

    public String setRowtipText(RowNode rowNode, int n2, Adjustable adjustable) {
        String string = null;
        DataTableModel dataTableModel = rowNode.getDataTableModel();
        RowFormat rowFormat = rowNode.getRowFormat();
        if (rowNode.getRowFormat().getDataFormats().isEmpty()) {
            return "";
        }
        CellFormat cellFormat = (CellFormat)rowNode.getRowFormat().getDataFormats().elementAt(0);
        String string2 = cellFormat.getName();
        if (rowFormat instanceof RecordFormat) {
            Object object = null;
            try {
                object = dataTableModel.getResultData(rowNode.getBookmark(), string2);
            }
            catch (Exception exception) {
                this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
            }
            if (object != null) {
                string = object.toString();
            }
        }
        if (string == null) {
            string = string2;
        }
        return string;
    }

    public void positionRowtip(Container container, Component component) {
        ((JLabel)component).setHorizontalAlignment(0);
        ((JLabel)component).setOpaque(true);
        component.setFont(new Font("Serif", 0, 12));
        component.setForeground(Color.black);
        component.setBackground(new Color(255, 255, 225));
        int n2 = 0;
        int n3 = 0;
        if (container != null) {
            Dimension dimension = container.getSize();
            int n4 = this.getFontHeight(component.getFont());
            int n5 = this.getStringWidth(component.getFont(), this.getRowtipText());
            n5 = Math.max(n5, 100);
            n5 = Math.min(n5, dimension.width);
            component.setSize(n5, n4);
            n2 = dimension.width - n5 - 1;
            n3 = (dimension.height - n4) / 2;
            component.setLocation(n2, n3);
            component.setVisible(true);
        }
    }

    protected void removeOldReferences() {
        this.oldTopRowNode = null;
    }

    private int getStringWidth(Font font, String string) {
        FontMetrics fontMetrics = this.getComponent().getFontMetrics(font);
        return fontMetrics.stringWidth(string) + (font.isItalic() ? font.getSize() / 3 + 1 : 0);
    }

    private int getFontHeight(Font font) {
        FontMetrics fontMetrics = this.getComponent().getFontMetrics(font);
        return fontMetrics.getLeading() + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
    }
}

