/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.higrid.DefaultImageRenderer;
import com.klg.jclass.higrid.EditStatus;
import com.klg.jclass.higrid.HiGridEditStatusRenderer;
import com.klg.jclass.util.swing.JCIconCreator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class DefaultEditStatusRenderer
extends DefaultImageRenderer
implements HiGridEditStatusRenderer {
    static final long serialVersionUID = -2909248749782807724L;
    private transient Image[] icons = null;
    private static final String[] updateCurrentIconString = new String[]{"             ", "        ...  ", "        .  . ", "       . ..  ", "       .  .  ", "      .  .   ", "      .  .   ", "     .  .    ", "     .  .    ", "     ...     ", "     ..      ", " . . .       ", "             "};
    private static final String[] updatePendingIconString = new String[]{"             ", "        ggg  ", "        g  g ", "       g gg  ", "       g  g  ", "      g  g   ", "      g  g   ", "     g  g    ", "     g  g    ", "     ggg     ", "     gg      ", " g g g       ", "             "};
    private static final String[] deleteCurrentIconString = new String[]{"...         .", "....      .. ", " ....    ..  ", "   ...  ..   ", "    .....    ", "     ...     ", "     ...     ", "    .....    ", "   ...  ..   ", " ....    ..  ", "....      .. ", "...         .", "             "};
    private static final String[] deletePendingIconString = new String[]{"ggg         g", "gggg      gg ", " gggg    gg  ", "   ggg  gg   ", "    ggggg    ", "     ggg     ", "     ggg     ", "    ggggg    ", "   ggg  gg   ", " gggg    gg  ", "gggg      gg ", "ggg         g", "             "};
    private static final String[] currentIconString = new String[]{"             ", "    .        ", "    ..       ", "    ...      ", "    ....     ", "    .....    ", "    ......   ", "    .....    ", "    ....     ", "    ...      ", "    ..       ", "    .        ", "             "};

    public DefaultEditStatusRenderer() {
        this.recreateIcons();
    }

    protected void recreateIcons() {
        if (this.icons == null) {
            this.icons = new Image[5];
            JCIconCreator jCIconCreator = new JCIconCreator(13, 13);
            jCIconCreator.setColor('.', Color.black);
            jCIconCreator.setColor('r', new Color(255, 0, 0).darker());
            jCIconCreator.setColor('g', Color.gray);
            jCIconCreator.setPixels(updateCurrentIconString);
            this.setIcon(jCIconCreator.getIcon().getImage(), 0);
            jCIconCreator.clear();
            jCIconCreator.setPixels(updatePendingIconString);
            this.setIcon(jCIconCreator.getIcon().getImage(), 1);
            jCIconCreator.clear();
            jCIconCreator.setPixels(deleteCurrentIconString);
            this.setIcon(jCIconCreator.getIcon().getImage(), 2);
            jCIconCreator.clear();
            jCIconCreator.setPixels(deletePendingIconString);
            this.setIcon(jCIconCreator.getIcon().getImage(), 3);
            jCIconCreator.clear();
            jCIconCreator.setPixels(currentIconString);
            this.setIcon(jCIconCreator.getIcon().getImage(), 4);
        }
    }

    public Image getIcon(int n2) {
        this.recreateIcons();
        return this.icons[n2];
    }

    public void setIcon(Image image, int n2) {
        this.recreateIcons();
        this.icons[n2] = image;
    }

    public void draw(Graphics graphics, JCCellInfo jCCellInfo, Object object, boolean bl) {
        this.draw(graphics, jCCellInfo, (EditStatus)object, bl);
    }

    public void draw(Graphics graphics, JCCellInfo jCCellInfo, EditStatus editStatus, boolean bl) {
        int n2;
        Rectangle rectangle = jCCellInfo.getDrawingArea();
        Color color = bl ? jCCellInfo.getSelectedBackground() : jCCellInfo.getBackground();
        graphics.setColor(color);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (editStatus == null) {
            return;
        }
        switch (editStatus.getStatus()) {
            case 1: {
                n2 = editStatus.isCurrentRow() ? 0 : 1;
                break;
            }
            case 2: {
                n2 = editStatus.isCurrentRow() ? 0 : 1;
                break;
            }
            case 3: {
                n2 = editStatus.isCurrentRow() ? 2 : 3;
                break;
            }
            case 4: {
                n2 = editStatus.isCurrentRow() ? 4 : -1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        if (n2 < 0) {
            return;
        }
        super.draw(graphics, jCCellInfo, this.getIcon(n2), bl, null);
    }

    public Dimension getPreferredSize(Graphics graphics, JCCellInfo jCCellInfo, Object object) {
        Rectangle rectangle = jCCellInfo.getDrawingArea();
        return new Dimension(rectangle.width, rectangle.height);
    }
}

