/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.Aggregate;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.SummaryColumn;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Hashtable;

public abstract class BaseAggregate
implements Aggregate,
Serializable {
    static final long serialVersionUID = 8905431406164420225L;
    protected int metaID;
    protected SummaryColumn column;
    protected long longValue;
    protected double doubleValue;
    protected BigDecimal bigDecimal;
    private Hashtable tableMetaID;
    private boolean metaIDFound;

    public BaseAggregate() {
        this.init(null);
    }

    public BaseAggregate(SummaryColumn summaryColumn) {
        this.init(summaryColumn);
    }

    public void setValue(Object object) {
        if (this.column == null || object == null) {
            return;
        }
        switch (this.column.getDataType()) {
            case 1002: {
                this.doubleValue = (Double)object;
                break;
            }
            case 1003: {
                this.doubleValue = ((Float)object).doubleValue();
                break;
            }
            case 1006: {
                this.bigDecimal = (BigDecimal)object;
                break;
            }
            case 1004: {
                this.longValue = ((Integer)object).longValue();
                break;
            }
            case 1007: {
                this.longValue = (Long)object;
                break;
            }
            case 1011: {
                this.longValue = ((Byte)object).longValue();
                break;
            }
            case 1012: {
                this.longValue = ((Short)object).longValue();
                break;
            }
        }
    }

    public void addValue(Object object) {
        if (this.column == null || object == null) {
            return;
        }
        switch (this.column.getDataType()) {
            case 1002: {
                this.doubleValue += ((Double)object).doubleValue();
                break;
            }
            case 1003: {
                this.doubleValue += ((Float)object).doubleValue();
                break;
            }
            case 1006: {
                this.bigDecimal = this.bigDecimal.add((BigDecimal)object);
                break;
            }
            case 1004: {
                this.longValue += ((Integer)object).longValue();
                break;
            }
            case 1007: {
                this.longValue += ((Long)object).longValue();
                break;
            }
            case 1011: {
                this.longValue += ((Byte)object).longValue();
                break;
            }
            case 1012: {
                this.longValue += ((Short)object).longValue();
                break;
            }
        }
    }

    public void divideValue(int n2) {
        if (this.column == null || n2 == 0) {
            return;
        }
        switch (this.column.getDataType()) {
            case 1002: 
            case 1003: {
                this.doubleValue /= (double)n2;
                break;
            }
            case 1006: {
                try {
                    this.bigDecimal = this.bigDecimal.divide(new BigDecimal((double)n2), 1);
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                }
                break;
            }
            case 1004: 
            case 1007: 
            case 1011: 
            case 1012: {
                this.longValue /= (long)n2;
                break;
            }
        }
    }

    public double getLongValue(Object object) {
        if (object == null) {
            return 0.0;
        }
        String string = object.toString();
        return new Long(string).longValue();
    }

    public double getDoubleValue(Object object) {
        if (object == null) {
            return 0.0;
        }
        String string = object.toString();
        return new Double(string);
    }

    public boolean isSameMetaID(RowNode rowNode) {
        return rowNode.getRowFormat().getMetaData().getMetaID() == this.metaID;
    }

    public Object getRowNodeResultData(RowNode rowNode, String string) {
        Object object = null;
        try {
            object = rowNode.getDataTableModel().getResultData(rowNode.getBookmark(), string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public void init(SummaryColumn summaryColumn) {
        this.metaID = summaryColumn == null ? -1 : summaryColumn.getTable();
        this.column = summaryColumn;
        this.longValue = 0L;
        this.doubleValue = 0.0;
        this.bigDecimal = null;
        if (summaryColumn != null && summaryColumn.getDataType() == 1006) {
            this.bigDecimal = new BigDecimal(0.0);
        }
        if (this.metaID < 0) {
            this.tableMetaID = null;
        } else {
            this.tableMetaID = new Hashtable();
            this.metaIDFound = false;
        }
    }

    public boolean done() {
        return false;
    }

    public boolean nextLevel(RowNode rowNode) {
        if (this.metaID == -1) {
            return true;
        }
        int n2 = rowNode.getRowFormat().getMetaData().getMetaID();
        Integer n3 = new Integer(n2);
        if (!this.metaIDFound) {
            this.tableMetaID.put(n3, n3);
            if (n2 == this.metaID) {
                this.metaIDFound = true;
                return false;
            }
            return true;
        }
        if (this.tableMetaID.get(n3) != null) {
            return n2 != this.metaID;
        }
        return false;
    }

    public abstract void calculate(RowNode var1);

    public boolean cacheResultData() {
        return true;
    }

    public Object getResultData() {
        if (this.column == null) {
            return null;
        }
        switch (this.column.getDataType()) {
            case 1002: {
                return new Double(this.doubleValue);
            }
            case 1003: {
                return new Float(this.doubleValue);
            }
            case 1006: {
                return this.bigDecimal;
            }
            case 1004: {
                return new Integer((int)this.longValue);
            }
            case 1007: {
                return new Long(this.longValue);
            }
            case 1011: {
                return new Byte((byte)this.longValue);
            }
            case 1012: {
                return new Short((short)this.longValue);
            }
        }
        return null;
    }
}

