/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field.validate;

import com.klg.jclass.field.validate.AbstractValidator;
import com.klg.jclass.field.validate.TextCursorEvent;
import com.klg.jclass.field.validate.TextEvent;
import java.util.Locale;
import javax.swing.ListModel;

public class JCStringValidator
extends AbstractValidator {
    static final int NUMBER = 0;
    static final int DIGIT = 1;
    static final int HEX = 2;
    static final int UPPER = 3;
    static final int LOWER = 4;
    static final int NOCONVERT = 5;
    static final int STAR = 6;
    static final int ALPHANUMERIC = 7;
    static final int LITERAL = 8;
    static final String HEXDIGITS = "AaBbCcDdEeFf";
    static final String NUMBERDIGITS = "+-,.";
    protected int[] compiled_mask_sym;
    protected char[] compiled_mask_ch;
    protected int mask_length = 0;
    protected int num_editable_pos = 0;
    protected String mask = "";
    protected String place_holder_chars = null;
    protected String mask_chars = "#@HULA*^\\";
    protected int num_mask_match = -1;
    protected Object defaultValue = null;

    public JCStringValidator() {
        this.spin_policy = 2;
        this.supportedClasses = this.getSupportedClasses();
    }

    public JCStringValidator(Locale locale, String string, int n2, String string2, ListModel listModel, boolean bl, String string3, String string4, boolean bl2, Object object) {
        this();
        this.setLocale(locale);
        this.setMask(string);
        this.setPickList(listModel);
        this.setMatchPickList(bl);
        this.setNumMaskMatch(n2);
        this.setPlaceHolderChars(string2);
        this.setValidChars(string3);
        this.setInvalidChars(string4);
        this.setAllowNull(bl2);
        this.setDefaultValue(object);
    }

    protected Class[] getSupportedClasses() {
        Class[] classArray = new Class[]{String.class, StringBuffer.class};
        return classArray;
    }

    public Object copyValue(Object object) {
        return object;
    }

    public void setNumMaskMatch(int n2) {
        this.num_mask_match = n2;
    }

    public int getNumMaskMatch() {
        return this.num_mask_match;
    }

    public void setMask(String string) {
        this.mask = string;
        this.compileMask();
    }

    public String getMask() {
        return this.mask;
    }

    public void setPlaceHolderChars(String string) {
        this.place_holder_chars = string;
    }

    public String getPlaceHolderChars() {
        return this.place_holder_chars;
    }

    public void setMaskChars(String string) {
        if (string.length() != this.mask_chars.length()) {
            throw new IllegalArgumentException("Missing mask chars");
        }
        this.mask_chars = string;
        this.compileMask();
    }

    public String getMaskChars() {
        return this.mask_chars;
    }

    public String getParsedMask() {
        if (this.mask != null && this.mask_length != 0) {
            return String.copyValueOf(this.compiled_mask_ch);
        }
        return "";
    }

    public boolean inRange(Object object) {
        return true;
    }

    protected void compileMask() {
        int n2;
        int n3 = n2 = this.mask == null ? 0 : this.mask.length();
        if (n2 == 0) {
            this.mask_length = 0;
            return;
        }
        this.compiled_mask_sym = new int[n2];
        this.compiled_mask_ch = new char[n2];
        this.num_editable_pos = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = this.mask_chars.indexOf(this.mask.charAt(n5));
            if (n6 < 0) {
                this.compiled_mask_sym[n4] = 8;
                this.compiled_mask_ch[n4] = this.mask.charAt(n5);
            } else if (this.mask.charAt(n5) == this.mask_chars.charAt(8)) {
                if (++n5 < n2) {
                    this.compiled_mask_sym[n4] = 8;
                    this.compiled_mask_ch[n4] = this.mask.charAt(n5);
                } else {
                    --n4;
                }
            } else {
                this.compiled_mask_sym[n4] = n6;
                this.compiled_mask_ch[n4] = 32;
                ++this.num_editable_pos;
            }
            ++n5;
            ++n4;
        }
        this.mask_length = n4;
    }

    protected boolean isValidChar(StringBuffer stringBuffer, int n2, int n3) {
        char c2 = stringBuffer.charAt(n2);
        if (n3 >= this.mask_length) {
            return false;
        }
        switch (this.compiled_mask_sym[n3]) {
            case 0: {
                return Character.isDigit(c2) || NUMBERDIGITS.indexOf(c2) >= 0;
            }
            case 2: {
                return Character.isDigit(c2) || HEXDIGITS.indexOf(c2) >= 0;
            }
            case 1: {
                return Character.isDigit(c2);
            }
            case 3: {
                if (Character.isLetter(c2)) {
                    stringBuffer.setCharAt(n2, Character.toUpperCase(c2));
                    return true;
                }
                return false;
            }
            case 4: {
                if (Character.isLetter(c2)) {
                    stringBuffer.setCharAt(n2, Character.toLowerCase(c2));
                    return true;
                }
                return false;
            }
            case 5: {
                return Character.isLetter(c2);
            }
            case 6: {
                return true;
            }
            case 8: {
                return c2 == this.compiled_mask_ch[n3];
            }
            case 7: {
                return Character.isLetter(c2) || Character.isDigit(c2);
            }
        }
        return false;
    }

    public int getNextCursorPosition(int n2, boolean bl) {
        if (this.mask == null || this.mask_length == 0) {
            return n2;
        }
        if (n2 == this.mask_length) {
            return n2;
        }
        if (bl) {
            for (int i2 = n2; i2 < this.mask_length; ++i2) {
                if (this.compiled_mask_sym[i2] == 8) continue;
                return i2;
            }
        } else {
            for (int i3 = n2; i3 < this.mask_length && i3 >= 0; --i3) {
                if (this.compiled_mask_sym[i3] == 8) continue;
                return i3;
            }
        }
        return -1;
    }

    private void addPlaceHolder(StringBuffer stringBuffer, int n2) {
        int n3 = 0;
        if (this.place_holder_chars != null) {
            n3 = this.place_holder_chars.length();
        }
        if (n3 > 0 && n2 < n3) {
            stringBuffer.append(this.place_holder_chars.charAt(n2));
        } else {
            stringBuffer.append(" ");
        }
    }

    public void changeText(TextEvent textEvent) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(50);
        super.changeText(textEvent);
        int n2 = textEvent.getStartPosition();
        int n3 = textEvent.getEndPosition();
        if (textEvent.isDeletion() && n3 - n2 > 0 && this.mask != null && this.mask_length != 0 && n2 < this.mask_length && n3 <= this.mask_length) {
            if (this.compiled_mask_sym[n2] == 8 && n3 - n2 == 1) {
                int n4 = this.getNextCursorPosition(n2, false);
                if (n4 == -1) {
                    textEvent.setStartPosition(n3);
                    textEvent.setAllowChange(false);
                    return;
                }
                this.addPlaceHolder(stringBuffer, n4);
                for (int i2 = n4 + 1; i2 <= n2; ++i2) {
                    if (this.compiled_mask_sym[i2] == 8) {
                        stringBuffer.append(this.compiled_mask_ch[i2]);
                        continue;
                    }
                    this.addPlaceHolder(stringBuffer, i2);
                }
                textEvent.setStartPosition(n4);
                textEvent.setText(stringBuffer.toString());
            } else if (n3 - n2 > 1) {
                StringBuffer stringBuffer2 = new StringBuffer(textEvent.getText());
                int n5 = stringBuffer2.length();
                int n6 = 0;
                for (int i3 = n2; i3 < n3; ++i3) {
                    if (this.compiled_mask_sym[i3] == 8) {
                        stringBuffer.append(this.compiled_mask_ch[i3]);
                        continue;
                    }
                    if (!stringBuffer2.equals("") && n6 < n5 && this.isValidChar(stringBuffer2, n6, i3)) {
                        stringBuffer.append(stringBuffer2.charAt(n6));
                        ++n6;
                        continue;
                    }
                    this.addPlaceHolder(stringBuffer, i3);
                }
                textEvent.setStartPosition(n2);
                textEvent.setText(stringBuffer.toString());
            } else {
                this.addPlaceHolder(stringBuffer, n2);
                textEvent.setText(stringBuffer.toString());
            }
            return;
        }
        String string = textEvent.getText();
        if (string != null && string.length() != 0) {
            StringBuffer stringBuffer3 = new StringBuffer(50);
            StringBuffer stringBuffer4 = this.checkValidInvalid(string);
            if (stringBuffer4 != null && stringBuffer4.length() != 0) {
                int n7 = n2;
                if (this.mask != null && this.mask_length != 0) {
                    for (int i4 = 0; i4 < stringBuffer4.length(); ++i4) {
                        bl = this.isValidChar(stringBuffer4, i4, n7);
                        if (!bl) continue;
                        stringBuffer3.append(stringBuffer4.charAt(i4));
                        ++n7;
                        if (n3 - n2 != 1) {
                            for (int i5 = n7; i5 < this.mask_length && this.compiled_mask_sym[i5] == 8; ++i5) {
                                char c2 = this.compiled_mask_ch[i5];
                                stringBuffer3.append(c2);
                                if (i4 + 1 >= stringBuffer4.length() || c2 != stringBuffer4.charAt(i4 + 1)) continue;
                                ++i4;
                            }
                        }
                        n7 = this.getNextCursorPosition(n7, true);
                    }
                    if (n3 - n2 != 1) {
                        textEvent.setEndPosition(textEvent.getStartPosition() + stringBuffer3.length());
                    }
                } else {
                    stringBuffer3.append(stringBuffer4.toString());
                }
            }
            textEvent.setText(stringBuffer3.toString());
            if (stringBuffer3.length() == 0) {
                textEvent.setAllowChange(false);
            }
        }
    }

    public void setCursor(TextCursorEvent textCursorEvent) {
        int n2;
        int n3 = textCursorEvent.getNewPosition();
        int n4 = textCursorEvent.getCurrentPosition();
        boolean bl = true;
        if (n4 > n3) {
            bl = false;
        }
        if ((n2 = this.getNextCursorPosition(n3, bl)) == -1 && (n2 = this.getNextCursorPosition(n3, !bl)) == -1) {
            textCursorEvent.setNewPosition(textCursorEvent.getCurrentPosition());
            return;
        }
        textCursorEvent.setNewPosition(n2);
    }

    public int getLastValidInputCharPosition(String string) {
        int n2 = 0;
        if (string == null) {
            return n2;
        }
        if (this.mask == null || this.mask_length == 0) {
            return string.length();
        }
        for (n2 = string.length(); n2 > 0; --n2) {
            int n3 = n2 - 1;
            if (this.place_holder_chars == null || n2 > this.place_holder_chars.length() ? string.charAt(n3) != ' ' && this.compiled_mask_sym[n3] != 8 : string.charAt(n3) != this.place_holder_chars.charAt(n3) && this.compiled_mask_sym[n3] != 8) break;
        }
        return n2;
    }

    public Object parse(Class clazz, String string) {
        String string2 = null;
        if ((string == null || string.length() == 0) && this.getAllowNull() || this.mask == null || this.mask_length == 0) {
            string2 = string;
        } else {
            StringBuffer stringBuffer = new StringBuffer(50);
            int n2 = this.getLastValidInputCharPosition(string);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.compiled_mask_sym[i2] == 8 && this.compiled_mask_ch[i2] == string.charAt(i2)) continue;
                stringBuffer.append(string.charAt(i2));
            }
            string2 = stringBuffer.toString();
        }
        Object object = string2;
        if (object.getClass() != clazz) {
            object = this.convertFromSupported(object, clazz);
        }
        return object;
    }

    public boolean validate(Object object) {
        Object object2 = this.convertToSupported(object);
        boolean bl = this.internalValidate(object2);
        return bl;
    }

    protected boolean internalValidate(Object object) {
        boolean bl = super.validate(object);
        String string = (String)object;
        if (!(string != null && string.length() != 0 || this.getAllowNull())) {
            return false;
        }
        int n2 = 0;
        int n3 = -1;
        if (bl && this.mask != null && this.mask_length > 0 && string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n4 = 0;
            while (n4 < stringBuffer.length()) {
                for (int i2 = n2; i2 < this.mask_length && this.compiled_mask_sym[i2] == 8; ++i2) {
                    ++n2;
                }
                if (!this.isValidChar(stringBuffer, n4, n2)) {
                    bl = false;
                    break;
                }
                ++n2;
                n3 = n4++;
            }
            if (this.num_mask_match >= 0) {
                bl = this.num_mask_match <= n3 + 1;
            } else if (stringBuffer.length() != this.num_editable_pos) {
                bl = false;
            }
        }
        return bl;
    }

    public String format(Object object) {
        boolean bl = false;
        if (object != null && (bl = this.isClassSupported(object.getClass()))) {
            object = this.convertToSupported(object);
        }
        String string = null;
        string = object == null || !bl ? "" : (String)object;
        StringBuffer stringBuffer = new StringBuffer(50);
        if (this.mask != null && this.mask_length != 0) {
            int n2;
            if (string.length() == 0 && this.place_holder_chars != null && this.place_holder_chars.length() != 0) {
                stringBuffer.append(this.place_holder_chars);
                for (int i2 = this.place_holder_chars.length(); i2 < this.mask_length; ++i2) {
                    if (this.compiled_mask_sym[i2] == 8) {
                        stringBuffer.append(this.compiled_mask_ch[i2]);
                        continue;
                    }
                    this.addPlaceHolder(stringBuffer, i2);
                }
                return stringBuffer.toString();
            }
            int n3 = 0;
            for (n2 = 0; n2 < string.length() && n2 < this.num_editable_pos; ++n2) {
                if (string.charAt(n2) == this.compiled_mask_ch[n3] && this.compiled_mask_sym[n3] != 8) {
                    stringBuffer.append(this.compiled_mask_ch[n3]);
                } else {
                    int n4 = n3;
                    while (this.compiled_mask_sym[n4] == 8) {
                        stringBuffer.append(this.compiled_mask_ch[n4]);
                        ++n3;
                        ++n4;
                    }
                    stringBuffer.append(string.charAt(n2));
                }
                ++n3;
            }
            for (n2 = n3; n2 < this.mask_length; ++n2) {
                if (this.compiled_mask_sym[n2] == 8) {
                    stringBuffer.append(this.compiled_mask_ch[n2]);
                    continue;
                }
                this.addPlaceHolder(stringBuffer, n2);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public int getFirstValidCursorPosition() {
        if (this.mask != null && this.mask_length != 0) {
            int n2 = this.getNextCursorPosition(0, true);
            if (n2 >= 0) {
                return n2;
            }
            return this.mask_length;
        }
        return 0;
    }

    public String formatForEdit(Object object) {
        return null;
    }

    public boolean hasEditFormat() {
        return false;
    }

    protected Object addIncrement(Object object) {
        return null;
    }

    protected Object subtractIncrement(Object object) {
        return null;
    }

    public Object convertToSupported(Object object) {
        if (object instanceof String) {
            return object;
        }
        if (object instanceof StringBuffer) {
            return object.toString();
        }
        return null;
    }

    public Object convertFromSupported(Object object, Class clazz) {
        if (object == null || clazz == null) {
            return null;
        }
        String string = clazz.getName();
        if (string.equals("java.lang.String")) {
            return object;
        }
        if (string.equals("java.lang.StringBuffer")) {
            return new StringBuffer((String)object);
        }
        return null;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }
}

