/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field.beans;

import com.klg.jclass.field.beans.AbstractValidatorEditor;
import com.klg.jclass.field.beans.ListModelEditor;
import com.klg.jclass.field.validate.JCStringValidator;
import com.klg.jclass.field.validate.JCValidator;
import com.klg.jclass.util.swing.JCGridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class StringValidatorEditor
extends AbstractValidatorEditor
implements ItemListener,
ActionListener {
    protected String mask;
    protected ListModel picklist;
    protected boolean match_picklist;
    protected Integer num_match;
    protected String place_holder_chars;
    protected String valid_chars;
    protected String invalid_chars;
    protected boolean allow_null;
    protected String default_value;
    protected JTextField mask_field;
    protected JComboBox mask_combo;
    protected JTextField num_match_field;
    protected JTextField place_holder_field;
    protected JTextField invalid_char_field;
    protected JTextField valid_char_field;
    protected JButton picklist_button;
    protected ListModelEditor picklist_editor;
    protected JComboBox match_picklist_field;
    protected JComboBox allow_null_field;
    protected JTextField default_value_field;
    protected JDialog picklist_dialog = null;
    protected PredefinedMask[] predefined_masks = new PredefinedMask[]{new PredefinedMask("Custom", null), new PredefinedMask("Phone Number", "(@@@) @@@-@@@@"), new PredefinedMask("Business Phone Number", "(@@@) @@@-@@@@ x@@@@"), new PredefinedMask("Business Phone Number", "(@@@) @@@-@@@@ Ext @@@@"), new PredefinedMask("ZIP Code", "@@@@@"), new PredefinedMask("Postal Code", "U@U @U@"), new PredefinedMask("State", "UU")};

    public StringValidatorEditor() {
        this.setLayout(new JCGridLayout(9, 2, 5, 5));
        this.add(new JLabel("Num Mask Match:"));
        this.num_match_field = new JTextField(TEXTFIELD_SIZE);
        this.add(this.num_match_field);
        this.add(new JLabel("Place Holder Chars:"));
        this.place_holder_field = new JTextField();
        this.add(this.place_holder_field);
        this.add(new JLabel("Valid Chars:"));
        this.valid_char_field = new JTextField();
        this.add(this.valid_char_field);
        this.add(new JLabel("Invalid Chars:"));
        this.invalid_char_field = new JTextField();
        this.add(this.invalid_char_field);
        this.add(new JLabel("PickList: "));
        this.picklist_button = new JButton("Click here to edit...");
        this.add(this.picklist_button);
        this.picklist_button.addActionListener(this);
        this.createPickListDialog();
        this.add(new JLabel("Match PickList:"));
        this.match_picklist_field = new JComboBox<String>(this.bool_vals);
        this.add(this.match_picklist_field);
        this.add(new JLabel("Allow Null:"));
        this.allow_null_field = new JComboBox<String>(this.bool_vals);
        this.add(this.allow_null_field);
        this.add(new JLabel("Default Value:"));
        this.default_value_field = new JTextField();
        this.add(this.default_value_field);
        this.add(new JLabel("Mask:"));
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.0f);
        jPanel.setAlignmentY(0.0f);
        jPanel.setLayout(new JCGridLayout(2, 1, 0, 0));
        String[] stringArray = new String[this.predefined_masks.length];
        for (int i2 = 0; i2 < this.predefined_masks.length; ++i2) {
            stringArray[i2] = this.predefined_masks[i2].toString();
        }
        this.mask_combo = new JComboBox<String>(stringArray);
        jPanel.add(this.mask_combo);
        this.mask_field = new JTextField();
        jPanel.add(this.mask_field);
        this.mask_combo.addItemListener(this);
        this.add(jPanel);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n2 = this.mask_combo.getSelectedIndex();
        if (n2 == 0) {
            this.mask_field.setEditable(true);
            this.mask_field.setText("");
        } else {
            this.mask_field.setText(this.predefined_masks[n2].mask);
            this.mask_field.setEditable(false);
        }
    }

    public void setProperties(JCValidator jCValidator) {
        JCStringValidator jCStringValidator = (JCStringValidator)jCValidator;
        this.mask = jCStringValidator.getMask();
        this.picklist = jCStringValidator.getPickList();
        this.match_picklist = jCStringValidator.getMatchPickList();
        this.num_match = new Integer(jCStringValidator.getNumMaskMatch());
        this.place_holder_chars = jCStringValidator.getPlaceHolderChars();
        this.valid_chars = jCStringValidator.getValidChars();
        this.invalid_chars = jCStringValidator.getInvalidChars();
        this.allow_null = jCStringValidator.getAllowNull();
        this.default_value = (String)jCStringValidator.getDefaultValue();
        this.mask_field.setText(this.mask);
        this.picklist_editor.setValue(this.picklist);
        this.num_match_field.setText(this.num_match.toString());
        this.place_holder_field.setText(this.place_holder_chars);
        this.valid_char_field.setText(this.valid_chars);
        this.invalid_char_field.setText(this.invalid_chars);
        if (this.match_picklist) {
            this.match_picklist_field.setSelectedIndex(1);
        } else {
            this.match_picklist_field.setSelectedIndex(0);
        }
        if (this.allow_null) {
            this.allow_null_field.setSelectedIndex(1);
        } else {
            this.allow_null_field.setSelectedIndex(0);
        }
        this.default_value_field.setText(this.default_value);
    }

    protected AbstractValidatorEditor.ValidatorInfo getValidatorInfo() {
        this.mask = this.mask_field.getText();
        String string = this.num_match_field.getText();
        this.num_match = string.length() == 0 ? new Integer(-1) : Integer.valueOf(string);
        this.place_holder_chars = this.place_holder_field.getText();
        this.valid_chars = this.valid_char_field.getText();
        this.invalid_chars = this.invalid_char_field.getText();
        this.picklist = (ListModel)this.picklist_editor.getValue();
        this.match_picklist = this.match_picklist_field.getSelectedIndex() != 0;
        this.allow_null = this.allow_null_field.getSelectedIndex() != 0;
        this.default_value = this.default_value_field.getText();
        if (this.default_value == null) {
            this.default_value = "";
        }
        return this.getInfo();
    }

    protected AbstractValidatorEditor.ValidatorInfo getInfo() {
        String string = "new com.klg.jclass.field.validate.JCStringValidator(null, \"" + this.mask + "\", " + this.num_match + ", \"" + this.place_holder_chars + "\", " + this.picklist_editor.getJavaInitializationString() + ", " + this.match_picklist + ", \"" + this.valid_chars + "\", \"" + this.invalid_chars + "\", " + this.allow_null + ", \"" + this.default_value + "\")";
        JCStringValidator jCStringValidator = new JCStringValidator(null, this.mask, this.num_match, this.place_holder_chars, this.picklist, this.match_picklist, this.valid_chars, this.invalid_chars, this.allow_null, this.default_value);
        AbstractValidatorEditor.ValidatorInfo validatorInfo = new AbstractValidatorEditor.ValidatorInfo(this, jCStringValidator, string);
        return validatorInfo;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.picklist_dialog.setVisible(true);
    }

    public void createPickListDialog() {
        this.picklist_dialog = new JDialog(JOptionPane.getFrameForComponent(this.getParent()), true);
        this.picklist_editor = new ListModelEditor(String.class);
        this.picklist_dialog.getContentPane().add(this.picklist_editor);
        this.picklist_dialog.pack();
    }

    protected class PredefinedMask {
        String name;
        String mask;

        public PredefinedMask(String string, String string2) {
            this.name = string;
            this.mask = string2;
        }

        public String toString() {
            if (this.mask != null) {
                return this.name + " [ " + this.mask + " ]";
            }
            return this.name;
        }
    }
}

