/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.util;

import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.util.ColumnDataBinding;
import com.klg.jclass.datasource.util.ExceptionManager;
import com.klg.jclass.datasource.util.LocaleBundle;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public abstract class FieldDataBinding
extends ColumnDataBinding {
    public FieldDataBinding(Component component) {
        super(component);
    }

    protected void tableChanged() {
        this.setDataAvailableState();
    }

    protected void rowDataChanged(int n2) {
        this.refreshCell(this.readCurrentCell());
    }

    protected void cellDataChanged(int n2, String string) {
        if (string.equals(this.column_name)) {
            this.refreshCell(this.readCurrentCell());
        }
    }

    protected void currentRowChanged(int n2) {
        this.setDataAvailableState();
        this.refreshCell(this.readCurrentCell());
    }

    protected boolean beforeCurrentRowChange() {
        return this.isColumnEditable() ? this.saveCell() : true;
    }

    protected void rowInserted() {
    }

    protected void rowDeleted() {
        this.toggleDataAvailableState();
    }

    protected abstract void refreshCell(Object var1);

    protected abstract boolean saveCell();

    protected Object readCurrentCell() {
        if (this.isDataAvailable()) {
            try {
                return this.binding.getCurrentCell(this, this.column_name);
            }
            catch (DataModelException dataModelException) {
                ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            }
        }
        return null;
    }

    public void saveItem(Object object) {
        if (!this.isDataAvailable()) {
            return;
        }
        try {
            this.binding.setCurrentCell(this, this.column_name, object);
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
        }
    }

    public void convertAndSaveItem(String string) {
        if (!this.isDataAvailable()) {
            return;
        }
        Object object = string instanceof String && string.length() == 0 ? null : string;
        try {
            if (object != null) {
                switch (this.column_type) {
                    case 1000: {
                        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t")) {
                            object = new Boolean(true);
                            break;
                        }
                        if (!string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("f")) break;
                        object = new Boolean(false);
                        break;
                    }
                    case 1001: {
                        object = new Date(string.trim());
                        break;
                    }
                    case 1002: {
                        if (string.trim().equalsIgnoreCase("infinity")) {
                            object = new Double(Double.POSITIVE_INFINITY);
                            break;
                        }
                        object = Double.valueOf(string.trim());
                        break;
                    }
                    case 1003: {
                        if (string.trim().equalsIgnoreCase("infinity")) {
                            object = new Float(Float.POSITIVE_INFINITY);
                            break;
                        }
                        object = Float.valueOf(string.trim());
                        break;
                    }
                    case 1004: {
                        object = Integer.valueOf(string.trim());
                        break;
                    }
                    case 1005: {
                        object = string;
                        break;
                    }
                    case 1006: {
                        object = new BigDecimal(string.trim());
                        break;
                    }
                    case 1007: {
                        object = Long.valueOf(string.trim());
                        break;
                    }
                    case 1008: {
                        object = Time.valueOf(string.trim());
                        break;
                    }
                    case 1009: {
                        if (string.indexOf(":") < 0) {
                            object = Timestamp.valueOf(string.trim() + " 00:00:00.0");
                            break;
                        }
                        object = Timestamp.valueOf(string.trim());
                        break;
                    }
                    case 1010: {
                        object = string;
                        break;
                    }
                    case 1011: {
                        object = Byte.valueOf(string.trim());
                        break;
                    }
                    case 1012: {
                        object = Short.valueOf(string.trim());
                        break;
                    }
                    case 1013: {
                        object = string;
                        break;
                    }
                    case 1014: {
                        object = new Date(string.trim());
                    }
                }
            }
        }
        catch (Exception exception) {
            ExceptionManager.getHandler().showException(this.getComponent(), "Error", LocaleBundle.string("Invalid data format: ") + string);
            return;
        }
        try {
            this.binding.setCurrentCell(this, this.column_name, object);
        }
        catch (DataModelException dataModelException) {
            ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
        }
    }

    public void setDataAvailable(boolean bl) {
        if (this.component != null) {
            this.component.setEnabled(this.isColumnEditable());
            if (!this.isDataAvailable()) {
                this.refreshCell(null);
            }
        }
    }

    public void setDataAvailableState() {
        this.toggleDataAvailableState();
    }

    protected void toggleDataAvailableState() {
        this.setDataAvailable(this.binding.isDataAvailable());
    }
}

