/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.jdbc;

import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.ErrorDialog;
import com.klg.jclass.datasource.LoginDialog;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.beans.NodeProperties;
import com.klg.jclass.datasource.jdbc.ConnectionInfo;
import com.klg.jclass.datasource.jdbc.DataTableConnection;
import com.klg.jclass.datasource.jdbc.MetaData;
import com.klg.jclass.util.JCEnvironment;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class MetaDataCreator
extends com.klg.jclass.datasource.beans.MetaDataCreator {
    static final long serialVersionUID = 547088802963888565L;
    private static final String sunJdbcOdbcDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
    private static final String msJdbcOdbcDriver = "com.ms.jdbc.odbc.JdbcOdbcDriver";
    private static Vector dataTableConnections = new Vector();
    private static final boolean TRACE = false;

    protected MetaDataModel create(DataModel dataModel, MetaDataModel metaDataModel, NodeProperties nodeProperties) throws DataModelException {
        MetaData metaData = null;
        DataTableConnection dataTableConnection = MetaDataCreator.getJdbcConnection(metaDataModel, nodeProperties);
        if (metaDataModel == null) {
            metaData = nodeProperties.getStatement() != null && nodeProperties.getStatement().trim().length() > 0 ? new MetaData(dataModel, dataTableConnection, nodeProperties.getStatement().trim()) : new MetaData(dataModel, dataTableConnection);
        } else {
            metaData = new MetaData(dataModel, (MetaData)metaDataModel, dataTableConnection);
            if (metaData != null) {
                if (nodeProperties.getStatement() != null && nodeProperties.getStatement().trim().length() > 0) {
                    metaData.setStatement(nodeProperties.getStatement().trim());
                }
                metaData.setDriverTable(nodeProperties.getDriverTable());
                int n2 = 0;
                while (n2 < nodeProperties.getJoins().length) {
                    metaData.joinOnParentColumn(nodeProperties.getJoins()[n2][0], nodeProperties.getJoins()[n2][1]);
                    ++n2;
                }
                if (!JCEnvironment.isDesignTime() || nodeProperties.getStatement() != null && nodeProperties.getStatement().trim().length() > 0) {
                    metaData.open();
                }
            }
        }
        if (metaData != null && nodeProperties.getDriverTable() != null && nodeProperties.getDriverTablePrimaryKeys() != null) {
            Object[] objectArray = new String[nodeProperties.getDriverTablePrimaryKeys().size()];
            nodeProperties.getDriverTablePrimaryKeys().copyInto(objectArray);
            metaData.setPrimaryKeys(nodeProperties.getDriverTable(), (String[])objectArray);
        }
        return metaData;
    }

    public static DataTableConnection getJdbcConnection(MetaDataModel metaDataModel, NodeProperties nodeProperties) throws DataModelException {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        DataTableConnection dataTableConnection = null;
        boolean bl = false;
        if (metaDataModel != null && nodeProperties.getUseParentConnection()) {
            dataTableConnection = ((MetaData)metaDataModel).getDataTableConnection();
            return dataTableConnection;
        }
        if (JCEnvironment.isDesignTime()) {
            serializable2 = new ConnectionInfo(nodeProperties);
            object = dataTableConnections.elements();
            while (object.hasMoreElements()) {
                serializable = (ConnectionInfo)object.nextElement();
                if (!((ConnectionInfo)serializable).equals(serializable2)) continue;
                return ((ConnectionInfo)serializable).getConnection();
            }
            if (dataTableConnection == null) {
                dataTableConnection = new DataTableConnection();
                serializable2.setConnection(dataTableConnection);
                dataTableConnections.addElement(serializable2);
            } else {
                bl = true;
            }
        } else {
            dataTableConnection = new DataTableConnection();
        }
        if (!JCEnvironment.isDesignTime() && nodeProperties.getPromptUserForLogin()) {
            serializable2 = null;
            object = new Frame();
            serializable = new LoginDialog((Frame)object);
            ((LoginDialog)serializable).setURL(nodeProperties.getURL());
            ((LoginDialog)serializable).setDatabase(nodeProperties.getDatabase());
            ((LoginDialog)serializable).setDriver(nodeProperties.getDriver());
            boolean bl2 = false;
            while (!bl2) {
                ((Window)serializable).pack();
                ((Dialog)serializable).show();
                if (((LoginDialog)serializable).isCancelled()) {
                    bl2 = true;
                    if (serializable2 == null) continue;
                    throw serializable2;
                }
                try {
                    if (((LoginDialog)serializable).getDriver() != null && ((LoginDialog)serializable).getDriver().trim().length() != 0) {
                        dataTableConnection.loadDriver(((LoginDialog)serializable).getDriver().trim());
                    }
                    dataTableConnection.connect(nodeProperties.getURL(), ((LoginDialog)serializable).getUser(), ((LoginDialog)serializable).getPassword(), ((LoginDialog)serializable).getDatabase());
                    bl2 = true;
                }
                catch (DataModelException dataModelException) {
                    serializable2 = dataModelException;
                    ErrorDialog.showError(null, dataModelException.toString());
                }
            }
            ((Window)serializable).dispose();
        } else if (!bl && (!JCEnvironment.isDesignTime() || nodeProperties.getURL() != null && nodeProperties.getURL().trim().length() != 0)) {
            if (nodeProperties.getDriver() != null && nodeProperties.getDriver().trim().length() != 0) {
                dataTableConnection.loadDriver(nodeProperties.getDriver().trim());
            }
            dataTableConnection.connect(nodeProperties.getURL(), nodeProperties.getUser(), nodeProperties.getPassword(), nodeProperties.getDatabase());
        }
        return dataTableConnection;
    }

    public static void resetJdbcConnection(NodeProperties nodeProperties) {
        if (JCEnvironment.isDesignTime()) {
            ConnectionInfo connectionInfo = new ConnectionInfo(nodeProperties);
            Enumeration enumeration = dataTableConnections.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionInfo connectionInfo2 = (ConnectionInfo)enumeration.nextElement();
                if (!connectionInfo2.equals(connectionInfo)) continue;
                dataTableConnections.removeElement(connectionInfo);
            }
        }
    }
}

