/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.jdbc;

import com.klg.jclass.datasource.BaseMetaData;
import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataSourceTreeModel;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.jdbc.Column;
import com.klg.jclass.datasource.jdbc.DataTable;
import com.klg.jclass.datasource.jdbc.DataTableConnection;
import com.klg.jclass.datasource.jdbc.PersistorModel;
import com.klg.jclass.datasource.util.ColumnMap;
import com.klg.jclass.datasource.util.SqlParser;
import com.klg.jclass.datasource.util.SqlStatementColumn;
import com.klg.jclass.datasource.util.SqlStatementTable;
import com.klg.jclass.util.JCEnvironment;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class MetaData
extends BaseMetaData
implements Serializable {
    static final long serialVersionUID = 4469150227741079237L;
    public static final int DEFAULT_DESIGN_TIME_MAX_ROWS = 10;
    protected DataTableConnection ds_connection;
    protected transient PreparedStatement query_statement;
    protected int numColumns = 0;
    protected Hashtable tableToPrimaryKeyMap = new Hashtable();
    protected MetaData parent_control;
    protected Vector join_columns = new Vector();
    protected Vector tables;
    protected String query;
    protected Vector tableColumnIndexes = new Vector();
    protected boolean open = false;
    protected String driverTable = null;
    protected PersistorModel persistor = null;
    protected SqlParser parser;
    protected static int designTimeMaxRows = 10;
    protected static int NOT_FOUND = -1;

    MetaData(DataModel dataModel) {
        super(dataModel);
        this.createDefaultPersistor();
    }

    public MetaData(DataModel dataModel, DataTableConnection dataTableConnection) {
        this(dataModel);
        this.ds_connection = dataTableConnection;
        this.tables = new Vector();
    }

    public MetaData(DataModel dataModel, DataTableConnection dataTableConnection, String string, int n2) throws DataModelException {
        this(dataModel, dataTableConnection);
        Serializable serializable;
        MetaDataModel metaDataModel = null;
        if (dataModel.getMetaDataTree().getRoot() != null) {
            serializable = (DataSourceTreeNode)dataModel.getMetaDataTree().getRoot();
        }
        if (metaDataModel != null) {
            serializable = new Exception(LocaleBundle.string("The root level MetaData has already been set.  This root-level convenience constructor should only be called when the root does not already exist. ") + metaDataModel.getDescription());
            throw new DataModelException(107, (Exception)serializable);
        }
        ((DataSourceTreeModel)dataModel.getMetaDataTree()).setRoot(this);
        this.setStatement(string);
        this.query = string;
        this.open();
        if (JCEnvironment.isDesignTime()) {
            this.setMaxRows(designTimeMaxRows);
        } else if (n2 > -1) {
            this.setMaxRows(n2);
        }
        ((DataSourceTreeModel)dataModel.getDataTableTree()).setRoot(this.executeQuery());
        this.open = true;
    }

    public MetaData(DataModel dataModel, DataTableConnection dataTableConnection, String string) throws DataModelException {
        this(dataModel, dataTableConnection, string, -1);
    }

    public MetaData(DataModel dataModel, MetaDataModel metaDataModel, DataTableConnection dataTableConnection) {
        this(dataModel, dataTableConnection);
        ((DataSourceTreeNode)((Object)metaDataModel)).add(this);
    }

    public void setConnection(DataTableConnection dataTableConnection) {
        this.ds_connection = dataTableConnection;
    }

    public DataTableConnection getDataTableConnection() {
        return this.ds_connection;
    }

    public void setStatement(String string) throws DataModelException {
        this.query = string;
        this.parser = new SqlParser(string);
        try {
            if (this.query_statement != null) {
                this.query_statement.close();
            }
            this.query_statement = this.ds_connection.getConnection().prepareCall(string);
        }
        catch (SQLException sQLException) {
            try {
                this.query_statement = this.ds_connection.getConnection().prepareStatement(string);
            }
            catch (SQLException sQLException2) {
                throw new DataModelException(107, sQLException2);
            }
        }
    }

    public void setWhereClause(String string) throws DataModelException {
        String string2 = this.parser.getClause(0, true) + " ";
        string2 = string2 + this.parser.getClause(1, true) + " ";
        this.setStatement(string2 + string);
    }

    public String getWhereClause() {
        return this.parser == null ? "" : this.parser.getClause(2);
    }

    public String getStatement() {
        return this.query;
    }

    public void joinOnParentColumn(String string, String string2) {
        this.join_columns.addElement(new ColumnMap(string, string2));
    }

    public void setParameter(int n2, Object object, int n3) throws DataModelException {
        try {
            if (object == null) {
                this.query_statement.setNull(n2, n3);
                switch (n3) {
                    case 91: {
                        this.query_statement.setNull(n2, 9);
                        break;
                    }
                    case 92: {
                        this.query_statement.setNull(n2, 10);
                        break;
                    }
                    case 93: {
                        this.query_statement.setNull(n2, 11);
                        break;
                    }
                }
            } else {
                this.query_statement.setObject(n2, object);
            }
        }
        catch (SQLException sQLException) {
            throw new DataModelException(107, sQLException);
        }
    }

    public Vector getTables() {
        if (this.tables.size() != 0) {
            return this.tables;
        }
        int n2 = 0;
        while (n2 < this.numColumns) {
            String string = ((ColumnModel)this.getColumnObjects().elementAt(n2)).getTableName();
            if (string != null && !string.equals("") && !this.tables.contains(string)) {
                this.tables.addElement(string);
            }
            ++n2;
        }
        return this.tables;
    }

    public Vector getColumnIndexesForTable(String string) {
        if (this.tableColumnIndexes.size() != 0) {
            return (Vector)this.tableColumnIndexes.elementAt(this.tables.indexOf(string));
        }
        Enumeration enumeration = this.tables.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Vector<Integer> vector = new Vector<Integer>();
            this.tableColumnIndexes.addElement(vector);
            int n2 = 0;
            while (n2 < this.numColumns) {
                String string3 = ((ColumnModel)this.getColumnObjects().elementAt(n2)).getTableName();
                if (string3 != null && string3.equals(string2)) {
                    vector.addElement(new Integer(n2));
                }
                ++n2;
            }
        }
        return (Vector)this.tableColumnIndexes.elementAt(this.tables.indexOf(string));
    }

    public DataTable executeQuery() throws DataModelException {
        if (!this.open) {
            this.open();
        }
        return this.executeQuery(-1L);
    }

    public DataTable executeQuery(long l2) throws DataModelException {
        if (this.ds_connection.getConnection() == null) {
            Exception exception = new Exception(LocaleBundle.string("Connection or query is null"));
            throw new DataModelException(107, exception);
        }
        DataTable dataTable = null;
        try {
            this.query_statement.setMaxRows(JCEnvironment.isDesignTime() ? designTimeMaxRows : this.getMaxRows());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            ResultSet resultSet;
            try {
                resultSet = this.query_statement.executeQuery();
            }
            catch (SQLException sQLException) {
                this.setStatement(this.query);
                resultSet = this.query_statement.executeQuery();
            }
            dataTable = new DataTable(this.numColumns, this, l2);
            boolean bl = false;
            while (resultSet.next()) {
                dataTable.addInternalRow(this.createRowFromResultSet(resultSet));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new DataModelException(107, sQLException);
        }
        return dataTable;
    }

    public void addColumnToIdentifiers(String string, int n2) throws DataModelException {
        if (this.getColumnMap().containsKey(string)) {
            Exception exception = new Exception(LocaleBundle.string("Duplicate columns not allowed. Use aliasing. Column: ") + string);
            throw new DataModelException(107, exception);
        }
        this.getColumnMap().put(string, new Integer(n2));
    }

    Object[] createRowFromResultSet(ResultSet resultSet) throws DataModelException {
        Object[] objectArray = new Object[this.numColumns];
        try {
            int n2 = 1;
            while (n2 < this.numColumns + 1) {
                Object object = null;
                ColumnModel columnModel = (ColumnModel)this.getColumnObjects().elementAt(n2 - 1);
                object = columnModel.getMetaColumnType() == 1013 ? (Object)this.createByteArrayFromBinaryStream(resultSet.getBinaryStream(n2)) : resultSet.getObject(n2);
                objectArray[n2 - 1] = object;
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            throw new DataModelException(107, sQLException);
        }
        return objectArray;
    }

    void createColumnInfo(ResultSetMetaData resultSetMetaData) throws DataModelException {
        try {
            this.numColumns = resultSetMetaData.getColumnCount();
        }
        catch (SQLException sQLException) {
            throw new DataModelException(107, sQLException);
        }
        int n2 = 1;
        while (n2 < this.numColumns + 1) {
            Column column = new Column(resultSetMetaData, n2);
            this.getColumnObjects().addElement(column);
            ++n2;
        }
    }

    public void clear() {
    }

    public void setPrimaryKeys(String string, String[] stringArray) {
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n2 = 0;
        while (n2 < stringArray.length) {
            vector.addElement(stringArray[n2]);
            ++n2;
        }
        this.tableToPrimaryKeyMap.put(string, vector);
    }

    Vector getPrimaryKeys(String string) throws DataModelException {
        if (string == null) {
            return new Vector(0);
        }
        if (this.tableToPrimaryKeyMap.containsKey(string)) {
            return (Vector)this.tableToPrimaryKeyMap.get(string);
        }
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            DatabaseMetaData databaseMetaData = this.ds_connection.getConnection().getMetaData();
            String string3 = null;
            if (string.indexOf(".") > NOT_FOUND) {
                int n2 = string.indexOf(".");
                string3 = string.substring(0, n2);
                string = string.substring(n2 + 1, string.length());
            }
            ResultSet resultSet = null;
            try {
                resultSet = databaseMetaData.getPrimaryKeys(null, null, string);
            }
            catch (SQLException sQLException) {
                resultSet = databaseMetaData.getBestRowIdentifier(null, null, string, 2, true);
            }
            while (resultSet.next()) {
                string2 = string3 + "." + string + "." + resultSet.getString("COLUMN_NAME");
                vector.addElement(string2);
            }
            if (vector.size() == 0) {
                resultSet = databaseMetaData.getBestRowIdentifier(null, null, string, 2, true);
                while (resultSet.next()) {
                    string2 = string3 + "." + string + "." + resultSet.getString("COLUMN_NAME");
                    vector.addElement(string2);
                }
            }
            if (vector.size() == 0) {
                string2 = LocaleBundle.string("Cannot determine primary key automatically. Use MetaData.setPrimaryKeys() to set the primary key for table: ");
                string2 = string2 + string;
                throw new DataModelException(107, new Exception(string2));
            }
        }
        catch (SQLException sQLException) {
            throw new DataModelException(107, sQLException);
        }
        this.tableToPrimaryKeyMap.put(string, vector);
        return vector;
    }

    private Vector getBestIdentifier(String string) {
        Vector<String> vector = new Vector<String>();
        try {
            DatabaseMetaData databaseMetaData = this.ds_connection.getConnection().getMetaData();
            String string2 = null;
            if (string.indexOf(".") > NOT_FOUND) {
                int n2 = string.indexOf(".");
                string2 = string.substring(0, n2);
                string = string.substring(n2 + 1, string.length());
            }
            ResultSet resultSet = databaseMetaData.getBestRowIdentifier(null, null, string, 2, true);
            while (resultSet.next()) {
                String string3 = string2 + "." + string + "." + resultSet.getString("COLUMN_NAME");
                vector.addElement(string3);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return vector;
    }

    public DataTable open() throws DataModelException {
        if (this.isOpen()) {
            return null;
        }
        if (this.query_statement == null) {
            Exception exception = new Exception(LocaleBundle.string("You must set the query statement before using/opening this MetaData object. ") + this.getDescription());
            throw new DataModelException(107, exception);
        }
        try {
            String string;
            Object object;
            Object object2;
            if (!this.parameterCountsMatch()) {
                String string2 = LocaleBundle.string("The number of join columns and the number of question mark place holders do not match: ");
                string2 = string2 + this.getDescription();
                throw new DataModelException(107, new Exception(string2));
            }
            MetaDataModel metaDataModel = (MetaDataModel)this.getParent();
            int n2 = 1;
            Enumeration enumeration = this.join_columns.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (ColumnMap)enumeration.nextElement();
                ColumnModel columnModel = metaDataModel.getColumnObject(((ColumnMap)object2).getParentColumn());
                int n3 = columnModel.getColumnType();
                object = new Object();
                String string3 = "-1";
                switch (n3) {
                    case -1: 
                    case 1: 
                    case 12: {
                        object = new String(string3);
                        break;
                    }
                    case 2: {
                        object = new BigDecimal(string3);
                        break;
                    }
                    case -7: {
                        object = new Boolean(false);
                        break;
                    }
                    case -6: {
                        object = new Byte(string3);
                        break;
                    }
                    case 5: {
                        object = new Short(string3);
                        break;
                    }
                    case 4: {
                        object = new Integer(string3);
                        break;
                    }
                    case -5: {
                        object = new BigInteger(string3);
                        break;
                    }
                    case 7: {
                        object = new Float(string3);
                        break;
                    }
                    case 8: {
                        object = new Double(string3);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        object = new Byte(string3);
                        break;
                    }
                    case 91: {
                        object = new Date(System.currentTimeMillis());
                        break;
                    }
                    case 92: {
                        object = new Time(System.currentTimeMillis());
                        break;
                    }
                    case 93: {
                        object = new Timestamp(System.currentTimeMillis());
                        break;
                    }
                }
                this.query_statement.setObject(n2++, object, n3);
            }
            this.open = true;
            object2 = this.ds_connection.getConnection().getMetaData();
            boolean bl = false;
            if (object2 != null && (string = object2.getDriverName()) != null) {
                boolean bl2 = bl = string.toLowerCase().indexOf("jconnect") > -1;
            }
            if (!bl) {
                try {
                    this.query_statement.setMaxRows(1);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            ResultSet resultSet = this.query_statement.executeQuery();
            if (this.getColumnObjects().size() == 0) {
                object = resultSet.getMetaData();
                this.createColumnInfo((ResultSetMetaData)object);
                if (!this.columnTableRelationsSet()) {
                    this.queryColumnTableRelations();
                }
                int n4 = 0;
                while (n4 < this.numColumns) {
                    Column column = (Column)this.getColumnObjects().elementAt(n4);
                    column.determineIdentifier(this.parser);
                    this.addColumnToIdentifiers(column.getIdentifier(), n4);
                    ++n4;
                }
            }
            while (resultSet.next()) {
            }
            resultSet.close();
            if (!bl) {
                try {
                    this.query_statement.setMaxRows(0);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return new DataTable(this.columns.size(), this);
        }
        catch (SQLException sQLException) {
            this.open = false;
            throw new DataModelException(107, sQLException);
        }
    }

    private boolean columnTableRelationsSet() {
        int n2 = 0;
        while (n2 < this.numColumns) {
            String string = ((ColumnModel)this.getColumnObjects().elementAt(n2)).getTableName();
            if (string != null && !string.equals("")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void queryColumnTableRelations() {
        SqlParser sqlParser = new SqlParser(this.query);
        try {
            DatabaseMetaData databaseMetaData = this.ds_connection.getConnection().getMetaData();
            int n2 = sqlParser.getTables().size();
            Enumeration enumeration = sqlParser.getTables().elements();
            while (enumeration.hasMoreElements()) {
                SqlStatementTable sqlStatementTable = (SqlStatementTable)enumeration.nextElement();
                ResultSet resultSet = databaseMetaData.getColumns(sqlStatementTable.getCatalogName(), sqlStatementTable.getSchemaName(), sqlStatementTable.getTableName(), null);
                block3: while (resultSet.next()) {
                    String string = resultSet.getString("COLUMN_NAME");
                    int n3 = resultSet.getInt("DATA_TYPE");
                    String string2 = resultSet.getString("TYPE_NAME");
                    Enumeration enumeration2 = this.getColumnObjects().elements();
                    while (enumeration2.hasMoreElements()) {
                        ColumnModel columnModel = (ColumnModel)enumeration2.nextElement();
                        if (!columnModel.getColumnName().equals(string) || n2 != 1 && !this.columnBelongsToTable(sqlStatementTable, columnModel, string, n3, string2)) continue;
                        columnModel.setTableName(sqlStatementTable.getTableName());
                        continue block3;
                    }
                }
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.toString());
        }
    }

    private boolean columnBelongsToTable(SqlStatementTable sqlStatementTable, ColumnModel columnModel, String string, int n2, String string2) {
        boolean bl = false;
        Enumeration enumeration = this.parser.getColumnsForTable(sqlStatementTable.getAlias()).elements();
        SqlStatementColumn sqlStatementColumn = null;
        while (enumeration.hasMoreElements()) {
            sqlStatementColumn = (SqlStatementColumn)enumeration.nextElement();
            if (sqlStatementColumn.getTableName() != null && !sqlStatementColumn.getColumnName().equals(string) && !sqlStatementColumn.getColumnName().equals("*")) continue;
            bl = true;
            break;
        }
        return !(!bl || !columnModel.getColumnName().equals(string) && (sqlStatementColumn == null || !sqlStatementColumn.getColumnName().equals(string)) || columnModel.getColumnType() != n2 && !columnModel.getColumnTypeName().equals(string2) || columnModel.getTableName() != null && !columnModel.getTableName().equals(""));
    }

    private boolean parameterCountsMatch() {
        return this.join_columns.size() == this.countQuestionMarks();
    }

    private int countQuestionMarks() {
        int n2 = 0;
        int n3 = 0;
        while (this.query.substring(n3, this.query.length()).indexOf("?") > NOT_FOUND) {
            n3 += this.query.substring(n3, this.query.length()).indexOf("?");
            ++n3;
            ++n2;
        }
        return n2;
    }

    public void setColumnTableRelations(String string, String[] stringArray) throws DataModelException {
        if (!this.isOpen()) {
            throw new DataModelException(107, this.createNotOpenException("setColumnTableRelations()"));
        }
        if (stringArray[0].equals("*")) {
            int n2 = 0;
            while (n2 < this.getColumnCount()) {
                ((ColumnModel)this.getColumnObjects().elementAt(n2)).setTableName(string);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.getColumnObjects().size()) {
                ColumnModel columnModel = (ColumnModel)this.getColumnObjects().elementAt(n3);
                if (columnModel.getTableName() != null && columnModel.getTableName().equals(string)) {
                    columnModel.setTableName("");
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < stringArray.length) {
                int n5 = 0;
                while (n5 < this.getColumnObjects().size()) {
                    ColumnModel columnModel = (ColumnModel)this.getColumnObjects().elementAt(n5);
                    String string2 = stringArray[n4];
                    if (columnModel.getColumnName().equals(stringArray[n4]) || columnModel.getIdentifier().equals(stringArray[n4])) {
                        columnModel.setTableName(string);
                        break;
                    }
                    ++n5;
                }
                ++n4;
            }
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    private Exception createNotOpenException(String string) {
        String string2 = LocaleBundle.string("MetaData is not open.  Call MetaData.open() before calling: ");
        string2 = string2 + this.getDescription();
        string2 = string2 + " " + string;
        return new Exception(string2);
    }

    public void setDriverTable(String string) {
        this.driverTable = string;
    }

    public String getDriverTable() {
        if (this.driverTable == null) {
            this.driverTable = (String)this.getTables().elementAt(0);
        }
        return this.driverTable;
    }

    public int getDriverTableIndex() {
        if (this.getDriverTable() == null) {
            return 0;
        }
        return this.getTables().indexOf(this.driverTable);
    }

    public void setAutoCommit(boolean bl) throws DataModelException {
        try {
            this.ds_connection.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            throw new DataModelException(107, sQLException);
        }
    }

    public boolean getAutoCommit() throws DataModelException {
        try {
            return this.ds_connection.getAutoCommit();
        }
        catch (SQLException sQLException) {
            throw new DataModelException(107, sQLException);
        }
    }

    public void rollbackTransaction() throws DataModelException {
        try {
            if (!this.getAutoCommit()) {
                this.getDataTableConnection().getConnection().rollback();
            }
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                ((MetaDataModel)enumeration.nextElement()).rollbackTransaction();
            }
        }
        catch (SQLException sQLException) {
            throw new DataModelException(107, sQLException);
        }
    }

    public void commitTransaction() throws DataModelException {
        try {
            if (!this.getAutoCommit()) {
                this.getDataTableConnection().getConnection().commit();
            }
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                ((MetaDataModel)enumeration.nextElement()).commitTransaction();
            }
        }
        catch (SQLException sQLException) {
            throw new DataModelException(107, sQLException);
        }
    }

    public boolean isUpdateAllowedOnColumn(String string) throws DataModelException {
        Enumeration enumeration = this.getColumnObjects().elements();
        while (enumeration.hasMoreElements()) {
            ColumnModel columnModel = (ColumnModel)enumeration.nextElement();
            if (!columnModel.getIdentifier().equals(string)) continue;
            String string2 = columnModel.getTableName();
            try {
                this.getPrimaryKeys(string2);
            }
            catch (DataModelException dataModelException) {
                throw new DataModelException(4, dataModelException);
            }
            if (string2 == null || string2.equals("")) {
                return false;
            }
            SqlStatementTable sqlStatementTable = this.parser.getSqlStatementTable(string2);
            if (sqlStatementTable == null || sqlStatementTable.equals("")) {
                return false;
            }
            return this.getUpdateAllowed(sqlStatementTable.getAlias());
        }
        return true;
    }

    public SqlParser getParser() {
        return this.parser;
    }

    public void addColumn(ColumnModel columnModel) throws DataModelException {
        if (!this.isOpen()) {
            throw new DataModelException(107, this.createNotOpenException("addColumn()"));
        }
        try {
            this.addColumnToIdentifiers(columnModel.getIdentifier(), this.getColumnMap().size());
        }
        catch (DataModelException dataModelException) {
            throw new DataModelException(107, dataModelException);
        }
        super.addColumn(columnModel);
    }

    public Object getNativeMetaData() {
        return this;
    }

    public void setPersistor(String string) throws DataModelException {
        try {
            this.persistor = (PersistorModel)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DataModelException(107, classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DataModelException(107, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new DataModelException(107, instantiationException);
        }
    }

    public PersistorModel getPersistor() {
        return this.persistor;
    }

    public static void setDesignTimeMaxRows(int n2) {
        designTimeMaxRows = n2;
    }

    public static int getDesignTimeMaxRows() {
        return designTimeMaxRows;
    }

    public Vector getJoinColumns() {
        return this.join_columns;
    }

    private void createDefaultPersistor() {
        try {
            this.setPersistor("com.klg.jclass.datasource.jdbc.Persistor");
        }
        catch (DataModelException dataModelException) {
            System.out.println(dataModelException.toString());
        }
    }

    protected void finalize() {
        if (this.query_statement != null) {
            try {
                this.query_statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

