/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.customizer;

import com.klg.jclass.datasource.ErrorDialog;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.customizer.TableChooserParent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TableChooser
extends JDialog
implements ActionListener,
ItemListener {
    Vector tableNames = new Vector();
    JCheckBox useSystemTables;
    JButton btnClose;
    JButton btnAdd;
    JButton btnRefresh;
    JList list;
    JScrollPane scrollPane;
    TableChooserParent parent;

    public TableChooser(TableChooserParent tableChooserParent) {
        super(tableChooserParent.getFrame(), LocaleBundle.string("Table Chooser"));
        this.parent = tableChooserParent;
        this.init();
    }

    public void init() {
        this.setModal(true);
        GridBagConstraints gridBagConstraints = null;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.useSystemTables = new JCheckBox(LocaleBundle.string("Use System Tables"), false);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.btnAdd = new JButton(LocaleBundle.string("Add"));
        this.btnRefresh = new JButton(LocaleBundle.string("Refresh"));
        this.btnClose = new JButton(LocaleBundle.string("Close"));
        this.list = new JList();
        this.scrollPane = new JScrollPane(this.list);
        this.useSystemTables.addItemListener(this);
        jPanel.add(this.useSystemTables);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        this.btnAdd.addActionListener(this);
        this.btnRefresh.addActionListener(this);
        this.btnClose.addActionListener(this);
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel2.add((Component)this.btnAdd, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        jPanel2.add((Component)this.btnRefresh, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        jPanel2.add((Component)this.btnClose, gridBagConstraints);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.getContentPane().add((Component)jPanel3, "East");
        this.pack();
        this.refresh();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TableChooser.this.setVisible(false);
            }
        });
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 240);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            int n2 = this.getParent().getBounds().x + (this.getParent().getBounds().width - this.getBounds().width) / 2;
            int n3 = this.getParent().getBounds().y + (this.getParent().getBounds().height - this.getBounds().height) / 2;
            if (n2 >= 0 && n3 >= 0) {
                this.setLocation(n2, n3);
            }
        }
        super.setVisible(bl);
    }

    public void getTables() {
        this.tableNames.removeAllElements();
        try {
            DatabaseMetaData databaseMetaData = this.parent.getConnection().getMetaData();
            String[] stringArray = this.useSystemTables.isSelected() ? new String[]{"TABLE", "SYSTEM TABLE"} : new String[]{"TABLE"};
            ResultSet resultSet = databaseMetaData.getTables(null, "%", "%", stringArray);
            int n2 = 0;
            while (resultSet.next()) {
                String string = resultSet.getString(2) + "." + resultSet.getString(3);
                this.tableNames.addElement(string);
                ++n2;
            }
            resultSet.close();
        }
        catch (Exception exception) {
            ErrorDialog.showError(this, exception + System.getProperty("line.separator") + LocaleBundle.string("Failed to get a list of tables"));
        }
    }

    public void refresh() {
        this.list.removeAll();
        this.getTables();
        if (this.tableNames.size() > 0) {
            this.list.setListData(this.tableNames);
        }
    }

    public void getTableSelected() {
        int[] nArray = this.list.getSelectedIndices();
        if (nArray != null) {
            Vector<String> vector = new Vector<String>();
            int n2 = 0;
            while (n2 < nArray.length) {
                vector.addElement((String)this.list.getModel().getElementAt(nArray[n2]));
                ++n2;
            }
            this.list.getSelectionModel().clearSelection();
            this.parent.tableSelected(vector);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.equals(this.btnAdd)) {
                this.getTableSelected();
            } else if (jButton.equals(this.btnRefresh)) {
                this.refresh();
            } else if (jButton.equals(this.btnClose)) {
                this.setVisible(false);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.refresh();
    }
}

