/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.customizer;

import com.klg.jclass.datasource.ErrorDialog;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.beans.JCDataEvent;
import com.klg.jclass.datasource.beans.NodeProperties;
import com.klg.jclass.datasource.customizer.CustomizerLauncher;
import com.klg.jclass.datasource.customizer.DataModelPage;
import com.klg.jclass.datasource.customizer.JDBCPage;
import com.klg.jclass.datasource.jdbc.DataTableConnection;
import com.klg.jclass.util.internal.JClassInfo;
import com.klg.jclass.util.swing.JCAlignLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ConnectionPanel
extends DataModelPage
implements ActionListener,
ItemListener {
    JCheckBox useParentConnection;
    JCheckBox promptUserForLogin;
    JCheckBox autoCommit;
    JTextField hostField;
    JTextField portField;
    JTextField loginField;
    JTextField passwordField;
    JTextField dbField;
    JButton btnConnect;
    JLabel connectMsg;
    JPanel controlPanel;
    JComboBox urlList;
    JComboBox driverList;
    JPanel serverPanel;
    JPanel loginPanel;
    DataTableConnection dsConnection = new DataTableConnection();
    JDBCPage jdbcPage = null;
    private static String defaultDelimiter = "#!#*#";
    private static String jdbcUrls = "jdbc.urls";
    private static String jdbcUrlsDelimiter = "jdbc.urls.delimiter";
    private static String jdbcDrivers = "jdbc.drivers";
    private static String sunJdbcOdbcDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
    private static String msJdbcOdbcDriver = "com.ms.jdbc.odbc.JdbcOdbcDriver";
    private static final boolean TRACE = false;

    public ConnectionPanel(JDBCPage jDBCPage) {
        super("Connection");
        this.jdbcPage = jDBCPage;
        this.setLayout(new BorderLayout());
        this.useParentConnection = new JCheckBox(LocaleBundle.string("Use Parent Connection"));
        this.autoCommit = new JCheckBox(LocaleBundle.string("Auto Commit"), true);
        this.useParentConnection.setEnabled(false);
        this.useParentConnection.addItemListener(this);
        this.autoCommit.setEnabled(true);
        this.autoCommit.addItemListener(this);
        JLabel jLabel = new JLabel(LocaleBundle.string("Server Name"));
        JLabel jLabel2 = new JLabel(LocaleBundle.string("Host or IP Address"));
        this.hostField = new JTextField("", 30);
        JLabel jLabel3 = new JLabel(LocaleBundle.string("TCP/IP Port"));
        this.portField = new JTextField("", 30);
        JLabel jLabel4 = new JLabel(LocaleBundle.string("Driver"));
        this.urlList = new JComboBox();
        this.driverList = new JComboBox();
        this.urlList.setEditable(true);
        this.driverList.setEditable(true);
        this.serverPanel = new JPanel();
        this.serverPanel.setBorder(new TitledBorder(LocaleBundle.string("Server")));
        JCAlignLayout jCAlignLayout = new JCAlignLayout();
        this.serverPanel.setLayout(jCAlignLayout);
        this.serverPanel.add(jLabel);
        this.serverPanel.add(this.urlList);
        jCAlignLayout.setResizeWidth(this.urlList, true);
        this.urlList.addActionListener(this);
        this.serverPanel.add(jLabel2);
        this.serverPanel.add(this.hostField);
        jCAlignLayout.setResizeWidth(this.hostField, true);
        this.hostField.addActionListener(this);
        this.serverPanel.add(jLabel3);
        this.serverPanel.add(this.portField);
        jCAlignLayout.setResizeWidth(this.portField, true);
        this.portField.addActionListener(this);
        this.serverPanel.add(jLabel4);
        this.serverPanel.add(this.driverList);
        jCAlignLayout.setResizeWidth(this.driverList, true);
        this.driverList.addActionListener(this);
        try {
            Class.forName(sunJdbcOdbcDriver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class.forName(msJdbcOdbcDriver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JClassInfo.getProperty("datasource", jdbcDrivers);
        this.populate();
        JLabel jLabel5 = new JLabel(LocaleBundle.string("Login Name"));
        this.loginField = new JTextField("", 30);
        JLabel jLabel6 = new JLabel(LocaleBundle.string("Password"));
        this.passwordField = new JPasswordField("", 30);
        JLabel jLabel7 = new JLabel(LocaleBundle.string("Database"));
        this.dbField = new JTextField("", 30);
        JLabel jLabel8 = new JLabel("");
        this.promptUserForLogin = new JCheckBox(LocaleBundle.string("Prompt User For Login"));
        this.loginPanel = new JPanel();
        this.loginPanel.setBorder(new TitledBorder(LocaleBundle.string("Login")));
        jCAlignLayout = new JCAlignLayout();
        this.loginPanel.setLayout(jCAlignLayout);
        this.loginPanel.add(jLabel5);
        this.loginPanel.add(this.loginField);
        jCAlignLayout.setResizeWidth(this.loginField, true);
        this.loginField.addActionListener(this);
        this.loginPanel.add(jLabel6);
        this.loginPanel.add(this.passwordField);
        jCAlignLayout.setResizeWidth(this.passwordField, true);
        this.passwordField.addActionListener(this);
        this.loginPanel.add(jLabel7);
        this.loginPanel.add(this.dbField);
        jCAlignLayout.setResizeWidth(this.dbField, true);
        this.dbField.addActionListener(this);
        this.loginPanel.add(jLabel8);
        this.promptUserForLogin.addItemListener(this);
        this.loginPanel.add(this.promptUserForLogin);
        this.controlPanel = new JPanel();
        JPanel jPanel = new JPanel();
        this.btnConnect = new JButton(LocaleBundle.string("Connect"));
        this.connectMsg = new JLabel();
        this.connectMsg.setText(" ");
        this.controlPanel.setLayout(new BorderLayout());
        jPanel.add(this.btnConnect);
        this.controlPanel.add((Component)jPanel, "Center");
        this.controlPanel.add((Component)this.connectMsg, "South");
        this.btnConnect.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(this.serverPanel);
        jPanel2.add(this.loginPanel);
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridy = 0;
        jPanel3.add((Component)this.useParentConnection, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)this.autoCommit, gridBagConstraints);
        this.add((Component)jPanel3, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)this.controlPanel, "South");
        CustomizerLauncher.setDefaultFont(this, new Font("Dialog", 0, 9));
    }

    void setUseConnectionPage(boolean bl) {
        this.hostField.setEnabled(bl);
        this.portField.setEnabled(bl);
        this.urlList.setEnabled(bl);
        this.driverList.setEnabled(bl);
        this.loginField.setEnabled(bl);
        this.passwordField.setEnabled(bl);
        this.dbField.setEnabled(bl);
        this.promptUserForLogin.setEnabled(bl);
    }

    public void setUseInHierarchy(boolean bl) {
        this.useParentConnection.setEnabled(bl);
        if (bl) {
            this.setUseConnectionPage(this.useParentConnection.isSelected());
        }
    }

    private void connectionInfoChanged() {
        try {
            this.getNodeProperties().setJDBCInfo(this.getDriver(), this.getURL(), this.getUser(), this.getPassword(), this.getDatabase());
        }
        catch (Exception exception) {
            ErrorDialog.showError(this, exception.toString());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isInitializing()) {
            return;
        }
        if (actionEvent.getSource() instanceof JComboBox) {
            return;
        }
        this.connectMsg.setText("");
        if (this.getNodeProperties() == null) {
            return;
        }
        if (actionEvent.getSource() == this.btnConnect) {
            this.connectMsg.setText(LocaleBundle.string("Connecting..."));
        }
        this.connectionInfoChanged();
        String string = "";
        if (actionEvent.getSource() instanceof JButton && actionEvent.getSource().equals(this.btnConnect)) {
            Connection connection = null;
            try {
                DataTableConnection dataTableConnection = this.getNodeProperties().getConnection();
                connection = dataTableConnection == null ? null : dataTableConnection.getConnection();
            }
            catch (Exception exception) {
                ErrorDialog.showError(this, exception.toString());
            }
            String string2 = string = connection == null ? LocaleBundle.string("Connect Failed") : LocaleBundle.string("Connect Succeeded");
            if (connection != null) {
                this.updatePropertyFile();
            } else {
                this.getNodeProperties().resetConnection();
            }
        }
        this.getNodeProperties().fireJCDataEvent(new JCDataEvent(this.getNodeProperties()));
        this.connectMsg.setText(string);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isInitializing()) {
            return;
        }
        if (itemEvent.getSource() instanceof JCheckBox) {
            JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
            boolean bl = jCheckBox.isSelected();
            if (jCheckBox.equals(this.useParentConnection)) {
                this.setUseConnectionPage(!bl);
                this.getNodeProperties().setUseParentConnection(bl);
                this.connectionInfoChanged();
                this.getNodeProperties().fireJCDataEvent(new JCDataEvent(this.getNodeProperties()));
            } else if (jCheckBox.equals(this.promptUserForLogin)) {
                this.getNodeProperties().setPromptUserForLogin(bl);
                this.connectionInfoChanged();
                this.getNodeProperties().fireJCDataEvent(new JCDataEvent(this.getNodeProperties()));
            } else if (jCheckBox.equals(this.autoCommit)) {
                this.getNodeProperties().setAutoCommit(bl);
                this.connectionInfoChanged();
                this.getNodeProperties().fireJCDataEvent(new JCDataEvent(this.getNodeProperties()));
            }
        }
    }

    public void setNodeProperties(NodeProperties nodeProperties) {
        this.connectMsg.setText("");
        this.urlList.setSelectedItem(nodeProperties.getURL());
        this.driverList.setSelectedItem(nodeProperties.getDriver());
        this.loginField.setText(nodeProperties.getUser());
        this.passwordField.setText(nodeProperties.getPassword());
        this.dbField.setText(nodeProperties.getDatabase());
        this.setUseConnectionPage(!nodeProperties.getUseParentConnection());
        this.useParentConnection.setSelected(nodeProperties.getUseParentConnection());
        this.autoCommit.setSelected(nodeProperties.getAutoCommit());
        this.promptUserForLogin.setSelected(nodeProperties.getPromptUserForLogin());
    }

    public String getURL() {
        String string = (String)this.urlList.getSelectedItem();
        if (this.hostField.getText().length() > 0) {
            string = string + this.hostField.getText();
            string = string + ":";
            string = string + this.portField.getText();
        }
        return string;
    }

    public String getUser() {
        return this.loginField.getText();
    }

    public String getDriver() {
        return (String)this.driverList.getSelectedItem();
    }

    public String getPassword() {
        return this.passwordField.getText();
    }

    public String getDatabase() {
        return this.dbField.getText();
    }

    void populate() {
        String string;
        int n2;
        boolean bl;
        String string2;
        String string3 = JClassInfo.getProperty("datasource", jdbcDrivers);
        String string4 = JClassInfo.getProperty("datasource", jdbcUrls);
        String string5 = JClassInfo.getProperty("datasource", jdbcUrlsDelimiter);
        if (string3 == null || string3.length() == 0) {
            string3 = sunJdbcOdbcDriver + ":" + msJdbcOdbcDriver;
            JClassInfo.setProperty("datasource", jdbcDrivers, string3);
        }
        string3 = string3 + (System.getProperty(jdbcDrivers) == null ? "" : ":" + System.getProperty(jdbcDrivers));
        if (string5 == null || string5.length() == 0) {
            string5 = defaultDelimiter;
            JClassInfo.setProperty("datasource", jdbcUrlsDelimiter, string5);
        }
        StringTokenizer stringTokenizer = null;
        if (string4 != null && string4.length() > 0) {
            stringTokenizer = new StringTokenizer(string4, string5);
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                if (string2.length() <= 0) continue;
                bl = false;
                n2 = 0;
                while (n2 < this.urlList.getModel().getSize()) {
                    string = (String)this.urlList.getModel().getElementAt(n2);
                    if (string.equals(string2)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (bl) continue;
                this.urlList.addItem(string2);
            }
        }
        if (string3 != null && string3.length() > 0) {
            stringTokenizer = new StringTokenizer(string3, ":");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                if (string2.length() <= 0) continue;
                bl = false;
                n2 = 0;
                while (n2 < this.driverList.getModel().getSize()) {
                    string = (String)this.driverList.getModel().getElementAt(n2);
                    if (string.equals(string2)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (bl) continue;
                this.driverList.addItem(string2);
            }
        }
    }

    void updatePropertyFile() {
        String string;
        StringTokenizer stringTokenizer;
        boolean bl;
        String string2 = JClassInfo.getProperty("datasource", jdbcDrivers);
        String string3 = JClassInfo.getProperty("datasource", jdbcUrls);
        String string4 = JClassInfo.getProperty("datasource", jdbcUrlsDelimiter);
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = defaultDelimiter;
        }
        if (this.getDriver() != null && this.getDriver().trim().length() > 0) {
            bl = false;
            stringTokenizer = new StringTokenizer(string2, ":");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                if (!string.equals(this.getDriver().trim())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (string2.length() > 0) {
                    string2 = string2 + ":";
                }
                string2 = string2 + this.getDriver().trim();
            }
        }
        if (this.getURL() != null && this.getURL().trim().length() > 0) {
            bl = false;
            stringTokenizer = new StringTokenizer(string3, string4);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                if (!string.equals(this.getURL().trim())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (string3.length() > 0) {
                    string3 = string3 + string4;
                }
                string3 = string3 + this.getURL().trim();
            }
        }
        if (string2 != null && string2.trim().length() > 0) {
            JClassInfo.setProperty("datasource", jdbcDrivers, string2);
        }
        if (string3 != null && string3.trim().length() > 0) {
            JClassInfo.setProperty("datasource", jdbcUrls, string3);
        }
        this.populate();
    }
}

