/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.beans;

import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.beans.JCDataEvent;
import com.klg.jclass.datasource.beans.JCDataListener;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCListenerList;
import java.beans.Beans;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Enumeration;

public class SerializedProperties
implements Serializable {
    static final long serialVersionUID = 6152977937877513889L;
    protected String serializationFile;
    protected String resourceName;
    protected String defaultSerializationFileBase;
    private boolean isSerializationRequired = false;
    private transient JCListenerList JCDataListeners = null;
    private transient boolean isFiringJCDataEvent = false;
    private static final boolean TRACE = false;

    public void setSerializationFile(String string) {
        if (this.isSameString(this.serializationFile, string)) {
            return;
        }
        this.serializationFile = string;
        this.setChanged();
    }

    public String getSerializationFile() {
        return this.serializationFile;
    }

    public void setResourceName(String string) {
        if (this.isSameString(this.resourceName, string)) {
            return;
        }
        this.resourceName = string;
        this.setChanged();
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public boolean isResourceNameSpecified() {
        return this.resourceName != null && this.resourceName.length() != 0;
    }

    public boolean isSerializationRequired() {
        return this.isSerializationRequired;
    }

    public static SerializedProperties fromResource(ClassLoader classLoader, String string) throws ClassNotFoundException, IOException {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = string.substring(0, string.lastIndexOf(".")).replace('/', '.');
        return (SerializedProperties)Beans.instantiate(classLoader, string2);
    }

    public static SerializedProperties fromResource(Class clazz, String string) throws ClassNotFoundException, IOException {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = string.substring(0, string.lastIndexOf(".")).replace('/', '.');
        ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
        String string3 = null;
        if (clazz != null && clazz.getName().indexOf(".") > -1) {
            string3 = clazz.getName().substring(0, clazz.getName().lastIndexOf("."));
        }
        SerializedProperties serializedProperties = null;
        if (string3 != null) {
            String string4 = string3 + "." + string2;
            try {
                serializedProperties = (SerializedProperties)Beans.instantiate(classLoader, string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (serializedProperties == null) {
            try {
                serializedProperties = (SerializedProperties)Beans.instantiate(classLoader, string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
        }
        return serializedProperties;
    }

    public static SerializedProperties fromFile(String string) throws FileNotFoundException, ClassNotFoundException, IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
        SerializedProperties serializedProperties = (SerializedProperties)objectInputStream.readObject();
        objectInputStream.close();
        return serializedProperties;
    }

    public static void toFile(SerializedProperties serializedProperties, String string) throws FileNotFoundException, IOException {
        String string2 = serializedProperties.getSerializationFile();
        try {
            File file = new File(string);
            if (file.exists() && !file.canWrite()) {
                Object[] objectArray = new Object[]{string};
                String string3 = MessageFormat.format(LocaleBundle.string("File Read-only"), objectArray);
                throw new IOException(string3);
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            serializedProperties.setSerializationFile(string);
            objectOutputStream.writeObject(serializedProperties);
            objectOutputStream.flush();
            objectOutputStream.close();
            serializedProperties.isSerializationRequired = false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            serializedProperties.setSerializationFile(string2);
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            serializedProperties.setSerializationFile(string2);
            throw iOException;
        }
        serializedProperties.fireJCDataEvent(new JCDataEvent(serializedProperties));
    }

    protected static String getDefaultSerializationFile(String string, int n2) {
        String string2 = null;
        if (JCEnvironment.isDesignTime()) {
            string2 = string + n2 + ".ser";
            while (new File(string2).exists()) {
                string2 = string + ++n2 + ".ser";
            }
        }
        return string2;
    }

    protected void setDefaultSerializationFileBase(String string) {
        this.defaultSerializationFileBase = new String(string);
    }

    public String getDefaultSerializationFileToOpen() {
        int n2 = 0;
        String string = null;
        String string2 = this.defaultSerializationFileBase + n2 + ".ser";
        while (new File(string2).exists()) {
            string = string2;
            string2 = this.defaultSerializationFileBase + ++n2 + ".ser";
        }
        return string;
    }

    protected boolean isSameString(String string, String string2) {
        return string == null && string2 == null || string != null && string2 != null && string.equals(string2);
    }

    protected void setChanged() {
        this.isSerializationRequired = true;
    }

    public synchronized void addJCDataListener(JCDataListener jCDataListener) {
        this.JCDataListeners = JCListenerList.add(this.JCDataListeners, jCDataListener);
    }

    public synchronized void removeJCDataListener(JCDataListener jCDataListener) {
        this.JCDataListeners = JCListenerList.remove(this.JCDataListeners, jCDataListener);
    }

    public void fireJCDataEvent(JCDataEvent jCDataEvent) {
        if (this.isFiringJCDataEvent) {
            return;
        }
        this.isFiringJCDataEvent = true;
        Enumeration<Object> enumeration = JCListenerList.elements(this.JCDataListeners);
        while (enumeration.hasMoreElements()) {
            JCDataListener jCDataListener = (JCDataListener)enumeration.nextElement();
            jCDataListener.JCDataValueChanged(jCDataEvent);
        }
        this.isFiringJCDataEvent = false;
    }
}

