/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.beans;

import com.klg.jclass.datasource.BaseDataTable;
import com.klg.jclass.datasource.BaseMetaData;
import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataSourceTreeModel;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.VirtualColumnModel;
import com.klg.jclass.datasource.beans.JCDataEvent;
import com.klg.jclass.datasource.beans.NodeProperties;
import com.klg.jclass.util.JCEnvironment;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class MetaDataCreator
implements Serializable {
    public static final long serialVersionUID = 5993967531083794512L;
    private static final boolean TRACE = false;
    private static MetaDataCreator jdbcCreator;
    private static MetaDataCreator unboundCreator;

    public MetaDataModel createMetaData(DataModel dataModel, NodeProperties nodeProperties) throws DataModelException {
        return this.createMetaData(dataModel, null, nodeProperties);
    }

    public MetaDataModel createMetaData(DataModel dataModel, MetaDataModel metaDataModel, NodeProperties nodeProperties) throws DataModelException {
        MetaDataModel metaDataModel2 = null;
        if (nodeProperties == null) {
            return metaDataModel2;
        }
        metaDataModel2 = this.create(dataModel, metaDataModel, nodeProperties);
        this.setMetaDataProperties(metaDataModel2, nodeProperties);
        if (metaDataModel2 != null && nodeProperties.getMetaID() == -1) {
            nodeProperties.setMetaID(metaDataModel2.getMetaID());
            nodeProperties.fireJCDataEvent(new JCDataEvent(nodeProperties));
        }
        return metaDataModel2;
    }

    private void setMetaDataProperties(MetaDataModel metaDataModel, NodeProperties nodeProperties) throws DataModelException {
        Object object;
        block6: {
            if (metaDataModel == null) {
                return;
            }
            try {
                metaDataModel.setAutoCommit(nodeProperties.getAutoCommit());
            }
            catch (Exception exception) {
                if (JCEnvironment.isDesignTime()) break block6;
                throw new DataModelException(107, exception);
            }
        }
        metaDataModel.setCommitPolicy(nodeProperties.getCommitPolicy());
        metaDataModel.setCacheChildren(nodeProperties.getCacheChildren());
        metaDataModel.setShowDeletedRows(nodeProperties.getShowDeletedRows());
        metaDataModel.setDescription(nodeProperties.getDescription());
        if (nodeProperties.getMetaID() > -1) {
            metaDataModel.setMetaID(nodeProperties.getMetaID());
        }
        Enumeration enumeration = nodeProperties.getTableAccess().keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            Boolean[] booleanArray = (Boolean[])nodeProperties.getTableAccess().get(object);
            metaDataModel.setInsertAllowed((String)object, booleanArray[0]);
            metaDataModel.setUpdateAllowed((String)object, booleanArray[1]);
            metaDataModel.setDeleteAllowed((String)object, booleanArray[2]);
        }
        object = nodeProperties.getVirtualColumns().elements();
        while (object.hasMoreElements()) {
            metaDataModel.addColumn((VirtualColumnModel)object.nextElement());
        }
    }

    public static MetaDataCreator getCreator(int n2) {
        switch (n2) {
            case 1: {
                if (jdbcCreator == null) {
                    jdbcCreator = new com.klg.jclass.datasource.jdbc.MetaDataCreator();
                }
                return jdbcCreator;
            }
        }
        if (unboundCreator == null) {
            unboundCreator = new MetaDataCreator();
        }
        return unboundCreator;
    }

    protected MetaDataModel create(DataModel dataModel, MetaDataModel metaDataModel, NodeProperties nodeProperties) throws DataModelException {
        BaseMetaData baseMetaData = new BaseMetaData(dataModel);
        baseMetaData.setDescription(nodeProperties.getDescription());
        try {
            Vector vector = nodeProperties.getUnboundColumns();
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                ColumnModel columnModel = (ColumnModel)vector.elementAt(n3);
                System.out.println("Adding column " + columnModel.getColumnName() + " to " + baseMetaData.getDescription());
                baseMetaData.addColumn(columnModel);
                ++n3;
            }
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
        }
        if (metaDataModel == null) {
            ((DataSourceTreeModel)dataModel.getMetaDataTree()).setRoot(baseMetaData);
            ((DataSourceTreeModel)dataModel.getDataTableTree()).setRoot(new BaseDataTable(baseMetaData));
        } else {
            ((DataSourceTreeNode)((Object)metaDataModel)).add(baseMetaData);
        }
        baseMetaData.setProviderClassName(nodeProperties.getProviderName());
        return baseMetaData;
    }
}

