/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource;

import com.klg.jclass.datasource.Binding;
import com.klg.jclass.datasource.BindingModel;
import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelAdapter;
import com.klg.jclass.datasource.DataModelEvent;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.util.JCListenerList;
import java.io.Serializable;
import javax.swing.tree.TreeNode;

public abstract class ReadOnlyBinding
implements BindingModel,
Serializable {
    static final long serialVersionUID = 8241141894499940558L;
    protected MetaDataModel metaDataModel;
    public DataModel dataModel;
    protected Binding parent;
    protected JCListenerList listeners;
    protected String dataBinding;
    private DataModelListener eventAdapter = new DataModelAdapter();

    public ReadOnlyBinding(DataModel dataModel) {
        this.dataModel = dataModel;
        this.setMetaDataModel((MetaDataModel)dataModel.getMetaDataTree().getRoot());
    }

    public ReadOnlyBinding(Binding binding) {
        this(binding.getDataModel());
    }

    public DataTableModel getCurrentDataTableModel(DataModelListener dataModelListener) throws DataModelException {
        return this.dataModel.getCurrentDataTable(dataModelListener, this.metaDataModel);
    }

    public MetaDataModel getMetaDataModel() {
        return this.metaDataModel;
    }

    public void setMetaDataModel(MetaDataModel metaDataModel) {
        this.metaDataModel = metaDataModel;
    }

    public Binding getParent() {
        return this.parent;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void setDescription(String string) {
        this.metaDataModel.setDescription(string);
    }

    public String getDescription() {
        return this.metaDataModel.getDescription();
    }

    public void addBindingListener(DataModelListener dataModelListener) {
        this.listeners = JCListenerList.add(this.listeners, dataModelListener);
    }

    public void removeBindingListener(DataModelListener dataModelListener) {
        this.listeners = JCListenerList.remove(this.listeners, dataModelListener);
    }

    public Object getListeners() {
        return this.listeners;
    }

    public int getRowCount() {
        int n2 = 0;
        try {
            n2 = this.getCurrentDataTableModel(new DataModelAdapter()).getRowCount();
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
        return n2;
    }

    public int getColumnCount() {
        int n2 = 0;
        try {
            n2 = this.metaDataModel.getColumnCount();
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
        return n2;
    }

    public boolean moveToRowIndex(DataModelListener dataModelListener, int n2) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        long l2 = dataTableModel.getRowIdentifier(n2);
        return this.dataModel.moveToRow(dataModelListener, dataTableModel, l2);
    }

    public boolean isDataAvailable() {
        boolean bl = false;
        try {
            DataTableModel dataTableModel = this.getCurrentDataTableModel(this.eventAdapter);
            long l2 = this.metaDataModel.getCurrentBookmark();
            bl = dataTableModel != null && l2 != -1L && dataTableModel.getRowStatus(l2) != 5 && dataTableModel.getRowStatus(l2) != 3;
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
        return bl;
    }

    public String getColumnIdentifier(int n2) {
        String string = "";
        try {
            string = this.metaDataModel.getColumnIdentifier(n2);
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
        return string;
    }

    public int getJavaColumnType(String string) {
        int n2 = -1;
        try {
            n2 = this.metaDataModel.getJavaColumnType(string);
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
        return n2;
    }

    public int getJavaColumnType(int n2) {
        return this.getJavaColumnType(this.getColumnIdentifier(n2));
    }

    public Object getCell(DataModelListener dataModelListener, int n2, int n3) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        return dataTableModel.getResultData(dataTableModel.getRowIdentifier(n2), this.metaDataModel.getColumnIdentifier(n3));
    }

    public Object getCell(DataModelListener dataModelListener, int n2, String string) throws DataModelException {
        return this.getCell(dataModelListener, n2, this.getColumnIndex(string));
    }

    public Object getCurrentCell(DataModelListener dataModelListener, String string) throws DataModelException {
        Object object = this.dataModel.getCurrentDataItem(dataModelListener, this.metaDataModel, string);
        return object;
    }

    public int getCurrentRowIndex() {
        int n2 = -1;
        long l2 = this.metaDataModel.getCurrentBookmark();
        try {
            DataTableModel dataTableModel = this.getCurrentDataTableModel(new DataModelAdapter());
            n2 = dataTableModel != null ? dataTableModel.getRowIndex(l2) : -1;
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
        return n2;
    }

    public void requeryRow(DataModelListener dataModelListener, int n2) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        dataTableModel.requeryRow(dataModelListener, dataTableModel.getRowIdentifier(n2));
    }

    public void requeryCurrentRow(DataModelListener dataModelListener) throws DataModelException {
        this.requeryRow(dataModelListener, this.getCurrentRowIndex());
    }

    public void requeryRowAndDetails(DataModelListener dataModelListener, int n2) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        dataTableModel.requeryRowAndDetails(dataModelListener, dataTableModel.getRowIdentifier(n2));
    }

    public void requeryCurrentRowAndDetails(DataModelListener dataModelListener) throws DataModelException {
        this.requeryRowAndDetails(dataModelListener, this.getCurrentRowIndex());
    }

    public void requeryAll(DataModelListener dataModelListener) throws DataModelException {
        this.dataModel.requeryAll(dataModelListener);
    }

    public int getColumnIndex(String string) {
        try {
            return this.metaDataModel.getColumnIndex(string);
        }
        catch (DataModelException dataModelException) {
            return -1;
        }
    }

    public void requeryLevel(DataModelListener dataModelListener) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        if (dataTableModel == null) {
            this.dataModel.requeryAll(dataModelListener);
        } else {
            long l2 = dataTableModel.getParentBookmark();
            if (l2 == -1L) {
                this.dataModel.requeryAll(dataModelListener);
            } else {
                MetaDataModel metaDataModel = (MetaDataModel)this.metaDataModel.getParent();
                DataTableModel dataTableModel2 = this.getCurrentDataTableModel(dataModelListener);
                dataTableModel2.requeryRowAndDetails(dataModelListener, l2);
            }
        }
    }

    public boolean isOurData(DataModelEvent dataModelEvent) {
        DataTableModel dataTableModel = dataModelEvent.getTable();
        return dataTableModel != null && dataTableModel.getMetaData() == this.metaDataModel;
    }

    public boolean isOutDataOrOurAncestors(DataModelEvent dataModelEvent) {
        return this.isOurData(dataModelEvent) || this.isDescendantOf(dataModelEvent.getTable().getMetaData());
    }

    public boolean isDescendantOf(MetaDataModel metaDataModel) {
        TreeNode treeNode = this.metaDataModel;
        while (treeNode != null) {
            if (treeNode.getParent() == metaDataModel) {
                return true;
            }
            treeNode = treeNode.getParent();
        }
        return false;
    }

    public ColumnModel getColumnObject(String string) {
        ColumnModel columnModel = null;
        try {
            columnModel = this.metaDataModel.getColumnObject(string);
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
        return columnModel;
    }
}

