/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource;

import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.DataModelEvent;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.DataTableAbstractionLayer;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.ProviderModel;
import com.klg.jclass.datasource.StoreModel;
import com.klg.jclass.datasource.VirtualColumnModel;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class BaseDataTable
extends DataSourceTreeNode
implements DataTableModel,
DataTableAbstractionLayer {
    static final long serialVersionUID = 3364765541867247105L;
    protected MetaDataModel metaData;
    protected long parentRow;
    protected StoreModel store;
    protected int initialHashtableSize = 5;
    protected Hashtable updatedRows;
    protected Hashtable insertedRows;
    protected Hashtable rowIndexBeforeEvent;
    protected Hashtable[] rowCaches;
    protected int cursor = -1;
    protected Hashtable logicallyDeletedRows = new Hashtable(this.initialHashtableSize);
    protected Hashtable userData = null;
    protected Hashtable internalData = null;
    protected Vector eventQueue;
    protected static long bookmark = 1L;
    protected String currentColumn;

    private BaseDataTable() {
        this.updatedRows = new Hashtable(this.initialHashtableSize);
        this.insertedRows = new Hashtable(this.initialHashtableSize);
        this.rowCaches = new Hashtable[]{this.logicallyDeletedRows, this.updatedRows, this.insertedRows};
        this.eventQueue = new Vector();
        this.rowIndexBeforeEvent = new Hashtable(this.initialHashtableSize);
    }

    public BaseDataTable(MetaDataModel metaDataModel) {
        this();
        this.metaData = metaDataModel;
        this.parentRow = -1L;
        this.createStore();
    }

    public BaseDataTable(MetaDataModel metaDataModel, long l2) {
        this();
        this.metaData = metaDataModel;
        this.parentRow = l2;
        this.createStore();
    }

    public int getRowCount() {
        return this.store.getRowCount();
    }

    public int getRowStatus(long l2) {
        if (this.logicallyDeleted(l2)) {
            return 3;
        }
        if (this.updatedRows.containsKey(new Long(l2))) {
            return 1;
        }
        if (this.insertedRows.containsKey(new Long(l2))) {
            return 2;
        }
        if (this.store.getIndex(l2) != -1) {
            return 4;
        }
        return 5;
    }

    public long getRowIdentifier(int n2) {
        return this.store.getBookmark(n2);
    }

    public Object getResultData(long l2, String string) throws DataModelException {
        ColumnModel columnModel = this.metaData.getColumnObject(string);
        return columnModel instanceof VirtualColumnModel ? ((VirtualColumnModel)columnModel).getResultData(this, l2) : this.getCell(l2, string);
    }

    public DataTableModel createTable(DataModelListener dataModelListener, long l2, TreeNode treeNode) throws DataModelException {
        DataTableModel dataTableModel = this.getTable(l2, treeNode);
        if (dataTableModel == null) {
            ProviderModel providerModel = this.metaData.getProvider();
            if (providerModel != null) {
                Object[][] objectArray = providerModel.getData(dataModelListener, l2, (MetaDataModel)treeNode);
                dataTableModel = BaseDataTable.createDataTableModelFromProviderData((MetaDataModel)treeNode, l2, objectArray);
            } else if (l2 != -1L) {
                dataTableModel = this.materializeTable(dataModelListener, l2, treeNode);
            }
            if (dataTableModel != null) {
                this.add((DataSourceTreeNode)((Object)dataTableModel));
            }
        }
        return dataTableModel;
    }

    public static DataTableModel createDataTableModelFromProviderData(MetaDataModel metaDataModel, long l2, Object[][] objectArray) {
        BaseDataTable baseDataTable = metaDataModel.getParent() == null ? new BaseDataTable(metaDataModel) : new BaseDataTable(metaDataModel, l2);
        int n2 = 0;
        while (n2 < objectArray.length) {
            baseDataTable.addInternalRow(objectArray[n2]);
            ++n2;
        }
        return baseDataTable;
    }

    public DataTableModel getTable(long l2, TreeNode treeNode) {
        MetaDataModel metaDataModel = (MetaDataModel)treeNode;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)((Object)enumeration.nextElement());
            if (dataTableModel.getParentBookmark() != l2 || !dataTableModel.getMetaData().equals(metaDataModel)) continue;
            return dataTableModel;
        }
        return null;
    }

    public MetaDataModel getMetaData() {
        return this.metaData;
    }

    public long getParentBookmark() {
        return this.parentRow;
    }

    public long addRow(DataModelListener dataModelListener) throws DataModelException {
        Object object = this.createNewRow();
        return this.addRow(dataModelListener, object);
    }

    public long addRow(DataModelListener dataModelListener, Object object, int n2) throws DataModelException {
        return this.addRow(dataModelListener, object, n2, -1);
    }

    public long addRow(DataModelListener dataModelListener, Object object, int n2, int n3) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, -2L, "", 1))) {
            return -1L;
        }
        Object[] objectArray = (Object[])object;
        long l2 = n3 < 0 ? this.addInternalRow(objectArray) : this.addInternalRow(objectArray, n3);
        switch (n2) {
            case 2: {
                this.insertedRows.put(new Long(l2), objectArray);
                break;
            }
            case 3: {
                this.logicallyDeletedRows.put(new Long(l2), objectArray);
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 101));
        return l2;
    }

    public long addRow(DataModelListener dataModelListener, Object object) throws DataModelException {
        return this.addRow(dataModelListener, object, 2);
    }

    public void deleteRow(DataModelListener dataModelListener, long l2) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 5))) {
            return;
        }
        int n2 = this.getRowStatus(l2);
        if (n2 != 4) {
            this.cancelChanges(dataModelListener, l2);
            if (n2 == 2) {
                return;
            }
        }
        this.logicallyDeletedRows.put(new Long(l2), this.getRowFromCache(l2));
        if (this.metaData.getCommitPolicy() == 1) {
            try {
                this.commitRow2(dataModelListener, l2);
                this.commitTransactionAndProcessEvent(dataModelListener, l2);
            }
            catch (DataModelException dataModelException) {
                this.removeRowFromLogicallyDeletedTable(l2);
                throw dataModelException;
            }
        } else if (this.metaData.getShowDeletedRows()) {
            this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 100));
        } else {
            Long l3 = new Long(l2);
            this.rowIndexBeforeEvent.put(l3, new Integer(this.store.getIndex(l2)));
            this.removeRowFromOriginalRowTable(l2);
            this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 102));
            this.fireOriginatorDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 108));
            this.rowIndexBeforeEvent.remove(l3);
        }
    }

    public void updateCell(DataModelListener dataModelListener, long l2, String string, Object object) throws DataModelException {
        if (!this.hasValueChanged(object, this.getResultData(l2, string))) {
            return;
        }
        if (!this.prepareCellUpdate(dataModelListener, l2, string)) {
            return;
        }
        this.setRowDirty(l2);
        this.setValueAt(l2, string, object);
        this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, string, 100));
    }

    public boolean commitRow(DataModelListener dataModelListener, long l2) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 10))) {
            return false;
        }
        if (this.getRowStatus(l2) == 4 || this.getRowStatus(l2) == 5) {
            return true;
        }
        this.commitRow2(dataModelListener, l2);
        this.commitTransactionAndProcessEvent(dataModelListener, l2);
        return true;
    }

    public void commitAll(DataModelListener dataModelListener) throws DataModelException {
        this.commitThisLevel(dataModelListener);
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)((Object)enumeration.nextElement());
            dataTableModel.commitAll(dataModelListener);
        }
    }

    public void conditionallyCommitYourselfAndChildren(DataModelListener dataModelListener) throws DataModelException {
        if (this.metaData.getCommitPolicy() != 3) {
            this.commitThisLevel(dataModelListener);
        }
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)((Object)enumeration.nextElement());
            dataTableModel.conditionallyCommitYourselfAndChildren(dataModelListener);
        }
    }

    public void cancelAllRowChanges(DataModelListener dataModelListener) throws DataModelException {
        Object object;
        Object object2;
        int n2 = 0;
        while (n2 < this.rowCaches.length) {
            object2 = (Hashtable)this.rowCaches[n2].clone();
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                this.cancelRowChanges(dataModelListener, (Long)object.nextElement());
            }
            ++n2;
        }
        object2 = this.children();
        while (object2.hasMoreElements()) {
            object = (DataTableModel)object2.nextElement();
            object.cancelAllRowChanges(dataModelListener);
        }
    }

    public void cancelRowChanges(DataModelListener dataModelListener, long l2) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 8))) {
            return;
        }
        this.cancelChanges(dataModelListener, l2);
    }

    public long getRootAncestorBookmark(long l2) {
        DataTableModel dataTableModel = (DataTableModel)((Object)this.getParent());
        if (dataTableModel == null) {
            return l2;
        }
        if (((TreeNode)((Object)dataTableModel)).getParent() == null) {
            return this.parentRow;
        }
        return dataTableModel.getRootAncestorBookmark(l2);
    }

    public void getAncestors(Vector vector) {
        DataTableModel dataTableModel = (DataTableModel)((Object)this.getParent());
        if (dataTableModel != null && ((TreeNode)((Object)dataTableModel)).getParent() != null) {
            dataTableModel.getAncestors(vector);
        }
        if (this.parentRow != -1L) {
            vector.addElement(new Long(this.parentRow));
        }
    }

    public void requeryRowAndDetails(DataModelListener dataModelListener, long l2) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 3))) {
            return;
        }
        this.requeryRow(dataModelListener, l2);
        this.removeAllChildren();
        this.metaData.getDataModel().clearCurrentPath(this.metaData);
        this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 109));
    }

    public DataTableModel requeryLevel() throws DataModelException {
        return this;
    }

    public boolean first() {
        if (this.getRowCount() > 0) {
            this.cursor = 0;
            return true;
        }
        return false;
    }

    public boolean last() {
        if (this.getRowCount() > 0) {
            this.cursor = this.store.getRowCount() - 1;
            return true;
        }
        return false;
    }

    public boolean next() {
        if (++this.cursor < this.store.getRowCount()) {
            return true;
        }
        --this.cursor;
        return false;
    }

    public boolean previous() {
        if (--this.cursor > -1) {
            return true;
        }
        ++this.cursor;
        return false;
    }

    public void beforeFirst() {
        this.cursor = -1;
    }

    public void afterLast() {
        this.cursor = this.store.getRowCount();
    }

    public boolean isBeforeFirst() {
        return this.cursor == -1;
    }

    public boolean isAfterLast() {
        return this.cursor >= this.store.getRowCount();
    }

    public void relative(int n2) throws DataModelException {
        int n3 = this.cursor + n2;
        if (n3 >= this.store.getRowCount() + 1 || n3 <= -2) {
            Exception exception = new Exception(LocaleBundle.string("Relative move failed. Index out of bounds. ") + n3);
            throw new DataModelException(107, exception);
        }
        this.cursor = n3;
    }

    public void absolute(int n2) throws DataModelException {
        if (n2 <= 0 || n2 > this.store.getRowCount()) {
            Exception exception = new Exception(LocaleBundle.string("Absolute move failed. Ordinal out of bounds. ") + n2);
            throw new DataModelException(107, exception);
        }
        this.cursor = n2 - 1;
    }

    public long getCurrentBookmark() throws DataModelException {
        if (this.store.getRowCount() < 1) {
            return 0L;
        }
        if (this.cursor >= this.store.getRowCount() || this.cursor < 0) {
            Exception exception = new Exception(LocaleBundle.string("Error getting current bookmark. Are there any rows?"));
            throw new DataModelException(-2L, "", this, 107, exception);
        }
        return this.store.getBookmark(this.cursor);
    }

    public Object getUserData(Object object) {
        if (this.userData == null || object == null) {
            return null;
        }
        return this.userData.get(object);
    }

    public void setUserData(Object object, Object object2) {
        if (object == null) {
            return;
        }
        if (this.userData == null) {
            this.userData = new Hashtable(this.initialHashtableSize);
        }
        if (object2 == null) {
            this.userData.remove(object);
        } else {
            this.userData.put(object, object2);
        }
    }

    public Object getInternalData(Object object) {
        if (this.internalData == null || object == null) {
            return null;
        }
        return this.internalData.get(object);
    }

    public void setInternalData(Object object, Object object2) {
        if (object == null) {
            return;
        }
        if (this.internalData == null) {
            this.internalData = new Hashtable(this.initialHashtableSize);
        }
        if (object2 == null) {
            this.internalData.remove(object);
        } else {
            this.internalData.put(object, object2);
        }
    }

    public void processEventQueue(DataModelListener dataModelListener) throws DataModelException {
        Enumeration enumeration = this.eventQueue.elements();
        while (enumeration.hasMoreElements()) {
            long l2 = (Long)enumeration.nextElement();
            this.processRowEvent(dataModelListener, l2);
        }
        this.eventQueue.removeAllElements();
        Enumeration<TreeNode> enumeration2 = this.children();
        while (enumeration2.hasMoreElements()) {
            ((DataTableModel)((Object)enumeration2.nextElement())).processEventQueue(dataModelListener);
        }
    }

    public void clearEventQueue() {
        this.eventQueue.removeAllElements();
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            ((DataTableModel)((Object)enumeration.nextElement())).clearEventQueue();
        }
    }

    public void moveCursorToRow(long l2) throws DataModelException {
        int n2 = this.getRowIndex(l2);
        if (n2 == -1) {
            Exception exception = new Exception(LocaleBundle.string("Move failed, bookmark not found: ") + l2);
            throw new DataModelException(l2, "", this, 107, exception);
        }
        this.cursor = n2;
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getRowIndex(long l2) {
        if (l2 < 0L) {
            return -1;
        }
        int n2 = this.store.getIndex(l2);
        if (n2 == -1) {
            Integer n3 = (Integer)this.rowIndexBeforeEvent.get(new Long(l2));
            n2 = n3 != null ? n3 : -1;
        }
        return n2;
    }

    public void deleteCacheChildren(DataModelListener dataModelListener) throws DataModelException {
        BaseDataTable baseDataTable;
        if (this.recursivelyDeleteChildren(this, dataModelListener)) {
            this.removeAllChildren();
        }
        if ((baseDataTable = (BaseDataTable)this.getParent()) != null && this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, -2L, "", 12))) {
            baseDataTable.remove(this);
        }
    }

    protected boolean recursivelyDeleteChildren(BaseDataTable baseDataTable, DataModelListener dataModelListener) throws DataModelException {
        if (baseDataTable == null) {
            return true;
        }
        Enumeration<TreeNode> enumeration = baseDataTable.children();
        while (enumeration.hasMoreElements()) {
            baseDataTable = (BaseDataTable)enumeration.nextElement();
            if (!(baseDataTable.getChildCount() > 0 ? !this.recursivelyDeleteChildren(baseDataTable, dataModelListener) : !this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, baseDataTable, -2L, "", 12)))) continue;
            return false;
        }
        return true;
    }

    public void moveToRow(long l2) throws DataModelException {
        this.setAncestorPath();
        this.getMetaData().setCurrentDataTable(this);
        this.getMetaData().setCurrentBookmark(l2);
    }

    public boolean isSubTreeModified(long l2) {
        int n2 = this.getRowStatus(l2);
        if (n2 != 4 && n2 != 5) {
            return true;
        }
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)((Object)enumeration.nextElement());
            if (dataTableModel.getParentBookmark() != l2 || !dataTableModel.isTableOrChildrenModified()) continue;
            return true;
        }
        return false;
    }

    public boolean isTableOrChildrenModified() {
        boolean bl = false;
        if (this.isModified()) {
            bl = true;
        } else {
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                DataTableModel dataTableModel = (DataTableModel)((Object)enumeration.nextElement());
                if (!dataTableModel.isTableOrChildrenModified()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void commitSubTree(DataModelListener dataModelListener, long l2) throws DataModelException {
        this.commitRow(dataModelListener, l2);
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)((Object)enumeration.nextElement());
            dataTableModel.commitAll(dataModelListener);
        }
    }

    public boolean isModified() {
        return this.insertedRows.size() + this.updatedRows.size() + this.logicallyDeletedRows.size() > 0;
    }

    public long[] getUpdatedRowBookmarks() {
        return this.getBookmarksFromTable(this.updatedRows);
    }

    public long[] getInsertedRowBookmarks() {
        return this.getBookmarksFromTable(this.insertedRows);
    }

    public long[] getDeletedRowBookmarks() {
        return this.getBookmarksFromTable(this.logicallyDeletedRows);
    }

    public void requeryTable(DataModelListener dataModelListener) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, this.getParentBookmark(), "", 3))) {
            return;
        }
        this.cancelAllRowChanges(dataModelListener);
        this.removeAllChildren();
        this.metaData.getDataModel().clearCurrentPath(this.metaData);
        this.cursor = 0;
        this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, this.getParentBookmark(), "", 110));
    }

    public Object cloneRow(long l2) throws DataModelException {
        Object[] objectArray = (Object[])this.getRowFromCache(l2);
        return objectArray.clone();
    }

    public void setValueAt(long l2, String string, Object object) throws DataModelException {
        ((Object[])this.getRowFromCache((long)l2))[this.metaData.getColumnIndex((String)string)] = object;
    }

    public void restoreRow(long l2) {
        Object[] objectArray = (Object[])this.getOriginalRow(l2);
        if (objectArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            try {
                String string = this.metaData.getColumnIdentifier(n2);
                if (this.columnModified(l2, string)) {
                    this.setValueAt(l2, string, objectArray[n2]);
                }
            }
            catch (DataModelException dataModelException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public Object createNewRow() throws DataModelException {
        int n2 = this.metaData.getColumnCount();
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        while (n3 < n2) {
            objectArray[n3] = null;
            ++n3;
        }
        return objectArray;
    }

    public void refreshRow(long l2) throws DataModelException {
    }

    public void saveRow(long l2) throws DataModelException {
    }

    public Object getCell(long l2, String string) throws DataModelException {
        int n2 = this.metaData.getColumnIndex(string);
        Object[] objectArray = (Object[])this.getRowFromCache(l2);
        if (objectArray != null) {
            return objectArray[n2];
        }
        return null;
    }

    public DataTableModel materializeTable(DataModelListener dataModelListener, long l2, TreeNode treeNode) throws DataModelException {
        return new BaseDataTable((MetaDataModel)treeNode, l2);
    }

    public boolean fireDataModelEvent(DataModelEvent dataModelEvent) {
        return this.metaData.getDataModel().fireDataModelEvent(dataModelEvent);
    }

    public boolean fireOriginatorDataModelEvent(DataModelEvent dataModelEvent) {
        this.metaData.getDataModel().fireDataModelEvent(dataModelEvent, dataModelEvent.getOriginator());
        return true;
    }

    protected long getNextBookmark() {
        return bookmark++;
    }

    public long addInternalRow(Object object) {
        long l2 = this.getNextBookmark();
        this.store.addRow(l2, object);
        return l2;
    }

    public long addInternalRow(Object object, int n2) {
        long l2 = this.getNextBookmark();
        this.store.addRow(l2, object, n2);
        return l2;
    }

    public Object getRowFromCache(long l2) throws DataModelException {
        Object object = this.store.getRow(l2);
        if (object == null) {
            Exception exception = new Exception(LocaleBundle.string("Internal error: bookmark not found in cache: ") + l2);
            throw new DataModelException(l2, "", this, 107, exception);
        }
        return object;
    }

    private boolean logicallyDeleted(long l2) {
        return this.logicallyDeletedRows.size() > 0 && this.logicallyDeletedRows.containsKey(new Long(l2));
    }

    protected void removeRowFromLogicallyDeletedTable(long l2) {
        if (this.logicallyDeleted(l2)) {
            this.logicallyDeletedRows.remove(new Long(l2));
        }
    }

    public void removeRowFromUpdatedTable(long l2) {
        Long l3 = new Long(l2);
        if (this.updatedRows.containsKey(l3)) {
            this.updatedRows.remove(l3);
        }
    }

    public void removeRowFromInsertedTable(long l2) {
        Long l3 = new Long(l2);
        if (this.insertedRows.containsKey(l3)) {
            this.insertedRows.remove(l3);
        }
    }

    protected void removeRowFromOriginalRowTable(long l2) {
        this.store.removeRow(l2);
    }

    private void commitThisLevel(DataModelListener dataModelListener) throws DataModelException {
        int n2 = 0;
        while (n2 < this.rowCaches.length) {
            Hashtable hashtable = (Hashtable)this.rowCaches[n2].clone();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                long l2 = (Long)enumeration.nextElement();
                if (this.metaData.getAutoCommit()) {
                    this.commitRow(dataModelListener, l2);
                    continue;
                }
                this.commitRow2(dataModelListener, l2);
            }
            ++n2;
        }
    }

    public void cancelChanges(DataModelListener dataModelListener, long l2) throws DataModelException {
        switch (this.getRowStatus(l2)) {
            case 1: {
                this.restoreRow(l2);
                this.removeRowFromUpdatedTable(l2);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 100));
                break;
            }
            case 3: {
                if (!this.metaData.getShowDeletedRows()) {
                    Object v = this.logicallyDeletedRows.get(new Long(l2));
                    long l3 = this.addInternalRow(v);
                    this.removeRowFromLogicallyDeletedTable(l2);
                    this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l3, "", 101));
                    break;
                }
                this.removeRowFromLogicallyDeletedTable(l2);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 100));
                break;
            }
            case 2: {
                Long l4 = new Long(l2);
                this.rowIndexBeforeEvent.put(l4, new Integer(this.store.getIndex(l2)));
                this.removeInsertedRow(l2);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 102));
                this.fireOriginatorDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 108));
                this.rowIndexBeforeEvent.remove(l4);
                break;
            }
            default: {
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 100));
            }
        }
    }

    private void commitTransactionAndProcessEvent(DataModelListener dataModelListener, long l2) throws DataModelException {
        try {
            this.metaData.commitTransaction();
        }
        catch (DataModelException dataModelException) {
            int n2 = this.getRowStatus(l2) == 102 ? 102 : 100;
            throw new DataModelException(l2, "", this, n2, dataModelException);
        }
        this.processRowEvent(dataModelListener, l2);
    }

    private void commitRow2(DataModelListener dataModelListener, long l2) throws DataModelException {
        if (this.getRowStatus(l2) == 4) {
            return;
        }
        try {
            this.saveRow(l2);
        }
        catch (DataModelException dataModelException) {
            int n2 = this.getRowStatus(l2) == 3 ? 102 : 100;
            throw new DataModelException(l2, "", this, n2, dataModelException);
        }
        if (!this.metaData.getAutoCommit()) {
            this.eventQueue.addElement(new Long(l2));
        } else {
            this.processRowEvent(dataModelListener, l2);
        }
    }

    private void processRowEvent(DataModelListener dataModelListener, long l2) throws DataModelException {
        switch (this.getRowStatus(l2)) {
            case 1: {
                this.removeRowFromUpdatedTable(l2);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 100));
                break;
            }
            case 2: {
                this.removeRowFromInsertedTable(l2);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 100));
                break;
            }
            case 3: {
                Long l3 = new Long(l2);
                this.rowIndexBeforeEvent.put(l3, new Integer(this.store.getIndex(l2)));
                this.removeRowFromLogicallyDeletedTable(l2);
                this.removeRowFromOriginalRowTable(l2);
                if (this.metaData.getShowDeletedRows()) {
                    this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 102));
                    this.fireOriginatorDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 108));
                }
                this.rowIndexBeforeEvent.remove(l3);
                break;
            }
        }
    }

    public void requeryRow(DataModelListener dataModelListener, long l2) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 3))) {
            return;
        }
        int n2 = this.getRowStatus(l2);
        Long l3 = new Long(l2);
        this.rowIndexBeforeEvent.put(l3, new Integer(this.store.getIndex(l2)));
        this.getRow(dataModelListener, l2);
        if (n2 == 2) {
            this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 102));
            this.fireOriginatorDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 108));
        } else {
            this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 100));
        }
        this.rowIndexBeforeEvent.remove(l3);
    }

    private void getRow(DataModelListener dataModelListener, long l2) throws DataModelException {
        if (this.insertedRows.containsKey(new Long(l2))) {
            this.removeInsertedRow(l2);
            return;
        }
        if (this.getRowStatus(l2) == 1) {
            this.cancelChanges(dataModelListener, l2);
        }
        this.refreshRow(l2);
        this.removeRowFromUpdatedTable(l2);
        this.removeRowFromLogicallyDeletedTable(l2);
    }

    private void removeInsertedRow(long l2) {
        this.removeRowFromInsertedTable(l2);
        this.removeRowFromOriginalRowTable(l2);
    }

    public boolean originalCellWasNull(int n2, Vector vector, Object[] objectArray) {
        int n3 = (Integer)vector.elementAt(n2);
        Object object = objectArray[n3];
        return object == null;
    }

    public boolean columnModified(long l2, String string) throws DataModelException {
        int n2 = this.metaData.getColumnIndex(string);
        Object[] objectArray = (Object[])this.getOriginalRow(l2);
        if (objectArray == null) {
            return false;
        }
        Object object = this.getResultData(l2, string);
        Object object2 = objectArray[n2];
        return this.hasValueChanged(object, object2);
    }

    public boolean hasValueChanged(Object object, Object object2) {
        return object == null && object2 != null || object2 == null && object != null || object2 != null && object != null && !object.equals(object2);
    }

    public Object getOriginalRow(long l2) {
        return (Object[])this.updatedRows.get(new Long(l2));
    }

    public Object getDeletedRow(long l2) {
        return this.logicallyDeletedRows.get(new Long(l2));
    }

    public boolean tableIsAncestor(DataTableModel dataTableModel) {
        TreeNode treeNode = (TreeNode)((Object)dataTableModel);
        while (treeNode != null) {
            if (treeNode == this) {
                return true;
            }
            treeNode = treeNode.getParent();
        }
        return false;
    }

    private void setAncestorPath() {
        DataTableModel dataTableModel = (DataTableModel)((Object)this.getParent());
        if (dataTableModel == null) {
            return;
        }
        ((BaseDataTable)dataTableModel).setAncestorPath();
        MetaDataModel metaDataModel = dataTableModel.getMetaData();
        metaDataModel.setCurrentDataTable(dataTableModel);
        metaDataModel.setCurrentBookmark(this.getParentBookmark());
    }

    public boolean prepareCellUpdate(DataModelListener dataModelListener, long l2, String string) throws DataModelException {
        if (this.logicallyDeleted(l2)) {
            Exception exception = new Exception(LocaleBundle.string("Deleted rows cannot be modified."));
            throw new DataModelException(l2, string, this, 4, exception);
        }
        ColumnModel columnModel = this.metaData.getColumnObject(string);
        if (columnModel == null || columnModel instanceof VirtualColumnModel) {
            Exception exception = new Exception(LocaleBundle.string("This is a derived column.  It cannot be modified."));
            throw new DataModelException(l2, string, this, 4, exception);
        }
        if (!this.metaData.isUpdateAllowedOnColumn(string) || columnModel.isReadOnly()) {
            Exception exception = new Exception(LocaleBundle.string("Cell cannot be updated: permissions disallow it or its table name cannot be determined.") + ": " + string);
            throw new DataModelException(l2, string, this, 4, exception);
        }
        return this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, string, 4));
    }

    private long[] getBookmarksFromTable(Hashtable hashtable) {
        long[] lArray = new long[hashtable.size()];
        int n2 = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            lArray[n2++] = (Long)enumeration.nextElement();
        }
        return lArray;
    }

    private void createStore() {
        try {
            this.store = (StoreModel)this.metaData.getStoreClass().newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
        }
    }

    public void setRowDirty(long l2) {
        if (!this.insertedRows.containsKey(new Long(l2)) && !this.updatedRows.containsKey(new Long(l2))) {
            try {
                this.updatedRows.put(new Long(l2), this.cloneRow(l2));
            }
            catch (DataModelException dataModelException) {
                System.out.println(dataModelException.toString());
            }
        }
    }
}

