/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.swing;

import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCComponentCellRenderer;
import com.klg.jclass.cell.JCLightCellRenderer;
import com.klg.jclass.cell.swing.AbstractRendererToComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;

public class LightRendererToComponentRenderer
extends JComponent
implements JCComponentCellRenderer {
    protected JCLightCellRenderer lightRenderer;
    protected JCCellInfo cellInfo;
    protected Object value;
    protected boolean selected;

    public LightRendererToComponentRenderer(JCLightCellRenderer jCLightCellRenderer) {
        this.lightRenderer = jCLightCellRenderer;
    }

    public Component getRendererComponent(JCCellInfo jCCellInfo, Object object, boolean bl) {
        this.cellInfo = jCCellInfo;
        this.value = object;
        this.selected = bl;
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.selected) {
            graphics.setColor(this.cellInfo.getSelectedBackground());
        } else {
            graphics.setColor(this.cellInfo.getBackground());
        }
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        super.paintComponent(graphics);
        this.lightRenderer.draw(graphics, this.cellInfo, this.value, this.selected);
        Container container = this.getParent();
        if (container != null && container instanceof CellRendererPane) {
            container.remove(this);
        }
    }

    public Dimension getPreferredSize() {
        AbstractRendererToComponent abstractRendererToComponent;
        JComponent jComponent;
        Graphics graphics = this.getGraphics();
        if (graphics == null && this.cellInfo != null && this.cellInfo instanceof AbstractRendererToComponent && (jComponent = (abstractRendererToComponent = (AbstractRendererToComponent)this.cellInfo).getParentComponent()) != null) {
            graphics = jComponent.getGraphics();
        }
        if (graphics == null) {
            return new Dimension(17, 17);
        }
        return this.lightRenderer.getPreferredSize(graphics, this.cellInfo, this.value);
    }
}

